/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhss.network;

import android.os.Bundle;
import android.text.TextUtils;
import com.vhall.httpclient.api.VHNetApi;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.TokenManger;
import com.vhall.vhss.data.VhssUserInfoData;
import com.vhall.vhss.netutils.CoreNetCallback;
import com.vhall.vhss.network.BaseNetwork;
import java.util.HashMap;
import java.util.Map;

public class UserNetworkRequest
extends BaseNetwork {
    public static void sendCode(String type, String data, CallBack callBack) {
        UserNetworkRequest.sendCode(type, data, "7", callBack);
    }

    public static void sendCode(String type, String data, String scene_id, CallBack callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", TextUtils.isEmpty((CharSequence)type) ? "" : type.trim());
        params.put("data", TextUtils.isEmpty((CharSequence)data) ? "" : data.trim());
        params.put("scene_id", scene_id);
        params.put("biz_id", "2");
        VHNetApi.getNetApi().doPost(UserNetworkRequest.getBaseRequest(UserNetworkRequest.getSignParam(params), "users/code/send"), new CoreNetCallback(callBack));
    }

    public static void getUserInfo(CallBack<VhssUserInfoData> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scene_id", "1");
        VHNetApi.getNetApi().doPost(UserNetworkRequest.getBaseRequest(UserNetworkRequest.getSignParam(params), "users/user/get-info"), new CoreNetCallback<VhssUserInfoData>(callBack, VhssUserInfoData.class));
    }

    public static void login(String account, String password, String dynamic_code, final CallBack<VhssUserInfoData> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("account", TextUtils.isEmpty((CharSequence)account) ? "" : account.trim());
        if (!TextUtils.isEmpty((CharSequence)password)) {
            params.put("password", password.trim());
            params.put("remember", "1");
        }
        if (!TextUtils.isEmpty((CharSequence)dynamic_code)) {
            params.put("dynamic_code", dynamic_code.trim());
        }
        Bundle bundle = new Bundle();
        bundle.putString("dynamic_code", dynamic_code.trim());
        bundle.putString("user_name", account.trim());
        bundle.putString("pass_word", password.trim());
        bundle.putString("REQUEST_URL", "users/user/login");
        VHNetApi.getNetApi().doPost(UserNetworkRequest.getBaseRequest(UserNetworkRequest.getSignParam(params), "users/user/login"), new CoreNetCallback<VhssUserInfoData>(new CallBack<VhssUserInfoData>(){

            @Override
            public void onSuccess(VhssUserInfoData result) {
                TokenManger.setToken(result.token);
                TokenManger.setGrayId(result.user_id);
                if (callBack != null) {
                    callBack.onSuccess(result);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callBack != null) {
                    callBack.onError(eventCode, msg);
                }
            }
        }, VhssUserInfoData.class, bundle));
    }

    public static void loginByThirdId(Map<String, String> requestParams, final CallBack<VhssUserInfoData> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (String key : requestParams.keySet()) {
            if (TextUtils.isEmpty((CharSequence)requestParams.get(key))) continue;
            params.put(key, TextUtils.isEmpty((CharSequence)requestParams.get(key)) ? "" : requestParams.get(key).trim());
        }
        Bundle bundle = new Bundle();
        bundle.putString("thirdId", TextUtils.isEmpty((CharSequence)((CharSequence)params.get("third_user_id"))) ? "" : (String)params.get("third_user_id"));
        bundle.putString("user_name", TextUtils.isEmpty((CharSequence)((CharSequence)params.get("nick_name"))) ? "" : (String)params.get("nick_name"));
        bundle.putString("headNetUrl", TextUtils.isEmpty((CharSequence)((CharSequence)params.get("head"))) ? "" : (String)params.get("head"));
        bundle.putString("REQUEST_URL", TextUtils.isEmpty((CharSequence)((CharSequence)params.get("users/open-user/login"))) ? "" : "users/open-user/login");
        VHNetApi.getNetApi().doPost(UserNetworkRequest.getBaseRequest(UserNetworkRequest.getSignParam(params), "users/open-user/login"), new CoreNetCallback<VhssUserInfoData>(new CallBack<VhssUserInfoData>(){

            @Override
            public void onSuccess(VhssUserInfoData result) {
                TokenManger.setToken(result.token);
                TokenManger.setGrayId(result.user_id);
                if (callBack != null) {
                    callBack.onSuccess(result);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callBack != null) {
                    callBack.onError(eventCode, msg);
                }
            }
        }, VhssUserInfoData.class, bundle));
    }

    public static void logout(final CallBack callBack) {
        Bundle bundle = new Bundle();
        bundle.putString("REQUEST_URL", "users/user/logout");
        VHNetApi.getNetApi().doPost(UserNetworkRequest.getBaseRequest(UserNetworkRequest.getSignParam(new HashMap<String, String>()), "users/user/logout"), new CoreNetCallback(new CallBack(){

            public void onSuccess(Object result) {
                if (callBack != null) {
                    callBack.onSuccess("");
                    TokenManger.liveOutByUser();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callBack != null) {
                    callBack.onError(eventCode, msg);
                }
            }
        }, null, bundle));
    }

    public static void feedBack(String content, CallBack callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("content", content);
        params.put("type", "4");
        params.put("source", "2");
        VHNetApi.getNetApi().doPost(UserNetworkRequest.getBaseRequest(UserNetworkRequest.getSignParam(params), "interacts/feedback/user-create-feedback"), new CoreNetCallback(callBack));
    }
}

