/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhss.network;

import android.text.TextUtils;
import com.vhall.httpclient.api.VHNetApi;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.data.ChatListData;
import com.vhall.vhss.data.QuestionHistoryListData;
import com.vhall.vhss.data.UserStateListData;
import com.vhall.vhss.data.VhssUserInfoData;
import com.vhall.vhss.netutils.CoreNetCallback;
import com.vhall.vhss.network.BaseNetwork;
import java.util.HashMap;

public class ChatNetworkRequest
extends BaseNetwork {
    public static void chatGetList(String room_id, int pos, int limit, CallBack<ChatListData> callBack) {
        ChatNetworkRequest.chatGetList(room_id, pos, limit, "", "", "", callBack);
    }

    public static void chatGetList(String room_id, int pos, int limit, String msg_id, String anchor_path, String is_role, CallBack<ChatListData> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("room_id", room_id);
        if (pos == 0) {
            if (callBack != null) {
                callBack.onError(-1, "\u9875\u7801\u4ece1\u5f00\u59cb");
            }
            return;
        }
        limit = limit == 0 ? 10 : limit;
        params.put("limit", String.valueOf(limit));
        if (!TextUtils.isEmpty((CharSequence)msg_id)) {
            params.put("msg_id", msg_id);
            params.put("anchor_path", TextUtils.isEmpty((CharSequence)anchor_path) ? "up" : anchor_path);
        } else {
            params.put("pos", String.valueOf((pos - 1) * limit));
        }
        if (!TextUtils.isEmpty((CharSequence)is_role)) {
            params.put("is_role", is_role);
        }
        VHNetApi.getNetApi().doPost(ChatNetworkRequest.getBaseRequest(ChatNetworkRequest.getSignParam(params), "interacts/chat/get-list"), new CoreNetCallback<ChatListData>(callBack, ChatListData.class));
    }

    public static void sendCustomMessage(String room_id, String channel_id, String body, CallBack callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("room_id", room_id);
        params.put("channel_id", channel_id);
        params.put("body", body);
        params.put("client", "android");
        VHNetApi.getNetApi().doPost(ChatNetworkRequest.getBaseRequest(ChatNetworkRequest.getSignParam(params), "interacts/chat/send-custom-message"), new CoreNetCallback<VhssUserInfoData>(callBack, VhssUserInfoData.class));
    }

    public static void setKicked(String room_id, String channel_id, String receive_account_id, String status, CallBack callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("room_id", room_id);
        params.put("channel_id", channel_id);
        params.put("status", status);
        params.put("receive_account_id", receive_account_id);
        VHNetApi.getNetApi().doPost(ChatNetworkRequest.getBaseRequest(ChatNetworkRequest.getSignParam(params), "interacts/chat-user/set-kicked"), new CoreNetCallback<VhssUserInfoData>(callBack, VhssUserInfoData.class));
    }

    public static void setBanned(String room_id, String channel_id, String receive_account_id, String status, CallBack callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("room_id", room_id);
        params.put("channel_id", channel_id);
        params.put("status", status);
        params.put("receive_account_id", receive_account_id);
        VHNetApi.getNetApi().doPost(ChatNetworkRequest.getBaseRequest(ChatNetworkRequest.getSignParam(params), "interacts/chat-user/set-banned"), new CoreNetCallback<VhssUserInfoData>(callBack, VhssUserInfoData.class));
    }

    public static void chatOnlineList(String room_id, int page, int limit, CallBack<UserStateListData> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("room_id", room_id);
        if (page == 0) {
            if (callBack != null) {
                callBack.onError(-1, "\u9875\u7801\u4ece1\u5f00\u59cb");
            }
            return;
        }
        limit = limit == 0 ? 10 : limit;
        params.put("pos", String.valueOf((page - 1) * limit));
        params.put("limit", String.valueOf(limit));
        VHNetApi.getNetApi().doPost(ChatNetworkRequest.getBaseRequest(ChatNetworkRequest.getSignParam(params), "interacts/chat-user/get-online-list"), new CoreNetCallback<UserStateListData>(callBack, UserStateListData.class));
    }

    public static void chatSpecialList(String room_id, int pos, int limit, CallBack<UserStateListData> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("room_id", room_id);
        if (pos == 0) {
            if (callBack != null) {
                callBack.onError(-1, "\u9875\u7801\u4ece1\u5f00\u59cb");
            }
            return;
        }
        limit = limit == 0 ? 10 : limit;
        params.put("pos", String.valueOf((pos - 1) * limit));
        params.put("limit", String.valueOf(limit));
        VHNetApi.getNetApi().doPost(ChatNetworkRequest.getBaseRequest(ChatNetworkRequest.getSignParam(params), "interacts/chat-user/get-bounded-list"), new CoreNetCallback<UserStateListData>(callBack, UserStateListData.class));
    }

    public static void getKeyword(String room_id, CallBack<String> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("room_id", room_id);
        VHNetApi.getNetApi().doPost(ChatNetworkRequest.getBaseRequest(ChatNetworkRequest.getSignParam(params), "interacts/keyword/get-current-user-all-keyword"), new CoreNetCallback(callBack));
    }

    public static void submitQuestion(String room_id, String content, CallBack<String> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("room_id", room_id);
        params.put("content", content);
        VHNetApi.getNetApi().doPost(ChatNetworkRequest.getBaseRequest(ChatNetworkRequest.getSignParam(params), "interacts/qa/submit-one-question"), new CoreNetCallback(callBack));
    }

    public static void getQuestionHistory(String room_id, CallBack<QuestionHistoryListData> callBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("room_id", room_id);
        VHNetApi.getNetApi().doPost(ChatNetworkRequest.getBaseRequest(ChatNetworkRequest.getSignParam(params), "interacts/qa/get-webinar-history-questions"), new CoreNetCallback<QuestionHistoryListData>(callBack, QuestionHistoryListData.class));
    }
}

