/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhss.network;

import android.text.TextUtils;
import com.vhall.httpclient.core.IVHRequest;
import com.vhall.vhss.TokenManger;
import com.vhall.vhss.api.CoreApiConstant;
import com.vhall.vhss.api.CoreNetApi;
import com.vhall.vhss.netutils.EncryptionUtil;
import com.vhall.vhss.netutils.Md5Encode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BaseNetwork {
    private static final String PKG_KEY = "package_name";
    private static final String SIGNATURE_KEY = "signature";

    public static String createVssUrl(String api) {
        if (api.contains("http")) {
            return api;
        }
        return String.format("%s%s%s", CoreApiConstant.API_HOST, CoreApiConstant.API_AREA, api);
    }

    static HashMap<String, String> getSignParam(HashMap<String, String> params) {
        HashMap<String, String> param = params == null ? new HashMap<String, String>() : params;
        param.put("signed_at", String.valueOf(System.currentTimeMillis() / 1000L));
        if (TextUtils.equals((CharSequence)CoreApiConstant.API_PLATFORM, (CharSequence)"5")) {
            param.putAll(CoreNetApi.getNet().getHashMap());
            param.put("sign_type", TokenManger.getSignType());
        }
        return BaseNetwork.getParam(param);
    }

    private static HashMap<String, String> getParam(HashMap<String, String> params) {
        Object[] key = params.keySet().toArray(new String[0]);
        Arrays.sort(key);
        String param = "";
        String withOutExtraParam = "";
        for (Object k : key) {
            param = param + (String)k + params.get(k);
            if (TextUtils.equals((CharSequence)PKG_KEY, (CharSequence)k) || TextUtils.equals((CharSequence)SIGNATURE_KEY, (CharSequence)k)) continue;
            withOutExtraParam = withOutExtraParam + (String)k + params.get(k);
        }
        if (!TextUtils.isEmpty((CharSequence)CoreApiConstant.SECRET_KEY) && !TextUtils.equals((CharSequence)TokenManger.getSignType(), (CharSequence)"1")) {
            param = String.format("%s%s%s", CoreApiConstant.SECRET_KEY, param, CoreApiConstant.SECRET_KEY);
            withOutExtraParam = String.format("%s%s%s", CoreApiConstant.SECRET_KEY, withOutExtraParam, CoreApiConstant.SECRET_KEY);
        }
        String sign = "";
        String sign_special = "";
        if (TextUtils.equals((CharSequence)TokenManger.getSignType(), (CharSequence)"1") && TextUtils.equals((CharSequence)CoreApiConstant.API_PLATFORM, (CharSequence)"5")) {
            sign = EncryptionUtil.encrypt(Md5Encode.getMD5(param));
            sign_special = EncryptionUtil.encrypt(Md5Encode.getMD5(withOutExtraParam));
        } else if (TextUtils.equals((CharSequence)TokenManger.getSignType(), (CharSequence)"2") && TextUtils.equals((CharSequence)CoreApiConstant.API_PLATFORM, (CharSequence)"5")) {
            sign = EncryptionUtil.SHA256Signature(param);
            sign_special = EncryptionUtil.SHA256Signature(withOutExtraParam);
        } else if (TextUtils.equals((CharSequence)TokenManger.getSignType(), (CharSequence)"3") && TextUtils.equals((CharSequence)CoreApiConstant.API_PLATFORM, (CharSequence)"5")) {
            try {
                sign = EncryptionUtil.sm3Signature(param);
                sign_special = EncryptionUtil.sm3Signature(withOutExtraParam);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            sign = Md5Encode.getMD5(param);
            sign_special = Md5Encode.getMD5(withOutExtraParam);
        }
        params.put("sign", sign);
        params.put("sign_special", sign_special);
        if (params.containsKey(PKG_KEY)) {
            params.remove(PKG_KEY);
        }
        if (params.containsKey(SIGNATURE_KEY)) {
            params.remove(SIGNATURE_KEY);
        }
        if (TextUtils.equals((CharSequence)CoreApiConstant.API_PLATFORM, (CharSequence)"1")) {
            params.putAll(CoreNetApi.getNet().getHashMap());
        }
        return params;
    }

    static JSONObject getJsonSignParam(JSONObject params) throws JSONException {
        params.put("signed_at", (Object)String.valueOf(System.currentTimeMillis() / 1000L));
        if (TextUtils.equals((CharSequence)CoreApiConstant.API_PLATFORM, (CharSequence)"5")) {
            HashMap<String, String> map = CoreNetApi.getNet().getHashMap();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                params.put(entry.getKey(), (Object)entry.getValue());
            }
            params.put("sign_type", (Object)TokenManger.getSignType());
        }
        return BaseNetwork.getJsonParam(params);
    }

    private static JSONObject getJsonParam(JSONObject params) throws JSONException {
        Iterator keys = params.keys();
        ArrayList<String> list = new ArrayList<String>();
        while (keys.hasNext()) {
            list.add((String)keys.next());
        }
        Collections.sort(list);
        String param = "";
        String withOutExtraParam = "";
        for (String k : list) {
            Object object = params.get(k);
            String value = "";
            if (!(object instanceof JSONObject) && !(object instanceof JSONArray)) {
                value = params.optString(k);
            }
            param = param + k + value;
            if (TextUtils.equals((CharSequence)PKG_KEY, (CharSequence)k) || TextUtils.equals((CharSequence)SIGNATURE_KEY, (CharSequence)k)) continue;
            withOutExtraParam = withOutExtraParam + k + value;
        }
        if (!TextUtils.isEmpty((CharSequence)CoreApiConstant.SECRET_KEY) && !TextUtils.equals((CharSequence)TokenManger.getSignType(), (CharSequence)"1")) {
            param = String.format("%s%s%s", CoreApiConstant.SECRET_KEY, param, CoreApiConstant.SECRET_KEY);
            withOutExtraParam = String.format("%s%s%s", CoreApiConstant.SECRET_KEY, withOutExtraParam, CoreApiConstant.SECRET_KEY);
        }
        String sign = "";
        String sign_special = "";
        if (TextUtils.equals((CharSequence)TokenManger.getSignType(), (CharSequence)"1") && TextUtils.equals((CharSequence)CoreApiConstant.API_PLATFORM, (CharSequence)"5")) {
            sign = EncryptionUtil.encrypt(Md5Encode.getMD5(param));
            sign_special = EncryptionUtil.encrypt(Md5Encode.getMD5(withOutExtraParam));
        } else if (TextUtils.equals((CharSequence)TokenManger.getSignType(), (CharSequence)"2") && TextUtils.equals((CharSequence)CoreApiConstant.API_PLATFORM, (CharSequence)"5")) {
            sign = EncryptionUtil.SHA256Signature(param);
            sign_special = EncryptionUtil.SHA256Signature(withOutExtraParam);
        } else if (TextUtils.equals((CharSequence)TokenManger.getSignType(), (CharSequence)"3") && TextUtils.equals((CharSequence)CoreApiConstant.API_PLATFORM, (CharSequence)"5")) {
            try {
                sign = EncryptionUtil.sm3Signature(param);
                sign_special = EncryptionUtil.sm3Signature(withOutExtraParam);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            sign = Md5Encode.getMD5(param);
            sign_special = Md5Encode.getMD5(withOutExtraParam);
        }
        params.put("sign", (Object)sign);
        params.put("sign_special", (Object)sign_special);
        if (params.get(PKG_KEY) != null) {
            params.remove(PKG_KEY);
        }
        if (params.get(SIGNATURE_KEY) != null) {
            params.remove(SIGNATURE_KEY);
        }
        if (TextUtils.equals((CharSequence)CoreApiConstant.API_PLATFORM, (CharSequence)"1")) {
            HashMap<String, String> map = CoreNetApi.getNet().getHashMap();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                params.put(entry.getKey(), (Object)entry.getValue());
            }
        }
        return params;
    }

    static IVHRequest getBaseRequest(HashMap<String, String> params, String apiUrl) {
        String time_zone;
        try {
            Calendar cal = Calendar.getInstance();
            TimeZone tz = cal.getTimeZone();
            time_zone = tz.getID();
        }
        catch (Exception e) {
            e.printStackTrace();
            time_zone = "";
        }
        IVHRequest.Builder builder = new IVHRequest.Builder();
        builder.setUrl(BaseNetwork.createVssUrl(apiUrl)).addHeader("platform", CoreApiConstant.API_PLATFORM).addHeader("interact-token", TokenManger.getInteractToken()).addHeader("request-id", UUID.randomUUID().toString()).addHeader("gray-id", TextUtils.isEmpty((CharSequence)TokenManger.getGrayId()) ? "" : TokenManger.getGrayId()).addFormParas(params);
        builder.addHeader("token", TokenManger.getToken());
        if (!TextUtils.isEmpty((CharSequence)time_zone)) {
            builder.addHeader("zone", time_zone);
        }
        return builder.addFormParas(params).build();
    }

    static IVHRequest getBaseRequestGET(HashMap<String, String> params, String apiUrl) {
        String time_zone;
        try {
            Calendar cal = Calendar.getInstance();
            TimeZone tz = cal.getTimeZone();
            time_zone = tz.getID();
        }
        catch (Exception e) {
            e.printStackTrace();
            time_zone = "";
        }
        Object[] key = params.keySet().toArray(new String[0]);
        Arrays.sort(key);
        String param = "";
        for (Object k : key) {
            param = param + (String)k + "=" + params.get(k) + "&";
        }
        IVHRequest.Builder builder = new IVHRequest.Builder();
        builder.setUrl(BaseNetwork.createVssUrl(apiUrl) + "?" + param).addHeader("platform", CoreApiConstant.API_PLATFORM).addHeader("interact-token", TokenManger.getInteractToken()).addHeader("request-id", UUID.randomUUID().toString()).addHeader("gray-id", TextUtils.isEmpty((CharSequence)TokenManger.getGrayId()) ? "" : TokenManger.getGrayId());
        builder.addHeader("token", TokenManger.getToken());
        if (!TextUtils.isEmpty((CharSequence)time_zone)) {
            builder.addHeader("zone", time_zone);
        }
        return builder.build();
    }

    static IVHRequest getJsonBaseRequest(JSONObject params, String apiUrl) {
        String time_zone;
        try {
            Calendar cal = Calendar.getInstance();
            TimeZone tz = cal.getTimeZone();
            time_zone = tz.getID();
        }
        catch (Exception e) {
            e.printStackTrace();
            time_zone = "";
        }
        IVHRequest.Builder builder = new IVHRequest.Builder();
        builder.setUrl(BaseNetwork.createVssUrl(apiUrl)).addHeader("platform", CoreApiConstant.API_PLATFORM).addHeader("interact-token", TokenManger.getInteractToken()).addHeader("request-id", UUID.randomUUID().toString()).addHeader("gray-id", TextUtils.isEmpty((CharSequence)TokenManger.getGrayId()) ? "" : TokenManger.getGrayId()).setJson(params);
        builder.addHeader("token", TokenManger.getToken());
        if (!TextUtils.isEmpty((CharSequence)time_zone)) {
            builder.addHeader("zone", time_zone);
        }
        return builder.setJson(params).build();
    }
}

