/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhss.netutils;

import android.os.Bundle;
import android.text.TextUtils;
import com.vhall.httpclient.core.IVHNetCallback;
import com.vhall.httpclient.core.VHNetResponse;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.CallBackV2;
import com.vhall.vhss.TokenManger;
import com.vhall.vhss.data.ResponseJe;
import com.vhall.vhss.data.VhssUserInfoData;
import com.vhall.vhss.exception.ApiException;
import com.vhall.vhss.exception.CustomException;
import com.vhall.vhss.network.UserNetworkRequest;
import java.util.HashMap;
import java.util.Map;

public class CoreNetCallback<T>
implements IVHNetCallback {
    public static final String REQUEST_URL = "REQUEST_URL";
    public static final String USER_NAME = "user_name";
    public static final String PASS_WORD = "pass_word";
    public static final String DYNAMIC_CODE = "dynamic_code";
    public static final String THIRD_ID = "thirdId";
    public static final String HEAD_NET_URL = "headNetUrl";
    private static Map<String, String> sLoginParams = new HashMap<String, String>();
    private CallBack callback;
    private Class<T> clz;
    private Bundle bundle;

    public CoreNetCallback(CallBack callback) {
        this.callback = callback;
    }

    public CoreNetCallback(CallBack callback, Class<T> clz) {
        this.callback = callback;
        this.clz = clz;
    }

    public CoreNetCallback(CallBack callBack, Class<T> clz, Bundle bundle) {
        this.callback = callBack;
        this.clz = clz;
        this.bundle = bundle;
        if (bundle != null) {
            sLoginParams.clear();
            sLoginParams.put(USER_NAME, bundle.getString(USER_NAME));
            sLoginParams.put(PASS_WORD, bundle.getString(PASS_WORD));
            sLoginParams.put(DYNAMIC_CODE, bundle.getString(DYNAMIC_CODE));
            sLoginParams.put(THIRD_ID, bundle.getString(THIRD_ID));
            sLoginParams.put(HEAD_NET_URL, bundle.getString(HEAD_NET_URL));
        }
    }

    public void onFailure(VHNetResponse response, Exception e) {
        if (this.callback != null) {
            ApiException exception = CustomException.handleException(response.getResponseCode(), e);
            if (this.callback instanceof CallBackV2) {
                this.response(response);
            } else {
                this.callback.onError(exception.getCode(), exception.getMessage());
            }
        }
    }

    public void response(VHNetResponse response) {
        block11: {
            if (this.callback != null && response != null) {
                ResponseJe<T> data = new ResponseJe<T>(response.getResult(), this.clz);
                int code = data.getCode();
                if (code != 200) {
                    String msg;
                    if (!this.retryLogin(code) && this.isTokenExpired(code)) {
                        TokenManger.liveOutByError();
                    }
                    if (TextUtils.isEmpty((CharSequence)(msg = data.getMsg()))) {
                        msg = response.getResult();
                    }
                    if (this.callback instanceof CallBackV2) {
                        ((CallBackV2)this.callback).onError(data.getCode(), msg, data.getData());
                    } else {
                        this.callback.onError(data.getCode(), msg);
                    }
                    return;
                }
                if (null != this.clz) {
                    try {
                        this.callback.onSuccess(data.getData());
                    }
                    catch (Exception e) {
                        if (this.callback instanceof CallBackV2) {
                            ((CallBackV2)this.callback).onError(-1, e.getMessage(), data.getData());
                            break block11;
                        }
                        this.callback.onError(-1, e.getMessage());
                    }
                } else {
                    this.callback.onSuccess(response.getResult());
                }
            }
        }
    }

    private boolean isTokenExpired(int code) {
        return code == 511006 || code == 511005 || code == 511007 || code == 11005;
    }

    private boolean retryLogin(int code) {
        boolean retry = false;
        if (!this.isLoginUrl() && this.isTokenExpired(code)) {
            if (TextUtils.isEmpty((CharSequence)sLoginParams.get(THIRD_ID))) {
                this.retryByUser();
            } else {
                this.retryByThirdId();
            }
            retry = true;
        }
        return retry;
    }

    private boolean isLoginUrl() {
        if (this.bundle == null) {
            return false;
        }
        String requestUrl = this.bundle.getString(REQUEST_URL);
        if (!TextUtils.isEmpty((CharSequence)requestUrl)) {
            return requestUrl.contains("users/user/login") || requestUrl.contains("users/open-user/login") || requestUrl.contains("users/user/logout");
        }
        return false;
    }

    private void retryByThirdId() {
        String userName = sLoginParams.get(USER_NAME);
        String thirdId = sLoginParams.get(THIRD_ID);
        String headIcon = sLoginParams.get(HEAD_NET_URL);
        if (TextUtils.isEmpty((CharSequence)thirdId) || TextUtils.isEmpty((CharSequence)userName)) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("third_user_id", thirdId);
        map.put("nick_name", userName);
        map.put("head", headIcon);
        UserNetworkRequest.loginByThirdId(map, new CallBack<VhssUserInfoData>(){

            @Override
            public void onSuccess(VhssUserInfoData result) {
            }

            @Override
            public void onError(int eventCode, String msg) {
            }
        });
    }

    private void retryByUser() {
        String userName = sLoginParams.get(USER_NAME);
        String pwd = sLoginParams.get(PASS_WORD);
        String dynamicCode = sLoginParams.get(DYNAMIC_CODE);
        if (TextUtils.isEmpty((CharSequence)userName) || TextUtils.isEmpty((CharSequence)pwd)) {
            return;
        }
        UserNetworkRequest.login(userName, pwd, dynamicCode, new CallBack<VhssUserInfoData>(){

            @Override
            public void onSuccess(VhssUserInfoData result) {
            }

            @Override
            public void onError(int eventCode, String msg) {
            }
        });
    }
}

