/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhss.data;

import android.text.TextUtils;
import android.widget.ImageView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class OrderInfoData
implements Serializable {
    public String order_no;
    public String order_status;
    public String order_url;
    public String referer;
    public String trade_no;
    public String pay_time;
    public double total_amount;
    public double pay_amount;
    public String webinar_id;
    public String webinar_subject;
    public String created_at;
    public String username;
    public String phone;
    public String remark;
    public String channel_source;
    public String pay_channel;
    public String service_code;
    public Integer buy_type;
    public List<OrderItem> order_items;
    public String raw;

    public OrderInfoData() {
    }

    public OrderInfoData(JSONObject object) {
        JSONArray listArray;
        this.raw = object.toString();
        if (object == null) {
            return;
        }
        this.order_no = object.optString("order_no");
        this.order_status = object.optString("order_status");
        this.order_url = object.optString("ext");
        this.referer = object.optString("referer");
        this.trade_no = object.optString("trade_no");
        this.pay_time = object.optString("pay_time");
        this.total_amount = object.optDouble("total_amount");
        this.pay_amount = object.optDouble("pay_amount");
        this.webinar_id = object.optString("webinar_id");
        this.webinar_subject = object.optString("webinar_subject");
        this.created_at = object.optString("created_at");
        this.username = object.optString("username");
        this.phone = object.optString("phone");
        this.remark = object.optString("remark");
        this.channel_source = object.optString("channel_source");
        this.pay_channel = object.optString("pay_channel");
        this.service_code = object.optString("service_code");
        this.buy_type = object.optInt("buy_type");
        if (TextUtils.isEmpty((CharSequence)this.referer)) {
            this.referer = "https://vhall.com";
        }
        if (!this.referer.contains("http")) {
            this.referer = "https://" + this.referer;
        }
        if ((listArray = object.optJSONArray("order_items")) != null) {
            this.order_items = new ArrayList<OrderItem>();
            for (int i = 0; i < listArray.length(); ++i) {
                this.order_items.add(new OrderItem(listArray.optJSONObject(i)));
            }
        }
    }

    public static class OrderItem
    implements Serializable {
        public String goods_id;
        public String cover_img;
        public double price;
        public double discount_price;
        public Integer quantity;
        public ImageView.ScaleType cover_img_scale_type;

        public OrderItem() {
        }

        public OrderItem(JSONObject object) {
            this.goods_id = object.optString("goods_id");
            this.cover_img = object.optString("cover_img");
            this.price = object.optDouble("price");
            this.discount_price = object.optDouble("discount_price");
            this.quantity = object.optInt("quantity");
            if (!TextUtils.isEmpty((CharSequence)this.cover_img) && this.cover_img.contains("https://")) {
                if (this.cover_img.contains("mode=1")) {
                    this.cover_img_scale_type = ImageView.ScaleType.FIT_XY;
                } else if (this.cover_img.contains("mode=3")) {
                    this.cover_img_scale_type = ImageView.ScaleType.CENTER_CROP;
                }
            }
        }
    }
}

