/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.Shape;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.vhall.business.MessageServer;
import com.vhall.business.widget.DocumentView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WhiteBoardView
extends DocumentView {
    private static final String TAG = "WhiteBoardView";
    private boolean showDoc = true;
    List<MessageServer.MsgInfo> msgInfos = new ArrayList<MessageServer.MsgInfo>();

    public WhiteBoardView(Context context) {
        super(context);
    }

    public WhiteBoardView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public WhiteBoardView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init(Context context) {
        super.init(context);
        this.setBackgroundColor(-7829368);
        WhiteShape shape = new WhiteShape();
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)shape);
        shapeDrawable.setIntrinsicWidth(1024);
        shapeDrawable.setIntrinsicHeight(768);
        this.setImageDrawable((Drawable)shapeDrawable);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.translate(this.transX, this.transY);
        canvas.scale(this.scaleX, this.scaleY);
        if (this.msgInfos != null && this.msgInfos.size() > 0) {
            for (int i = 0; i < this.msgInfos.size(); ++i) {
                MessageServer.MsgInfo msgInfo = this.msgInfos.get(i);
                switch (msgInfo.event) {
                    case 21: {
                        this.paint(msgInfo, canvas);
                    }
                }
            }
        }
    }

    public void setShowDoc(boolean showDoc) {
        this.showDoc = showDoc;
    }

    @Override
    public void setSteps(String key, List<MessageServer.MsgInfo> list) {
        if (TextUtils.isEmpty((CharSequence)key) || !key.equals("board")) {
            return;
        }
        if (list != null && list.size() > 0) {
            this.msgInfos.clear();
            for (int i = 0; i < list.size(); ++i) {
                MessageServer.MsgInfo msgInfo = list.get(i);
                this.setStep(msgInfo, false);
            }
            this.invalidate();
        }
    }

    @Override
    public void setStep(MessageServer.MsgInfo msgInfo) {
        this.setStep(msgInfo, true);
    }

    private void setStep(MessageServer.MsgInfo msgInfo, boolean invalidate) {
        switch (msgInfo.event) {
            case 19: {
                if (msgInfo.showType == 1) {
                    if (!this.showDoc) break;
                    this.setVisibility(0);
                    break;
                }
                this.setVisibility(8);
                break;
            }
            case 21: {
                if (msgInfo.step == null) {
                    return;
                }
                if (msgInfo.step.type == 7) {
                    Iterator<MessageServer.MsgInfo> msgIter = this.msgInfos.iterator();
                    while (msgIter.hasNext()) {
                        MessageServer.MsgInfo info = msgIter.next();
                        if (info.step == null || info.step.id == -1 || info.step.type != 7) continue;
                        msgIter.remove();
                    }
                }
                this.msgInfos.add(msgInfo);
                if (!invalidate) break;
                this.invalidate();
                break;
            }
            case 22: {
                Iterator<MessageServer.MsgInfo> msgIter = this.msgInfos.iterator();
                while (msgIter.hasNext()) {
                    MessageServer.MsgInfo info = msgIter.next();
                    if (msgInfo.step == null || msgInfo.step.id == -1 || info.step == null || info.step.id == -1 || info.step.id != msgInfo.step.id) continue;
                    msgIter.remove();
                }
                if (!invalidate) break;
                this.invalidate();
                break;
            }
            case 23: {
                this.msgInfos.clear();
                if (!invalidate) break;
                this.invalidate();
                break;
            }
            case 20: {
                this.msgInfos.clear();
                if (!invalidate) break;
                this.invalidate();
            }
        }
    }

    class WhiteShape
    extends Shape {
        int remoteWidth = 1024;
        int remoteHeight = 768;

        WhiteShape() {
        }

        public void draw(Canvas canvas, Paint paint) {
            paint.setColor(-1);
            RectF rectF = new RectF(0.0f, 0.0f, (float)this.remoteWidth, (float)this.remoteHeight);
            canvas.drawRect(rectF, paint);
        }
    }
}

