/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.vhall.business.HttpDataSource;
import com.vhall.business.MessageServer;
import com.vhall.business.utils.LogManager;
import com.vhall.business.widget.DocumentView;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import okhttp3.Request;
import okhttp3.Response;

public class PPTView
extends DocumentView {
    private static final String TAG = "PPTView";
    ImageDownloadTask task = null;
    HashMap<String, List<MessageServer.MsgInfo>> map = new HashMap();
    List<MessageServer.MsgInfo> msgInfos = new ArrayList<MessageServer.MsgInfo>();
    private String currentKey = "";
    private Handler mHandler;

    @Override
    protected void init(Context context) {
        super.init(context);
        this.mContext = context;
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    public PPTView(Context context) {
        super(context);
        this.init(context);
    }

    public PPTView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public PPTView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.translate(this.transX, this.transY);
        canvas.scale(this.scaleX, this.scaleY);
        if (this.msgInfos != null && this.msgInfos.size() > 0) {
            for (int i = 0; i < this.msgInfos.size(); ++i) {
                MessageServer.MsgInfo msgInfo = this.msgInfos.get(i);
                switch (msgInfo.event) {
                    case 24: {
                        this.paint(msgInfo, canvas);
                    }
                }
            }
        }
    }

    @Override
    public void setSteps(String key, List<MessageServer.MsgInfo> list) {
        if (key.equals("board")) {
            return;
        }
        if (list != null && list.size() > 0) {
            this.map.clear();
            this.currentKey = "";
            if (!TextUtils.isEmpty((CharSequence)key)) {
                for (int i = 0; i < list.size(); ++i) {
                    MessageServer.MsgInfo msgInfo = list.get(i);
                    this.setStep(msgInfo, false);
                }
            }
        }
    }

    @Override
    public void setStep(MessageServer.MsgInfo msgInfo) {
        this.setStep(msgInfo, true);
    }

    private void setStep(MessageServer.MsgInfo msgInfo, boolean validate) {
        if (msgInfo != null) {
            String key = "";
            switch (msgInfo.event) {
                case 6: {
                    key = msgInfo.doc + "/" + msgInfo.page;
                    if (key.equals(this.currentKey)) break;
                    if (msgInfo.pptUrl == null) {
                        return;
                    }
                    this.task = new ImageDownloadTask(msgInfo.pptUrl);
                    this.task.execute(new Void[0]);
                    this.currentKey = key;
                    if (!this.map.keySet().contains(this.currentKey)) {
                        ArrayList list = new ArrayList();
                        this.map.put(this.currentKey, list);
                    }
                    this.msgInfos = this.map.get(this.currentKey);
                    break;
                }
                case 24: {
                    if (msgInfo.step == null) {
                        return;
                    }
                    key = msgInfo.step.pageID;
                    if (!key.equals(this.currentKey)) {
                        if (!this.map.keySet().contains(key)) {
                            ArrayList list = new ArrayList();
                            this.map.put(key, list);
                        }
                        this.map.get(key).add(msgInfo);
                        return;
                    }
                    if (msgInfo.step.type == 7) {
                        Iterator<MessageServer.MsgInfo> msgIter = this.msgInfos.iterator();
                        while (msgIter.hasNext()) {
                            MessageServer.MsgInfo info = msgIter.next();
                            if (info.step == null || info.step.id == -1 || info.step.type != 7) continue;
                            msgIter.remove();
                        }
                    }
                    this.msgInfos.add(msgInfo);
                    break;
                }
                case 25: {
                    if (msgInfo.step == null || this.msgInfos == null) {
                        return;
                    }
                    Iterator<MessageServer.MsgInfo> msgIter = this.msgInfos.iterator();
                    while (msgIter.hasNext()) {
                        MessageServer.MsgInfo info = msgIter.next();
                        if (info.step == null || info.step.id == -1 || info.step.id != msgInfo.step.id) continue;
                        msgIter.remove();
                    }
                    break;
                }
                case 32: {
                    if (this.msgInfos == null) {
                        return;
                    }
                    this.msgInfos.clear();
                }
            }
            if (validate) {
                this.invalidate();
            }
        }
    }

    public class ImageDownloadTask
    extends AsyncTask<Void, Void, Bitmap> {
        private final String imageURL;

        ImageDownloadTask(String url) {
            this.imageURL = url;
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected Bitmap doInBackground(Void ... params) {
            Bitmap bitmap = null;
            try {
                Request request = new Request.Builder().url(this.imageURL).build();
                Response response = HttpDataSource.getOkHttpClient().newCall(request).execute();
                InputStream is = response.body().byteStream();
                bitmap = BitmapFactory.decodeStream((InputStream)is);
                if (bitmap == null) {
                    return null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return bitmap;
        }

        protected void onPostExecute(Bitmap bitmap) {
            super.onPostExecute((Object)bitmap);
            PPTView.this.task = null;
            LogManager.innerLog(PPTView.TAG, "setImageBitmap:");
            PPTView.this.setImageBitmap(bitmap);
        }

        protected void onCancelled() {
            PPTView.this.task = null;
        }
    }
}

