/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.utils;

import android.text.TextUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VHInternalUtils {
    private static Map<String, Integer> sOnLineOrderRoles = new HashMap<String, Integer>();
    private static Map<String, Integer> sInteractiveOrderRoles = new HashMap<String, Integer>();

    public static boolean isEmpty(List list) {
        return list == null || list.isEmpty();
    }

    public static boolean isNotEmpty(List list) {
        return !VHInternalUtils.isEmpty(list);
    }

    public static boolean isEmpty(Object[] list) {
        return list == null || list.length == 0;
    }

    public static boolean isNotEmpty(Object[] list) {
        return !VHInternalUtils.isEmpty(list);
    }

    public static boolean isHost(String roleName) {
        return TextUtils.equals((CharSequence)roleName, (CharSequence)"1") || TextUtils.equals((CharSequence)roleName, (CharSequence)"host");
    }

    public static int getOrderNum(String role) {
        if (sOnLineOrderRoles.containsKey(role = VHInternalUtils.parseRoleNameToNum(role))) {
            return sOnLineOrderRoles.get(role);
        }
        return 2;
    }

    public static int getInteractiveOrderNum(String role) {
        if (sInteractiveOrderRoles.containsKey(role = VHInternalUtils.parseRoleNameToNum(role))) {
            return sInteractiveOrderRoles.get(role);
        }
        return 2;
    }

    public static String parseRoleNameToNum(String role) {
        if (TextUtils.isEmpty((CharSequence)role)) {
            return "2";
        }
        if (TextUtils.isDigitsOnly((CharSequence)role)) {
            return role;
        }
        if (TextUtils.equals((CharSequence)"host", (CharSequence)role)) {
            return "1";
        }
        if (TextUtils.equals((CharSequence)"user", (CharSequence)role)) {
            return "2";
        }
        if (TextUtils.equals((CharSequence)"assistant", (CharSequence)role)) {
            return "3";
        }
        if (TextUtils.equals((CharSequence)"guest", (CharSequence)role)) {
            return "4";
        }
        return "2";
    }

    public static int strToInt(String val) {
        if (!TextUtils.isEmpty((CharSequence)val) && TextUtils.isDigitsOnly((CharSequence)val)) {
            return Integer.valueOf(val);
        }
        return 0;
    }

    public static String switchToStrNumber(int val) {
        return String.valueOf(val);
    }

    public static String switchToStrNumber(Integer val) {
        if (val == null) {
            return "0";
        }
        return String.valueOf(val);
    }

    public static String switchToStrNumber(String val) {
        if (TextUtils.isEmpty((CharSequence)val) || !TextUtils.isDigitsOnly((CharSequence)val)) {
            return "0";
        }
        return String.valueOf(val);
    }

    static {
        sOnLineOrderRoles.put("1", 4);
        sOnLineOrderRoles.put("2", 1);
        sOnLineOrderRoles.put("3", 2);
        sOnLineOrderRoles.put("4", 3);
        sInteractiveOrderRoles.put("1", 8);
        sInteractiveOrderRoles.put("2", 5);
        sInteractiveOrderRoles.put("3", 6);
        sInteractiveOrderRoles.put("4", 7);
    }
}

