/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.module.warmup;

import com.vhall.business.H5MessageChange;
import com.vhall.business.NewH5ImManager;
import com.vhall.business.R;
import com.vhall.business.VhallSDK;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.module.warmup.WarmUp;
import com.vhall.business.module.warmup.WatchWarmUp;
import com.vhall.player.Constants;
import com.vhall.player.VHPlayerListener;
import com.vhall.vhss.data.WarmInfoData;
import com.vhall.vhss.data.WebinarInfoData;
import com.vhall.vod.VHVodPlayer;

public class WatchWarmUpNewH5
extends WarmUp {
    private VHVodPlayer mPlayer;
    private WebinarInfoData roomInfo = null;
    private VHPlayerListener innerListener = new VHPlayerListener(){

        public void onStateChanged(Constants.State state) {
            switch (state) {
                case START: {
                    WatchWarmUpNewH5.this.isPlaying = true;
                    break;
                }
                case PAUSE: 
                case STOP: 
                case END: {
                    WatchWarmUpNewH5.this.isPlaying = false;
                    break;
                }
            }
            if (WatchWarmUpNewH5.this.listener != null) {
                WatchWarmUpNewH5.this.listener.onStateChanged(state);
            }
        }

        public void onEvent(int i, String s) {
            if (i == -256) {
                if (WatchWarmUpNewH5.this.listener != null) {
                    WatchWarmUpNewH5.this.listener.onEvent(20300, WatchWarmUpNewH5.this.context.getString(R.string.event_init_play_success));
                }
                if (WatchWarmUpNewH5.this.mPlayer != null) {
                    WatchWarmUpNewH5.this.mPlayer.start();
                }
            }
            if (WatchWarmUpNewH5.this.listener != null) {
                WatchWarmUpNewH5.this.listener.onEvent(i, s);
            }
        }

        public void onError(int i, int i1, String s) {
            if (WatchWarmUpNewH5.this.listener != null) {
                WatchWarmUpNewH5.this.listener.onError(i, i1, s);
            }
        }
    };
    private H5MessageChange iMessageListener;
    private boolean isPlaying = false;

    WatchWarmUpNewH5(WatchWarmUp.Builder builder) {
        this.context = builder.context;
        if (builder.vodPlayerView != null) {
            this.vodPlayerView = builder.vodPlayerView;
        }
        this.listener = builder.listener;
        this.chatCallback = builder.chatCallback;
        this.messageCallback = builder.messageCallback;
        LogReportManager.doReport("115024");
    }

    @Override
    public void setWebinarInfo(WebinarInfo webinarInfo) {
        super.setWebinarInfo(webinarInfo);
        if (this.roomInfo == null && webinarInfo.getWebinarInfoData() != null) {
            this.roomInfo = webinarInfo.getWebinarInfoData();
            this.initPlay();
            this.initIM();
        }
    }

    private void initIM() {
        if (this.iMessageListener == null) {
            this.iMessageListener = new H5MessageChange(this.messageCallback, this.chatCallback, this.webinarInfo, new H5MessageChange.WebinarInfoChangeCallBack(){

                @Override
                public void dataChange(WebinarInfo data) {
                    WatchWarmUpNewH5.this.setWebinarInfo(data);
                }

                @Override
                public void kickedOut() {
                    if (WatchWarmUpNewH5.this.listener != null) {
                        WatchWarmUpNewH5.this.listener.onEvent(20023, VhallSDK.mContext.getString(R.string.error_login_more));
                    }
                }
            });
            NewH5ImManager.getInstance().enterRoom(this.roomInfo);
            NewH5ImManager.getInstance().setMessageListener(this.iMessageListener);
        }
    }

    private void initPlay() {
        this.mPlayer = new VHVodPlayer(this.context);
        if (this.vodPlayerView != null) {
            this.mPlayer.setDisplay(this.vodPlayerView);
        }
        if (this.listener != null) {
            this.mPlayer.setListener(this.innerListener);
        }
    }

    @Override
    public void setScaleType(int scaleType) {
        super.setScaleType(scaleType);
        if (this.mPlayer != null) {
            this.mPlayer.setDrawMode(scaleType);
        }
    }

    @Override
    public boolean isPlaying() {
        if (this.mPlayer != null) {
            return this.isPlaying;
        }
        return false;
    }

    @Override
    public void setDefinition(String dpi) {
        this.mCurrentDpi = dpi;
        if (this.mPlayer == null) {
            this.mPlayer.start();
        } else {
            this.mPlayer.setDPI(this.mCurrentDpi);
        }
    }

    @Override
    public void start(WarmInfoData.RecordListBean recordBean) {
        if (this.roomInfo == null || this.roomInfo.interact == null) {
            if (this.listener != null) {
                this.listener.onError(20202, 0, this.context.getString(R.string.error_video_msg_init));
            }
            return;
        }
        if (this.mPlayer == null) {
            this.initPlay();
        }
        this.mPlayer.init(recordBean.paas_record_id, this.roomInfo.interact.paas_access_token);
    }

    @Override
    public void pause() {
        if (this.mPlayer != null) {
            this.mPlayer.pause();
        }
    }

    @Override
    public void resume() {
        if (this.mPlayer != null) {
            this.mPlayer.resume();
        }
    }

    @Override
    public void stop() {
        if (this.mPlayer != null) {
            this.mPlayer.stop();
        }
    }

    @Override
    public long getCurrentPosition() {
        if (this.mPlayer != null) {
            return this.mPlayer.getPosition();
        }
        return 0L;
    }

    @Override
    public long getDuration() {
        if (this.mPlayer != null) {
            return this.mPlayer.getDuration();
        }
        return 0L;
    }

    @Override
    public void seekTo(long position) {
        if (this.mPlayer != null) {
            this.mPlayer.seekto(position);
        }
    }

    @Override
    public Constants.State getPlayerState() {
        if (this.mPlayer != null) {
            return this.mPlayer.getState();
        }
        return Constants.State.NONE;
    }

    @Override
    public float setSpeed(float speed) {
        if (this.mPlayer != null) {
            return this.mPlayer.setSpeed(speed);
        }
        return 1.0f;
    }

    @Override
    public void destroy() {
        if (this.mPlayer != null) {
            this.mPlayer.release();
        }
        this.mPlayer = null;
        NewH5ImManager.getInstance().removeMessageListener(this.iMessageListener);
        NewH5ImManager.getInstance().leaveRoom();
    }
}

