/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.module.survey;

import android.content.Context;
import com.vhall.business.NewH5ImManager;
import com.vhall.business.VhallSDK;
import com.vhall.business.data.RequestDataCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.module.survey.ISurvey;
import com.vhall.business.module.survey.SurveyMessageCallBack;
import com.vhall.business.utils.SurveyInternal;

public class SurveyServer
implements ISurvey {
    private WebinarInfo webinarInfo;
    private Context context;
    private SurveyMessageCallBack surveyMessageCallBack;

    private void SurveyServer() {
    }

    private SurveyServer(Builder builder) {
        this.context = builder.context;
        this.webinarInfo = builder.webinarInfo;
        this.surveyMessageCallBack = builder.surveyMessageCallBack;
        if (this.surveyMessageCallBack != null) {
            NewH5ImManager.getInstance().setMessageCallBackMap("key_survey", this.surveyMessageCallBack);
        }
    }

    @Override
    public void getHistorySurveyList(RequestDataCallback callBack) {
        if (this.webinarInfo != null) {
            VhallSDK.getHistorySurveyList(this.webinarInfo.switch_id, this.webinarInfo.vss_room_id, this.webinarInfo.webinar_id, callBack);
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    @Override
    public String getSurveyUrl(String questionId) {
        if (this.webinarInfo != null) {
            return SurveyInternal.createSurveyUrl(this.webinarInfo, questionId);
        }
        return "";
    }

    public static class Builder {
        WebinarInfo webinarInfo;
        Context context;
        SurveyMessageCallBack surveyMessageCallBack;

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder surveyMessageCallBack(SurveyMessageCallBack surveyMessageCallBack) {
            this.surveyMessageCallBack = surveyMessageCallBack;
            return this;
        }

        public Builder webinarInfo(WebinarInfo webinarInfo) {
            this.webinarInfo = webinarInfo;
            return this;
        }

        public SurveyServer build() {
            if (this.webinarInfo == null) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            if (this.webinarInfo.is_new_version == 3 && (this.webinarInfo.getWebinarInfoData() == null || this.webinarInfo.getWebinarInfoData().interact == null)) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            return new SurveyServer(this);
        }
    }
}

