/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.module.lottery;

import android.content.Context;
import android.text.TextUtils;
import com.vhall.business.ErrorCode;
import com.vhall.business.NewH5ImManager;
import com.vhall.business.VhallCallback;
import com.vhall.business.VhallSDK;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.data.LotteryPrizeListInfo;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.RequestDataCallback;
import com.vhall.business.data.RequestDataCallbackV2;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.module.lottery.LotteryMessageCallBack;
import com.vhall.vhss.data.LotteryWinningDetailData;
import com.vhall.vhss.data.LotteryWinningUserInfoData;
import java.util.List;

public class LotteryServer {
    private WebinarInfo webinarInfo;
    private Context context;
    private LotteryMessageCallBack lotteryMessageCallBack;

    private void LotteryServer() {
        LotteryServer.initNetRequestInfo();
    }

    private LotteryServer(Builder builder) {
        this.context = builder.context;
        this.webinarInfo = builder.webinarInfo;
        this.lotteryMessageCallBack = builder.lotteryMessageCallBack;
        if (this.lotteryMessageCallBack != null) {
            NewH5ImManager.getInstance().setMessageCallBackMap("key_lottery", this.lotteryMessageCallBack);
        }
        LotteryServer.initNetRequestInfo();
        LogReportManager.doReport("115044");
    }

    private static void initNetRequestInfo() {
    }

    public static void getHistoryLotteryList(String show_all, RequestDataCallback callBack) {
        if (!VhallSDK.isLogin()) {
            VhallCallback.ErrorCallback(callBack, 20004, ErrorCode.ERROR_MSG_ISLOGIN);
            return;
        }
        VhallSDK.getHistoryLotteryList(show_all, callBack);
    }

    public static void submitLotteryInfo(String join_id, String lottery_id, String name, String phone, String remark, RequestCallback callBack) {
        if (TextUtils.isEmpty((CharSequence)join_id) || TextUtils.isEmpty((CharSequence)lottery_id) || TextUtils.isEmpty((CharSequence)name) || TextUtils.isEmpty((CharSequence)join_id.trim()) || TextUtils.isEmpty((CharSequence)lottery_id.trim()) || TextUtils.isEmpty((CharSequence)name.trim())) {
            VhallCallback.ErrorCallback(callBack, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        VhallSDK.submitLotteryInfo(join_id.trim(), lottery_id.trim(), name.trim(), TextUtils.isEmpty((CharSequence)phone) ? "" : phone.trim(), TextUtils.isEmpty((CharSequence)remark) ? "" : remark.trim(), callBack);
    }

    public static void submitLotteryInfo(String lottery_id, List<LotteryPrizeListInfo> infoList, RequestCallback callBack) {
        if (TextUtils.isEmpty((CharSequence)lottery_id) || TextUtils.isEmpty((CharSequence)lottery_id.trim()) || infoList == null || infoList.isEmpty()) {
            VhallCallback.ErrorCallback(callBack, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        VhallSDK.submitLotteryInfo(lottery_id.trim(), infoList, callBack);
    }

    @Deprecated
    public static void getPrizeInfo(String webinarId, RequestDataCallback callBack) {
        if (TextUtils.isEmpty((CharSequence)webinarId)) {
            VhallCallback.ErrorCallback(callBack, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        VhallSDK.getPrizeInfo(webinarId, callBack);
    }

    public static void getPrizeInfo(String webinarId, String lottery_id, RequestDataCallback callBack) {
        if (TextUtils.isEmpty((CharSequence)webinarId)) {
            VhallCallback.ErrorCallback(callBack, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        VhallSDK.getPrizeInfo(webinarId, lottery_id, callBack);
    }

    public static void getLotteryWinner(String room_id, String lottery_id, RequestDataCallback callBack) {
        if (TextUtils.isEmpty((CharSequence)room_id) || TextUtils.isEmpty((CharSequence)lottery_id)) {
            VhallCallback.ErrorCallback(callBack, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        VhallSDK.getLotteryWinner(room_id, lottery_id, callBack);
    }

    public static void joinCodeLottery(String room_id, String lottery_id, String command, RequestCallback callBack) {
        if (TextUtils.isEmpty((CharSequence)command) || TextUtils.isEmpty((CharSequence)lottery_id) || TextUtils.isEmpty((CharSequence)room_id) || TextUtils.isEmpty((CharSequence)command.trim()) || TextUtils.isEmpty((CharSequence)lottery_id.trim()) || TextUtils.isEmpty((CharSequence)room_id.trim())) {
            VhallCallback.ErrorCallback(callBack, 20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        VhallSDK.joinCodeLottery(room_id.trim(), lottery_id.trim(), command.trim(), callBack);
    }

    public static void lotteryCheck(RequestDataCallback callBack) {
        VhallSDK.lotteryCheck(callBack);
    }

    public static void lotteryWinningDetail(String room_id, String lottery_id, RequestDataCallbackV2<LotteryWinningDetailData> callBack) {
        VhallSDK.lotteryWinningDetail(room_id, lottery_id, callBack);
    }

    public static void lotteryWinningUserInfo(String room_id, RequestDataCallbackV2<LotteryWinningUserInfoData> callBack) {
        VhallSDK.lotteryWinningUserInfo(room_id, callBack);
    }

    public static class Builder {
        WebinarInfo webinarInfo;
        Context context;
        LotteryMessageCallBack lotteryMessageCallBack;

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder lotteryMessageCallBack(LotteryMessageCallBack lotteryMessageCallBack) {
            this.lotteryMessageCallBack = lotteryMessageCallBack;
            return this;
        }

        public Builder webinarInfo(WebinarInfo webinarInfo) {
            this.webinarInfo = webinarInfo;
            return this;
        }

        public LotteryServer build() {
            if (this.webinarInfo == null) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            if (this.context == null) {
                throw new IllegalArgumentException("context can not be null");
            }
            if (this.webinarInfo.is_new_version == 3 && (this.webinarInfo.getWebinarInfoData() == null || this.webinarInfo.getWebinarInfoData().interact == null)) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            return new LotteryServer(this);
        }
    }
}

