/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.module.like;

import android.content.Context;
import com.vhall.business.NewH5ImManager;
import com.vhall.business.VhallSDK;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.RequestDataCallbackV2;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.module.like.ILike;
import com.vhall.business.module.like.LikeMessageCallBack;

public class LikeServer
implements ILike {
    private WebinarInfo webinarInfo;
    private Context context;
    private LikeMessageCallBack likeMessageCallBack;

    private void LikeServer() {
    }

    private LikeServer(Builder builder) {
        this.context = builder.context;
        this.webinarInfo = builder.webinarInfo;
        this.likeMessageCallBack = builder.likeMessageCallBack;
        if (this.likeMessageCallBack != null) {
            NewH5ImManager.getInstance().setMessageCallBackMap("key_like", this.likeMessageCallBack);
        }
        LogReportManager.doReport("115026");
    }

    @Override
    public void userLike(String num, RequestCallback callBack) {
        if (this.webinarInfo != null) {
            VhallSDK.userLike(this.webinarInfo.vss_room_id, num, callBack);
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    @Override
    public void getRoomLike(RequestDataCallbackV2<Integer> callBack) {
        if (this.webinarInfo != null) {
            VhallSDK.getRoomLike(this.webinarInfo.vss_room_id, callBack);
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    public static class Builder {
        WebinarInfo webinarInfo;
        Context context;
        LikeMessageCallBack likeMessageCallBack;

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder likeMessageCallBack(LikeMessageCallBack likeMessageCallBack) {
            this.likeMessageCallBack = likeMessageCallBack;
            return this;
        }

        public Builder webinarInfo(WebinarInfo webinarInfo) {
            this.webinarInfo = webinarInfo;
            return this;
        }

        public LikeServer build() {
            if (this.webinarInfo == null) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            if (this.webinarInfo.is_new_version == 3 && (this.webinarInfo.getWebinarInfoData() == null || this.webinarInfo.getWebinarInfoData().interact == null)) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            return new LikeServer(this);
        }
    }
}

