/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.module.goods;

import android.annotation.TargetApi;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.vhall.business.NewH5ImManager;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.data.RequestDataCallbackV2;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.data.WebinarInfoRemote;
import com.vhall.business.module.goods.GoodsMessageCallBack;
import com.vhall.business.support.WrapperCallback;
import com.vhall.logmanager.VLog;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.data.CouponInfoData;
import com.vhall.vhss.data.GoodsInfoData;
import com.vhall.vhss.data.GoodsOrderSetting;
import com.vhall.vhss.data.OrderInfoData;
import com.vhall.vhss.network.InteractToolsNetworkRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoodsServer {
    private WebinarInfo webinarInfo;
    private Context context;
    private GoodsMessageCallBack goodsMessageCallBack;
    private static WebSettings webSettings;
    private static WebView vhwebView;
    public static final String PAY_TYPE_WEIXIN = "WEIXIN";
    public static final String PAY_TYPE_ALIPAY = "ALIPAY";

    private void GoodsServer() {
    }

    private GoodsServer(Builder builder) {
        this.context = builder.context;
        this.webinarInfo = builder.webinarInfo;
        this.goodsMessageCallBack = builder.goodsMessageCallBack;
        if (this.goodsMessageCallBack != null) {
            NewH5ImManager.getInstance().setMessageCallBackMap("key_goods", this.goodsMessageCallBack);
        }
        LogReportManager.doReport("115045");
        this.getWebView(this.context);
    }

    public void getGoodsList(RequestDataCallbackV2<GoodsInfoData> callBack) {
        if (this.webinarInfo != null) {
            WebinarInfoRemote.getGoodsList(this.webinarInfo.webinar_id, 1, callBack);
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    public void getGoodsList(int status, RequestDataCallbackV2<GoodsInfoData> callBack) {
        if (this.webinarInfo != null) {
            WebinarInfoRemote.getGoodsList(this.webinarInfo.webinar_id, status, callBack);
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    public static void getGoodsList(String webinar_id, int status, RequestDataCallbackV2<GoodsInfoData> callBack) {
        if (webinar_id != null) {
            WebinarInfoRemote.getGoodsList(webinar_id, status, callBack);
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    public static void getGoodsInfo(String goods_id, RequestDataCallbackV2<GoodsInfoData.GoodsInfo> callBack) {
        if (goods_id != null) {
            WebinarInfoRemote.getGoodsInfo(goods_id, callBack);
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    public void getGoodsOrderSetting(final RequestDataCallbackV2<GoodsOrderSetting> callBack) {
        if (this.webinarInfo != null) {
            final GoodsOrderSetting setting = new GoodsOrderSetting();
            WebinarInfoRemote.getGoodsOrderSetting(this.webinarInfo.webinar_id, new RequestDataCallbackV2<GoodsOrderSetting>(){

                @Override
                public void onSuccess(GoodsOrderSetting data) {
                    setting.webinar_id = data.webinar_id;
                    setting.enable_username = data.enable_username;
                    setting.enable_phone = data.enable_phone;
                    setting.enable_remark = data.enable_remark;
                    WebinarInfoRemote.getGoodsPartnerList(((GoodsServer)GoodsServer.this).webinarInfo.webinar_id, new RequestDataCallbackV2<String>(){

                        @Override
                        public void onSuccess(String data) {
                            block5: {
                                try {
                                    JSONObject json = new JSONObject(data);
                                    JSONArray list = json.optJSONArray("list");
                                    for (int i = 0; i < list.length(); ++i) {
                                        JSONObject item = list.optJSONObject(i);
                                        if (item.optString("channel").equals(GoodsServer.PAY_TYPE_WEIXIN)) {
                                            setting.enable_weixin = true;
                                        }
                                        if (!item.optString("channel").equals(GoodsServer.PAY_TYPE_ALIPAY)) continue;
                                        setting.enable_alipay = true;
                                    }
                                    if (callBack != null) {
                                        callBack.onSuccess(setting);
                                    }
                                }
                                catch (JSONException e) {
                                    if (callBack == null) break block5;
                                    callBack.onError(-1, "JSONObject error");
                                }
                            }
                        }

                        @Override
                        public void onError(int errorCode, String errorMsg) {
                            if (callBack != null) {
                                callBack.onError(errorCode, errorMsg);
                            }
                        }
                    });
                }

                @Override
                public void onError(int errorCode, String errorMsg) {
                    if (callBack != null) {
                        callBack.onError(errorCode, errorMsg);
                    }
                }
            });
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    public void createOrder(String goods_id, int quantity, double pay_amount, String pay_channel, String username, String phone, String remark, String channel_source, RequestDataCallbackV2<OrderInfoData> callBack) {
        this.createOrder(goods_id, quantity, pay_amount, pay_channel, username, phone, remark, channel_source, null, callBack);
    }

    public void createOrder(String goods_id, int quantity, double pay_amount, String pay_channel, String username, String phone, String remark, String channel_source, List<String> coupon_user_ids, RequestDataCallbackV2<OrderInfoData> callBack) {
        if (this.webinarInfo != null && !TextUtils.isEmpty((CharSequence)goods_id)) {
            if (quantity < 1) {
                quantity = 1;
            }
            if (pay_amount < 0.0) {
                pay_amount = 0.0;
            }
            try {
                JSONObject params = new JSONObject();
                params.put("switch_id", (Object)this.webinarInfo.switch_id);
                params.put("third_user_id", (Object)this.webinarInfo.user_id);
                params.put("username", (Object)(TextUtils.isEmpty((CharSequence)username) ? "" : username));
                params.put("phone", (Object)(TextUtils.isEmpty((CharSequence)phone) ? "" : phone));
                params.put("remark", (Object)(TextUtils.isEmpty((CharSequence)remark) ? "" : remark));
                params.put("pay_channel", (Object)(TextUtils.isEmpty((CharSequence)pay_channel) ? "" : pay_channel));
                params.put("channel_source", (Object)(TextUtils.isEmpty((CharSequence)channel_source) ? "main" : channel_source));
                params.put("pay_amount", (Object)String.format("%.2f", pay_amount));
                params.put("service_code", (Object)"H5_PAY");
                JSONObject good = new JSONObject();
                good.put("goods_id", (Object)goods_id);
                good.put("quantity", quantity);
                JSONArray goods = new JSONArray();
                goods.put((Object)good);
                params.put("goods", (Object)goods);
                if (coupon_user_ids != null) {
                    JSONArray coupons = new JSONArray();
                    for (String ids : coupon_user_ids) {
                        coupons.put((Object)ids);
                    }
                    params.put("coupon_user_ids", (Object)coupons);
                }
                InteractToolsNetworkRequest.goodsOrderCreate(params, new WrapperCallback<OrderInfoData>(callBack));
            }
            catch (Exception e) {
                if (callBack != null) {
                    callBack.onError(-1, e.getMessage());
                }
            }
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    public void payOrder(OrderInfoData orderInfo, RequestDataCallbackV2<String> callBack) {
        this.payOrder(null, orderInfo, callBack);
    }

    public void payOrder(Context ctx, OrderInfoData orderInfo, final RequestDataCallbackV2<String> callBack) {
        if (ctx == null) {
            ctx = this.context;
        }
        final Context finalCtx = ctx;
        vhwebView.setWebViewClient(new WebViewClient(){

            @TargetApi(value=21)
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                String url = request.getUrl().toString();
                VLog.e((String)"GoodsServer", (String)url);
                if (!url.startsWith("http")) {
                    block4: {
                        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                        try {
                            finalCtx.startActivity(intent);
                            if (callBack != null) {
                                callBack.onSuccess("\u5524\u8d77\u4e09\u65b9\u5e94\u7528\u652f\u4ed8");
                            }
                        }
                        catch (ActivityNotFoundException e) {
                            if (callBack == null) break block4;
                            callBack.onError(10001, "\u672a\u5b89\u88c5\u5e94\u7528");
                        }
                    }
                    vhwebView.loadUrl("about:blank");
                    return true;
                }
                return false;
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                vhwebView.clearCache(true);
                vhwebView.clearHistory();
                vhwebView.freeMemory();
            }
        });
        HashMap<String, String> webviewHead = new HashMap<String, String>();
        webviewHead.put("Referer", orderInfo.referer);
        vhwebView.loadUrl(orderInfo.order_url, webviewHead);
    }

    public void getGoodsOrderInfo(String order_no, RequestDataCallbackV2<OrderInfoData> callBack) {
        if (!TextUtils.isEmpty((CharSequence)order_no)) {
            InteractToolsNetworkRequest.getGoodsOrderInfo(order_no, new WrapperCallback<OrderInfoData>(callBack));
        } else if (callBack != null) {
            callBack.onError(-1, "order_no can not be null");
        }
    }

    public static void getCouponAvailableList(String webinar_id, String goods_id, Integer goods_num, final RequestDataCallbackV2<CouponInfoData> callBack) {
        InteractToolsNetworkRequest.getCouponAvailableList(webinar_id, goods_id, goods_num, new CallBack<ArrayList<CouponInfoData.CouponItem>>(){

            @Override
            public void onSuccess(ArrayList<CouponInfoData.CouponItem> result) {
                CouponInfoData data = new CouponInfoData();
                data.total = result.size();
                data.coupon_items = result;
                if (callBack != null) {
                    callBack.onSuccess(data);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callBack != null) {
                    callBack.onError(eventCode, msg);
                }
            }
        });
    }

    public static void getCouponUnavailableList(String webinar_id, String goods_id, Integer goods_num, final RequestDataCallbackV2<CouponInfoData> callBack) {
        InteractToolsNetworkRequest.getCouponUnavailableList(webinar_id, goods_id, goods_num, new CallBack<ArrayList<CouponInfoData.CouponItem>>(){

            @Override
            public void onSuccess(ArrayList<CouponInfoData.CouponItem> result) {
                CouponInfoData data = new CouponInfoData();
                data.total = result.size();
                data.coupon_items = result;
                if (callBack != null) {
                    callBack.onSuccess(data);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callBack != null) {
                    callBack.onError(eventCode, msg);
                }
            }
        });
    }

    WebView getWebView(Context context) {
        if (vhwebView == null && context != null) {
            vhwebView = new WebView(context.getApplicationContext());
            webSettings = vhwebView.getSettings();
            webSettings.setJavaScriptEnabled(true);
            webSettings.setDomStorageEnabled(true);
            webSettings.setUseWideViewPort(true);
            webSettings.setLoadWithOverviewMode(true);
            webSettings.setDomStorageEnabled(true);
            webSettings.setAllowContentAccess(true);
            webSettings.setAllowFileAccess(true);
            webSettings.setAllowFileAccessFromFileURLs(true);
            webSettings.setAllowUniversalAccessFromFileURLs(true);
            webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
            webSettings.setDefaultTextEncodingName("UTF-8");
        }
        return vhwebView;
    }

    public static class Builder {
        WebinarInfo webinarInfo;
        Context context;
        GoodsMessageCallBack goodsMessageCallBack;

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder goodsMessageCallBack(GoodsMessageCallBack goodsMessageCallBack) {
            this.goodsMessageCallBack = goodsMessageCallBack;
            return this;
        }

        public Builder webinarInfo(WebinarInfo webinarInfo) {
            this.webinarInfo = webinarInfo;
            return this;
        }

        public GoodsServer build() {
            if (this.webinarInfo == null) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            if (this.context == null) {
                throw new IllegalArgumentException("context can not be null");
            }
            if (this.webinarInfo.is_new_version == 3 && (this.webinarInfo.getWebinarInfoData() == null || this.webinarInfo.getWebinarInfoData().interact == null)) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            return new GoodsServer(this);
        }
    }
}

