/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.module.gift;

import android.content.Context;
import com.vhall.business.NewH5ImManager;
import com.vhall.business.VhallSDK;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.RequestDataCallbackV2;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.module.gift.GiftMessageCallBack;
import com.vhall.business.module.gift.IGift;
import com.vhall.vhss.data.GiftListData;

public class GiftServer
implements IGift {
    private WebinarInfo webinarInfo;
    private Context context;
    private GiftMessageCallBack giftMessageCallBack;

    private void GiftServer() {
    }

    private GiftServer(Builder builder) {
        this.context = builder.context;
        this.webinarInfo = builder.webinarInfo;
        this.giftMessageCallBack = builder.giftMessageCallBack;
        if (this.giftMessageCallBack != null) {
            NewH5ImManager.getInstance().setMessageCallBackMap("key_gift", this.giftMessageCallBack);
        }
        LogReportManager.doReport("115022");
    }

    @Override
    public void getGiftList(RequestDataCallbackV2<GiftListData> callBack) {
        if (this.webinarInfo != null) {
            VhallSDK.getGiftList(this.webinarInfo.vss_room_id, callBack);
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    @Override
    public void sendGift(String gift_id, String channel, String service_code, String open_id, RequestCallback callBack) {
        if (this.webinarInfo != null) {
            VhallSDK.sendGift(this.webinarInfo.vss_room_id, gift_id, channel, service_code, open_id, callBack);
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    public static class Builder {
        WebinarInfo webinarInfo;
        Context context;
        GiftMessageCallBack giftMessageCallBack;

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder giftMessageCallBack(GiftMessageCallBack giftMessageCallBack) {
            this.giftMessageCallBack = giftMessageCallBack;
            return this;
        }

        public Builder webinarInfo(WebinarInfo webinarInfo) {
            this.webinarInfo = webinarInfo;
            return this;
        }

        public GiftServer build() {
            if (this.webinarInfo == null) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            if (this.webinarInfo.is_new_version == 3 && (this.webinarInfo.getWebinarInfoData() == null || this.webinarInfo.getWebinarInfoData().interact == null)) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            return new GiftServer(this);
        }
    }
}

