/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.module.exam;

import android.content.Context;
import com.vhall.business.NewH5ImManager;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.RequestDataCallbackV2;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.impl.VhssSimpleCallBack;
import com.vhall.business.module.exam.ExamMessageCallBack;
import com.vhall.business.module.exam.IExam;
import com.vhall.business.utils.ExamInternal;
import com.vhall.vhss.data.ExamAnswerPaperHistoryData;
import com.vhall.vhss.data.ExamInfoData;
import com.vhall.vhss.data.ExamListData;
import com.vhall.vhss.data.ExamRankListData;
import com.vhall.vhss.data.ExamScoreInfoData;
import com.vhall.vhss.data.ExamUserFormCheckData;
import com.vhall.vhss.data.ExamUserFormData;
import com.vhall.vhss.data.WebinarinfoListData;
import com.vhall.vhss.network.ExamNetworkRequest;

public class ExamServer
implements IExam {
    private WebinarInfo webinarInfo;
    private Context context;
    private ExamMessageCallBack examMessageCallBack;

    private void ExamServer() {
    }

    private ExamServer(Builder builder) {
        this.context = builder.context;
        this.webinarInfo = builder.webinarInfo;
        this.examMessageCallBack = builder.examMessageCallBack;
        if (this.examMessageCallBack != null) {
            NewH5ImManager.getInstance().setMessageCallBackMap("key_exam", this.examMessageCallBack);
        }
    }

    @Override
    public void examUserFormCheck(String user_name, String head_img, String mobile, RequestDataCallbackV2<ExamUserFormCheckData> callBack) {
        if (this.webinarInfo != null) {
            ExamNetworkRequest.examUserFormCheck(this.webinarInfo.webinar_id, user_name, head_img, mobile, new VhssSimpleCallBack<ExamUserFormCheckData>(callBack));
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    @Override
    public void examGetUserFormInfo(String paper_id, RequestDataCallbackV2<ExamUserFormData> callBack) {
        if (this.webinarInfo != null) {
            ExamNetworkRequest.examGetUserFormInfo(this.webinarInfo.webinar_id, paper_id, new VhssSimpleCallBack<ExamUserFormData>(callBack));
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    @Override
    public void examSendVerifyCode(String phone, String country_code, RequestCallback callBack) {
        if (this.webinarInfo != null) {
            ExamNetworkRequest.examSendVerifyCode(this.webinarInfo.webinar_id, phone, country_code, new VhssSimpleCallBack(callBack));
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    @Override
    public void examVerifyCode(String paper_id, String phone, String verify_code, String country_code, RequestCallback callBack) {
        if (this.webinarInfo != null) {
            ExamNetworkRequest.examVerifyCode(this.webinarInfo.webinar_id, paper_id, phone, verify_code, country_code, new VhssSimpleCallBack(callBack));
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    @Override
    public void examSaveUserForm(String user_detail, String paper_id, String verify_code, RequestCallback callBack) {
        if (this.webinarInfo != null) {
            ExamNetworkRequest.examSaveUserForm(this.webinarInfo.webinar_id, paper_id, user_detail, verify_code, new VhssSimpleCallBack(callBack));
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    @Override
    public void examGetPushedPaperList(RequestDataCallbackV2<ExamListData> callBack) {
        if (this.webinarInfo != null) {
            ExamNetworkRequest.examGetPushedPaperList(this.webinarInfo.webinar_id, this.webinarInfo.switch_id, new VhssSimpleCallBack<ExamListData>(callBack));
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    @Override
    public void examGetPaperInfoForWatch(String paper_id, RequestDataCallbackV2<ExamInfoData> callBack) {
        if (this.webinarInfo != null) {
            ExamNetworkRequest.examGetPaperInfoForWatch(this.webinarInfo.webinar_id, paper_id, new VhssSimpleCallBack<ExamInfoData>(callBack));
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    @Override
    public void examAnswerQuestion(String paper_id, String user_answer, String question_id, RequestCallback callBack) {
        if (this.webinarInfo != null) {
            ExamNetworkRequest.examAnswerQuestion(this.webinarInfo.webinar_id, paper_id, user_answer, question_id, new VhssSimpleCallBack(callBack));
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    @Override
    public void examInitiativeSubmitPaper(String paper_id, RequestCallback callBack) {
        if (this.webinarInfo != null) {
            ExamNetworkRequest.examInitiativeSubmitPaper(this.webinarInfo.webinar_id, paper_id, new VhssSimpleCallBack<WebinarinfoListData>(callBack));
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    @Override
    public void examGetUserAnswerPaperHistory(String paper_id, RequestDataCallbackV2<ExamAnswerPaperHistoryData> callBack) {
        if (this.webinarInfo != null) {
            ExamNetworkRequest.examGetUserAnswerPaperHistory(this.webinarInfo.webinar_id, paper_id, new VhssSimpleCallBack<ExamAnswerPaperHistoryData>(callBack));
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    public void examGetSimpleRankList(String paper_id, String pos, RequestDataCallbackV2<ExamRankListData> callBack) {
        this.examGetSimpleRankList(paper_id, pos, "20", callBack);
    }

    @Override
    public void examGetSimpleRankList(String paper_id, String pos, String limit, RequestDataCallbackV2<ExamRankListData> callBack) {
        try {
            int lim = Integer.parseInt(limit);
            if (lim < 1) {
                limit = "20";
            }
        }
        catch (Exception e) {
            limit = "20";
        }
        if (this.webinarInfo != null) {
            ExamNetworkRequest.examGetSimpleRankList(this.webinarInfo.webinar_id, paper_id, pos, limit, new VhssSimpleCallBack<ExamRankListData>(callBack));
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    @Override
    public void examPersonScoreInfo(String paper_id, RequestDataCallbackV2<ExamScoreInfoData> callBack) {
        if (this.webinarInfo != null) {
            ExamNetworkRequest.examPersonScoreInfo(this.webinarInfo.webinar_id, paper_id, new VhssSimpleCallBack<ExamScoreInfoData>(callBack));
        } else if (callBack != null) {
            callBack.onError(-1, "webinarInfo can not be null");
        }
    }

    @Override
    public String getExamUrl(String paper_id) {
        if (this.webinarInfo != null) {
            return ExamInternal.createExamUrl(this.webinarInfo, paper_id, "owner");
        }
        return "";
    }

    @Override
    public String getExamRankUrl(String paper_id) {
        if (this.webinarInfo != null) {
            return ExamInternal.createExamUrl(this.webinarInfo, paper_id, "rank");
        }
        return "";
    }

    public static String getExamUrl(WebinarInfo webinarInfo, String paper_id) {
        if (webinarInfo != null) {
            return ExamInternal.createExamUrl(webinarInfo, paper_id, "owner");
        }
        return "";
    }

    public static String getExamRankUrl(WebinarInfo webinarInfo, String paper_id) {
        if (webinarInfo != null) {
            return ExamInternal.createExamUrl(webinarInfo, paper_id, "rank");
        }
        return "";
    }

    public static class Builder {
        WebinarInfo webinarInfo;
        Context context;
        ExamMessageCallBack examMessageCallBack;

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder examMessageCallBack(ExamMessageCallBack examMessageCallBack) {
            this.examMessageCallBack = examMessageCallBack;
            return this;
        }

        public Builder webinarInfo(WebinarInfo webinarInfo) {
            this.webinarInfo = webinarInfo;
            return this;
        }

        public ExamServer build() {
            if (this.webinarInfo == null) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            if (this.webinarInfo.is_new_version == 3 && (this.webinarInfo.getWebinarInfoData() == null || this.webinarInfo.getWebinarInfoData().interact == null)) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            return new ExamServer(this);
        }
    }
}

