/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.impl;

import com.vhall.business.R;
import com.vhall.business.VhallSDK;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.core.IAccountApi;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.impl.VhssSimpleCallBack;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.TokenManger;
import com.vhall.vhss.data.VhssUserInfoData;
import com.vhall.vhss.network.InteractToolsNetworkRequest;
import com.vhall.vhss.network.UserNetworkRequest;
import java.util.Map;

public class AccountApi
implements IAccountApi {
    @Override
    public void login(String account, String password, String dynamic_code, CallBack<VhssUserInfoData> callBack) {
        if (!TokenManger.checkVerifyLegal()) {
            callBack.onError(20025, VhallSDK.mContext.getString(R.string.error_rsa_private_key_is_empty));
            return;
        }
        UserNetworkRequest.login(account, password, dynamic_code, callBack);
        LogReportManager.doReport("115000", new String[]{"user_name"}, new String[]{account.trim()});
    }

    @Override
    public void loginByThirdId(Map<String, String> requestParams, CallBack<VhssUserInfoData> callBack) {
        if (!TokenManger.checkVerifyLegal()) {
            callBack.onError(20025, VhallSDK.mContext.getString(R.string.error_rsa_private_key_is_empty));
            return;
        }
        UserNetworkRequest.loginByThirdId(requestParams, callBack);
        LogReportManager.doReport("115001", new String[]{"third_user_id", "nick_name"}, new String[]{requestParams.get("third_user_id"), requestParams.get("nick_name")});
    }

    @Override
    public void sendCode(String type, String data, String scene_id, RequestCallback callBack) {
        UserNetworkRequest.sendCode(type, data, scene_id, new VhssSimpleCallBack(callBack));
    }

    @Override
    public void wechatSubmit(String webinar_id, String phone, String code, RequestCallback callBack) {
        InteractToolsNetworkRequest.wechatSubmit(webinar_id, phone, code, new VhssSimpleCallBack(callBack));
    }
}

