/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.data.source.remote;

import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.data.source.PlaybackDocumentDataSource;
import com.vhall.business.utils.FileUtil;
import java.io.File;

public class PlaybackDocumentRemoteDataSource
implements PlaybackDocumentDataSource {
    private static PlaybackDocumentRemoteDataSource INSTANCE;

    private PlaybackDocumentRemoteDataSource() {
    }

    public static PlaybackDocumentRemoteDataSource getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlaybackDocumentRemoteDataSource();
        }
        return INSTANCE;
    }

    @Override
    public void getDocumentList(final WebinarInfo webinarInfo, final PlaybackDocumentDataSource.LoadDocumentCallback callback) {
        String fileName = FileUtil.getFileName(webinarInfo.docurl);
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            callback.onDataNotAvailable("\u65e0\u6587\u6863\uff01");
            return;
        }
        final File localFile = new File(FileUtil.getCacheDir(), fileName);
        if (localFile != null) {
            if (localFile.exists()) {
                localFile.delete();
            }
            FileUtil.downloadFile(localFile.getAbsolutePath(), webinarInfo.docurl, new Handler(){

                public void handleMessage(Message msg) {
                    super.handleMessage(msg);
                    switch (msg.what) {
                        case 0: {
                            callback.onDataNotAvailable("\u4e0b\u8f7d\u5931\u8d25\uff01");
                            break;
                        }
                        case 1: {
                            webinarInfo.doc_local_url = localFile.getAbsolutePath();
                            callback.onLoaded(webinarInfo, null);
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                }
            });
        }
    }
}

