/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.data.source.local;

import android.text.TextUtils;
import com.vhall.business.MessageServer;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.data.source.PlaybackDocumentDataSource;
import com.vhall.business.utils.FileUtil;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PlaybackDocumentLocalDataSource
implements PlaybackDocumentDataSource {
    private static PlaybackDocumentLocalDataSource INSTANCE;

    private PlaybackDocumentLocalDataSource() {
    }

    public static PlaybackDocumentLocalDataSource getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlaybackDocumentLocalDataSource();
        }
        return INSTANCE;
    }

    @Override
    public void getDocumentList(WebinarInfo webinarInfo, PlaybackDocumentDataSource.LoadDocumentCallback callback) {
        try {
            String text = FileUtil.readFile2String(webinarInfo.doc_local_url);
            if (TextUtils.isEmpty((CharSequence)text)) {
                callback.onDataNotAvailable("\u65e0\u5185\u5bb9\uff01");
                return;
            }
            if (text.startsWith("\ufeff")) {
                text = text.substring(1);
            }
            ArrayList<MessageServer.MsgInfo> list = new ArrayList<MessageServer.MsgInfo>();
            JSONObject jsonObject = new JSONObject(text);
            JSONArray jsonArray = jsonObject.getJSONArray("cuepoint");
            if (jsonArray != null) {
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject obj = (JSONObject)jsonArray.get(i);
                    String event = obj.optString("event");
                    if (!event.equals("flashMsg")) continue;
                    MessageServer.MsgInfo msgInfo = MessageServer.getMsgFromStr(webinarInfo, obj.optString("content"));
                    msgInfo.created_at = obj.optInt("created_at");
                    list.add(msgInfo);
                }
                text = null;
                callback.onLoaded(null, list);
            } else {
                callback.onDataNotAvailable("\u65e0\u5185\u5bb9\uff01");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

