/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business.common;

import android.content.Context;
import android.os.Build;
import com.vhall.business.common.Constants;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
public class LiveParam
implements Constants {
    private static String blacklist = "{\n  \"MI 4LTE\" : {\n    \"1080p\" : {\n      \"10fps\" : true,\n      \"15fps\" : false,\n      \"25fps\" : false\n    },\n    \"480p\" : {\n      \"10fps\" : true,\n      \"15fps\" : true,\n      \"25fps\" : true\n    },\n    \"720p\" : {\n      \"10fps\" : true,\n      \"15fps\" : false,\n      \"25fps\" : false\n    }\n  },\n  \"HUAWEI P7-L07\" : {\n    \"1080p\" : {\n      \"10fps\" : false,\n      \"15fps\" : false,\n      \"25fps\" : false\n    },\n    \"480p\" : {\n      \"10fps\" : true,\n      \"15fps\" : true,\n      \"25fps\" : false\n    },\n    \"720p\" : {\n      \"10fps\" : false,\n      \"15fps\" : false,\n      \"25fps\" : false\n    }\n  }\n}";
    private static final String TAG = "LiveParam";
    private static final int platform = 5;
    private static String device_type = Build.MODEL;
    private static String device_identifier = "";
    private static PushParam push_param = null;
    private static WatchParam warch_param = null;

    public static String readTextFile(Context context, int resId) {
        InputStream inputStream = context.getResources().openRawResource(resId);
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder result = new StringBuilder();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                result.append(line);
                result.append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return result.toString();
    }

    public static PushParam getPushParam() {
        if (push_param == null) {
            push_param = new PushParam();
        }
        return push_param;
    }

    public static WatchParam getWarchParam() {
        if (warch_param == null) {
            warch_param = new WatchParam();
        }
        return warch_param;
    }

    public static final int getVideoWidth(int type) {
        int width = 0;
        switch (type) {
            case 1: {
                width = 640;
                break;
            }
            case 2: {
                width = 1280;
                break;
            }
            case 3: {
                width = 1920;
                break;
            }
            default: {
                width = 640;
            }
        }
        return width;
    }

    public static final int getVideoHeight(int type) {
        int height = 0;
        switch (type) {
            case 1: {
                height = 480;
                break;
            }
            case 2: {
                height = 720;
                break;
            }
            case 3: {
                height = 1080;
                break;
            }
            default: {
                height = 480;
            }
        }
        return height;
    }

    public static class PushParam {
        private int frame_rate = 15;
        public int video_width = 640;
        public int video_height = 480;
        public int video_bitrate = 400000;
        public int audio_bitrate = 16000;
        public int sample_rate = 16000;
        public int channel_num = 1;
        private int src_sample_fmt = VHAVSampleFormat.VH_AV_SAMPLE_FMT_S16.getValue();
        public int publish_timeout = 5000;
        public int publish_reconnect_times = 5;
        public int encode_type = VideoEncoderMode.kVideoEncoderModeSoftware.getValue();
        public int orientation = 0;
        public int live_publish_model = LivePublishModel.kLivePublishModelVideoAndAudio.getValue();
        public int encode_pix_fmt = EncodePixFmt.kEncodePixFmtYuv420spNV21.getValue();
        private int pixel_type = 1;
        public int live_format = LiveFormat.kLiveFormatRtmp.getValue();
        private int mParamState;

        private PushParam() {
        }

        public void setPixel(int with, int height) {
            this.video_width = with;
            this.video_height = height;
        }

        public int getFrame_rate() {
            return this.frame_rate;
        }

        public void setFrame_rate(int frame_rate) {
            frame_rate = frame_rate < 10 ? 10 : frame_rate;
            this.frame_rate = frame_rate = frame_rate > 25 ? 25 : frame_rate;
        }

        private int getVideo_width() {
            return this.video_width;
        }

        private int getVideo_height() {
            return this.video_height;
        }

        public int getParamState() {
            return this.mParamState;
        }

        private Section fpsSection(JSONObject resolutionObj) throws JSONException {
            boolean is10fps = resolutionObj.optBoolean("10fps");
            boolean is15fps = resolutionObj.optBoolean("15fps");
            boolean is25fps = resolutionObj.optBoolean("25fps");
            Section section = new Section();
            if (is10fps) {
                section.min = 10;
            }
            if (is15fps) {
                section.max = 15;
            }
            if (is25fps) {
                section.max = 25;
            }
            if (section.max == 0) {
                section.max = section.min;
            }
            return section;
        }

        private void deviceFilter() {
            this.mParamState = 0;
            try {
                JSONObject object = new JSONObject(blacklist);
                if (!object.isNull(device_type)) {
                    JSONObject phone = object.getJSONObject(device_type);
                    switch (this.pixel_type) {
                        case 3: {
                            JSONObject obj = phone.getJSONObject("1080p");
                            Section section = this.fpsSection(obj);
                            if (section.max == 0) {
                                this.mParamState = -1;
                                this.pixel_type = 2;
                            } else {
                                if (this.frame_rate <= section.max) break;
                                this.frame_rate = section.max;
                                this.mParamState = -1;
                                break;
                            }
                        }
                        case 2: {
                            JSONObject obj = phone.getJSONObject("720p");
                            Section section = this.fpsSection(obj);
                            if (section.max == 0) {
                                this.mParamState = -1;
                                this.pixel_type = 1;
                            } else {
                                if (this.frame_rate <= section.max) break;
                                this.frame_rate = section.max;
                                this.mParamState = -1;
                                break;
                            }
                        }
                        case 1: {
                            JSONObject obj = phone.getJSONObject("480p");
                            Section section = this.fpsSection(obj);
                            if (section.max == 0) {
                                this.mParamState = -2;
                                break;
                            }
                            if (this.frame_rate <= section.max) break;
                            this.frame_rate = section.max;
                            this.mParamState = -1;
                            break;
                        }
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }

        public String getParamStr() {
            this.deviceFilter();
            JSONObject obj = new JSONObject();
            try {
                if (this.orientation == 0) {
                    obj.put("width", this.video_width);
                    obj.put("height", this.video_height);
                } else {
                    obj.put("width", this.video_height);
                    obj.put("height", this.video_width);
                }
                obj.put("frame_rate", this.frame_rate);
                obj.put("bit_rate", this.video_bitrate);
                obj.put("sample_rate", this.sample_rate);
                obj.put("ch_num", this.channel_num);
                obj.put("audio_bitrate", this.audio_bitrate);
                obj.put("publish_timeout", this.publish_timeout);
                obj.put("publish_reconnect_times", this.publish_reconnect_times);
                obj.put("live_publish_model", this.live_publish_model);
                obj.put("encode_pix_fmt", this.encode_pix_fmt);
                obj.put("encode_type", this.encode_type);
                obj.put("platform", 5);
                obj.put("device_type", (Object)device_type);
                obj.put("device_identifier", (Object)device_identifier);
                obj.put("live_format", this.live_format);
                obj.put("src_sample_fmt", this.src_sample_fmt);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return obj.toString();
        }

        private class Section {
            public int max = 0;
            public int min = 0;

            private Section() {
            }
        }
    }

    public static class WatchParam {
        public int watch_timeout = 5000;
        public int watch_reconnect_times = 6;
        public int buffer_time = 6;
        private int video_decoder_mode = VideoDecoderMode.kVideoDecoderModeSoftware.getValue();
        public LiveFormat live_format = LiveFormat.kLiveFormatRtmp;

        private WatchParam() {
        }

        public int getVideo_decoder_mode() {
            return this.video_decoder_mode;
        }

        public void setVideo_decoder_mode(int video_decoder_mode) {
            this.video_decoder_mode = video_decoder_mode;
        }

        public String getParamStr() {
            JSONObject obj = new JSONObject();
            try {
                obj.put("watch_timeout", this.watch_timeout);
                obj.put("watch_reconnect_times", this.watch_reconnect_times);
                obj.put("buffer_time", this.buffer_time);
                obj.put("video_decoder_mode", this.video_decoder_mode);
                obj.put("platform", 5);
                obj.put("device_type", (Object)device_type);
                obj.put("device_identifier", (Object)device_identifier);
                obj.put("live_format", this.live_format.getValue());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return obj.toString();
        }
    }

    public static enum VHAVSampleFormat {
        VH_AV_SAMPLE_FMT_NONE(-1),
        VH_AV_SAMPLE_FMT_U8(0),
        VH_AV_SAMPLE_FMT_S16(1),
        VH_AV_SAMPLE_FMT_S32(2),
        VH_AV_SAMPLE_FMT_FLT(3),
        VH_AV_SAMPLE_FMT_DBL(4);

        private int _value;

        private VHAVSampleFormat(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }

    public static enum LiveFormat {
        kLiveFormatNone(0),
        kLiveFormatRtmp(1),
        kLiveFormatFlV(2);

        private int _value;

        private LiveFormat(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }

    public static enum VHallStreamType {
        kVHallStreamTypeNone(0),
        kVHallStreamTypeVideoAndAudio(1),
        kVHallStreamTypeOnlyVideo(2),
        kVHallStreamTypeOnlyAudio(3);

        private int _value;

        private VHallStreamType(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }

    public static enum LivePublishModel {
        kLivePublishModelNone(0),
        kLivePublishModelVideoAndAudio(1),
        kLivePublishModelOnlyVideo(2),
        kLivePublishModelOnlyAudio(3);

        private int _value;

        private LivePublishModel(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }

    public static enum VideoDecoderMode {
        kVideoDecoderModeSoftware(1),
        kVideoDecoderModeHardware(2);

        private int _value;

        private VideoDecoderMode(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }

    public static enum VideoEncoderMode {
        kVideoEncoderModeSoftware(0),
        kVideoEncoderModeHardware(1);

        private int _value;

        private VideoEncoderMode(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }

    public static enum EncodePixFmt {
        kEncodePixFmtYuv420spNV21(0),
        kEncodePixFmtYUV420spNV12(1),
        kEncodePixFmtYUV420pYV21(2),
        kEncodePixFmtYUV420pYV12(3);

        private int _value;

        private EncodePixFmt(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }
}

