/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import com.vhall.business.ChatServer;
import com.vhall.business.H5MessageChange;
import com.vhall.business.MessageServer;
import com.vhall.business.Playback;
import com.vhall.business.R;
import com.vhall.business.VhallSDK;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.impl.VhallNetApiFactory;
import com.vhall.ops.VHOPS;
import com.vhall.player.Constants;
import com.vhall.player.VHPlayerListener;
import com.vhall.player.stream.play.impl.VHVideoPlayerView;
import com.vhall.vod.VHVodPlayer;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import vhall.com.vss2.CallBack;
import vhall.com.vss2.data.ResponseChatInfo;
import vhall.com.vss2.data.ResponseRoomInfo;
import vhall.com.vss2.module.chat.VssChatManager;
import vhall.com.vss2.module.room.VssRoomManager;

public class WatchPlaybackH5
extends Playback {
    private static final String TAG = "WatchPlaybackNew";
    private VHVodPlayer mPlayer;
    VHOPS document;
    private ResponseRoomInfo roomInfo = null;
    private boolean isPlaying = false;
    private Timer timer;
    private VHPlayerListener innerListener = new VHPlayerListener(){

        public void onStateChanged(Constants.State state) {
            switch (state) {
                case START: {
                    WatchPlaybackH5.this.isPlaying = true;
                    WatchPlaybackH5.this.handlePosition();
                    break;
                }
                case PAUSE: 
                case STOP: 
                case END: {
                    WatchPlaybackH5.this.isPlaying = false;
                    if (WatchPlaybackH5.this.timer == null) break;
                    WatchPlaybackH5.this.timer.cancel();
                    break;
                }
            }
            if (WatchPlaybackH5.this.listener != null) {
                WatchPlaybackH5.this.listener.onStateChanged(state);
            }
        }

        public void onEvent(int i, String s) {
            if (i == -256) {
                if (WatchPlaybackH5.this.document != null) {
                    if (WatchPlaybackH5.this.mPlayer == null) {
                        return;
                    }
                    WatchPlaybackH5.this.document.setCue_point(WatchPlaybackH5.this.mPlayer.getCurePoint());
                }
                if (WatchPlaybackH5.this.listener != null) {
                    WatchPlaybackH5.this.listener.onEvent(20300, WatchPlaybackH5.this.context.getString(R.string.event_init_play_success));
                }
            }
            if (WatchPlaybackH5.this.listener != null) {
                WatchPlaybackH5.this.listener.onEvent(i, s);
            }
        }

        public void onError(int i, int i1, String s) {
            if (WatchPlaybackH5.this.listener != null) {
                WatchPlaybackH5.this.listener.onError(i, i1, s);
            }
        }
    };
    private VHOPS.EventListener opsListener = new VHOPS.EventListener(){

        public void onEvent(String event, String type, String cid) {
            if (event.equals(VHOPS.KEY_OPERATE)) {
                MessageServer.MsgInfo messageInfo = null;
                if (type.equals(VHOPS.TYPE_ACTIVE)) {
                    messageInfo = new MessageServer.MsgInfo();
                    messageInfo.event = 65;
                    if (WatchPlaybackH5.this.document != null) {
                        messageInfo.h5DocView = WatchPlaybackH5.this.document.getActiveView();
                    }
                } else if (type.equals(VHOPS.TYPE_SWITCHOFF)) {
                    messageInfo = new MessageServer.MsgInfo();
                    messageInfo.event = 64;
                    messageInfo.watchType = 0;
                    WatchPlaybackH5.this.setIsUseDoc(0);
                } else if (type.equals(VHOPS.TYPE_SWITCHON)) {
                    messageInfo = new MessageServer.MsgInfo();
                    messageInfo.event = 64;
                    messageInfo.watchType = 1;
                    WatchPlaybackH5.this.setIsUseDoc(1);
                }
                if (messageInfo != null && WatchPlaybackH5.this.messageCallback != null) {
                    WatchPlaybackH5.this.messageCallback.onEvent(messageInfo);
                }
            }
            if (WatchPlaybackH5.this.docEventCallback != null && event.equals(VHOPS.KEY_OPERATE)) {
                if (type.equals(VHOPS.TYPE_ACTIVE)) {
                    if (WatchPlaybackH5.this.document != null) {
                        WatchPlaybackH5.this.docEventCallback.onEvent(event, type, (View)WatchPlaybackH5.this.document.getActiveView());
                    }
                } else if (type.equals(VHOPS.TYPE_SWITCHOFF)) {
                    WatchPlaybackH5.this.docEventCallback.onEvent(event, type, null);
                    WatchPlaybackH5.this.setIsUseDoc(0);
                } else if (type.equals(VHOPS.TYPE_SWITCHON)) {
                    WatchPlaybackH5.this.docEventCallback.onEvent(event, type, null);
                    WatchPlaybackH5.this.setIsUseDoc(1);
                } else {
                    WatchPlaybackH5.this.docEventCallback.onEvent(event, type, null);
                }
            }
        }

        public void onError(int i, int i1, String s) {
            if (WatchPlaybackH5.this.docEventCallback != null) {
                WatchPlaybackH5.this.docEventCallback.onError(i, i1, s);
            }
        }
    };

    WatchPlaybackH5(Playback.Builder builder) {
        this.context = builder.context;
        if (builder.surfaceView != null) {
            this.surfaceView = builder.surfaceView;
        } else if (builder.vodPlayerView != null) {
            this.vodPlayerView = builder.vodPlayerView;
        }
        this.listener = builder.listener;
        this.docEventCallback = builder.docCallback;
        this.chatCallback = builder.chatCallback;
        this.messageCallback = builder.messageCallback;
        this.mDelivery = new Handler(new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                if (msg.what == 0 && WatchPlaybackH5.this.mPlayer != null && WatchPlaybackH5.this.mPlayer.isPlaying() && WatchPlaybackH5.this.document != null) {
                    WatchPlaybackH5.this.document.setTime(WatchPlaybackH5.this.mPlayer.getPosition());
                }
                return false;
            }
        });
    }

    @Override
    public void setScaleType(int scaleType) {
        super.setScaleType(scaleType);
        if (this.mPlayer != null) {
            this.mPlayer.setDrawMode(scaleType);
        }
    }

    @Override
    public boolean isPlaying() {
        if (this.mPlayer != null) {
            return this.isPlaying;
        }
        return false;
    }

    @Override
    public void mute() {
        if (null != this.mPlayer) {
            this.mPlayer.mute();
        }
    }

    @Override
    public void unMute() {
        if (null != this.mPlayer) {
            this.mPlayer.unmute();
        }
    }

    private void handlePosition() {
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                WatchPlaybackH5.this.mDelivery.sendEmptyMessage(0);
            }
        }, 150L, 150L);
    }

    @Override
    public void setWebinarInfo(WebinarInfo webinarInfo) {
        super.setWebinarInfo(webinarInfo);
        this.qualities = webinarInfo.qualities;
        if (this.roomInfo == null) {
            if (VssRoomManager.enter) {
                this.roomInfo = VssRoomManager.getInstance().getRoomInfo();
                if (this.document == null) {
                    this.document = new VHOPS(this.roomInfo.getPaas_access_token(), this.context, this.roomInfo.getRecord_id(), this.roomInfo.getChannel_id());
                    this.document.setListener(this.opsListener);
                }
                VssRoomManager.getInstance().setVssMessageListener(new H5MessageChange(this.messageCallback, this.chatCallback, webinarInfo, new H5MessageChange.WebinarInfoChangeCallBack(){

                    @Override
                    public void dataChange(WebinarInfo data) {
                        WatchPlaybackH5.this.setWebinarInfo(data);
                    }

                    @Override
                    public void kickedOut() {
                    }
                }));
                this.mPlayer = new VHVodPlayer(this.context);
                this.mPlayer.init(this.roomInfo.getRecord_id(), this.roomInfo.getPaas_access_token());
                if (this.surfaceView != null) {
                    this.mPlayer.setDisplay(this.surfaceView);
                } else if (this.vodPlayerView != null) {
                    this.mPlayer.setDisplay(this.vodPlayerView);
                } else if (this.listener != null) {
                    this.listener.onEvent(20202, VhallSDK.mContext.getString(R.string.error_empty_play_view));
                }
                this.mPlayer.setListener(this.innerListener);
                this.mPlayer.setDPI(this.mCurrentDpi);
                this.mPlayer.setDrawMode(this.scaleType);
                this.mPlayer.setWaterMark(this.waterMarkUrl, this.waterMarkGravity, this.waterMarkAlpha);
            } else if (this.listener != null) {
                this.listener.onEvent(20202, VhallSDK.mContext.getString(R.string.error_video_msg_init));
            }
        }
        this.waterMarkUrl = webinarInfo.watermark.imgUrl;
        this.waterMarkGravity = webinarInfo.watermark.imgPosition;
        this.waterMarkAlpha = webinarInfo.watermark.imgAlpha;
    }

    @Override
    public void setDefinition(String dpi) {
        this.mCurrentDpi = dpi;
        if (this.mPlayer == null) {
            this.start();
        } else {
            this.mPlayer.setDPI(this.mCurrentDpi);
        }
    }

    @Override
    public void start() {
        if (this.roomInfo == null) {
            if (this.listener != null) {
                this.listener.onError(20202, 0, this.context.getString(R.string.error_video_msg_init));
            }
            return;
        }
        if (this.mPlayer == null) {
            this.mPlayer = new VHVodPlayer(this.context);
            this.mPlayer.init(this.roomInfo.getRecord_id(), this.roomInfo.getPaas_access_token());
            if (this.surfaceView != null) {
                this.mPlayer.setDisplay(this.surfaceView);
            } else if (this.vodPlayerView != null) {
                this.mPlayer.setDisplay(this.vodPlayerView);
            }
            this.mPlayer.setListener(this.innerListener);
            this.mPlayer.setDPI(this.mCurrentDpi);
            this.mPlayer.setDrawMode(this.scaleType);
            this.mPlayer.setWaterMark(this.waterMarkUrl, this.waterMarkGravity, this.waterMarkAlpha);
            this.mPlayer.start();
        } else {
            this.mPlayer.start();
        }
    }

    @Override
    public void onPause() {
        if (this.mPlayer != null) {
            this.mPlayer.pause();
        }
    }

    @Override
    public void onResume() {
        if (this.mPlayer != null) {
            this.mPlayer.resume();
        }
    }

    @Override
    public void stop() {
        if (this.mPlayer != null) {
            this.mPlayer.stop();
        }
    }

    @Override
    public void destroy() {
        if (this.mPlayer != null) {
            this.mPlayer.release();
        }
        this.mPlayer = null;
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.mDelivery.removeMessages(0);
        VssRoomManager.leaveRoom();
        this.flag = false;
    }

    @Override
    public float setSpeed(float speed) {
        if (this.mPlayer != null) {
            return this.mPlayer.setSpeed(speed);
        }
        return 0.0f;
    }

    @Override
    public boolean setVideoBackgroundColor(int color) {
        if (this.listener != null) {
            this.listener.onError(20000, 0, VhallSDK.mContext.getString(R.string.error_no_support));
        }
        return false;
    }

    @Override
    public boolean setVideoBackgroundImage(Bitmap bitmap) {
        if (this.listener != null) {
            this.listener.onError(20000, 0, VhallSDK.mContext.getString(R.string.error_no_support));
        }
        return false;
    }

    @Override
    public boolean takeVideoScreenshot(VHVideoPlayerView.ScreenShotCallback callback) {
        if (this.listener != null) {
            this.listener.onError(20000, 0, VhallSDK.mContext.getString(R.string.error_no_support));
        }
        return false;
    }

    @Override
    public void startPlay(String url) {
        if (this.roomInfo == null) {
            if (this.listener != null) {
                this.listener.onError(20202, 0, this.context.getString(R.string.error_video_msg_init));
            }
            return;
        }
        this.releasePlayer();
        if (this.mPlayer == null) {
            this.mPlayer = new VHVodPlayer(this.context);
            this.mPlayer.init(this.roomInfo.getRecord_id(), this.roomInfo.getPaas_access_token());
            this.mPlayer.setListener(this.innerListener);
            if (this.surfaceView != null) {
                this.mPlayer.setDisplay(this.surfaceView);
            } else {
                this.mPlayer.setDisplay(this.vodPlayerView);
            }
        }
        this.mPlayer.setWaterMark(this.waterMarkUrl, this.waterMarkGravity, this.waterMarkAlpha);
        this.mPlayer.startPlay(url);
        if (this.mSavePlayerPoint != 0L) {
            this.mPlayer.seekto(this.mSavePlayerPoint);
            if (this.document != null) {
                this.document.seekTo(this.mSavePlayerPoint);
            }
        }
    }

    @Override
    public void releasePlayer() {
        try {
            if (this.mPlayer != null) {
                this.mSavePlayerPoint = this.mPlayer.getPosition();
                this.mPlayer.release();
                this.mPlayer = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public long getCurrentPosition() {
        if (this.mPlayer != null) {
            return this.mPlayer.getPosition();
        }
        return 0L;
    }

    @Override
    public long getDuration() {
        if (this.mPlayer != null) {
            return this.mPlayer.getDuration();
        }
        return 0L;
    }

    @Override
    public void seekTo(long position) {
        if (this.mPlayer != null) {
            this.mPlayer.seekto(position);
        }
        if (this.document != null) {
            this.document.seekTo(position);
        }
    }

    @Override
    public Constants.State getPlayerState() {
        if (this.mPlayer != null) {
            return this.mPlayer.getState();
        }
        return Constants.State.NONE;
    }

    @Override
    public void initWH(int width, int height) {
    }

    @Override
    public String getOriginalUrl() {
        if (this.webinarInfo.getCast_screen() == 1 && this.mPlayer != null) {
            return this.mPlayer.getOriginalUrl();
        }
        return null;
    }

    @Override
    public void sendComment(String content, final RequestCallback callback) {
        VssRoomManager.getInstance().sendMsg(content, "", new CallBack(){

            public void onSuccess(Object result) {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callback != null) {
                    callback.onError(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void requestCommentHistory(String webinar_id, int limit, int pos, final ChatServer.ChatRecordCallback chatRecordCallback) {
        VssChatManager.getInstance().chatLists(String.valueOf(pos), String.valueOf(limit), "", new CallBack<List<ResponseChatInfo>>(){

            @Override
            public void onSuccess(List<ResponseChatInfo> result) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onDataLoaded(VhallNetApiFactory.createChatApi().chatHistoryOld(result));
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onFailed(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void requestCommentHistory(String webinar_id, int limit, int page, String msgId, String anchor_path, String is_role, ChatServer.ChatRecordCallback chatRecordCallback) {
        if (chatRecordCallback != null) {
            chatRecordCallback.onFailed(20000, VhallSDK.mContext.getString(R.string.error_no_support));
        }
    }
}

