/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business;

import android.graphics.Bitmap;
import android.text.TextUtils;
import com.vhall.business.ChatServer;
import com.vhall.business.ErrorCode;
import com.vhall.business.H5MessageChange;
import com.vhall.business.Live;
import com.vhall.business.MessageServer;
import com.vhall.business.R;
import com.vhall.business.VhallSDK;
import com.vhall.business.WatchLive;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.data.source.UserInfoRepository;
import com.vhall.business.data.source.local.UserInfoLocalDataSource;
import com.vhall.business.data.source.remote.UserInfoRemoteDataSource;
import com.vhall.business.impl.VhallNetApiFactory;
import com.vhall.lss.play.VHLivePlayer;
import com.vhall.message.ConnectServer;
import com.vhall.ops.VHOPS;
import com.vhall.player.Constants;
import com.vhall.player.VHPlayerListener;
import com.vhall.player.stream.play.impl.VHVideoPlayerView;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vhall.com.vss2.CallBack;
import vhall.com.vss2.data.ResponseChatInfo;
import vhall.com.vss2.data.ResponseRoomInfo;
import vhall.com.vss2.module.chat.VssChatManager;
import vhall.com.vss2.module.room.VssRoomManager;
import vhall.com.vss2.module.room.callback.IVssCallBackListener;
import vhall.com.vss2.module.rtc.VssRtcManager;

class WatchLiveH5
extends Live {
    private static final String TAG = "WatchLiveH5";
    private VHLivePlayer mPlayer;
    private ResponseRoomInfo roomInfo;
    protected VHOPS vhops;
    private IVssCallBackListener iVssCallBackListener = new IVssCallBackListener(){

        @Override
        public void onStateChanged(ConnectServer.State state, int i) {
            switch (state) {
                case STATE_CONNECTED: {
                    if (WatchLiveH5.this.chatCallback == null) break;
                    WatchLiveH5.this.chatCallback.onChatServerConnected();
                    break;
                }
                case STATE_CONNECTIONG: {
                    break;
                }
                case STATE_DISCONNECT: {
                    if (WatchLiveH5.this.chatCallback == null) break;
                    WatchLiveH5.this.chatCallback.onChatServerClosed();
                    break;
                }
                case STATE_KICK_OFF: {
                    if (WatchLiveH5.this.chatCallback == null) break;
                    WatchLiveH5.this.chatCallback.onChatServerKickOff();
                    break;
                }
            }
        }

        @Override
        public void onError(int code, String msg) {
            if (WatchLiveH5.this.chatCallback != null) {
                WatchLiveH5.this.chatCallback.onConnectFailed();
            }
        }
    };
    private VHOPS.EventListener opsListener = new VHOPS.EventListener(){

        public void onEvent(String event, String type, String cid) {
            if (event.equals(VHOPS.KEY_OPERATE)) {
                MessageServer.MsgInfo messageInfo = null;
                if (type.equals(VHOPS.TYPE_ACTIVE)) {
                    messageInfo = new MessageServer.MsgInfo();
                    messageInfo.event = 65;
                    messageInfo.h5DocView = WatchLiveH5.this.vhops.getActiveView();
                } else if (type.equals(VHOPS.TYPE_SWITCHOFF)) {
                    messageInfo = new MessageServer.MsgInfo();
                    messageInfo.event = 64;
                    messageInfo.watchType = 0;
                } else if (type.equals(VHOPS.TYPE_SWITCHON)) {
                    messageInfo = new MessageServer.MsgInfo();
                    messageInfo.event = 64;
                    messageInfo.watchType = 1;
                }
                if (messageInfo != null && WatchLiveH5.this.messageCallback != null) {
                    WatchLiveH5.this.messageCallback.onEvent(messageInfo);
                }
            }
        }

        public void onError(int errorCode, int innerError, String errorMsg) {
            switch (errorCode) {
                case -1: 
                case 201: {
                    break;
                }
                case 101: {
                    try {
                        JSONObject obj = new JSONObject(errorMsg);
                        String msg = obj.optString("msg");
                        String string2 = obj.optString("cid");
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
            }
        }
    };
    private VHPlayerListener innerListener = new VHPlayerListener(){

        public void onStateChanged(Constants.State state) {
            if (WatchLiveH5.this.listener != null) {
                if (state == Constants.State.START && WatchLiveH5.this.vhops != null) {
                    WatchLiveH5.this.vhops.setDealTime(WatchLiveH5.this.mPlayer.getRealityBufferTime() + 2500);
                }
                WatchLiveH5.this.listener.onStateChanged(state);
            }
        }

        public void onEvent(int event, String msg) {
            if (event == -261) {
                try {
                    JSONArray array = new JSONArray(msg);
                    if (array.length() > 0) {
                        block18: for (int i = 0; i < array.length(); ++i) {
                            String key;
                            switch (key = (String)array.opt(i)) {
                                case "A": 
                                case "a": {
                                    WatchLiveH5.this.webinarInfo.A.valid = 1;
                                    continue block18;
                                }
                                case "SD": 
                                case "360p": {
                                    WatchLiveH5.this.webinarInfo.SD.valid = 1;
                                    continue block18;
                                }
                                case "HD": 
                                case "480p": {
                                    WatchLiveH5.this.webinarInfo.HD.valid = 1;
                                    continue block18;
                                }
                                case "UHD": 
                                case "720p": {
                                    WatchLiveH5.this.webinarInfo.UHD.valid = 1;
                                    continue block18;
                                }
                            }
                        }
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (WatchLiveH5.this.listener != null) {
                WatchLiveH5.this.listener.onEvent(event, msg);
            }
        }

        public void onError(int i, int i1, String s) {
            if (WatchLiveH5.this.listener != null) {
                WatchLiveH5.this.listener.onError(i, i1, s);
            }
        }
    };

    @Override
    public String getDefinition() {
        if (this.mPlayer != null) {
            return this.mPlayer.getDpi();
        }
        return "";
    }

    @Override
    public void setDefinition(String definition) {
        if (this.mPlayer != null) {
            this.mPlayer.setDPI(definition);
        }
    }

    @Override
    public boolean isPlaying() {
        if (this.mPlayer != null) {
            return this.mPlayer.isPlaying();
        }
        return false;
    }

    @Override
    public void mute() {
        if (null != this.mPlayer) {
            this.mPlayer.mute();
        }
    }

    @Override
    public void unMute() {
        if (null != this.mPlayer) {
            this.mPlayer.unmute();
        }
    }

    @Override
    public void setPCSwitchDefinition() {
        if (this.mPlayer != null) {
            this.mPlayer.pushMsgInfo();
        }
    }

    @Override
    protected void setWebinarInfo(WebinarInfo webinarInfo) {
        super.setWebinarInfo(webinarInfo);
        if (this.roomInfo == null && VssRoomManager.enter) {
            this.roomInfo = VssRoomManager.getInstance().getRoomInfo();
            if (this.listener != null) {
                if (this.roomInfo.getStatus() != 1) {
                    int ERROR_STATUS = -17;
                    this.listener.onError(ERROR_STATUS, ERROR_STATUS, this.context.getString(R.string.no_playing));
                }
                VssRoomManager.getInstance().setVssMessageListener(new H5MessageChange(this.messageCallback, this.chatCallback, webinarInfo, new H5MessageChange.WebinarInfoChangeCallBack(){

                    @Override
                    public void dataChange(WebinarInfo data) {
                        WatchLiveH5.this.setWebinarInfo(data);
                    }

                    @Override
                    public void kickedOut() {
                    }
                }));
                VssRoomManager.getInstance().setVssCallBackListener(this.iVssCallBackListener);
            }
        } else {
            return;
        }
        this.vhops = new VHOPS(this.context, this.roomInfo.getChannel_id(), this.roomInfo.getRoom_id(), this.roomInfo.getPaas_access_token());
        this.vhops.setListener(this.opsListener);
        this.vhops.join();
        this.VR = webinarInfo.is_publish_vr == 1;
        this.waterMarkUrl = webinarInfo.watermark.imgUrl;
        this.waterMarkGravity = webinarInfo.watermark.imgPosition;
        this.waterMarkAlpha = webinarInfo.watermark.imgAlpha;
        if (this.mPlayer == null) {
            if (this.videoContainer != null) {
                this.initWH(this.videoContainer.getWidth(), this.videoContainer.getHeight());
            } else if (this.listener != null) {
                this.listener.onEvent(20202, VhallSDK.mContext.getString(R.string.error_empty_play_view));
            }
            this.mPlayer = new VHLivePlayer.Builder().videoPlayer(this.videoView).bufferSeconds(this.buffSeconds).connectTimeout(this.connectTimeout).listener(this.innerListener).build();
            this.mPlayer.setDefaultRealtimeSubtitle(true);
        }
        if (this.listener != null) {
            this.listener.onEvent(20300, this.context.getString(R.string.event_init_play_success));
        }
    }

    WatchLiveH5(WatchLive.Builder builder) {
        this.context = builder.context;
        this.videoContainer = builder.videoContainer;
        this.listener = builder.listener;
        this.videoView = builder.videoView;
        this.buffSeconds = builder.buffSeconds;
        this.connectTimeout = builder.connectTimeout;
        this.messageCallback = builder.messageCallback;
        this.chatCallback = builder.chatCallback;
    }

    @Override
    public void start() {
        if (this.mPlayer == null) {
            if (this.videoContainer != null) {
                this.initWH(this.videoContainer.getWidth(), this.videoContainer.getHeight());
            }
            this.mPlayer = new VHLivePlayer.Builder().videoPlayer(this.videoView).bufferSeconds(this.buffSeconds).connectTimeout(this.connectTimeout).listener(this.innerListener).build();
            this.mPlayer.setDefaultRealtimeSubtitle(true);
        }
        if (this.mPlayer.isPlaying()) {
            return;
        }
        if (!this.isAvaliable()) {
            if (this.listener != null) {
                this.listener.onError(20202, 0, this.context.getString(R.string.error_video_msg_init));
            }
            return;
        }
        if (this.webinarInfo.status != 1) {
            if (this.listener != null) {
                this.listener.onError(20209, 0, String.format(this.context.getString(R.string.playing_status), this.webinarInfo.getStatusStr()));
            }
            return;
        }
        this.mPlayer.start(this.roomInfo.getRoom_id(), this.roomInfo.getPaas_access_token());
        this.mPlayer.setWaterMark(this.waterMarkUrl, this.waterMarkGravity, this.waterMarkAlpha);
    }

    @Override
    public void stop() {
        if (this.mPlayer != null) {
            this.mPlayer.stop();
        }
    }

    @Override
    public void destroy() {
        this.releasePlayer();
        if (this.vhops != null) {
            this.vhops.leave();
        }
        VssRoomManager.leaveRoom();
    }

    @Override
    public void startPlay(String url) {
        if (this.mPlayer != null) {
            this.mPlayer.startPlay(url);
        }
    }

    @Override
    public void releasePlayer() {
        if (this.mPlayer != null) {
            this.mPlayer.release();
        }
    }

    @Override
    public boolean setVideoBackgroundColor(int color) {
        if (this.videoView != null) {
            if (this.videoView instanceof VHVideoPlayerView) {
                ((VHVideoPlayerView)this.videoView).setVideoBackgroundColor(color);
                return true;
            }
            if (this.listener != null) {
                this.listener.onError(20001, 0, VhallSDK.mContext.getString(R.string.error_video_view));
            }
        } else if (this.listener != null) {
            this.listener.onError(20001, 0, VhallSDK.mContext.getString(R.string.error_video_view));
        }
        return false;
    }

    @Override
    public boolean setVideoBackgroundImage(Bitmap bitmap) {
        if (this.videoView != null) {
            if (this.videoView instanceof VHVideoPlayerView) {
                ((VHVideoPlayerView)this.videoView).setVideoBackgroundImage(bitmap);
                return true;
            }
            if (this.listener != null) {
                this.listener.onError(20001, 0, VhallSDK.mContext.getString(R.string.error_video_view));
            }
        } else if (this.listener != null) {
            this.listener.onError(20001, 0, VhallSDK.mContext.getString(R.string.error_video_view));
        }
        return false;
    }

    @Override
    public boolean takeVideoScreenshot(VHVideoPlayerView.ScreenShotCallback callback) {
        if (this.videoView != null) {
            if (this.videoView instanceof VHVideoPlayerView) {
                ((VHVideoPlayerView)this.videoView).takeVideoScreenshot(callback);
                return true;
            }
            if (this.listener != null) {
                this.listener.onError(20001, 0, VhallSDK.mContext.getString(R.string.error_video_view));
            }
        } else if (this.listener != null) {
            this.listener.onError(20001, 0, VhallSDK.mContext.getString(R.string.error_video_view));
        }
        return false;
    }

    @Override
    public void sendChat(String content, final RequestCallback callback) {
        VssRoomManager.getInstance().sendMsg(content, "", new CallBack(){

            public void onSuccess(Object result) {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callback != null) {
                    callback.onError(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void sendCustom(JSONObject content, final RequestCallback callback) {
        VssRoomManager.getInstance().sendMsg(content.toString(), "service_custom", new CallBack(){

            public void onSuccess(Object result) {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callback != null) {
                    callback.onError(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void sendQuestion(String content, RequestCallback callback) {
        if (!VhallSDK.isLogin()) {
            return;
        }
        UserInfoRepository repository = UserInfoRepository.getInstance(UserInfoRemoteDataSource.getInstance(), UserInfoLocalDataSource.getInstance());
        repository.sendQuestion(VhallSDK.user.user_id, this.webinarInfo.webinar_id, content, callback);
    }

    @Override
    public void onRaiseHand(String webinarId, int type, final RequestCallback callback) {
        if (!VhallSDK.isLogin()) {
            callback.onError(20004, ErrorCode.ERROR_MSG_ISLOGIN);
            return;
        }
        if (this.webinarInfo == null || TextUtils.isEmpty((CharSequence)this.webinarInfo.join_id)) {
            callback.onError(20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        if (this.context != null) {
            if (type == 1) {
                VssRtcManager.getInstance().apply(new CallBack(){

                    public void onSuccess(Object result) {
                        if (callback != null) {
                            callback.onSuccess();
                        }
                    }

                    @Override
                    public void onError(int eventCode, String msg) {
                        if (callback != null) {
                            callback.onError(eventCode, msg);
                        }
                    }
                });
            } else {
                VssRtcManager.getInstance().cancelApply(new CallBack(){

                    public void onSuccess(Object result) {
                        if (callback != null) {
                            callback.onSuccess();
                        }
                    }

                    @Override
                    public void onError(int eventCode, String msg) {
                        if (callback != null) {
                            callback.onError(eventCode, msg);
                        }
                    }
                });
            }
        } else if (callback != null) {
            callback.onError(20001, ErrorCode.ERROR_MSG_INIT);
        }
    }

    @Override
    public void replyInvitation(String webinarId, int type, final RequestCallback callback) {
        if (!VhallSDK.isLogin()) {
            callback.onError(20004, ErrorCode.ERROR_MSG_ISLOGIN);
            return;
        }
        if (this.webinarInfo == null || TextUtils.isEmpty((CharSequence)this.webinarInfo.join_id)) {
            callback.onError(20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        if (type == 1) {
            VssRtcManager.getInstance().agreeInvite(new CallBack(){

                public void onSuccess(Object result) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }

                @Override
                public void onError(int eventCode, String msg) {
                    if (callback != null) {
                        callback.onError(eventCode, msg);
                    }
                }
            });
        } else if (type == 2) {
            VssRtcManager.getInstance().rejectInvite(new CallBack(){

                public void onSuccess(Object result) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }

                @Override
                public void onError(int eventCode, String msg) {
                    if (callback != null) {
                        callback.onError(eventCode, msg);
                    }
                }
            });
        }
    }

    @Override
    public void acquireChatRecord(int page, final ChatServer.ChatRecordCallback chatRecordCallback) {
        VssChatManager.getInstance().chatLists(String.valueOf(page), "20", "", new CallBack<List<ResponseChatInfo>>(){

            @Override
            public void onSuccess(List<ResponseChatInfo> result) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onDataLoaded(VhallNetApiFactory.createChatApi().chatHistoryOld(result));
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onFailed(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void acquireChatRecord(int page, int limit, String msgId, String anchor_path, String is_role, ChatServer.ChatRecordCallback chatRecordCallback) {
        if (chatRecordCallback != null) {
            chatRecordCallback.onFailed(20000, VhallSDK.mContext.getString(R.string.error_no_support));
        }
    }

    @Override
    public void acquireChatRecord(boolean show_all, final ChatServer.ChatRecordCallback chatRecordCallback) {
        VssChatManager.getInstance().chatLists("1", show_all ? "200" : "20", "", new CallBack<List<ResponseChatInfo>>(){

            @Override
            public void onSuccess(List<ResponseChatInfo> result) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onDataLoaded(VhallNetApiFactory.createChatApi().chatHistoryOld(result));
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onFailed(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void setScaleType(int scaleType) {
        super.setScaleType(scaleType);
        if (this.videoView != null) {
            this.videoView.setDrawMode(scaleType);
        }
    }

    @Override
    public String getOriginalUrl() {
        if (this.webinarInfo.getCast_screen() == 1 && this.mPlayer != null) {
            return this.mPlayer.getOriginalUrl();
        }
        return null;
    }

    @Override
    public void connectChatServer() {
    }

    @Override
    public void disconnectChatServer() {
    }

    @Override
    public void connectMsgServer() {
    }

    @Override
    public void disconnectMsgServer() {
    }
}

