/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.widget.RelativeLayout;
import com.vhall.business.ChatServer;
import com.vhall.business.ErrorCode;
import com.vhall.business.Live;
import com.vhall.business.MessageServer;
import com.vhall.business.NewH5ImManager;
import com.vhall.business.R;
import com.vhall.business.VhallCallback;
import com.vhall.business.VhallSDK;
import com.vhall.business.WatchLiveH5New;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.module.message.IMessageCallBack;
import com.vhall.business.module.notice.NoticeMessageCallBack;
import com.vhall.player.VHPlayerListener;
import com.vhall.player.stream.play.IVHVideoPlayer;
import com.vhall.player.stream.play.impl.VHVideoPlayerView;
import java.util.HashMap;
import java.util.List;
import org.json.JSONObject;

public class WatchLive
extends Live {
    private static final String TAG = "WatchLive";
    private Live watchLivePlayer;

    @Override
    public String getDefinition() {
        if (this.watchLivePlayer != null) {
            return this.watchLivePlayer.getDefinition();
        }
        return null;
    }

    @Override
    public void setDefinition(String definition) {
        if (this.watchLivePlayer != null) {
            this.watchLivePlayer.setDefinition(definition);
        }
    }

    @Override
    public void setPCSwitchDefinition() {
        if (this.watchLivePlayer != null) {
            this.watchLivePlayer.setPCSwitchDefinition();
        }
    }

    @Override
    public boolean isPlaying() {
        if (this.watchLivePlayer != null) {
            return this.watchLivePlayer.isPlaying();
        }
        return false;
    }

    @Override
    public void mute() {
        if (null != this.watchLivePlayer) {
            this.watchLivePlayer.mute();
        }
    }

    @Override
    public void unMute() {
        if (null != this.watchLivePlayer) {
            this.watchLivePlayer.unMute();
        }
    }

    @Override
    public void setScaleType(int scaleType) {
        if (this.watchLivePlayer != null) {
            this.watchLivePlayer.setScaleType(scaleType);
        }
    }

    @Override
    public void setWebinarInfo(WebinarInfo webinarInfo) {
        super.setWebinarInfo(webinarInfo);
        Live.Builder builder = new Live.Builder();
        builder.playView(this.videoView).callback(this.listener).bufferDelay(this.buffSeconds).connectTimeoutMils(this.connectTimeout).messageCallback(this.messageCallback).context(this.context).containerLayout(this.videoContainer).chatCallback(this.chatCallback);
        String type = webinarInfo.is_new_version == 3 ? "6" : (TextUtils.isEmpty((CharSequence)webinarInfo.vss_token) ? "flash" : "h5");
        this.watchLivePlayer = builder.buildLive(type);
        this.watchLivePlayer.setWebinarInfo(webinarInfo);
        if (webinarInfo.notice != null && !TextUtils.isEmpty((CharSequence)webinarInfo.notice.content)) {
            List<IMessageCallBack> messageCallBackByKey;
            MessageServer.MsgInfo messageInfo = new MessageServer.MsgInfo();
            messageInfo.content = webinarInfo.notice.content;
            messageInfo.publish_release_time = webinarInfo.notice.publish_release_time;
            messageInfo.duration = webinarInfo.notice.duration;
            messageInfo.event = 9;
            if (this.messageCallback != null) {
                this.messageCallback.onEvent(messageInfo);
            }
            if ((messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey("key_notice")) != null && messageCallBackByKey.size() > 0) {
                for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                    if (!(iMessageCallBack instanceof NoticeMessageCallBack)) continue;
                    ((NoticeMessageCallBack)iMessageCallBack).noticeSend(messageInfo);
                }
            }
        }
    }

    private WatchLive(Builder builder) {
        this.context = builder.context;
        this.videoContainer = builder.videoContainer;
        this.listener = builder.listener;
        this.videoView = builder.videoView;
        this.buffSeconds = builder.buffSeconds;
        this.connectTimeout = builder.connectTimeout;
        this.messageCallback = builder.messageCallback;
        this.chatCallback = builder.chatCallback;
    }

    @Override
    public void start() {
        if (this.watchLivePlayer != null) {
            if (this.watchLivePlayer.isPlaying()) {
                return;
            }
            if (!this.isAvaliable()) {
                this.listener.onError(20202, 0, this.context.getString(R.string.error_video_msg_init));
                return;
            }
            this.watchLivePlayer.start();
        }
    }

    @Override
    public void stop() {
        if (this.watchLivePlayer == null) {
            return;
        }
        this.watchLivePlayer.stop();
    }

    @Override
    public void destroy() {
        if (this.watchLivePlayer != null) {
            this.watchLivePlayer.destroy();
        }
        this.destoryPlayview();
    }

    @Override
    public void startPlay(String url) {
        if (this.watchLivePlayer != null) {
            this.watchLivePlayer.startPlay(url);
        }
    }

    @Override
    public boolean setVideoBackgroundColor(int color) {
        if (this.watchLivePlayer != null) {
            return this.watchLivePlayer.setVideoBackgroundColor(color);
        }
        return false;
    }

    @Override
    public boolean setVideoBackgroundImage(Bitmap bitmap) {
        if (bitmap == null) {
            return false;
        }
        if (this.watchLivePlayer != null) {
            return this.watchLivePlayer.setVideoBackgroundImage(bitmap);
        }
        return false;
    }

    @Override
    public boolean takeVideoScreenshot(VHVideoPlayerView.ScreenShotCallback callback) {
        if (callback == null) {
            return false;
        }
        if (this.watchLivePlayer != null) {
            return this.watchLivePlayer.takeVideoScreenshot(callback);
        }
        return false;
    }

    public boolean setLiveSubtitle(boolean open) {
        if (this.watchLivePlayer != null && this.watchLivePlayer instanceof WatchLiveH5New) {
            return ((WatchLiveH5New)this.watchLivePlayer).setLiveSubtitle(open);
        }
        return true;
    }

    @Override
    @Deprecated
    public void releasePlayer() {
        if (this.watchLivePlayer != null) {
            this.watchLivePlayer.releasePlayer();
        }
    }

    private void destoryPlayview() {
        if (this.videoView != null && this.videoContainer != null) {
            this.videoContainer.removeView((View)this.videoView);
        }
    }

    @Override
    public void sendChat(String content, RequestCallback callback) {
        if (!this.isAvaliable()) {
            callback.onError(20001, this.context.getString(R.string.error_msg_init));
            return;
        }
        if (this.webinarInfo.chatforbid) {
            callback.onError(20021, this.context.getString(R.string.error_chat_forbid_open));
            return;
        }
        if (this.webinarInfo.filters != null) {
            for (int i = 0; i < this.webinarInfo.filters.size(); ++i) {
                if (!content.contains(this.webinarInfo.filters.get(i))) continue;
                VhallCallback.ErrorCallback(callback, 20020, this.context.getString(R.string.error_chat_forbid));
                return;
            }
        }
        if (this.watchLivePlayer != null) {
            this.watchLivePlayer.sendChat(content, callback);
        }
    }

    @Override
    public void sendCustom(JSONObject content, RequestCallback callback) {
        if (this.watchLivePlayer != null) {
            this.watchLivePlayer.sendCustom(content, callback);
        }
    }

    @Override
    public void sendQuestion(String content, RequestCallback callback) {
        if (!VhallSDK.isLogin()) {
            return;
        }
        if (this.watchLivePlayer != null) {
            if (TextUtils.isEmpty((CharSequence)content)) {
                VhallCallback.ErrorCallback(callback, 20003, "\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
                return;
            }
            this.watchLivePlayer.sendQuestion(content, callback);
        }
    }

    @Override
    public void onRaiseHand(String webinarId, int type, RequestCallback callback) {
        if (!VhallSDK.isLogin()) {
            callback.onError(20004, ErrorCode.ERROR_MSG_ISLOGIN);
            return;
        }
        if (this.watchLivePlayer == null) {
            callback.onError(20001, ErrorCode.ERROR_MSG_INIT);
            return;
        }
        if (this.webinarInfo == null || TextUtils.isEmpty((CharSequence)this.webinarInfo.join_id)) {
            callback.onError(20003, ErrorCode.ERROR_MESSAGE_NOT_EMPTY_STR);
            return;
        }
        this.watchLivePlayer.onRaiseHand(webinarId, type, callback);
    }

    @Override
    public void replyInvitation(String webinarId, int type, RequestCallback callback) {
        if (!VhallSDK.isLogin()) {
            callback.onError(20004, ErrorCode.ERROR_MSG_ISLOGIN);
            return;
        }
        if (this.webinarInfo == null || TextUtils.isEmpty((CharSequence)this.webinarInfo.join_id)) {
            callback.onError(20003, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        if (this.watchLivePlayer != null) {
            this.watchLivePlayer.replyInvitation(webinarId, type, callback);
        } else {
            callback.onError(20001, ErrorCode.ERROR_MSG_INIT);
        }
    }

    @Override
    public void acquireChatRecord(boolean show_all, ChatServer.ChatRecordCallback chatRecordCallback) {
        if (this.watchLivePlayer != null) {
            this.watchLivePlayer.acquireChatRecord(show_all, chatRecordCallback);
        }
    }

    @Override
    @Deprecated
    public void acquireChatRecord(int page, ChatServer.ChatRecordCallback chatRecordCallback) {
        if (this.watchLivePlayer != null) {
            this.watchLivePlayer.acquireChatRecord(page, chatRecordCallback);
        }
    }

    @Override
    public void acquireChatRecord(int page, int limit, String msgId, String anchorPath, String isRole, ChatServer.ChatRecordCallback chatRecordCallback) {
        if (this.watchLivePlayer != null) {
            this.watchLivePlayer.acquireChatRecord(page, limit, msgId, anchorPath, isRole, chatRecordCallback);
        }
    }

    @Override
    public HashMap<String, Integer> getDefinitionAvailable() {
        if (this.watchLivePlayer != null) {
            return this.watchLivePlayer.getDefinitionAvailable();
        }
        return null;
    }

    @Override
    public String getOriginalUrl() {
        if (this.watchLivePlayer != null) {
            return this.watchLivePlayer.getOriginalUrl();
        }
        return null;
    }

    @Override
    public void connectChatServer() {
        if (this.watchLivePlayer != null) {
            this.watchLivePlayer.connectChatServer();
        }
    }

    @Override
    public void disconnectChatServer() {
        if (this.watchLivePlayer != null) {
            this.watchLivePlayer.disconnectChatServer();
        }
    }

    @Override
    public void connectMsgServer() {
        if (this.watchLivePlayer != null) {
            this.watchLivePlayer.connectMsgServer();
        }
    }

    @Override
    public void disconnectMsgServer() {
        if (this.watchLivePlayer != null) {
            this.watchLivePlayer.disconnectMsgServer();
        }
    }

    @Override
    public void setOPSDelay(int delayMs) {
        if (null != this.watchLivePlayer) {
            this.watchLivePlayer.setOPSDelay(delayMs);
        }
    }

    public static class Builder {
        Context context;
        RelativeLayout videoContainer;
        VHPlayerListener listener;
        int buffSeconds = 6;
        int connectTimeout = 5000;
        MessageServer.Callback messageCallback;
        ChatServer.Callback chatCallback;
        IVHVideoPlayer videoView;

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder containerLayout(RelativeLayout container) {
            this.videoContainer = container;
            return this;
        }

        public Builder callback(VHPlayerListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder messageCallback(MessageServer.Callback messageCallback) {
            this.messageCallback = messageCallback;
            return this;
        }

        public Builder chatCallback(ChatServer.Callback chatCallback) {
            this.chatCallback = chatCallback;
            return this;
        }

        public Builder bufferDelay(int buffSeconds) {
            if (buffSeconds > 0) {
                this.buffSeconds = buffSeconds;
            }
            return this;
        }

        public Builder connectTimeoutMils(int millisecond) {
            if (millisecond > 0) {
                this.connectTimeout = millisecond;
            }
            return this;
        }

        public Builder playView(IVHVideoPlayer playView) {
            this.videoView = playView;
            return this;
        }

        public WatchLive build() {
            if (this.context == null) {
                throw new IllegalArgumentException("context can not be null");
            }
            if (this.videoContainer == null && this.videoView == null) {
                throw new IllegalArgumentException("containerLayout and playView can not both be null");
            }
            return new WatchLive(this);
        }
    }
}

