/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business;

import android.os.CountDownTimer;
import android.text.TextUtils;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.data.MessageLotteryData;
import com.vhall.business.module.message.IMessageCallBack;
import com.vhall.framework.connect.VhallConnectService;
import com.vhall.ims.VHIM;
import com.vhall.logmanager.VLog;
import com.vhall.message.ConnectServer;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.data.LotteryCheckData;
import com.vhall.vhss.data.WebinarInfoData;
import com.vhall.vhss.netutils.VHJSON;
import com.vhall.vhss.network.InteractToolsNetworkRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vhall.com.vss2.data.MessageData;
import vhall.com.vss2.data.ResponseChatInfo;
import vhall.com.vss2.data.ResponseImMessageInfo;
import vhall.com.vss2.data.VssMessageAnnouncementData;
import vhall.com.vss2.data.VssMessageChatData;
import vhall.com.vss2.data.VssMessageQuestionData;
import vhall.com.vss2.data.VssMessageSignData;
import vhall.com.vss2.module.room.callback.IVssCallBackListener;
import vhall.com.vss2.module.room.callback.IVssMessageListener;

public class NewH5ImManager {
    private static volatile NewH5ImManager instance;
    private VHIM im;
    private final String TAG = "RoomPresenter";
    private IVssCallBackListener vssCallBackListener;
    private List<IVssMessageListener> messageListenerList = new ArrayList<IVssMessageListener>();
    private WebinarInfoData roomInfo;
    private List<LotteryRecord> lottery = new ArrayList<LotteryRecord>();
    private Map<String, List<IMessageCallBack>> messageCallBackMap = new HashMap<String, List<IMessageCallBack>>();
    public static boolean enter;
    private int countTime = 5;
    private MsgListener.LotteryCount lotteryCount;

    public void setMessageCallBackMap(String key, IMessageCallBack callBack) {
        List<IMessageCallBack> messageCallBackByList = NewH5ImManager.getInstance().getMessageCallBackByKey(key);
        if (messageCallBackByList == null) {
            messageCallBackByList = new ArrayList<IMessageCallBack>();
        }
        messageCallBackByList.add(callBack);
        this.messageCallBackMap.put(key, messageCallBackByList);
        VLog.e((String)"NewH5ImManager", (String)key);
    }

    public List<IMessageCallBack> getMessageCallBackByKey(String key) {
        return this.messageCallBackMap.get(key);
    }

    public int getMessageListenerListSize() {
        if (this.messageListenerList == null || this.messageListenerList.size() < 1) {
            return 0;
        }
        return this.messageListenerList.size();
    }

    public String getRoomId() {
        return this.roomInfo.interact.room_id;
    }

    private NewH5ImManager() {
        LogReportManager.doReport("115029");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NewH5ImManager getInstance() {
        if (instance != null) return instance;
        Class<NewH5ImManager> clazz = NewH5ImManager.class;
        synchronized (NewH5ImManager.class) {
            if (instance != null) return instance;
            instance = new NewH5ImManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void leaveRoom() {
        if (this.im != null) {
            this.im.leave();
        }
        this.im = null;
        this.lottery.clear();
        enter = false;
        this.messageListenerList.clear();
        this.roomInfo = null;
        if (this.lotteryCount != null) {
            this.lotteryCount.cancel();
            this.lotteryCount = null;
        }
        this.messageCallBackMap.clear();
    }

    public void enterRoom(WebinarInfoData webinarInfoData) {
        if (webinarInfoData != null && webinarInfoData.interact != null) {
            this.roomInfo = webinarInfoData;
            enter = true;
            if (this.im == null) {
                this.im = new VHIM(webinarInfoData.getInteract().getChannel_id(), webinarInfoData.getInteract().getPaas_access_token());
                this.im.setOnMessageListener((VHIM.OnMessageListener)new MsgListener());
                this.im.setOnConnectChangedListener(new VhallConnectService.OnConnectStateChangedListener(){

                    public void onStateChanged(ConnectServer.State state, int i) {
                        if (NewH5ImManager.this.vssCallBackListener != null) {
                            NewH5ImManager.this.vssCallBackListener.onStateChanged(state, i);
                        }
                    }
                });
                this.im.join();
            }
        }
    }

    public void setVssCallBackListener(IVssCallBackListener listener) {
        if (this.im != null) {
            this.vssCallBackListener = listener;
        } else {
            VLog.e((String)"RoomPresenter", (String)"No enter room");
        }
    }

    public void sendMsg(String msg, String type, final CallBack callBack) {
        if (TextUtils.isEmpty((CharSequence)type)) {
            type = "text";
        }
        if (this.im != null) {
            if ("service_custom".equals(type)) {
                this.im.sendCustomMsg(msg, new VHIM.Callback(){

                    public void onSuccess() {
                        if (callBack != null) {
                            callBack.onSuccess(null);
                        }
                    }

                    public void onFailure(int i, String s) {
                        if (callBack != null) {
                            callBack.onError(i, s);
                        }
                    }
                });
                return;
            }
            this.im.sendMsg(msg, type, new VHIM.Callback(){

                public void onSuccess() {
                    if (callBack != null) {
                        callBack.onSuccess(null);
                    }
                }

                public void onFailure(int i, String s) {
                    if (callBack != null) {
                        callBack.onError(i, s);
                    }
                }
            });
        } else if (callBack != null) {
            callBack.onError(-1, "\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    public void setMessageListener(IVssMessageListener iMessageListener) {
        this.messageListenerList.add(0, iMessageListener);
    }

    public void removeMessageListener(IVssMessageListener iMessageListener) {
        this.messageListenerList.remove(iMessageListener);
    }

    static {
        enter = false;
    }

    class MsgListener
    implements VHIM.OnMessageListener {
        private MessageLotteryData lotteryData = new MessageLotteryData();
        private ResponseImMessageInfo responseImMessageInfo;

        MsgListener() {
        }

        public void onMessage(String msg) {
            if (!TextUtils.isEmpty((CharSequence)msg)) {
                try {
                    ResponseImMessageInfo responseImMessageInfo = VHJSON.parseObject(msg, ResponseImMessageInfo.class);
                    if (TextUtils.isEmpty((CharSequence)responseImMessageInfo.getData()) || TextUtils.isEmpty((CharSequence)responseImMessageInfo.getService_type())) {
                        return;
                    }
                    this.dealMessage(responseImMessageInfo);
                }
                catch (Exception var3) {
                    var3.printStackTrace();
                }
            }
        }

        public void onChannelStatus(String s) {
        }

        private void sendMessage(String type, Object data, ResponseImMessageInfo responseImMessageInfo) {
            if (NewH5ImManager.this.messageListenerList != null && NewH5ImManager.this.messageListenerList.size() > 0) {
                for (IVssMessageListener iMessageListener : NewH5ImManager.this.messageListenerList) {
                    if (iMessageListener == null) continue;
                    iMessageListener.onMessage(new MessageData(type, data, responseImMessageInfo));
                }
            }
        }

        private void dealMessage(ResponseImMessageInfo responseImMessageInfo) {
            block86: {
                try {
                    String type;
                    JSONObject objData;
                    JSONObject objCon = null;
                    if (!TextUtils.isEmpty((CharSequence)responseImMessageInfo.getContext())) {
                        objCon = new JSONObject(responseImMessageInfo.getContext());
                    }
                    try {
                        objData = new JSONObject(responseImMessageInfo.getData());
                        type = objData.optString("type");
                    }
                    catch (Exception e) {
                        objData = null;
                        type = "-1";
                    }
                    String id = "";
                    block8 : switch (responseImMessageInfo.getService_type()) {
                        case "service_im": {
                            switch (type) {
                                case "disable": {
                                    this.sendMessage(type, null, responseImMessageInfo);
                                    break block8;
                                }
                                case "permit": {
                                    this.sendMessage(type, null, responseImMessageInfo);
                                    break block8;
                                }
                                case "disable_all": {
                                    this.sendMessage(type, null, responseImMessageInfo);
                                    break block8;
                                }
                                case "permit_all": {
                                    this.sendMessage(type, null, responseImMessageInfo);
                                    break block8;
                                }
                                case "image": 
                                case "text": {
                                    JSONArray image_urls;
                                    VssMessageChatData chatData = new VssMessageChatData();
                                    ArrayList<ResponseChatInfo.ContextBean.AtListBean> atList = new ArrayList();
                                    if (objCon != null) {
                                        JSONArray atListArray;
                                        String replyMsg;
                                        chatData.setAvatar(objCon.optString("avatar"));
                                        chatData.setRoom_id(objCon.optString("room_id"));
                                        chatData.setRoleName(objCon.optString("role_name"));
                                        if (!TextUtils.isEmpty((CharSequence)objCon.optString("nickname"))) {
                                            chatData.setNickname(objCon.optString("nickname"));
                                        }
                                        if (TextUtils.isEmpty((CharSequence)chatData.getNickname())) {
                                            chatData.setNickname(objCon.optString("nick_name"));
                                        }
                                        if (!TextUtils.isEmpty((CharSequence)(replyMsg = objCon.optString("replyMsg").trim())) && !replyMsg.startsWith("[") && replyMsg.startsWith("{")) {
                                            VssMessageChatData.ReplyMsgBean replyMsgBean = VHJSON.parseObject(replyMsg, VssMessageChatData.ReplyMsgBean.class);
                                            chatData.setReplyMsg(replyMsgBean);
                                        }
                                        if ((atListArray = objCon.optJSONArray("atList")) != null && atListArray.length() > 0) {
                                            atList = (List)VHJSON.parseObject(atListArray.toString(), new ArrayList<ResponseChatInfo.ContextBean.AtListBean>(){}.getClass());
                                            chatData.setAtlist(atList);
                                        }
                                    }
                                    if ((image_urls = objData.optJSONArray("image_urls")) != null) {
                                        ArrayList<String> urls = new ArrayList<String>();
                                        for (int i = 0; i < image_urls.length(); ++i) {
                                            urls.add(image_urls.get(i).toString());
                                        }
                                        chatData.setImage_urls(urls);
                                    }
                                    chatData.setTime(responseImMessageInfo.getDate_time());
                                    chatData.setType(type);
                                    chatData.setTarget_id(objData.optString("target_id"));
                                    String textContent = objData.optString("text_content");
                                    if (atList != null && atList.size() > 0) {
                                        for (ResponseChatInfo.ContextBean.AtListBean bean : atList) {
                                            textContent = textContent.replace("***" + bean.getNickName(), "@" + bean.getNickName());
                                        }
                                    }
                                    chatData.setText_content(textContent);
                                    chatData.setImage_url(objData.optString("image_url"));
                                    chatData.setUserId(responseImMessageInfo.getSender_id());
                                    chatData.setMy(responseImMessageInfo.getSender_id().equals(((NewH5ImManager)NewH5ImManager.this).roomInfo.join_info.third_party_user_id));
                                    this.sendMessage(type, chatData, responseImMessageInfo);
                                    break block8;
                                }
                            }
                            this.sendMessage(type, responseImMessageInfo, responseImMessageInfo);
                            break;
                        }
                        case "service_custom": {
                            if (TextUtils.equals((CharSequence)objData.optString("type"), (CharSequence)"edit_webinar_role_name")) {
                                this.sendMessage("edit_webinar_role_name", responseImMessageInfo, responseImMessageInfo);
                                return;
                            }
                            VssMessageChatData chatData = new VssMessageChatData();
                            if (objCon != null) {
                                chatData.setAvatar(objCon.optString("avatar"));
                                chatData.setRoom_id(objCon.optString("room_id"));
                                chatData.setRoleName(objCon.optString("role_name"));
                                if (!TextUtils.isEmpty((CharSequence)objCon.optString("nickname"))) {
                                    chatData.setNickname(objCon.optString("nickname"));
                                } else {
                                    chatData.setNickname(objCon.optString("nick_name"));
                                }
                                chatData.setRoleName(objCon.optString("role_name"));
                            }
                            chatData.setTime(responseImMessageInfo.getDate_time());
                            chatData.setType("text");
                            chatData.event = "custom_broadcast";
                            chatData.setText_content(responseImMessageInfo.getData());
                            chatData.setUserId(responseImMessageInfo.getSender_id());
                            chatData.setMy(responseImMessageInfo.getSender_id().equals(((NewH5ImManager)NewH5ImManager.this).roomInfo.join_info.third_party_user_id));
                            this.sendMessage("service_custom", chatData, responseImMessageInfo);
                            break;
                        }
                        case "service_online": {
                            String hide = objData.optString("hide");
                            JSONObject online = new JSONObject();
                            online.put("time", (Object)responseImMessageInfo.getDate_time());
                            online.put("id", (Object)responseImMessageInfo.getSender_id());
                            online.put("hide", (Object)objData.optString("hide"));
                            if (objCon != null) {
                                if (!TextUtils.isEmpty((CharSequence)objCon.optString("nickname"))) {
                                    online.put("name", (Object)objCon.optString("nickname"));
                                } else {
                                    online.put("name", (Object)objCon.optString("nick_name"));
                                }
                                online.put("avatar", (Object)objCon.optString("avatar"));
                            }
                            this.sendMessage(type, online, responseImMessageInfo);
                            break;
                        }
                        case "service_room": {
                            switch (type) {
                                case "lottery_push": {
                                    MessageLotteryData lotteryData = VHJSON.parseObject(responseImMessageInfo.getData(), MessageLotteryData.class);
                                    if (lotteryData != null) {
                                        this.sendMessage(type, lotteryData, responseImMessageInfo);
                                        break;
                                    }
                                    break block86;
                                }
                                case "lottery_result_notice": {
                                    this.dealLottery(responseImMessageInfo, type);
                                    break;
                                }
                                case "sign_in_push": {
                                    this.dealData(responseImMessageInfo, type, VssMessageSignData.class);
                                    break;
                                }
                                case "room_announcement": {
                                    this.dealData(responseImMessageInfo, type, VssMessageAnnouncementData.class);
                                    break;
                                }
                                case "question_answer_open": {
                                    this.dealData(responseImMessageInfo, type, VssMessageAnnouncementData.class);
                                    break;
                                }
                                case "question_answer_create": 
                                case "question_answer_commit": {
                                    this.dealData(responseImMessageInfo, type, VssMessageQuestionData.class);
                                    break;
                                }
                                case "questionnaire_push": 
                                case "questionnaire_repush": {
                                    String questionnaire_id = objData.optString("questionnaire_id");
                                    JSONObject question = new JSONObject();
                                    question.put("questionnaire_id", (Object)questionnaire_id);
                                    this.sendMessage(type, question, responseImMessageInfo);
                                    break;
                                }
                                case "vrtc_connect_apply": 
                                case "vrtc_connect_apply_cancel": 
                                case "vrtc_connect_invite_refused": 
                                case "vrtc_connect_success": {
                                    JSONObject apply = new JSONObject();
                                    apply.put("nick_name", (Object)objData.optString("nick_name"));
                                    apply.put("user_id", (Object)objData.optString("room_join_id"));
                                    apply.put("inviter_account_id", (Object)objData.optString("inviter_account_id"));
                                    this.sendMessage(type, apply, responseImMessageInfo);
                                    break;
                                }
                                case "vrtc_connect_invite": 
                                case "room_kickout": 
                                case "vrtc_connect_agree": 
                                case "vrtc_connect_refused": {
                                    id = objData.optString("target_id");
                                    this.sendMessage(type, responseImMessageInfo, responseImMessageInfo);
                                    break;
                                }
                                case "vrtc_frames_forbid": 
                                case "vrtc_mute_cancel": 
                                case "vrtc_mute": 
                                case "vrtc_frames_display": 
                                case "vrtc_disconnect_success": {
                                    this.sendMessage(type, responseImMessageInfo, responseImMessageInfo);
                                    break;
                                }
                                default: {
                                    this.sendMessage(type, responseImMessageInfo, responseImMessageInfo);
                                    break;
                                }
                            }
                            break;
                        }
                        default: {
                            this.sendMessage(type, responseImMessageInfo, responseImMessageInfo);
                        }
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }

        private void dealData(ResponseImMessageInfo responseImMessageInfo, String type, Class c) {
            Object data = VHJSON.parseObject(responseImMessageInfo.getData(), c);
            if (data != null) {
                this.sendMessage(type, data, responseImMessageInfo);
            }
        }

        private void dealLottery(ResponseImMessageInfo responseImMessageInfo, String type) {
            this.lotteryData = VHJSON.parseObject(responseImMessageInfo.getData(), MessageLotteryData.class);
            this.responseImMessageInfo = responseImMessageInfo;
            if (this.lotteryData != null) {
                this.cancelCount();
                LotteryRecord lotteryRecord = new LotteryRecord(this.lotteryData.lottery_id, this.lotteryData.actual_lottery_number);
                int winner = 0;
                if (!TextUtils.isEmpty((CharSequence)this.lotteryData.lottery_winners)) {
                    winner = this.getWinnerNum(this.lotteryData.lottery_winners);
                }
                if (NewH5ImManager.this.lottery.contains(lotteryRecord)) {
                    LotteryRecord record = (LotteryRecord)NewH5ImManager.this.lottery.get(NewH5ImManager.this.lottery.indexOf(lotteryRecord));
                    if (record.now_lottery_number == record.actual_lottery_number) {
                        return;
                    }
                    lotteryRecord.now_lottery_number = winner + record.now_lottery_number;
                    NewH5ImManager.this.lottery.remove(lotteryRecord);
                    NewH5ImManager.this.lottery.add(lotteryRecord);
                } else {
                    lotteryRecord.now_lottery_number = winner;
                }
                if (lotteryRecord.now_lottery_number == lotteryRecord.actual_lottery_number) {
                    if (this.lotteryData.lottery_winners.contains(((NewH5ImManager)NewH5ImManager.this).roomInfo.join_info.third_party_user_id)) {
                        this.lotteryData.isWinner = true;
                    }
                    lotteryRecord.now_lottery_number = this.lotteryData.actual_lottery_number;
                    NewH5ImManager.this.lottery.remove(lotteryRecord);
                    NewH5ImManager.this.lottery.add(lotteryRecord);
                    this.sendMessage(type, this.lotteryData, responseImMessageInfo);
                } else {
                    this.startCount();
                }
            }
        }

        private int getWinnerNum(String winner) {
            if (TextUtils.isEmpty((CharSequence)winner)) {
                return 0;
            }
            return winner.length() - winner.replaceAll(",", "").length() + 1;
        }

        private void startCount() {
            if (NewH5ImManager.this.lotteryCount != null) {
                NewH5ImManager.this.lotteryCount.cancel();
            }
            NewH5ImManager.this.lotteryCount = new LotteryCount(NewH5ImManager.this.countTime * 1000, 1000L);
            NewH5ImManager.this.lotteryCount.start();
        }

        private void cancelCount() {
            if (NewH5ImManager.this.lotteryCount != null) {
                NewH5ImManager.this.lotteryCount.cancel();
            }
        }

        class LotteryCount
        extends CountDownTimer {
            public LotteryCount(long millisInFuture, long countDownInterval) {
                super(millisInFuture, countDownInterval);
            }

            public void onTick(long millisUntilFinished) {
            }

            public void onFinish() {
                try {
                    Random random = new Random();
                    Thread.sleep(random.nextInt(500) * 10);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                InteractToolsNetworkRequest.lotteryCheck(new CallBack<LotteryCheckData>(){

                    @Override
                    public void onSuccess(LotteryCheckData result) {
                        if (MsgListener.this.lotteryData == null) {
                            return;
                        }
                        LotteryRecord lotteryRecord = new LotteryRecord(((MsgListener)MsgListener.this).lotteryData.lottery_id, ((MsgListener)MsgListener.this).lotteryData.actual_lottery_number);
                        lotteryRecord.now_lottery_number = ((MsgListener)MsgListener.this).lotteryData.actual_lottery_number;
                        ((MsgListener)MsgListener.this).lotteryData.isWinner = result != null && result.win == 1;
                        NewH5ImManager.this.lottery.remove(lotteryRecord);
                        NewH5ImManager.this.lottery.add(lotteryRecord);
                        MsgListener.this.sendMessage("lottery_result_notice", MsgListener.this.lotteryData, MsgListener.this.responseImMessageInfo);
                        MsgListener.this.lotteryData = null;
                        MsgListener.this.responseImMessageInfo = null;
                    }

                    @Override
                    public void onError(int eventCode, String msg) {
                    }
                });
            }
        }
    }

    private class LotteryRecord {
        public String lottery_id;
        public int actual_lottery_number;
        public int now_lottery_number;

        public LotteryRecord(String lottery_id, int actual_lottery_number) {
            this.lottery_id = lottery_id;
            this.actual_lottery_number = actual_lottery_number;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LotteryRecord that = (LotteryRecord)o;
            return TextUtils.equals((CharSequence)this.lottery_id, (CharSequence)that.lottery_id);
        }
    }
}

