/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.utils.LogManager;
import com.vhall.player.MPlayer;
import com.vhall.vhss.data.CardsInfoData;
import com.vhall.vhss.data.GoodsInfoData;
import com.vhall.vhss.data.MenuListInfoData;
import com.vhall.vhss.data.OrderInfoData;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vhall.com.vss2.data.ResponseImMessageInfo;

public class MessageServer {
    public static final int EVENT_OVER = 0;
    public static final int EVENT_KICKOUT = 1;
    public static final int EVENT_KICKOUT_RESTORE = 2;
    public static final int EVENT_DISABLE_CHAT = 3;
    public static final int EVENT_PERMIT_CHAT = 4;
    public static final int EVENT_DIFINITION_CHANGED = 5;
    public static final int EVENT_CHANGEDOC = 6;
    public static final int EVENT_START_LOTTERY = 7;
    public static final int EVENT_END_LOTTERY = 8;
    public static final int EVENT_NOTICE = 9;
    public static final int EVENT_SIGNIN = 16;
    public static final int EVENT_QUESTION = 17;
    public static final int EVENT_SURVEY = 18;
    public static final int EVENT_SHOWBOARD = 19;
    public static final int EVENT_INITBOARD = 20;
    public static final int EVENT_PAINTBOARD = 21;
    public static final int EVENT_DELETEBOARD = 22;
    public static final int EVENT_CLEARBOARD = 23;
    public static final int EVENT_SHOWDOC = 26;
    public static final int EVENT_PAINTDOC = 24;
    public static final int EVENT_DELETEDOC = 25;
    public static final int EVENT_CLEARDOC = 32;
    public static final int EVENT_SHOWH5DOC = 64;
    public static final int EVENT_PAINTH5DOC = 65;
    public static final int EVENT_RESTART = 33;
    public static final int EVENT_CHAT_FORBID_ALL = 34;
    public static final int EVENT_INTERACTIVE_ALLOW_HAND = 48;
    public static final int EVENT_INTERACTIVE_HAND = 49;
    public static final int EVENT_INTERACTIVE_ALLOW_MIC = 50;
    public static final int EVENT_INTERACTIVE_DOWN_MIC = 51;
    public static final int EVENT_SWITCH_DEVICE = 52;
    public static final int EVENT_INVITED_MIC = 53;
    public static final int EVENT_VRTC_CONNECT_SUCCESS = 54;
    public static final int EVENT_VRTC_DISCONNECT_SUCCESS = 55;
    public static final int EVENT_VRTC_CONNECT_INVITE_AGREE = 56;
    public static final int EVENT_VRTC_SPEAKER_SWITCH = 57;
    public static final int EVENT_VRTC_CONNECT_REFUSED = 80;
    public static final int EVENT_CONNECT_INVITE_REFUSED = 81;
    public static final int EVENT_EDIT_WEBINAR_ROLE_NAME = 82;
    public static final int EVENT_VRTC_BIG_SCREEN_SET = 83;
    public static final int EVENT_SURVEY_PUSH = 84;
    public static final int EVENT_QUESTION_ANSWER_SET = 85;
    public static final int EVENT_DIRECTOR_STREAM = 96;
    public static final int EVENT_VIDEO_ROUND_START = 97;
    public static final int EVENT_VIDEO_ROUND_USERS = 98;
    public static final int EVENT_VIDEO_ROUND_END = 99;
    public static final int EVENT_TIMER_START = 100;
    public static final int EVENT_TIMER_END = 101;
    public static final int EVENT_TIMER_RESET = 102;
    public static final int EVENT_TIMER_RESUME = 103;
    public static final int EVENT_TIMER_PAUSE = 104;
    public static final int EVENT_PRAISE_TOTAL = 105;
    public static final int EVENT_GIFT_SEND_SUCCESS = 112;
    public static final int EVENT_LIVE_START_REHEARSAL = 113;
    public static final int EVENT_LIVE_OVER_REHEARSAL = 114;
    public static final int EVENT_EXAM_PAPER_SEND = 115;
    public static final int EVENT_EXAM_PAPER_END = 116;
    public static final int EVENT_EXAM_PAPER_AUTO_END = 117;
    public static final int EVENT_EXAM_PAPER_SEND_RANK = 118;
    public static final int EVENT_EXAM_PAPER_AUTO_SEND_RANK = 119;
    public static final int EVENT_SIGN_END = 120;
    public static final int EVENT_CHART_DELETE = 121;
    public static final int EVENT_DATA_DOWNLOAD_UPDATE = 128;
    public static final int EVENT_PUSH_SCREEN_CRAD = 129;
    public static final int EVENT_PUSH_SCREEN_CRAD_DELETE = 130;
    public static final int EVENT_PUSH_SCREEN_CRAD_UPDATE = 131;
    public static final int EVENT_PUSH_GOODS_CARD = 132;
    public static final int EVENT_GOOD_UPDATE_INFO = 133;
    public static final int EVENT_GOOD_ORFER_STATUS = 134;
    private static final int TYPE_CMD = 1;
    private static final int TYPE_FLASH = 2;
    private static final String TAG = "MessageServer";
    public static final String imgUrlFormat = "%s/%s/%d.jpg";
    private WebinarInfo webinarInfo;
    private Handler mDelivery = null;
    private Callback mCallback;
    private Socket mSocket;
    private MPlayer mPlayer;
    private Emitter.Listener flashMsg = new Emitter.Listener(){

        public void call(Object ... args) {
            MessageServer.this.parserMsg(args[0], 2);
        }
    };
    private Emitter.Listener cmd = new Emitter.Listener(){

        public void call(Object ... args) {
            MessageServer.this.parserMsg(args[0], 1);
        }
    };
    private Emitter.Listener connect = new Emitter.Listener(){

        public void call(Object ... args) {
            MessageServer.this.mDelivery.post(new Runnable(){

                @Override
                public void run() {
                    if (MessageServer.this.mCallback != null) {
                        MessageServer.this.mCallback.onMsgServerConnected();
                    }
                }
            });
        }
    };
    private Emitter.Listener connect_error = new Emitter.Listener(){

        public void call(Object ... args) {
            MessageServer.this.mDelivery.post(new Runnable(){

                @Override
                public void run() {
                    if (MessageServer.this.mCallback != null) {
                        MessageServer.this.mCallback.onConnectFailed();
                    }
                }
            });
        }
    };
    private Emitter.Listener onDisconnect = new Emitter.Listener(){

        public void call(Object ... args) {
            MessageServer.this.mDelivery.post(new Runnable(){

                @Override
                public void run() {
                    if (MessageServer.this.mCallback != null) {
                        MessageServer.this.mCallback.onMsgServerClosed();
                    }
                }
            });
        }
    };

    public void setmPlayLive(MPlayer player) {
        this.mPlayer = player;
    }

    public MessageServer() {
        this.mDelivery = new Handler(Looper.getMainLooper());
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public void setWebinarInfo(WebinarInfo webinarInfo) {
        if (webinarInfo == null) {
            return;
        }
        this.webinarInfo = webinarInfo;
        this.sendDefaultPPT();
        this.sendDefaultBoard();
        this.sendDefaultNotice();
        this.connect();
    }

    protected void sendDefaultPPT() {
        if (!(this.webinarInfo == null || TextUtils.isEmpty((CharSequence)this.webinarInfo.doc) || this.webinarInfo.doc.equals("null") || TextUtils.isEmpty((CharSequence)this.webinarInfo.host))) {
            String urlStr = String.format(imgUrlFormat, this.webinarInfo.host, this.webinarInfo.doc, this.webinarInfo.page);
            final MsgInfo messageInfo = new MsgInfo();
            messageInfo.doc = this.webinarInfo.doc;
            messageInfo.page = this.webinarInfo.page;
            messageInfo.pptUrl = urlStr;
            messageInfo.event = 6;
            if (this.mCallback != null) {
                this.mDelivery.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        MessageServer.this.mCallback.onEvent(messageInfo);
                    }
                }, 200L);
            }
        }
    }

    protected void sendDefaultBoard() {
        if (this.webinarInfo != null && this.webinarInfo.use_white_board == 1) {
            final MsgInfo messageInfo = new MsgInfo();
            messageInfo.event = 19;
            messageInfo.showType = 1;
            if (this.mCallback != null) {
                this.mDelivery.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        MessageServer.this.mCallback.onEvent(messageInfo);
                    }
                }, 200L);
            }
        }
    }

    protected void sendDefaultNotice() {
        if (this.webinarInfo != null && this.webinarInfo.notice != null && !TextUtils.isEmpty((CharSequence)this.webinarInfo.notice.content)) {
            MsgInfo messageInfo = new MsgInfo();
            messageInfo.content = this.webinarInfo.notice.content;
            messageInfo.event = 9;
            if (this.mCallback != null) {
                this.mCallback.onEvent(messageInfo);
            }
        }
    }

    public void connect() {
        this.disconnect();
        if (this.webinarInfo == null || this.mCallback == null || TextUtils.isEmpty((CharSequence)this.webinarInfo.msg_server) || TextUtils.isEmpty((CharSequence)this.webinarInfo.msg_token)) {
            return;
        }
        try {
            IO.Options options = new IO.Options();
            options.query = "token=" + this.webinarInfo.msg_token;
            options.reconnectionAttempts = 5;
            options.transports = new String[]{"websocket"};
            options.forceNew = true;
            this.mSocket = IO.socket((String)this.webinarInfo.msg_server, (IO.Options)options);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mSocket.on("connect", this.connect);
        this.mSocket.on("connect_error", this.connect_error);
        this.mSocket.on("connect_timeout", this.connect_error);
        this.mSocket.on("disconnect", this.onDisconnect);
        this.mSocket.on("flashMsg", this.flashMsg);
        this.mSocket.on("cmd", this.cmd);
        this.mSocket.connect();
    }

    public void disconnect() {
        if (this.mSocket != null && this.mSocket.connected()) {
            this.mSocket.off("flashMsg", this.flashMsg);
            this.mSocket.off("cmd", this.cmd);
            this.mSocket.off("connect", this.connect);
            this.mSocket.off("connect_error", this.connect_error);
            this.mSocket.off("connect_timeout", this.connect_error);
            this.mSocket.off("disconnect", this.onDisconnect);
            this.mSocket.disconnect();
            this.mSocket.close();
            this.mSocket = null;
        }
    }

    private void parserMsg(Object obj, int type) {
        if (this.mCallback == null) {
            return;
        }
        String msg = "";
        try {
            msg = (String)obj;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (TextUtils.isEmpty((CharSequence)msg)) {
            try {
                JSONObject jsonObject = (JSONObject)obj;
                msg = jsonObject.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        final MsgInfo msgInfo = MessageServer.getMsgFromStr(this.webinarInfo, msg);
        if (msgInfo == null || msgInfo.event < 0) {
            return;
        }
        switch (type) {
            case 1: {
                this.mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        if (MessageServer.this.mCallback != null) {
                            MessageServer.this.mCallback.onEvent(msgInfo);
                        }
                    }
                });
                break;
            }
            case 2: {
                long timemils = 5000L;
                if (this.mPlayer != null) {
                    timemils = this.mPlayer.getRealityBufferTime();
                }
                this.mDelivery.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (MessageServer.this.mCallback != null) {
                            MessageServer.this.mCallback.onEvent(msgInfo);
                        }
                    }
                }, timemils);
            }
        }
    }

    public static MsgInfo getMsgFromStr(WebinarInfo webinarInfo, String msg) {
        MsgInfo messageInfo = null;
        Log.e((String)"getMsgFromStr    ", (String)msg);
        try {
            JSONObject result = new JSONObject(msg);
            messageInfo = new MsgInfo();
            messageInfo.type = result.optString("type");
            messageInfo.user_id = result.optString("user_id");
            LogManager.i(TAG, "onMsg:" + messageInfo.type + "  onResult:" + result);
            switch (messageInfo.type) {
                case "*publish_start": {
                    LogManager.innerLog(TAG, result.toString());
                    messageInfo.event = 5;
                    MessageServer.dealDifinition(webinarInfo, result);
                    break;
                }
                case "*publishStart": {
                    LogManager.innerLog(TAG, result.toString());
                    messageInfo.event = 33;
                    webinarInfo.status = 1;
                    break;
                }
                case "*over": {
                    messageInfo.event = 0;
                    messageInfo.webinar_id = result.optString("webinar_id");
                    webinarInfo.status = 3;
                    break;
                }
                case "*kickout": {
                    if (TextUtils.isEmpty((CharSequence)messageInfo.user_id) || !webinarInfo.join_id.equals(messageInfo.user_id)) break;
                    messageInfo.event = 1;
                    break;
                }
                case "*disablechat": {
                    if (TextUtils.isEmpty((CharSequence)messageInfo.user_id) || !webinarInfo.join_id.equals(messageInfo.user_id)) break;
                    messageInfo.event = 3;
                    webinarInfo.chatforbid = true;
                    break;
                }
                case "*permitchat": {
                    if (TextUtils.isEmpty((CharSequence)messageInfo.user_id) || !webinarInfo.join_id.equals(messageInfo.user_id)) break;
                    messageInfo.event = 4;
                    webinarInfo.chatforbid = false;
                    break;
                }
                case "*forbidchat": {
                    messageInfo.event = 34;
                    messageInfo.status = result.optInt("status");
                    webinarInfo.chatforbid = messageInfo.status == 1;
                    break;
                }
                case "*question": {
                    messageInfo.event = 17;
                    webinarInfo.question_status = messageInfo.status = result.optInt("status");
                    break;
                }
                case "*announcement": {
                    messageInfo.event = 9;
                    messageInfo.content = result.optString("content");
                    break;
                }
                case "*survey": {
                    messageInfo.event = 18;
                    messageInfo.id = result.optString("survey_id");
                    messageInfo.webinar_id = webinarInfo.webinar_id;
                    messageInfo.user_id = webinarInfo.join_id;
                    break;
                }
                case "*startSign": {
                    messageInfo.event = 16;
                    messageInfo.webinar_id = result.optString("webinar_id");
                    messageInfo.id = result.optString("sign_id");
                    messageInfo.user_id = result.optString("user_id");
                    messageInfo.sign_show_time = result.optString("sign_show_time");
                    break;
                }
                case "*lottery": {
                    messageInfo.event = 7;
                    messageInfo.id = result.optString("lottery_id");
                    break;
                }
                case "*lotteryResult": {
                    messageInfo.event = 8;
                    JSONArray lotteryInfo = result.optJSONArray("lists");
                    if (lotteryInfo == null || lotteryInfo.length() <= 0) break;
                    for (int i = 0; i < lotteryInfo.length(); ++i) {
                        JSONObject obj = lotteryInfo.optJSONObject(i);
                        if (obj == null) continue;
                        Lottery lottery = new Lottery();
                        String id = obj.optString("id");
                        if (!TextUtils.isEmpty((CharSequence)id) && webinarInfo.join_id.equals(id)) {
                            lottery.isSelf = true;
                            lottery.id = id;
                        }
                        lottery.nick_name = obj.optString("nick_name");
                        lottery.lottery_id = obj.optString("lottery_id");
                        messageInfo.lotteries.add(lottery);
                    }
                    break;
                }
                case "board_init": {
                    messageInfo.event = 20;
                    break;
                }
                case "change_showtype": {
                    messageInfo.event = 19;
                    messageInfo.showType = result.optInt("showType");
                    break;
                }
                case "board_add": {
                    messageInfo.event = 21;
                    messageInfo.step = MessageServer.getSteps(result);
                    break;
                }
                case "board_del": {
                    messageInfo.event = 22;
                    messageInfo.step = MessageServer.getSteps(result);
                    break;
                }
                case "board_delAll": {
                    messageInfo.event = 23;
                    break;
                }
                case "change_watchtype": {
                    messageInfo.event = 26;
                    messageInfo.watchType = result.optInt("watchType");
                    break;
                }
                case "flipOver": {
                    String urlStr;
                    messageInfo.event = 6;
                    messageInfo.doc = result.optString("doc");
                    messageInfo.page = result.optInt("page");
                    if (webinarInfo == null || TextUtils.isEmpty((CharSequence)webinarInfo.host)) break;
                    messageInfo.pptUrl = urlStr = String.format(imgUrlFormat, webinarInfo.host, messageInfo.doc, messageInfo.page);
                    break;
                }
                case "doc_add": {
                    messageInfo.event = 24;
                    messageInfo.step = MessageServer.getSteps(result);
                    break;
                }
                case "doc_del": {
                    messageInfo.event = 25;
                    messageInfo.step = MessageServer.getSteps(result);
                    break;
                }
                case "doc_delAll": {
                    messageInfo.event = 32;
                    messageInfo.step = MessageServer.getSteps(result);
                    break;
                }
                case "*handsUp": {
                    messageInfo.user_id = result.optString("join_uid");
                    if (!messageInfo.user_id.equals(webinarInfo.join_id)) break;
                    messageInfo.event = 49;
                    messageInfo.status = Integer.parseInt(result.optString("status"));
                    messageInfo.role = result.getString("role_name");
                    messageInfo.nick_name = result.getString("nick_name");
                    break;
                }
                case "*addSpeaker": {
                    int way = result.optInt("way");
                    messageInfo.user_id = result.optString("join_uid");
                    if (way == 2 || !messageInfo.user_id.equals(webinarInfo.join_id)) break;
                    messageInfo.event = 50;
                    messageInfo.role = result.getString("role_name");
                    messageInfo.nick_name = result.getString("nick_name");
                    messageInfo.audio = result.getInt("audio");
                    messageInfo.video = result.getInt("video");
                    break;
                }
                case "*switchDevice": {
                    messageInfo.user_id = result.optString("join_uid");
                    if (!messageInfo.user_id.equals(webinarInfo.join_id)) break;
                    messageInfo.event = 52;
                    messageInfo.status = Integer.parseInt(result.optString("status"));
                    messageInfo.device = Integer.parseInt(result.optString("device"));
                    break;
                }
                case "*notSpeak": {
                    messageInfo.user_id = result.optString("join_uid");
                    if (!messageInfo.user_id.equals(webinarInfo.join_id)) break;
                    messageInfo.event = 51;
                    messageInfo.role = result.getString("role_name");
                    messageInfo.nick_name = result.getString("nick_name");
                    break;
                }
                case "*switchHandsup": {
                    messageInfo.event = 48;
                    messageInfo.status = result.optInt("status");
                    break;
                }
                case "*sendInvite": {
                    messageInfo.user_id = result.getString("join_uid");
                    if (!messageInfo.user_id.equals(webinarInfo.join_id)) break;
                    messageInfo.event = 53;
                    messageInfo.role = result.getString("role_name");
                    messageInfo.nick_name = result.getString("nick_name");
                    break;
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return messageInfo;
    }

    private static Step getSteps(JSONObject result) throws JSONException {
        JSONArray tpoints;
        Position p;
        Step step = new Step();
        JSONObject object = result.optJSONObject("data");
        if (object == null) {
            return null;
        }
        step.type = object.optInt("type");
        step.color = object.optInt("color");
        step.id = object.optInt("id");
        step.lineSize = object.optInt("lineSize");
        step.pageID = object.optString("pageID");
        JSONArray array = object.optJSONArray("points");
        if (array != null && array.length() > 0) {
            step.points = new ArrayList();
            for (int i = 0; i < array.length(); ++i) {
                JSONArray point = (JSONArray)array.get(i);
                p = new Position();
                p.x = point.optDouble(0);
                p.y = point.optDouble(1);
                step.points.add(p);
            }
        }
        step.fb = object.optInt("fb");
        JSONArray spoints = object.optJSONArray("sPoint");
        if (spoints != null) {
            Position p2 = new Position();
            p2.x = spoints.optDouble(0);
            p2.y = spoints.optDouble(1);
            step.sPoint = p2;
        }
        if ((tpoints = object.optJSONArray("tPoint")) != null) {
            p = new Position();
            p.x = tpoints.optDouble(0);
            p.y = tpoints.optDouble(1);
            step.tPoint = p;
        }
        step.fi = object.optInt("fi");
        step.fs = object.optInt("fs");
        step.ft = object.optString("ft");
        return step;
    }

    private static void dealDifinition(WebinarInfo webinarInfo, JSONObject result) {
        JSONArray difis = result.optJSONArray("trans");
        if (difis != null && difis.length() > 0) {
            webinarInfo.A.valid = 0;
            webinarInfo.SD.valid = 0;
            webinarInfo.HD.valid = 0;
            webinarInfo.UHD.valid = 0;
            block12: for (int i = 0; i < difis.length(); ++i) {
                String key;
                switch (key = (String)difis.opt(i)) {
                    case "A": {
                        webinarInfo.A.valid = 1;
                        continue block12;
                    }
                    case "SD": {
                        webinarInfo.SD.valid = 1;
                        continue block12;
                    }
                    case "HD": {
                        webinarInfo.HD.valid = 1;
                        continue block12;
                    }
                    case "UHD": {
                        webinarInfo.UHD.valid = 1;
                    }
                }
            }
        }
    }

    public static interface Callback {
        public void onEvent(MsgInfo var1);

        public void onMsgServerConnected();

        public void onConnectFailed();

        public void onMsgServerClosed();
    }

    public static class MsgInfo {
        public String type;
        public int event = -1;
        public String id;
        public String webinar_id;
        public String user_id;
        public String signTitle;
        public int created_at;
        public int status;
        public String question_name;
        public String survey_name;
        public String chat_status;
        public String qa_status;
        public String private_chat_status;
        public String msg_id;
        public List<String> uids = new ArrayList<String>();
        public String content;
        public String publish_release_time;
        public int duration;
        public String sign_show_time;
        public int showType;
        public int watchType;
        public List<Lottery> lotteries = new ArrayList<Lottery>();
        public LotteryInfo lotteryInfo;
        public boolean winnerLottery = false;
        public Step step;
        public String doc;
        public int page;
        public String pptUrl;
        public String targetId;
        public String senderId;
        public String role;
        public String nick_name;
        public int device;
        public int audio;
        public int video;
        public View h5DocView;
        public String roomJoinId;
        public JSONObject mOriginData;
        public ResponseImMessageInfo responseImMessageInfo;
        public String edit_role_type;
        public String edit_role_name;
        public String inviter_account_id;
        public String director_stream_status;
        public TimerData timerData;
        public int likeNum;
        public GiftInfoData giftInfoData;
        public ExamInfo examInfo;
        public String msg_id_delete;
        public MenuListInfoData.MenuItem file_download_menu;
        public GoodsInfoData.GoodsInfo goodsInfo;
        public OrderInfoData orderInfo;
        public CardsInfoData.CardInfo cardInfo;
        public String card_delete_ids;

        public long getAnnounceRemainingMS() {
            if (this.duration == 0) {
                return 0L;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date publishDate = null;
            try {
                publishDate = sdf.parse(this.publish_release_time);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            if (null == publishDate) {
                return 0L;
            }
            Date curDate = new Date();
            long diffms = curDate.getTime() - publishDate.getTime();
            if (diffms >= (long)this.duration * 1000L) {
                return -1L;
            }
            return (long)this.duration * 1000L - diffms;
        }
    }

    public static class Lottery {
        public String id;
        public String nick_name;
        public String lottery_user_avatar;
        public boolean isSelf = false;
        public String lottery_id;
        public int lottery_status;
        public String lottery_award_id;
        public String lottery_award_name;
    }

    public static class Step {
        public int type;
        public int color;
        public int lineSize;
        public int id = 1;
        public ArrayList<Position> points;
        public int fb;
        public Position sPoint;
        public Position tPoint;
        public int fi;
        public int fs;
        public String ft;
        public String pageID;
    }

    public static class Position {
        public double x;
        public double y;
    }

    public static class ExamInfo {
        public String role_name;
        public String send_time;
        public String paper_title;
        public String webinar_id;
        public String nick_name;
        public String paper_id;
        public String send_time_stamp;
    }

    public static class LotteryInfo {
        public String title;
        public String remark;
        public String icon;
        public String lottery_id;
        public String room_id;
        public int is_new = 0;
        public String command;
        public String lottery_type;
        public int lottery_status;
        public int publish_winner = 1;
        public Award award;
        public int need_take_award;

        public static class Award {
            public String id;
            public String business_uid;
            public String app_id;
            public String source_id;
            public String award_name;
            public String image_url;
            public String award_desc;
            public String link_url;
            public String created_at;
        }
    }

    public static class TimerData {
        public String duration;
        public String is_all_show;
        public String is_timeout;
        public int remain_time;
    }

    public static class GiftInfoData {
        public String gift_user_id;
        public String gift_user_nickname;
        public String gift_user_avatar;
        public String gift_name;
        public String gift_id;
        public String gift_price;
        public String gift_image_url;
        public String gift_receiver_id;
        public String gift_creator_id;
        public String source_status;
    }

    public static interface MessageSupportMsgFilterOther {
        public boolean isFilterOther();
    }
}

