/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business;

import android.text.TextUtils;
import com.vhall.business.ChatServer;
import com.vhall.business.MessageServer;
import com.vhall.business.NewH5ImManager;
import com.vhall.business.VhallSDK;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.data.MessageLotteryData;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.module.card.CardMessageCallBack;
import com.vhall.business.module.gift.GiftMessageCallBack;
import com.vhall.business.module.goods.GoodsMessageCallBack;
import com.vhall.business.module.like.LikeMessageCallBack;
import com.vhall.business.module.lottery.LotteryMessageCallBack;
import com.vhall.business.module.message.IMessageCallBack;
import com.vhall.business.module.message.MessageDealUtils;
import com.vhall.business.module.notice.NoticeMessageCallBack;
import com.vhall.business.module.sign.SignMessageCallBack;
import com.vhall.business.module.survey.SurveyMessageCallBack;
import com.vhall.business.widget.WebinarStatus;
import com.vhall.vhss.data.CardsInfoData;
import com.vhall.vhss.data.GoodsInfoData;
import com.vhall.vhss.data.MenuListInfoData;
import com.vhall.vhss.data.OrderInfoData;
import com.vhall.vhss.data.RoomToolsStatusData;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vhall.com.vss2.data.MessageData;
import vhall.com.vss2.data.ResponseChatInfo;
import vhall.com.vss2.data.ResponseImMessageInfo;
import vhall.com.vss2.data.VssMessageAnnouncementData;
import vhall.com.vss2.data.VssMessageChatData;
import vhall.com.vss2.data.VssMessageLotteryData;
import vhall.com.vss2.data.VssMessageQuestionData;
import vhall.com.vss2.data.VssMessageSignData;
import vhall.com.vss2.module.room.callback.IVssMessageListener;

public class H5MessageChange
implements IVssMessageListener {
    private MessageServer.Callback messageCallback;
    private ChatServer.Callback chatCallback;
    private WebinarInfo webinarInfo;
    private boolean isChat = true;
    private WebinarInfoChangeCallBack webinarInfoChangeCallBack;
    private WebinarStatus webinarStatus = WebinarStatus.WATCH_BACK;
    private List<RoomToolsStatusData.SpeakerListBean> speakList = new ArrayList<RoomToolsStatusData.SpeakerListBean>();

    public H5MessageChange(MessageServer.Callback messageCallback, ChatServer.Callback chatCallback, WebinarInfo webinarInfo, WebinarInfoChangeCallBack changeCallBack) {
        this.messageCallback = messageCallback;
        this.chatCallback = chatCallback;
        if (chatCallback == null) {
            this.chatCallback = new ChatServer.DefCallback();
        }
        this.webinarInfo = webinarInfo;
        if (webinarInfo != null && webinarInfo.getWebinarInfoData() != null && webinarInfo.getWebinarInfoData().roomToolsStatusData != null && webinarInfo.getWebinarInfoData().roomToolsStatusData.speaker_list != null) {
            this.speakList.clear();
            this.speakList.addAll(webinarInfo.getWebinarInfoData().roomToolsStatusData.speaker_list);
        }
        this.webinarInfoChangeCallBack = changeCallBack;
    }

    @Override
    public void onMessage(MessageData msg) {
        if (msg != null && msg.getImMessageInfo() != null) {
            JSONObject objData = null;
            JSONObject objCon = null;
            try {
                objCon = new JSONObject(msg.getImMessageInfo().getContext());
            }
            catch (JSONException e) {
                e.printStackTrace();
                objCon = new JSONObject();
            }
            try {
                objData = new JSONObject(msg.getImMessageInfo().getData());
            }
            catch (Exception e) {
                objData = new JSONObject();
            }
            this.isChat = true;
            if (this.chatCallback != null) {
                boolean filterOtherMsg = true;
                if (this.chatCallback instanceof MessageServer.MessageSupportMsgFilterOther) {
                    filterOtherMsg = ((MessageServer.MessageSupportMsgFilterOther)((Object)this.chatCallback)).isFilterOther();
                }
                this.setChatInfo(msg, objData, objCon, filterOtherMsg);
            } else {
                this.isChat = false;
            }
            if (this.messageCallback != null && !this.isChat) {
                boolean filterOtherMsg = true;
                if (this.chatCallback instanceof MessageServer.MessageSupportMsgFilterOther) {
                    filterOtherMsg = ((MessageServer.MessageSupportMsgFilterOther)((Object)this.chatCallback)).isFilterOther();
                }
                this.setMessageInfo(msg, objData, objCon, filterOtherMsg);
            }
        }
    }

    @Override
    public void onError(int code, String msg) {
    }

    private void setChatInfo(MessageData msg, JSONObject objData, JSONObject objCon, boolean filterOther) {
        if (msg == null || msg.getImMessageInfo() == null) {
            return;
        }
        ResponseImMessageInfo responseImMessageInfo = msg.getImMessageInfo();
        ChatServer.ChatInfo chatInfo = new ChatServer.ChatInfo();
        chatInfo.setMessageData(msg);
        chatInfo.msg_id = msg.getImMessageInfo().getMsg_id();
        chatInfo.mOriginData = objCon;
        if (objCon != null) {
            chatInfo.account_id = objCon.optString("account_id");
            chatInfo.third_account_id = objCon.optString("third_account_id");
            chatInfo.avatar = objCon.optString("avatar");
            chatInfo.role = H5MessageChange.changeRoleNameToRole(objCon.optString("role_name"));
            chatInfo.roleName = this.changeRoleToRoleName(objCon.optString("role_name"));
            chatInfo.user_name = !TextUtils.isEmpty((CharSequence)objCon.optString("nickname")) ? objCon.optString("nickname") : objCon.optString("nick_name");
        }
        if (TextUtils.isEmpty((CharSequence)chatInfo.account_id)) {
            chatInfo.account_id = msg.getImMessageInfo().getSender_id();
        }
        chatInfo.room = responseImMessageInfo.getChannel();
        chatInfo.time = responseImMessageInfo.getDate_time();
        switch (msg.getType()) {
            case "Join": {
                chatInfo.event = "online";
                ChatServer.ChatInfo.OnlineData onlineDataJoin = new ChatServer.ChatInfo.OnlineData();
                String msg_kick_id = "";
                String msg_kick_mark = "";
                if (objCon != null) {
                    onlineDataJoin.role = H5MessageChange.changeRoleNameToRole(objCon.optString("role_name"));
                    onlineDataJoin.roleName = objCon.optString("role_name");
                    onlineDataJoin.is_gag = objCon.optInt("is_banned");
                    msg_kick_id = objCon.optString("kick_id");
                    msg_kick_mark = objCon.optString("kick_mark");
                }
                if (TextUtils.isEmpty((CharSequence)onlineDataJoin.roleName)) {
                    onlineDataJoin.roleName = "2";
                    onlineDataJoin.role = "user";
                }
                onlineDataJoin.concurrent_user = responseImMessageInfo.getUv();
                onlineDataJoin.attend_count = responseImMessageInfo.getPv();
                onlineDataJoin.tracksNum = responseImMessageInfo.getContextPv();
                chatInfo.onlineData = onlineDataJoin;
                if (this.webinarInfo == null || this.webinarInfo.getWebinarInfoData() == null || this.webinarInfo.getWebinarInfoData().ssoBean == null || this.webinarInfo.getWebinarInfoData().ssoBean.enabled != 1) break;
                String kick_id = this.webinarInfo.getWebinarInfoData().ssoBean.kick_id;
                String kick_mark = VhallSDK.getmIMEI() + this.webinarInfo.webinar_id;
                if (TextUtils.isEmpty((CharSequence)msg_kick_id) || !TextUtils.equals((CharSequence)msg_kick_id, (CharSequence)kick_id) || TextUtils.equals((CharSequence)kick_mark, (CharSequence)msg_kick_mark) || this.webinarInfoChangeCallBack == null) break;
                this.webinarInfoChangeCallBack.kickedOut();
                break;
            }
            case "Leave": {
                chatInfo.event = "offline";
                ChatServer.ChatInfo.OnlineData onlineData = new ChatServer.ChatInfo.OnlineData();
                if (objCon != null) {
                    onlineData.role = H5MessageChange.changeRoleNameToRole(objCon.optString("role_name"));
                    onlineData.roleName = objCon.optString("role_name");
                    onlineData.is_gag = objCon.optInt("is_banned");
                }
                if (TextUtils.isEmpty((CharSequence)onlineData.roleName)) {
                    onlineData.roleName = "2";
                    onlineData.role = "user";
                }
                onlineData.concurrent_user = responseImMessageInfo.getUv();
                onlineData.attend_count = responseImMessageInfo.getPv();
                onlineData.tracksNum = responseImMessageInfo.getContextPv();
                chatInfo.onlineData = onlineData;
                break;
            }
            case "question_answer_commit": 
            case "question_answer_create": {
                chatInfo.event = "question";
                VssMessageQuestionData vssMessageQuestionData = (VssMessageQuestionData)msg.getT();
                if (vssMessageQuestionData == null) break;
                ChatServer.ChatInfo.QuestionData questionData = new ChatServer.ChatInfo.QuestionData();
                questionData.avatar = vssMessageQuestionData.getAvatar();
                questionData.content = vssMessageQuestionData.getContent();
                questionData.created_at = vssMessageQuestionData.getCreated_at();
                questionData.created_time = vssMessageQuestionData.getCreated_time();
                questionData.id = String.valueOf(vssMessageQuestionData.getId());
                questionData.join_id = String.valueOf(vssMessageQuestionData.getJoin_id());
                questionData.nick_name = vssMessageQuestionData.getNick_name();
                questionData.type = vssMessageQuestionData.getType();
                VssMessageQuestionData.AnswerBean answer = vssMessageQuestionData.getAnswer();
                if (answer != null) {
                    ChatServer.ChatInfo.QuestionData answerData = new ChatServer.ChatInfo.QuestionData();
                    answerData.avatar = answer.getAvatar();
                    answerData.content = answer.getContent();
                    answerData.created_at = answer.getCreated_at();
                    answerData.created_time = answer.getCreated_time();
                    answerData.role_name = answer.getRole_name();
                    answerData.roleName = this.changeRoleToRoleName(answerData.role_name);
                    answerData.id = String.valueOf(answer.getId());
                    answerData.join_id = String.valueOf(answer.getJoin_id());
                    answerData.nick_name = answer.getNick_name();
                    answerData.is_open = Integer.parseInt(answer.getIs_open());
                    questionData.answer = answerData;
                }
                chatInfo.questionData = questionData;
                break;
            }
            case "image": 
            case "text": {
                chatInfo.event = "msg";
                VssMessageChatData messageChatData = (VssMessageChatData)msg.getT();
                ChatServer.ChatInfo.ChatData msgData = new ChatServer.ChatInfo.ChatData();
                ChatServer.ChatInfo.ReplyMsg chatReplyMsg = new ChatServer.ChatInfo.ReplyMsg();
                ChatServer.ChatInfo.ReplyMsg.Content chatReplyMsgContent = new ChatServer.ChatInfo.ReplyMsg.Content();
                VssMessageChatData.ReplyMsgBean replyMsg = messageChatData.getReplyMsg();
                if (replyMsg != null && replyMsg.getContent() != null) {
                    chatReplyMsg.user_name = replyMsg.getNickName();
                    chatReplyMsg.time = replyMsg.getSendTime();
                    chatReplyMsg.avatar = replyMsg.getAvatar();
                    chatReplyMsg.account_id = replyMsg.getSendId();
                    chatReplyMsg.role = replyMsg.getRoleName();
                    chatReplyMsg.roleName = this.changeRoleToRoleName(chatReplyMsg.role);
                    chatReplyMsg.type = replyMsg.getType();
                    chatReplyMsgContent.textContent = replyMsg.getContent().getText_content();
                    chatReplyMsgContent.type = replyMsg.getContent().getType();
                    chatReplyMsg.content = chatReplyMsgContent;
                    chatInfo.replyMsg = chatReplyMsg;
                } else {
                    chatInfo.replyMsg = null;
                }
                msgData.type = msg.getType();
                msgData.text = messageChatData.getText_content();
                msgData.target_id = messageChatData.getTarget_id();
                if (messageChatData.getImage_url() != null) {
                    msgData.resourceUrl = messageChatData.getImage_url();
                }
                if (messageChatData.getImage_urls() != null && messageChatData.getImage_urls().size() > 0) {
                    msgData.resourceUrl = messageChatData.getImage_urls().get(0);
                    msgData.imageUrls.addAll(messageChatData.getImage_urls());
                }
                ArrayList<ChatServer.ChatInfo.AtListBean> atList = new ArrayList<ChatServer.ChatInfo.AtListBean>();
                List<ResponseChatInfo.ContextBean.AtListBean> atListObj = messageChatData.getAtlist();
                if (atListObj != null && atListObj.size() > 0) {
                    for (ResponseChatInfo.ContextBean.AtListBean bean : atListObj) {
                        if (bean == null) continue;
                        ChatServer.ChatInfo.AtListBean atListBean = new ChatServer.ChatInfo.AtListBean();
                        atListBean.accountId = bean.getAccountId();
                        atListBean.nickName = bean.getNickName();
                        atListBean.index = bean.getIndex();
                        atList.add(atListBean);
                    }
                }
                chatInfo.atList = atList;
                chatInfo.msgData = msgData;
                break;
            }
            case "service_custom": {
                if (TextUtils.equals((CharSequence)"timer_pause", (CharSequence)objData.optString("type")) || TextUtils.equals((CharSequence)"data_download_update", (CharSequence)objData.optString("type")) || TextUtils.equals((CharSequence)"goods_update_info", (CharSequence)objData.optString("type")) || TextUtils.equals((CharSequence)"push_goods_change", (CharSequence)objData.optString("type")) || TextUtils.equals((CharSequence)"order_status_change", (CharSequence)objData.optString("type"))) break;
                chatInfo.event = "custom_broadcast";
                ChatServer.ChatInfo.ChatData customData = new ChatServer.ChatInfo.ChatData();
                customData.text = responseImMessageInfo.getData();
                chatInfo.msgData = customData;
                break;
            }
            case "base_num_update": {
                chatInfo.event = "base_num_update";
                ChatServer.ChatInfo.VirtualNumUpdateData virtualNumUpdateData = new ChatServer.ChatInfo.VirtualNumUpdateData();
                virtualNumUpdateData.update_online_num = objData.optInt("update_online_num");
                virtualNumUpdateData.update_pv = objData.optInt("update_pv");
                chatInfo.virtualNumUpdateData = virtualNumUpdateData;
                break;
            }
        }
        if (!TextUtils.isEmpty((CharSequence)chatInfo.avatar) && !chatInfo.avatar.startsWith("http")) {
            chatInfo.avatar = String.format("https:%s", chatInfo.avatar);
        }
        if (!TextUtils.isEmpty((CharSequence)chatInfo.event)) {
            this.chatCallback.onChatMessageReceived(chatInfo);
            this.isChat = true;
        } else {
            this.isChat = false;
        }
    }

    private void setMessageInfo(MessageData msg, JSONObject objData, JSONObject objCon, boolean filterOther) {
        MessageServer.MsgInfo messageInfo = new MessageServer.MsgInfo();
        String targetId = "";
        String roomJoinId = "";
        String senderId = "";
        String nickName = "";
        String roleName = "2";
        messageInfo.mOriginData = objData;
        if (msg != null) {
            messageInfo.responseImMessageInfo = msg.getImMessageInfo();
            if (msg.getImMessageInfo() != null) {
                messageInfo.msg_id = msg.getImMessageInfo().getMsg_id();
            }
        }
        if (objData != null) {
            targetId = objData.optString("target_id");
            roomJoinId = objData.optString("room_join_id");
            senderId = objData.optString("sender_id");
            roleName = objData.optString("room_role");
            if (TextUtils.isEmpty((CharSequence)roleName)) {
                roleName = objData.optString("role_name", "2");
            }
            nickName = objData.optString("nick_name");
            messageInfo.roomJoinId = roomJoinId;
            messageInfo.role = roleName;
            messageInfo.targetId = targetId;
            messageInfo.nick_name = nickName;
            messageInfo.senderId = senderId;
        } else {
            objData = new JSONObject();
        }
        switch (msg.getType()) {
            case "live_start": {
                messageInfo.event = 33;
                break;
            }
            case "live_over": {
                messageInfo.event = 0;
                messageInfo.webinar_id = this.webinarInfo.webinar_id;
                break;
            }
            case "room_kickout": {
                if (TextUtils.isEmpty((CharSequence)targetId) || !this.webinarInfo.user_id.equals(targetId)) break;
                messageInfo.event = 1;
                LogReportManager.doReport("115017");
                break;
            }
            case "room_kickout_cancel": {
                messageInfo.event = 2;
                break;
            }
            case "disable": {
                if (!this.isFilterOther(filterOther, targetId)) break;
                messageInfo.event = 3;
                this.webinarInfo.chatforbid = true;
                this.webinarInfo.chatOwnForbid = true;
                if (this.webinarInfoChangeCallBack == null) break;
                this.webinarInfoChangeCallBack.dataChange(this.webinarInfo);
                break;
            }
            case "permit": {
                if (TextUtils.equals((CharSequence)"customPraiseTotal", (CharSequence)objData.optString("event_type"))) {
                    messageInfo.event = 105;
                    messageInfo.likeNum = objData.optInt("num");
                    List<IMessageCallBack> messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey("key_like");
                    if (messageCallBackByKey == null || messageCallBackByKey.size() <= 0) break;
                    for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                        if (!(iMessageCallBack instanceof LikeMessageCallBack)) continue;
                        ((LikeMessageCallBack)iMessageCallBack).likeSend(messageInfo);
                    }
                    break;
                }
                if (!this.isFilterOther(filterOther, targetId)) break;
                messageInfo.event = 4;
                this.webinarInfo.chatforbid = this.webinarInfo.chatAllForbid;
                this.webinarInfo.chatOwnForbid = false;
                if (this.webinarInfoChangeCallBack == null) break;
                this.webinarInfoChangeCallBack.dataChange(this.webinarInfo);
                break;
            }
            case "disable_all": {
                messageInfo.event = 34;
                messageInfo.status = 1;
                this.webinarInfo.chatforbid = true;
                this.webinarInfo.chatAllForbid = true;
                messageInfo.chat_status = objData.optString("chat_status");
                messageInfo.qa_status = objData.optString("qa_status");
                this.webinarInfo.private_chat_status = messageInfo.private_chat_status = objData.optString("private_chat_status");
                this.webinarInfo.qa_status = messageInfo.qa_status;
                this.webinarInfo.chat_status = messageInfo.chat_status;
                if (this.webinarInfoChangeCallBack == null) break;
                this.webinarInfoChangeCallBack.dataChange(this.webinarInfo);
                break;
            }
            case "permit_all": {
                messageInfo.event = 34;
                messageInfo.status = 0;
                this.webinarInfo.chatforbid = this.webinarInfo.chatOwnForbid;
                this.webinarInfo.chatAllForbid = false;
                messageInfo.chat_status = objData.optString("chat_status");
                messageInfo.qa_status = objData.optString("qa_status");
                this.webinarInfo.private_chat_status = messageInfo.private_chat_status = objData.optString("private_chat_status");
                this.webinarInfo.qa_status = messageInfo.qa_status;
                this.webinarInfo.chat_status = messageInfo.chat_status;
                if (this.webinarInfoChangeCallBack == null) break;
                this.webinarInfoChangeCallBack.dataChange(this.webinarInfo);
                break;
            }
            case "chat_delete": {
                messageInfo.event = 121;
                messageInfo.msg_id_delete = objData.optString("msg_id");
                break;
            }
            case "room_announcement": {
                messageInfo.event = 9;
                VssMessageAnnouncementData announcementData = (VssMessageAnnouncementData)msg.getT();
                messageInfo.content = announcementData.getRoom_announcement_text();
                messageInfo.publish_release_time = announcementData.getPush_time();
                messageInfo.duration = announcementData.getDuration();
                List<IMessageCallBack> messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey("key_notice");
                if (messageCallBackByKey == null || messageCallBackByKey.size() <= 0) break;
                for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                    if (!(iMessageCallBack instanceof NoticeMessageCallBack)) continue;
                    ((NoticeMessageCallBack)iMessageCallBack).noticeSend(messageInfo);
                }
                break;
            }
            case "sign_in_push": {
                messageInfo.event = 16;
                VssMessageSignData vssMessageSignData = (VssMessageSignData)msg.getT();
                messageInfo.webinar_id = this.webinarInfo.webinar_id;
                messageInfo.id = vssMessageSignData.getSign_id();
                messageInfo.signTitle = vssMessageSignData.getTitle();
                messageInfo.user_id = vssMessageSignData.getSign_creator_id();
                messageInfo.sign_show_time = vssMessageSignData.getSign_show_time();
                messageInfo.nick_name = vssMessageSignData.getSign_creator_nickname();
                List<IMessageCallBack> messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey("key_sign");
                if (messageCallBackByKey == null || messageCallBackByKey.size() <= 0) break;
                for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                    if (!(iMessageCallBack instanceof SignMessageCallBack)) continue;
                    ((SignMessageCallBack)iMessageCallBack).signSend(messageInfo);
                }
                LogReportManager.doReport("115032");
                break;
            }
            case "sign_end": {
                messageInfo.event = 120;
                List<IMessageCallBack> messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey("key_sign");
                if (messageCallBackByKey == null || messageCallBackByKey.size() <= 0) break;
                for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                    if (!(iMessageCallBack instanceof SignMessageCallBack)) continue;
                    ((SignMessageCallBack)iMessageCallBack).signSend(messageInfo);
                }
                break;
            }
            case "question_answer_open": {
                messageInfo.event = 17;
                messageInfo.status = 1;
                messageInfo.question_name = objData.optString("name");
                this.webinarInfo.question_status = messageInfo.status;
                if (this.webinarInfoChangeCallBack != null) {
                    this.webinarInfoChangeCallBack.dataChange(this.webinarInfo);
                }
                LogReportManager.doReport("115030");
                break;
            }
            case "question_answer_close": {
                messageInfo.event = 17;
                messageInfo.status = 0;
                messageInfo.question_name = objData.optString("name");
                this.webinarInfo.question_status = messageInfo.status;
                if (this.webinarInfoChangeCallBack == null) break;
                this.webinarInfoChangeCallBack.dataChange(this.webinarInfo);
                break;
            }
            case "questionnaire_push": {
                messageInfo.event = 18;
                messageInfo.id = objData.optString("questionnaire_id");
                messageInfo.survey_name = objData.optString("alias");
                messageInfo.webinar_id = this.webinarInfo.webinar_id;
                messageInfo.user_id = this.webinarInfo.user_id;
                List<IMessageCallBack> messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey("key_survey");
                if (messageCallBackByKey == null || messageCallBackByKey.size() <= 0) break;
                for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                    if (!(iMessageCallBack instanceof SurveyMessageCallBack)) continue;
                    ((SurveyMessageCallBack)iMessageCallBack).questionAnswerSend(messageInfo);
                }
                LogReportManager.doReport("115033");
                break;
            }
            case "question_answer_set": {
                messageInfo.event = 85;
                messageInfo.question_name = objData.optString("name");
                messageInfo.webinar_id = this.webinarInfo.webinar_id;
                break;
            }
            case "questionanswer_push": {
                messageInfo.event = 84;
                messageInfo.id = objData.optString("surveyid");
                messageInfo.webinar_id = this.webinarInfo.webinar_id;
                messageInfo.user_id = objData.optString("accountid");
                LogReportManager.doReport("115020");
                break;
            }
            case "vrtc_connect_open": {
                messageInfo.event = 48;
                messageInfo.status = 1;
                break;
            }
            case "vrtc_connect_close": {
                messageInfo.event = 48;
                messageInfo.status = 0;
                break;
            }
            case "vrtc_connect_apply": {
                messageInfo.user_id = targetId;
                messageInfo.event = 49;
                messageInfo.role = roleName;
                messageInfo.status = 1;
                messageInfo.nick_name = nickName;
                break;
            }
            case "vrtc_connect_apply_cancel": {
                messageInfo.user_id = targetId;
                messageInfo.event = 49;
                messageInfo.role = roleName;
                messageInfo.status = 0;
                messageInfo.nick_name = nickName;
                break;
            }
            case "vrtc_speaker_switch": {
                messageInfo.user_id = targetId;
                messageInfo.event = 57;
                messageInfo.role = roleName;
                messageInfo.nick_name = nickName;
                if (null == this.webinarInfoChangeCallBack) break;
                this.webinarInfoChangeCallBack.onVRtcSpeakerSwitch(messageInfo.user_id);
                break;
            }
            case "vrtc_connect_refused": {
                messageInfo.user_id = targetId;
                messageInfo.event = 80;
                messageInfo.role = roleName;
                messageInfo.nick_name = nickName;
                break;
            }
            case "vrtc_connect_invite_refused": {
                messageInfo.user_id = targetId;
                messageInfo.event = 81;
                messageInfo.role = roleName;
                messageInfo.nick_name = nickName;
                messageInfo.inviter_account_id = objData.optString("inviter_account_id");
                break;
            }
            case "vrtc_connect_invite": {
                messageInfo.user_id = targetId;
                if (!targetId.equals(this.webinarInfo.user_id)) break;
                messageInfo.event = 53;
                messageInfo.role = roleName;
                messageInfo.nick_name = nickName;
                LogReportManager.doReport("115016");
                break;
            }
            case "vrtc_connect_agree": {
                messageInfo.user_id = targetId;
                if (!targetId.equals(this.webinarInfo.user_id)) break;
                messageInfo.event = 50;
                messageInfo.role = roleName;
                messageInfo.nick_name = nickName;
                break;
            }
            case "vrtc_connect_invite_agree": {
                messageInfo.event = 56;
                break;
            }
            case "vrtc_connect_success": {
                messageInfo.event = 54;
                break;
            }
            case "vrtc_disconnect_success": {
                if (!this.isFilterOther(filterOther, targetId)) break;
                messageInfo.user_id = targetId;
                messageInfo.event = 51;
                messageInfo.role = roleName;
                messageInfo.nick_name = nickName;
                break;
            }
            case "vrtc_mute_all": {
                messageInfo.user_id = targetId;
                messageInfo.event = 52;
                messageInfo.status = 0;
                messageInfo.device = 1;
                break;
            }
            case "vrtc_mute_all_cancel": {
                messageInfo.user_id = targetId;
                messageInfo.event = 52;
                messageInfo.status = 1;
                messageInfo.device = 1;
                break;
            }
            case "vrtc_mute": {
                messageInfo.user_id = targetId;
                if (!this.isFilterOther(filterOther, targetId)) break;
                messageInfo.event = 52;
                messageInfo.status = 0;
                messageInfo.device = 1;
                break;
            }
            case "vrtc_mute_cancel": {
                messageInfo.user_id = targetId;
                if (!this.isFilterOther(filterOther, targetId)) break;
                messageInfo.event = 52;
                messageInfo.status = 1;
                messageInfo.device = 1;
                break;
            }
            case "vrtc_frames_forbid": {
                messageInfo.user_id = targetId;
                if (!this.isFilterOther(filterOther, targetId)) break;
                messageInfo.event = 52;
                messageInfo.device = 2;
                messageInfo.status = 0;
                break;
            }
            case "vrtc_frames_display": {
                messageInfo.user_id = targetId;
                if (!this.isFilterOther(filterOther, targetId)) break;
                messageInfo.event = 52;
                messageInfo.status = 1;
                messageInfo.device = 2;
                break;
            }
            case "lottery_push": {
                MessageServer.LotteryInfo lotteryInfo;
                messageInfo.event = 7;
                messageInfo.user_id = targetId;
                if (msg.getT() instanceof VssMessageLotteryData) {
                    VssMessageLotteryData vssMessageLotteryData = (VssMessageLotteryData)msg.getT();
                    messageInfo.id = vssMessageLotteryData.getLottery_id();
                    lotteryInfo = new MessageServer.LotteryInfo();
                    lotteryInfo.command = "";
                    lotteryInfo.need_take_award = 0;
                    lotteryInfo.remark = "";
                    lotteryInfo.title = "";
                    lotteryInfo.icon = "https://cnstatic01.e.vhall.com/vhall-new-saas/static/img/lottery-loading.1a55817.gif";
                    lotteryInfo.is_new = 0;
                    lotteryInfo.room_id = vssMessageLotteryData.getRoom_id();
                    lotteryInfo.lottery_id = vssMessageLotteryData.getLottery_id();
                    lotteryInfo.lottery_type = vssMessageLotteryData.getLottery_type();
                    lotteryInfo.lottery_status = vssMessageLotteryData.getLottery_status();
                    messageInfo.lotteryInfo = lotteryInfo;
                } else if (msg.getT() instanceof MessageLotteryData) {
                    MessageLotteryData messageLotteryData = (MessageLotteryData)msg.getT();
                    messageInfo.id = messageLotteryData.getLottery_id();
                    lotteryInfo = new MessageServer.LotteryInfo();
                    lotteryInfo.command = messageLotteryData.command;
                    lotteryInfo.need_take_award = messageLotteryData.need_take_award;
                    lotteryInfo.remark = messageLotteryData.remark;
                    lotteryInfo.title = messageLotteryData.title;
                    lotteryInfo.icon = messageLotteryData.icon;
                    lotteryInfo.is_new = messageLotteryData.is_new;
                    lotteryInfo.room_id = messageLotteryData.getRoom_id();
                    lotteryInfo.lottery_id = messageLotteryData.getLottery_id();
                    lotteryInfo.lottery_type = messageLotteryData.getLottery_type();
                    lotteryInfo.lottery_status = messageLotteryData.getLottery_status();
                    if (messageLotteryData.award_snapshoot != null) {
                        MessageServer.LotteryInfo.Award award = new MessageServer.LotteryInfo.Award();
                        award.id = messageLotteryData.award_snapshoot.id;
                        award.app_id = messageLotteryData.award_snapshoot.app_id;
                        award.business_uid = messageLotteryData.award_snapshoot.business_uid;
                        award.source_id = messageLotteryData.award_snapshoot.source_id;
                        award.award_name = messageLotteryData.award_snapshoot.award_name;
                        award.image_url = messageLotteryData.award_snapshoot.image_url;
                        award.award_desc = messageLotteryData.award_snapshoot.award_desc;
                        award.link_url = messageLotteryData.award_snapshoot.link_url;
                        award.created_at = messageLotteryData.award_snapshoot.created_at;
                        lotteryInfo.award = award;
                    }
                    messageInfo.lotteryInfo = lotteryInfo;
                    LogReportManager.doReport("115031");
                }
                List<IMessageCallBack> messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey("key_lottery");
                if (messageCallBackByKey == null || messageCallBackByKey.size() <= 0) break;
                for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                    if (!(iMessageCallBack instanceof LotteryMessageCallBack)) continue;
                    ((LotteryMessageCallBack)iMessageCallBack).startLottery(messageInfo);
                }
                break;
            }
            case "lottery_result_notice": {
                MessageServer.LotteryInfo lotteryInfo;
                messageInfo.event = 8;
                messageInfo.user_id = targetId;
                if (msg.getT() instanceof VssMessageLotteryData) {
                    VssMessageLotteryData vssMessageLotteryEnd = (VssMessageLotteryData)msg.getT();
                    messageInfo.id = vssMessageLotteryEnd.getLottery_id();
                    lotteryInfo = new MessageServer.LotteryInfo();
                    lotteryInfo.command = "";
                    lotteryInfo.need_take_award = 0;
                    lotteryInfo.remark = "";
                    lotteryInfo.title = "";
                    lotteryInfo.icon = "https://cnstatic01.e.vhall.com/vhall-new-saas/static/img/lottery-loading.1a55817.gif";
                    lotteryInfo.is_new = 0;
                    lotteryInfo.room_id = vssMessageLotteryEnd.getRoom_id();
                    lotteryInfo.lottery_id = vssMessageLotteryEnd.getLottery_id();
                    lotteryInfo.lottery_type = vssMessageLotteryEnd.getLottery_type();
                    lotteryInfo.lottery_status = vssMessageLotteryEnd.getLottery_status();
                    messageInfo.lotteryInfo = lotteryInfo;
                    ArrayList<MessageServer.Lottery> lotteries = new ArrayList<MessageServer.Lottery>();
                    List<VssMessageLotteryData.LotteryWinnersBean> lottery_winners = vssMessageLotteryEnd.getLottery_winners();
                    if (lottery_winners != null && lottery_winners.size() > 0) {
                        for (VssMessageLotteryData.LotteryWinnersBean lottery_winner : lottery_winners) {
                            MessageServer.Lottery e = new MessageServer.Lottery();
                            e.id = lottery_winner.getLottery_user_id();
                            e.lottery_id = lottery_winner.getLottery_id();
                            e.nick_name = lottery_winner.getLottery_user_nickname();
                            e.lottery_user_avatar = lottery_winner.getLottery_user_avatar();
                            e.isSelf = TextUtils.equals((CharSequence)lottery_winner.getLottery_user_id(), (CharSequence)this.webinarInfo.user_id);
                            if (e.isSelf) {
                                messageInfo.winnerLottery = true;
                            }
                            lotteries.add(e);
                        }
                    }
                    messageInfo.lotteries = lotteries;
                } else if (msg.getT() instanceof MessageLotteryData) {
                    MessageLotteryData messageLotteryEnd = (MessageLotteryData)msg.getT();
                    messageInfo.id = messageLotteryEnd.getLottery_id();
                    lotteryInfo = new MessageServer.LotteryInfo();
                    lotteryInfo.command = messageLotteryEnd.command;
                    lotteryInfo.title = messageLotteryEnd.title;
                    lotteryInfo.remark = messageLotteryEnd.remark;
                    lotteryInfo.icon = messageLotteryEnd.icon;
                    lotteryInfo.is_new = messageLotteryEnd.is_new;
                    lotteryInfo.room_id = messageLotteryEnd.getRoom_id();
                    lotteryInfo.lottery_id = messageLotteryEnd.getLottery_id();
                    lotteryInfo.lottery_type = messageLotteryEnd.getLottery_type();
                    lotteryInfo.lottery_status = messageLotteryEnd.getLottery_status();
                    lotteryInfo.publish_winner = messageLotteryEnd.publish_winner;
                    lotteryInfo.need_take_award = messageLotteryEnd.need_take_award;
                    messageInfo.winnerLottery = messageLotteryEnd.isWinner;
                    if (messageLotteryEnd.award_snapshoot != null) {
                        MessageServer.LotteryInfo.Award award = new MessageServer.LotteryInfo.Award();
                        award.id = messageLotteryEnd.award_snapshoot.id;
                        award.app_id = messageLotteryEnd.award_snapshoot.app_id;
                        award.business_uid = messageLotteryEnd.award_snapshoot.business_uid;
                        award.source_id = messageLotteryEnd.award_snapshoot.source_id;
                        award.award_name = messageLotteryEnd.award_snapshoot.award_name;
                        award.image_url = messageLotteryEnd.award_snapshoot.image_url;
                        award.award_desc = messageLotteryEnd.award_snapshoot.award_desc;
                        award.link_url = messageLotteryEnd.award_snapshoot.link_url;
                        award.created_at = messageLotteryEnd.award_snapshoot.created_at;
                        lotteryInfo.award = award;
                    }
                    messageInfo.lotteryInfo = lotteryInfo;
                }
                List<IMessageCallBack> messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey("key_lottery");
                if (messageCallBackByKey == null || messageCallBackByKey.size() <= 0) break;
                for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                    if (!(iMessageCallBack instanceof LotteryMessageCallBack)) continue;
                    ((LotteryMessageCallBack)iMessageCallBack).endLottery(messageInfo);
                }
                break;
            }
            case "edit_webinar_role_name": {
                messageInfo.event = 82;
                messageInfo.edit_role_name = objData.optString("name");
                messageInfo.edit_role_type = objData.optString("role_type");
                break;
            }
            case "director_stream": {
                messageInfo.event = 96;
                messageInfo.director_stream_status = objData.optString("status");
                break;
            }
            case "vrtc_big_screen_set": {
                messageInfo.user_id = targetId;
                messageInfo.event = 83;
                messageInfo.role = roleName;
                messageInfo.nick_name = nickName;
                break;
            }
            case "video_round_start": {
                messageInfo.event = 97;
                break;
            }
            case "video_round_end": {
                messageInfo.event = 99;
                break;
            }
            case "video_round_users": {
                messageInfo.event = 98;
                JSONArray uidJsonArray = objData.optJSONArray("uids");
                if (uidJsonArray == null) break;
                messageInfo.uids = new ArrayList<String>();
                for (int i = 0; i < uidJsonArray.length(); ++i) {
                    messageInfo.uids.add(uidJsonArray.optString(i));
                }
                break;
            }
            case "timer_start": {
                messageInfo.event = 100;
                MessageServer.TimerData timerData = new MessageServer.TimerData();
                timerData.duration = objData.optString("duration");
                timerData.remain_time = Integer.parseInt(timerData.duration);
                timerData.is_all_show = objData.optString("is_all_show");
                timerData.is_timeout = objData.optString("is_timeout");
                messageInfo.timerData = timerData;
                break;
            }
            case "timer_reset": {
                messageInfo.event = 102;
                MessageServer.TimerData timerDataReset = new MessageServer.TimerData();
                timerDataReset.duration = objData.optString("duration");
                timerDataReset.remain_time = Integer.parseInt(timerDataReset.duration);
                timerDataReset.is_all_show = objData.optString("is_all_show");
                timerDataReset.is_timeout = objData.optString("is_timeout");
                messageInfo.timerData = timerDataReset;
                break;
            }
            case "timer_resume": {
                messageInfo.event = 103;
                MessageServer.TimerData timerDataResume = new MessageServer.TimerData();
                timerDataResume.duration = objData.optString("duration");
                timerDataResume.is_all_show = objData.optString("is_all_show");
                timerDataResume.is_timeout = objData.optString("is_timeout");
                timerDataResume.remain_time = objData.optInt("remain_time");
                messageInfo.timerData = timerDataResume;
                break;
            }
            case "timer_end": {
                messageInfo.event = 101;
                break;
            }
            case "service_custom": {
                if (TextUtils.equals((CharSequence)"timer_pause", (CharSequence)objData.optString("type"))) {
                    messageInfo.event = 104;
                    MessageServer.TimerData timerDataPause = new MessageServer.TimerData();
                    timerDataPause.remain_time = objData.optInt("remain_time");
                    messageInfo.timerData = timerDataPause;
                    break;
                }
                if (TextUtils.equals((CharSequence)"data_download_update", (CharSequence)objData.optString("type"))) {
                    messageInfo.event = 128;
                    MenuListInfoData.MenuItem menu = new MenuListInfoData.MenuItem();
                    menu.id = objData.optString("menu_id");
                    menu.name = objData.optString("name");
                    menu.type = 9;
                    messageInfo.status = menu.status = objData.optInt("status");
                    messageInfo.file_download_menu = menu;
                    break;
                }
                if (TextUtils.equals((CharSequence)"push_goods_change", (CharSequence)objData.optString("type"))) {
                    messageInfo.event = 132;
                    messageInfo.goodsInfo = new GoodsInfoData.GoodsInfo(objData.optJSONObject("goods_info"));
                    messageInfo.role = objData.optString("role_name");
                    messageInfo.nick_name = objData.optString("pusher_nickname");
                    List<IMessageCallBack> messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey("key_goods");
                    if (messageCallBackByKey == null || messageCallBackByKey.size() <= 0) break;
                    for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                        if (!(iMessageCallBack instanceof GoodsMessageCallBack)) continue;
                        ((GoodsMessageCallBack)iMessageCallBack).pushGoodsCard(messageInfo, messageInfo.goodsInfo.push_status);
                    }
                    break;
                }
                if (TextUtils.equals((CharSequence)"goods_update_info", (CharSequence)objData.optString("type"))) {
                    messageInfo.event = 133;
                    messageInfo.goodsInfo = new GoodsInfoData.GoodsInfo(objData.optJSONObject("goods_info"));
                    messageInfo.goodsInfo.cdn_url = objData.optString("cdn_url");
                    messageInfo.goodsInfo.action = objData.optInt("action");
                    List<IMessageCallBack> messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey("key_goods");
                    if (messageCallBackByKey == null || messageCallBackByKey.size() <= 0) break;
                    for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                        if (!(iMessageCallBack instanceof GoodsMessageCallBack)) continue;
                        switch (messageInfo.goodsInfo.action) {
                            case 1: {
                                ((GoodsMessageCallBack)iMessageCallBack).addGoodsInfo(messageInfo.goodsInfo, messageInfo.goodsInfo.cdn_url);
                                break;
                            }
                            case 2: {
                                ((GoodsMessageCallBack)iMessageCallBack).updateGoodsInfo(messageInfo.goodsInfo, messageInfo.goodsInfo.cdn_url);
                                break;
                            }
                            case 4: {
                                ((GoodsMessageCallBack)iMessageCallBack).updateGoodsList(messageInfo.goodsInfo.cdn_url);
                                break;
                            }
                            case 3: {
                                JSONArray jsonArray = objData.optJSONArray("del_goods_ids");
                                messageInfo.goodsInfo.del_goods_ids = new ArrayList<String>();
                                try {
                                    for (int i = 0; i < jsonArray.length(); ++i) {
                                        messageInfo.goodsInfo.del_goods_ids.add(jsonArray.get(i).toString());
                                    }
                                }
                                catch (JSONException e) {
                                    throw new RuntimeException(e);
                                }
                                ((GoodsMessageCallBack)iMessageCallBack).deleteGoods(messageInfo.goodsInfo.del_goods_ids, messageInfo.goodsInfo.cdn_url);
                            }
                        }
                    }
                    break;
                }
                if (!TextUtils.equals((CharSequence)"order_status_change", (CharSequence)objData.optString("type"))) break;
                messageInfo.event = 134;
                messageInfo.orderInfo = new OrderInfoData(objData);
                List<IMessageCallBack> messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey("key_goods");
                if (messageCallBackByKey == null || messageCallBackByKey.size() <= 0) break;
                for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                    if (!(iMessageCallBack instanceof GoodsMessageCallBack)) continue;
                    ((GoodsMessageCallBack)iMessageCallBack).orderStatusChange(messageInfo.orderInfo);
                }
                break;
            }
            case "gift_send_success": {
                messageInfo.event = 112;
                MessageServer.GiftInfoData giftInfoData = new MessageServer.GiftInfoData();
                giftInfoData.gift_user_id = objData.optString("gift_user_id");
                giftInfoData.gift_user_nickname = objData.optString("gift_user_nickname");
                giftInfoData.gift_user_avatar = objData.optString("gift_user_avatar");
                giftInfoData.gift_name = objData.optString("gift_name");
                giftInfoData.gift_id = objData.optString("gift_id");
                giftInfoData.gift_price = objData.optString("gift_price");
                giftInfoData.gift_image_url = objData.optString("gift_image_url");
                giftInfoData.gift_receiver_id = objData.optString("gift_receiver_id");
                giftInfoData.gift_creator_id = objData.optString("gift_creator_id");
                giftInfoData.source_status = objData.optString("source_status");
                messageInfo.giftInfoData = giftInfoData;
                List<IMessageCallBack> messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey("key_gift");
                if (messageCallBackByKey == null || messageCallBackByKey.size() <= 0) break;
                for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                    if (!(iMessageCallBack instanceof GiftMessageCallBack)) continue;
                    ((GiftMessageCallBack)iMessageCallBack).giftSend(messageInfo);
                }
                break;
            }
            case "live_start_rehearsal": {
                messageInfo.event = 113;
                LogReportManager.doReport("115025");
                break;
            }
            case "live_over_rehearsal": {
                messageInfo.event = 114;
                break;
            }
            case "push_screen_card": {
                try {
                    messageInfo.event = 129;
                    messageInfo.cardInfo = new CardsInfoData.CardInfo(objData.getJSONObject("card_info"));
                    messageInfo.role = messageInfo.cardInfo.role_name;
                    messageInfo.edit_role_name = messageInfo.cardInfo.operator;
                    List<IMessageCallBack> messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey("key_card");
                    if (messageCallBackByKey == null || messageCallBackByKey.size() <= 0) break;
                    for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                        if (!(iMessageCallBack instanceof CardMessageCallBack)) continue;
                        ((CardMessageCallBack)iMessageCallBack).cardSend(messageInfo);
                    }
                    break;
                }
                catch (JSONException jSONException) {
                    break;
                }
            }
            case "push_screen_card_delete": {
                messageInfo.event = 130;
                messageInfo.card_delete_ids = objData.optString("ids");
                List<IMessageCallBack> messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey("key_card");
                if (messageCallBackByKey == null || messageCallBackByKey.size() <= 0) break;
                for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                    if (!(iMessageCallBack instanceof CardMessageCallBack)) continue;
                    ((CardMessageCallBack)iMessageCallBack).cardDelete(messageInfo);
                }
                break;
            }
            case "push_screen_card_update": {
                try {
                    messageInfo.event = 131;
                    messageInfo.cardInfo = new CardsInfoData.CardInfo(objData.getJSONObject("card_info"));
                    messageInfo.role = messageInfo.cardInfo.role_name;
                    messageInfo.edit_role_name = messageInfo.cardInfo.operator;
                    List<IMessageCallBack> messageCallBackByKey = NewH5ImManager.getInstance().getMessageCallBackByKey("key_card");
                    if (messageCallBackByKey == null || messageCallBackByKey.size() <= 0) break;
                    for (IMessageCallBack iMessageCallBack : messageCallBackByKey) {
                        if (!(iMessageCallBack instanceof CardMessageCallBack)) continue;
                        ((CardMessageCallBack)iMessageCallBack).cardUpdate(messageInfo);
                    }
                    break;
                }
                catch (JSONException jSONException) {
                    break;
                }
            }
            case "paper_send": 
            case "paper_end": 
            case "paper_auto_end": 
            case "paper_send_rank": 
            case "paper_auto_send_rank": {
                messageInfo = MessageDealUtils.dealPushExam(msg, NewH5ImManager.getInstance().getMessageCallBackByKey("key_exam"));
                break;
            }
        }
        if (this.webinarInfo != null) {
            messageInfo.webinar_id = this.webinarInfo.webinar_id;
        }
        if (messageInfo.event >= 0) {
            this.messageCallback.onEvent(messageInfo);
        } else {
            this.messageCallback.onEvent(messageInfo);
        }
    }

    private boolean isFilterOther(boolean filterOther, String targetId) {
        if (!filterOther) {
            return true;
        }
        return filterOther && !TextUtils.isEmpty((CharSequence)targetId) && TextUtils.equals((CharSequence)targetId, (CharSequence)this.webinarInfo.user_id);
    }

    private void dealLottery(Object data, MessageServer.MsgInfo messageInfo) {
    }

    String changeRoleToRoleName(String role) {
        String roleName;
        if (TextUtils.isEmpty((CharSequence)role)) {
            return "2";
        }
        switch (role) {
            case "1": 
            case "host": {
                roleName = "1";
                break;
            }
            case "3": 
            case "assistant": {
                roleName = "3";
                break;
            }
            case "4": 
            case "guest": {
                roleName = "4";
                break;
            }
            default: {
                roleName = "2";
            }
        }
        return roleName;
    }

    public static String changeRoleNameToRole(String roleName) {
        String role;
        if (TextUtils.isEmpty((CharSequence)roleName)) {
            return "user";
        }
        switch (roleName) {
            case "1": 
            case "host": {
                role = "host";
                break;
            }
            case "3": 
            case "assistant": {
                role = "assistant";
                break;
            }
            case "4": 
            case "guest": {
                role = "guest";
                break;
            }
            default: {
                role = "user";
            }
        }
        return role;
    }

    public static interface WebinarInfoChangeCallBack {
        public void dataChange(WebinarInfo var1);

        public void kickedOut();

        default public void onVRtcSpeakerSwitch(String mainId) {
        }
    }
}

