/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.vhall.business.ErrorCode;
import com.vhall.business.R;
import com.vhall.business.VhallCallback;
import com.vhall.business.VhallSDK;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.data.WebinarInfoRemoteDataSource;
import com.vhall.business.data.source.UserInfoRepository;
import com.vhall.business.data.source.WebinarInfoRepository;
import com.vhall.business.data.source.local.UserInfoLocalDataSource;
import com.vhall.business.data.source.remote.UserInfoRemoteDataSource;
import com.vhall.business.utils.LogManager;
import com.vhall.logmanager.VLog;
import java.io.Serializable;
import java.net.URLDecoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vhall.com.vss2.data.MessageData;

public final class ChatServer {
    private static final String TAG = "ChatServer";
    public static final String eventOnlineKey = "online";
    public static final String eventOfflineKey = "offline";
    public static final String eventMsgKey = "msg";
    public static final String eventCustomKey = "custom_broadcast";
    public static final String eventQuestion = "question";
    public static final String eventPayKey = "pay";
    public static final String eventFavsNum = "favs_num";
    public static final String eventVirtualUpdate = "base_num_update";
    private WebinarInfo webinarInfo;
    private Handler mDelivery = new Handler(Looper.getMainLooper());
    private Callback mCallback;
    private WebSocket ws;

    protected boolean isAvaliable() {
        return this.webinarInfo != null;
    }

    public void setWebinarInfo(WebinarInfo webinarInfo) {
        if (webinarInfo == null) {
            return;
        }
        this.webinarInfo = webinarInfo;
        this.connect();
    }

    private static SSLSocketFactory createSSLSocketFactory() {
        SSLSocketFactory ssfFactory = null;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{new TrustAllCerts()}, new SecureRandom());
            ssfFactory = sc.getSocketFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ssfFactory;
    }

    public void connect() {
        this.disconnect();
        if (this.webinarInfo == null || this.mCallback == null || TextUtils.isEmpty((CharSequence)this.webinarInfo.chat_server)) {
            return;
        }
        OkHttpClient mOkHttpClient = new OkHttpClient.Builder().sslSocketFactory(ChatServer.createSSLSocketFactory(), (X509TrustManager)new TrustAllCerts()).hostnameVerifier((HostnameVerifier)new TrustAllHostnameVerifier()).connectTimeout(0L, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).writeTimeout(0L, TimeUnit.MILLISECONDS).build();
        String url = this.webinarInfo.chat_server + "/ws/" + this.webinarInfo.webinar_id;
        Request wsRequest = new Request.Builder().url(url).build();
        this.ws = mOkHttpClient.newWebSocket(wsRequest, new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                super.onOpen(webSocket, response);
                LogManager.innerLog(ChatServer.TAG, "chatServer on Open");
                ChatServer.this.mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        ChatServer.this.mCallback.onChatServerConnected();
                    }
                });
            }

            public void onMessage(WebSocket webSocket, final String text) {
                super.onMessage(webSocket, text);
                LogManager.innerLog(ChatServer.TAG, "chatServer on Message");
                if (TextUtils.isEmpty((CharSequence)text) || ChatServer.this.mCallback == null) {
                    return;
                }
                ChatServer.this.mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            VLog.e((String)"onChatMessageReceived", (String)text);
                            JSONObject obj = new JSONObject(text);
                            ChatInfo chatInfo = ChatServer.getMessageInfo(obj, true);
                            if (chatInfo != null) {
                                if (chatInfo.questionData != null && chatInfo.questionData.answer != null) {
                                    if (chatInfo.questionData.answer.is_open == 1) {
                                        ChatServer.this.mCallback.onChatMessageReceived(chatInfo);
                                    } else if (chatInfo.questionData.join_id.equals(((ChatServer)ChatServer.this).webinarInfo.join_id)) {
                                        ChatServer.this.mCallback.onChatMessageReceived(chatInfo);
                                    }
                                } else {
                                    ChatServer.this.mCallback.onChatMessageReceived(chatInfo);
                                }
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                super.onMessage(webSocket, bytes);
                LogManager.innerLog(ChatServer.TAG, "chatServer on Message:bytes");
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                super.onClosing(webSocket, code, reason);
                LogManager.innerLog(ChatServer.TAG, "chatServer onClosing");
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                super.onClosed(webSocket, code, reason);
                LogManager.innerLog(ChatServer.TAG, "code:" + code + " reason:" + reason);
                ChatServer.this.mDelivery.post(new Runnable(){

                    @Override
                    public void run() {
                        ChatServer.this.mCallback.onChatServerClosed();
                    }
                });
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                super.onFailure(webSocket, t, response);
                if (!(t instanceof Exception)) {
                    return;
                }
                LogManager.innerLog(ChatServer.TAG, "ChatServer onFailure:" + t.getMessage());
                if (t.getMessage() != null && t.getMessage().equals("Socket closed")) {
                    ChatServer.this.mDelivery.post(new Runnable(){

                        @Override
                        public void run() {
                            ChatServer.this.mCallback.onChatServerClosed();
                        }
                    });
                } else {
                    ChatServer.this.mDelivery.post(new Runnable(){

                        @Override
                        public void run() {
                            ChatServer.this.mCallback.onConnectFailed();
                        }
                    });
                }
            }
        });
        mOkHttpClient.dispatcher().executorService().shutdown();
    }

    public void disconnect() {
        if (this.ws != null) {
            try {
                this.ws.close(1000, "closed by user");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.ws.cancel();
            this.ws = null;
        }
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public void sendChat(String content, final RequestCallback callback) {
        if (!this.isAvaliable() || TextUtils.isEmpty((CharSequence)this.webinarInfo.msg_token) || TextUtils.isEmpty((CharSequence)this.webinarInfo.publish_server)) {
            VhallCallback.ErrorCallback(callback, 20001, VhallSDK.mContext.getString(R.string.error_video_info_init));
            return;
        }
        String url = this.webinarInfo.publish_server;
        String token = this.webinarInfo.msg_token;
        UserInfoRepository userInfoRepository = UserInfoRepository.getInstance(UserInfoRemoteDataSource.getInstance(), UserInfoLocalDataSource.getInstance());
        userInfoRepository.sendChat(url, token, content, new RequestCallback(){

            @Override
            public void onSuccess() {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int errorCode, String reason) {
                VhallCallback.ErrorCallback(callback, errorCode, reason);
            }
        });
    }

    public void sendCustom(JSONObject content, final RequestCallback callback) {
        long newMillis = System.currentTimeMillis();
        if (!this.isAvaliable() || TextUtils.isEmpty((CharSequence)this.webinarInfo.msg_token) || TextUtils.isEmpty((CharSequence)this.webinarInfo.publish_server)) {
            VhallCallback.ErrorCallback(callback, 20001, VhallSDK.mContext.getString(R.string.error_video_info_init));
            return;
        }
        String url = this.webinarInfo.publish_server;
        String token = this.webinarInfo.msg_token;
        UserInfoRepository userInfoRepository = UserInfoRepository.getInstance(UserInfoRemoteDataSource.getInstance(), UserInfoLocalDataSource.getInstance());
        userInfoRepository.sendCustom(url, token, content, new RequestCallback(){

            @Override
            public void onSuccess() {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int errorCode, String reason) {
                VhallCallback.ErrorCallback(callback, errorCode, reason);
            }
        });
    }

    public void sendQuestion(String user_id, String content, final RequestCallback callback) {
        if (!this.isAvaliable() || TextUtils.isEmpty((CharSequence)user_id) || TextUtils.isEmpty((CharSequence)this.webinarInfo.webinar_id)) {
            VhallCallback.ErrorCallback(callback, 20001, "\u83b7\u53d6\u89c6\u9891\u4fe1\u606f\u5931\u8d25\uff01");
            return;
        }
        String webinar_id = this.webinarInfo.webinar_id;
        UserInfoRepository userInfoRepository = UserInfoRepository.getInstance(UserInfoRemoteDataSource.getInstance(), UserInfoLocalDataSource.getInstance());
        userInfoRepository.sendQuestion(user_id, webinar_id, content, new RequestCallback(){

            @Override
            public void onSuccess() {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int errorCode, String reason) {
                VhallCallback.ErrorCallback(callback, errorCode, reason);
            }
        });
    }

    public static ChatInfo getMessageInfo(JSONObject response, boolean text) {
        ChatInfo msgInfo = new ChatInfo();
        try {
            JSONObject obj = null;
            obj = text ? new JSONObject(URLDecoder.decode(response.optString("text"))) : response;
            if (obj == null) {
                return null;
            }
            if (obj.has("service_type")) {
                msgInfo.event = obj.optString("service_type");
                msgInfo.room = obj.optString("channel");
                msgInfo.time = obj.optString("date_time");
                switch (msgInfo.event) {
                    case "service_im": {
                        JSONObject context = new JSONObject(obj.optString("context"));
                        msgInfo.account_id = context.optString("account_id");
                        msgInfo.user_name = context.optString("user_name");
                        msgInfo.avatar = context.optString("avatar");
                        msgInfo.role = context.optString("role_name");
                        msgInfo.roleName = ChatServer.changeRoleToRoleName(msgInfo.role);
                        msgInfo.role = ChatServer.changeRoleNameToRole(msgInfo.roleName);
                        JSONObject data = new JSONObject(obj.optString("data"));
                        ChatInfo.ChatData msgData = new ChatInfo.ChatData();
                        switch (msgData.type = data.optString("type")) {
                            case "text": {
                                msgData.text = data.optString("text_content");
                                break;
                            }
                            case "image": {
                                JSONArray array = data.optJSONArray("image_urls");
                                if (array == null || array.length() <= 0) break;
                                msgData.resourceUrl = array.getString(0);
                            }
                        }
                        msgInfo.msgData = msgData;
                        msgInfo.event = eventMsgKey;
                        break;
                    }
                    case "service_custom": {
                        ChatInfo.ChatData customData = new ChatInfo.ChatData();
                        customData.text = obj.optString("data");
                        msgInfo.msgData = customData;
                        msgInfo.event = eventCustomKey;
                        break;
                    }
                }
            } else {
                msgInfo.account_id = obj.optString("account_id");
                msgInfo.user_name = obj.optString("user_name");
                msgInfo.avatar = obj.optString("avatar");
                msgInfo.event = obj.optString("event");
                msgInfo.room = obj.optString("room");
                msgInfo.time = obj.optString("time");
                msgInfo.role = obj.optString("role");
                msgInfo.roleName = ChatServer.changeRoleToRoleName(msgInfo.role);
                msgInfo.role = ChatServer.changeRoleNameToRole(msgInfo.roleName);
                JSONObject data = obj.optJSONObject("data");
                switch (msgInfo.event) {
                    case "msg": {
                        if (!text) {
                            ChatInfo.ChatData msgData = new ChatInfo.ChatData();
                            msgData.text = data.optString("text");
                            msgData.type = "text";
                            msgInfo.msgData = msgData;
                            break;
                        }
                        return null;
                    }
                    case "online": 
                    case "offline": {
                        ChatInfo.OnlineData onlineData = new ChatInfo.OnlineData();
                        onlineData.role = data.optString("role");
                        onlineData.roleName = ChatServer.changeRoleToRoleName(onlineData.role);
                        onlineData.role = ChatServer.changeRoleNameToRole(onlineData.roleName);
                        onlineData.concurrent_user = data.optInt("concurrent_user");
                        onlineData.is_gag = data.optInt("is_gag");
                        onlineData.attend_count = data.optInt("attend_count");
                        onlineData.tracksNum = data.optInt("tracksNum");
                        msgInfo.onlineData = onlineData;
                        msgInfo.role = onlineData.role;
                        msgInfo.roleName = onlineData.roleName;
                        break;
                    }
                    case "question": {
                        ChatInfo.QuestionData questionData = new ChatInfo.QuestionData();
                        questionData.id = data.optString("id");
                        questionData.nick_name = data.optString("nick_name");
                        questionData.content = data.optString("content");
                        questionData.join_id = data.optString("join_id");
                        questionData.created_at = data.optString("created_at");
                        questionData.role_name = data.optString("role_name");
                        questionData.roleName = ChatServer.changeRoleToRoleName(questionData.role_name);
                        questionData.is_open = data.optInt("is_open");
                        questionData.avatar = data.optString("avatar");
                        JSONObject answerObj = data.optJSONObject("answer");
                        if (answerObj != null) {
                            ChatInfo.QuestionData answerData = new ChatInfo.QuestionData();
                            answerData.id = answerObj.optString("id");
                            answerData.avatar = answerObj.optString("avatar");
                            answerData.nick_name = answerObj.optString("nick_name");
                            answerData.content = answerObj.optString("content");
                            answerData.join_id = answerObj.optString("join_id");
                            answerData.created_at = answerObj.optString("created_at");
                            answerData.role_name = answerObj.optString("role_name");
                            answerData.roleName = ChatServer.changeRoleToRoleName(answerData.role_name);
                            answerData.is_open = answerObj.optInt("is_open");
                            questionData.answer = answerData;
                        }
                        msgInfo.questionData = questionData;
                        break;
                    }
                    case "favs_num": {
                        ChatInfo.FavData fav = new ChatInfo.FavData();
                        fav.favs = data.optString("favs");
                        msgInfo.favData = fav;
                        break;
                    }
                    case "custom_broadcast": {
                        ChatInfo.ChatData msgData = new ChatInfo.ChatData();
                        msgData.text = obj.optString("data");
                        msgData.type = "text";
                        msgInfo.msgData = msgData;
                    }
                    default: {
                        msgInfo.unDifinedData = data != null ? data.toString() : obj.optString("data");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (!TextUtils.isEmpty((CharSequence)msgInfo.avatar) && !msgInfo.avatar.startsWith("http")) {
            msgInfo.avatar = String.format("https:%s", msgInfo.avatar);
        }
        return msgInfo;
    }

    public static String changeRoleToRoleName(String role) {
        String roleName = "";
        switch (role) {
            case "1": 
            case "host": {
                roleName = "1";
                break;
            }
            case "2": 
            case "user": {
                roleName = "2";
                break;
            }
            case "3": 
            case "assistant": {
                roleName = "3";
                break;
            }
            case "4": 
            case "guest": {
                roleName = "4";
            }
        }
        return roleName;
    }

    public static String changeRoleNameToRole(String roleName) {
        String role = "";
        switch (roleName) {
            case "1": 
            case "host": {
                role = "host";
                break;
            }
            case "2": 
            case "user": {
                role = "user";
                break;
            }
            case "3": 
            case "assistant": {
                role = "assistant";
                break;
            }
            case "4": 
            case "guest": {
                role = "guest";
            }
        }
        return role;
    }

    public void acquireChatRecord(boolean show_all, final ChatRecordCallback chatRecordCallback) {
        if (chatRecordCallback == null) {
            throw new IllegalArgumentException(ErrorCode.CALLBACK_ERROR_STR);
        }
        if (!this.isAvaliable() || TextUtils.isEmpty((CharSequence)this.webinarInfo.join_id) || TextUtils.isEmpty((CharSequence)this.webinarInfo.webinar_id)) {
            chatRecordCallback.onFailed(20001, "\u83b7\u53d6\u89c6\u9891\u4fe1\u606f\u5931\u8d25\uff01");
            return;
        }
        WebinarInfoRepository webinarInfoRepository = WebinarInfoRepository.getInstance(WebinarInfoRemoteDataSource.getInstance());
        webinarInfoRepository.getChatHistory(this.webinarInfo.join_id, this.webinarInfo.webinar_id, show_all, new ChatRecordCallback(){

            @Override
            public void onDataLoaded(List<ChatInfo> list) {
                chatRecordCallback.onDataLoaded(list);
            }

            @Override
            public void onFailed(int errorcode, String messaage) {
                chatRecordCallback.onFailed(errorcode, messaage);
            }
        });
    }

    public static interface Callback {
        public void onChatServerConnected();

        public void onConnectFailed();

        public void onChatMessageReceived(ChatInfo var1);

        public void onChatServerClosed();

        public void onChatServerKickOff();
    }

    private static class TrustAllCerts
    implements X509TrustManager {
        private TrustAllCerts() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class TrustAllHostnameVerifier
    implements HostnameVerifier {
        private TrustAllHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    public static class ChatInfo
    implements Serializable {
        public String account_id;
        public String third_account_id;
        public String user_name;
        public String avatar;
        public String room;
        public String event;
        public String time;
        public String role;
        public String roleName;
        public String id;
        public String name;
        public String url;
        public ChatData msgData;
        public OnlineData onlineData;
        public QuestionData questionData;
        public String unDifinedData;
        public FavData favData;
        public ReplyMsg replyMsg;
        private MessageData messageData;
        public JSONObject mOriginData;
        public String msg_id;
        public VirtualNumUpdateData virtualNumUpdateData;
        public List<AtListBean> atList;

        public MessageData getMessageData() {
            return this.messageData;
        }

        public void setMessageData(MessageData messageData) {
            this.messageData = messageData;
        }

        public static class FavData {
            public String favs;
        }

        public static class QuestionData {
            public String id;
            public String nick_name;
            public String content;
            public String join_id;
            public String created_at;
            public String created_time;
            public String role_name = "user";
            public String roleName = "2";
            public int is_open;
            public String avatar;
            public String type;
            public QuestionData answer;
        }

        public static class VirtualNumUpdateData {
            public int update_online_num;
            public int update_pv;
        }

        public static class OnlineData {
            public String role;
            public String roleName;
            public int concurrent_user;
            public int is_gag;
            public int attend_count;
            public int tracksNum;
        }

        public static class ChatData {
            public String text;
            public String type;
            public String resourceUrl;
            public String target_id;
            public List<String> imageUrls = new ArrayList<String>();
        }

        public static class AtListBean {
            public String nickName;
            public String accountId;
            public int index;
        }

        public static class ReplyMsg {
            public String type;
            public String avatar;
            public String account_id;
            public String user_name;
            public String role;
            public String roleName;
            public Content content;
            public String time;

            public static class Content {
                public String type;
                public String textContent;
            }
        }
    }

    public static interface ChatRecordCallback {
        public void onDataLoaded(List<ChatInfo> var1);

        public void onFailed(int var1, String var2);
    }

    public static class DefCallback
    implements Callback {
        @Override
        public void onChatServerConnected() {
        }

        @Override
        public void onConnectFailed() {
        }

        @Override
        public void onChatMessageReceived(ChatInfo chatInfo) {
        }

        @Override
        public void onChatServerClosed() {
        }

        @Override
        public void onChatServerKickOff() {
        }
    }
}

