/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.business;

import android.content.Context;
import android.text.TextUtils;
import com.vhall.business.ChatServer;
import com.vhall.business.ErrorCode;
import com.vhall.business.MessageServer;
import com.vhall.business.Push;
import com.vhall.business.R;
import com.vhall.business.VhallSDK;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.lss_v2.push.IVHV2Pusher;
import com.vhall.lss_v2.push.VHV2PusherFactory;
import com.vhall.player.VHPlayerListener;
import com.vhall.push.VHAudioCapture;
import com.vhall.push.VHLivePushConfig;
import com.vhall.push.VHVideoCaptureView;
import org.json.JSONObject;

public class Broadcast
extends Push {
    private static final String TAG = "Broadcast";
    private int RECONNECT;
    private int currentTimes;
    private VHPlayerListener listener;
    private Push mVhallPushLive;

    @Override
    public void setWebinarInfo(WebinarInfo webinarInfo) {
        this.initPush(webinarInfo);
    }

    private void initPush(WebinarInfo webinarInfo) {
        if (webinarInfo == null || this.mVhallPushLive != null) {
            if (this.listener != null) {
                this.listener.onError(20001, 20001, "error webinarInfo");
            }
            return;
        }
        if (webinarInfo.no_delay_webinar == 1) {
            if (this.listener != null) {
                this.listener.onError(20026, 20026, ErrorCode.ERROR_MSG_NO_DELAY);
            }
            return;
        }
        if (this.isBuilderV2 && webinarInfo.is_new_version != 3) {
            if (this.listener != null) {
                this.listener.onError(20028, 20028, "is_new_version is not 3");
            }
            return;
        }
        this.webinarInfo = webinarInfo;
        Push.Builder pushBuilder = new Push.Builder();
        pushBuilder.cameraView(this.videoCapture).audioCapture(this.mAudioCapture).callback(this.listener).chatCallback(this.chatCallback).messageCallback(this.messageCallback).config(this.config).stream(this.streamOnly).isBuildV2(this.isBuilderV2).setContext(this.mContext).setInteractiveV2(this.vhLivePusherV2).setLicenseKey(this.licenseKey).setLicenseUrl(this.licenseUrl).denoise(this.denoise);
        String type = webinarInfo.is_new_version == 3 ? "6" : (TextUtils.isEmpty((CharSequence)webinarInfo.vss_token) ? "flash" : "h5");
        this.mVhallPushLive = pushBuilder.buildPush(type);
        if (this.mVhallPushLive != null) {
            this.mVhallPushLive.setWebinarInfo(webinarInfo);
        }
    }

    public Broadcast(Builder builder) {
        this.currentTimes = this.RECONNECT = 1;
        this.isBuilderV2 = builder.isBuilderV2;
        this.streamOnly = builder.streamOnly;
        this.mContext = builder.mContext;
        this.config = builder.config;
        this.vhLivePusherV2 = builder.vhInteractiveV2;
        this.denoise = builder.denoise;
        this.chatCallback = builder.chatCallback;
        this.licenseUrl = builder.licenseUrl;
        this.licenseKey = builder.licenseKey;
        this.messageCallback = builder.messageCallback;
        this.videoCapture = builder.videoCapture;
        this.mAudioCapture = builder.audioCapture;
        if (builder.config.pushReconnectTimes > 0) {
            this.RECONNECT = builder.config.pushReconnectTimes;
        }
        this.listener = builder.listener;
        if (!builder.isBuilderV2 && this.videoCapture != null) {
            this.videoCapture.init(this.config);
        }
    }

    @Override
    public void destroy() {
        if (this.videoCapture != null) {
            this.videoCapture.releaseCapture();
        }
        if (this.vhLivePusherV2 != null) {
            this.vhLivePusherV2.release();
            this.vhLivePusherV2 = null;
        }
        if (this.mVhallPushLive != null) {
            this.mVhallPushLive.destroy();
            LogReportManager.doReport("115009");
        }
    }

    @Override
    public void start(boolean rehearsal, RequestCallback callback) {
        if (this.webinarInfo == null && this.listener != null) {
            this.listener.onError(20102, 0, VhallSDK.mContext.getString(R.string.error_video_msg_init));
        }
        if (this.mVhallPushLive != null) {
            this.mVhallPushLive.start(rehearsal, callback);
        }
    }

    @Override
    public boolean pushStream(RequestCallback callback) {
        if (this.mVhallPushLive != null) {
            return this.mVhallPushLive.pushStream(callback);
        }
        return false;
    }

    @Override
    public void start(RequestCallback callback) {
        if (this.webinarInfo == null && this.listener != null) {
            this.listener.onError(20102, 0, VhallSDK.mContext.getString(R.string.error_video_msg_init));
        }
        if (this.mVhallPushLive != null) {
            this.mVhallPushLive.start(callback);
            LogReportManager.doReport("115004");
        }
    }

    @Override
    public void stop() {
        if (this.mVhallPushLive != null) {
            this.mVhallPushLive.stop();
            LogReportManager.doReport("115005");
        }
    }

    @Override
    public void sendChat(String content, RequestCallback callback) {
        if (!this.isAvaliable()) {
            if (callback != null) {
                callback.onError(20001, VhallSDK.mContext.getString(R.string.error_msg_init));
            }
            return;
        }
        if (this.mVhallPushLive != null) {
            this.mVhallPushLive.sendChat(content, callback);
        }
    }

    @Override
    public void sendCustom(JSONObject content, RequestCallback callback) {
        if (this.mVhallPushLive != null) {
            this.mVhallPushLive.sendCustom(content, callback);
        }
    }

    @Override
    public void connectChatServer() {
        if (this.mVhallPushLive != null) {
            this.mVhallPushLive.connectChatServer();
        }
    }

    @Override
    public void disconnectChatServer() {
        if (this.mVhallPushLive != null) {
            this.mVhallPushLive.disconnectChatServer();
        }
    }

    @Override
    public void acquireChatRecord(boolean show_all, ChatServer.ChatRecordCallback chatRecordCallback) {
        if (this.mVhallPushLive != null) {
            this.mVhallPushLive.acquireChatRecord(show_all, chatRecordCallback);
        }
    }

    @Override
    public void acquireChatRecord(int page, int limit, String msgId, String anchor_path, String is_role, ChatServer.ChatRecordCallback chatRecordCallback) {
        if (this.mVhallPushLive != null) {
            this.mVhallPushLive.acquireChatRecord(page, limit, msgId, anchor_path, is_role, chatRecordCallback);
        }
    }

    @Override
    public int PushAACDataTs(byte[] data, int size, int type, long timestamp) {
        if (this.mVhallPushLive != null) {
            this.mVhallPushLive.PushAACDataTs(data, size, type, timestamp);
        }
        return -1;
    }

    @Override
    public int PushH264DataTs(byte[] data, int size, int type, long timestamp) {
        if (this.mVhallPushLive != null) {
            return this.mVhallPushLive.PushH264DataTs(data, size, type, timestamp);
        }
        return -1;
    }

    @Override
    public int setVolumeAmplificateSize(float size) {
        if (this.mVhallPushLive != null) {
            return this.mVhallPushLive.setVolumeAmplificateSize(size);
        }
        return -1;
    }

    public static class Builder {
        VHVideoCaptureView videoCapture;
        IVHV2Pusher vhInteractiveV2;
        VHAudioCapture audioCapture;
        VHPlayerListener listener;
        VHLivePushConfig config;
        ChatServer.Callback chatCallback;
        MessageServer.Callback messageCallback;
        Context mContext;
        String licenseUrl;
        String licenseKey;
        boolean streamOnly;
        boolean denoise = true;
        boolean isBuilderV2 = false;

        public Builder stream(boolean streamOnly) {
            this.streamOnly = streamOnly;
            return this;
        }

        public Builder denoise(boolean denoise) {
            this.denoise = denoise;
            return this;
        }

        public Builder isBuildV2(boolean v2) {
            this.isBuilderV2 = v2;
            return this;
        }

        public Builder cameraView(VHVideoCaptureView videoCapture) {
            this.videoCapture = videoCapture;
            return this;
        }

        public Builder setLicenseUrl(String url) {
            this.licenseUrl = url;
            return this;
        }

        public Builder setLicenseKey(String key) {
            this.licenseKey = key;
            return this;
        }

        public Builder audioCapture(VHAudioCapture audioCapture) {
            this.audioCapture = audioCapture;
            return this;
        }

        public Builder config(VHLivePushConfig config) {
            this.config = config;
            return this;
        }

        public Builder callback(VHPlayerListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder chatCallback(ChatServer.Callback chatCallback) {
            this.chatCallback = chatCallback;
            return this;
        }

        public Builder messageCallback(MessageServer.Callback messageCallback) {
            this.messageCallback = messageCallback;
            return this;
        }

        public Builder setContext(Context context) {
            this.mContext = context;
            return this;
        }

        public Builder setInteractiveV2(IVHV2Pusher interactive) {
            this.vhInteractiveV2 = interactive;
            return this;
        }

        public Broadcast build() {
            if (!(this.streamOnly || this.videoCapture != null && this.videoCapture.getActivity() != null)) {
                throw new IllegalArgumentException("init CameraView first...");
            }
            if (this.listener == null) {
                throw new IllegalArgumentException("Broadcast callback should not be null...");
            }
            if (this.config == null) {
                throw new IllegalArgumentException("PushConfig should not be null...");
            }
            if (this.mContext == null) {
                throw new IllegalArgumentException("mContext should not be null...");
            }
            if (this.audioCapture == null) {
                this.audioCapture = new VHAudioCapture();
            }
            if (this.isBuilderV2 && this.vhInteractiveV2 == null) {
                this.vhInteractiveV2 = VHV2PusherFactory.newPusher((Context)this.mContext, (int)1);
            }
            LogReportManager.doReport("115003");
            return new Broadcast(this);
        }
    }
}

