package vhall.com.vss2.net;

import com.vhall.httpclient.core.IVHNetCallback;
import com.vhall.httpclient.core.VHNetResponse;

import vhall.com.vss2.CallBack;
import vhall.com.vss2.data.ResponseJe;
import vhall.com.vss2.utils.exception.ApiException;
import vhall.com.vss2.utils.exception.CustomException;

/**
 * @author cyl
 */
public class VssNetCallback<T> implements IVHNetCallback {
    private CallBack callback;

    private Class<T> clz;

    public VssNetCallback(CallBack callback) {
        this.callback = callback;
    }

    public VssNetCallback(CallBack callback, Class<T> clz) {
        this.callback = callback;
        this.clz = clz;
    }

    @Override
    public void onFailure(VHNetResponse response, Exception e) {
        if (callback != null) {
            ApiException exception = CustomException.handleException(response.getResponseCode(), e);
            callback.onError(exception.getCode(), exception.getMessage());
        }
    }

    @Override
    public void response(VHNetResponse response) {
        if (callback != null && response != null) {
            ResponseJe data = new ResponseJe(response.getResult(), clz);
            if (data.getCode() != 200) {
                callback.onError(data.getCode(), data.getMsg());
                return;
            }
            if (null != clz) {
                callback.onSuccess(data.getData());
            } else {
                callback.onSuccess(response.getResult());
            }

        }
    }
}
