package vhall.com.vss2.module.rtc;

import android.text.TextUtils;
import android.util.Log;

import com.vhall.httpclient.api.VHNetApi;
import com.vhall.httpclient.core.IVHRequest;
import com.vhall.logmanager.VLog;

import java.util.HashMap;

import vhall.com.vss2.CallBack;
import vhall.com.vss2.VssSdk;
import vhall.com.vss2.api.VssApiConstant;
import vhall.com.vss2.module.role.VssRoleManager;
import vhall.com.vss2.net.VssNetCallback;
import vhall.com.vss2.utils.rxutils.BasePresenter;

/**
 * @author hkl
 * Date: 2019-06-25 17:14
 */
public class VssRtcManager extends BasePresenter {

    private static String TAG = "VssRtcManager";
    private volatile static VssRtcManager instance;

    public static VssRtcManager getInstance() {
        if (roomInfo == null) {
            VLog.e(TAG, "room data error");
        }
        if (instance == null) {
            synchronized (VssRtcManager.class) {
                if (instance == null) {
                    instance = new VssRtcManager();
                }
            }
        }
        return instance;
    }

    /**
     * 设置自己设备开关状态
     *
     * @param device   1麦克风，2摄像头
     * @param status   0关闭1打开
     * @param callBack 回掉
     */
    public void setDeviceStatus(String device, String status, CallBack callBack) {
        setDeviceStatus(device, status, "", callBack);
    }

    /**
     * 设置别人设备开关状态
     *
     * @param device   1麦克风，2摄像头
     * @param status   0关闭1打开
     * @param userId   为空则直接操作自己的
     * @param callBack 回掉
     */
    public void setDeviceStatus(String device, String status, String userId, CallBack callBack) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 5);
        params.put(VssApiConstant.KEY_DEVICE, device);
        params.put(VssApiConstant.KEY_STATUS, status);
        if (TextUtils.isEmpty(userId)) {
            params.put(VssApiConstant.KEY_RECEIVE_ACCOUNT_ID, roomInfo.getThird_party_user_id());
            if (!VssRoleManager.getInstance().canOpenCameraVoice()) {
                if (callBack != null) {
                    callBack.onError(VssRoleManager.VSS_ROLE_ERROR_CODE, "没有开关自己的音视频权限");
                }
                VLog.e(TAG, "没有开关自己的音视频权限");
                return;
            }
        } else {
            if (!VssRoleManager.getInstance().canChangeOtherVoiceCamera()) {
                if (callBack != null) {
                    callBack.onError(VssRoleManager.VSS_ROLE_ERROR_CODE, "没有开关别人的音视频权限");
                }
                VLog.e(TAG, "没有开关别人的音视频权限");
                return;
            }
            params.put(VssApiConstant.KEY_RECEIVE_ACCOUNT_ID, userId);
        }

        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_SET_DEVICE_STATUS)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 设置观看端布局/清晰度
     *
     * @param definition 清晰度
     * @param layout     布局
     * @param callBack   callBack
     */
    public void setStream(String layout, String definition, CallBack callBack) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 4);
        params.put(VssApiConstant.KEY_LAYOUT, layout);
        params.put(VssApiConstant.KEY_DEFINITION, definition);

        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_SET_STREAM)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 用户申请上麦
     */
    public void apply(CallBack callBack) {
        if (!VssRoleManager.getInstance().canApplySpeak()) {
            if (callBack != null) {
                callBack.onError(VssRoleManager.VSS_ROLE_ERROR_CODE, "没有申请上麦权限");
            }
            VLog.e(TAG, "没有申请上麦权限");
            return;
        }

        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 2);
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_APPLY)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 拒绝上麦邀请
     */
    public void rejectInvite(CallBack callBack) {
        if (!VssRoleManager.getInstance().canOperateInviteSpeak()) {
            if (callBack != null) {
                callBack.onError(VssRoleManager.VSS_ROLE_ERROR_CODE, "没有操控别人上麦控制权限");
            }
            VLog.e(TAG, "没有操控别人上麦控制权限");
            return;
        }
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 4);
        params.put(VssApiConstant.KEY_ACCOUNT_ID, roomInfo.getThird_party_user_id());
        params.put(VssApiConstant.KEY_RECEIVE_ACCOUNT_ID, String.valueOf(roomInfo.getAccount_id()));
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_REJECT_INVITE)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 用户取消申请上麦
     */
    public void cancelApply(CallBack callBack) {

        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 3);
        params.put(VssApiConstant.KEY_ACCOUNT_ID, roomInfo.getThird_party_user_id());
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_CANCEL_APPLY)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 同意上麦邀请
     */
    public void agreeInvite(CallBack callBack) {
        if (!VssRoleManager.getInstance().canOperateInviteSpeak()) {
            if (callBack != null) {
                callBack.onError(VssRoleManager.VSS_ROLE_ERROR_CODE, "没有操控别人上麦控制权限");
            }
            VLog.e(TAG, "没有操控别人上麦控制权限");
            return;
        }
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 4);
        params.put("receive_account_id", String.valueOf(roomInfo.getAccount_id()));
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_AGREE_INVITE)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }


    /**
     * 用户下麦
     * id为空代表自己 不为空代表 下麦他人
     */
    public void unpublish(String id, CallBack callBack) {

        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 3);
        if (TextUtils.isEmpty(id)) {
            if (!VssRoleManager.getInstance().canOnSpeak()) {
                if (callBack != null) {
                    callBack.onError(VssRoleManager.VSS_ROLE_ERROR_CODE, "没有下麦控制权限");
                }
                VLog.e(TAG, "没有下麦控制权限");
                return;
            }
            params.put(VssApiConstant.KEY_RECEIVE_ACCOUNT_ID,(roomInfo == null)? VssSdk.getInstance().getUserId():roomInfo.getThird_party_user_id());
        } else {
            if (!VssRoleManager.getInstance().canOperateOtherOnSpeak()) {
                if (callBack != null) {
                    callBack.onError(VssRoleManager.VSS_ROLE_ERROR_CODE, "没有下麦他人控制权限");
                }
                VLog.e(TAG, "没有下麦他人控制权限");
                return;
            }
            params.put(VssApiConstant.KEY_RECEIVE_ACCOUNT_ID, id);
        }
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_NOSPEAK)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 同意用户上麦申请
     * <p>
     * receiver 接受者用户id
     */
    public void agreeApply(String userId, CallBack callBack) {

        if (!VssRoleManager.getInstance().canOperateInviteSpeak()) {
            if (callBack != null) {
                callBack.onError(VssRoleManager.VSS_ROLE_ERROR_CODE, "没有同意上麦控制权限");
            }
            VLog.e(TAG, "没有同意上麦控制权限");
            return;
        }
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 3);
        params.put("receive_account_id", userId);
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_AGREE_APPLY)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 拒绝用户上麦申请
     */
    public void rejectApply(String userId, CallBack callBack) {
        if (!VssRoleManager.getInstance().canOperateInviteSpeak()) {
            if (callBack != null) {
                callBack.onError(VssRoleManager.VSS_ROLE_ERROR_CODE, "没有拒绝用户上麦申请控制权限");
            }
            VLog.e(TAG, "没有拒绝用户上麦申请控制权限");
            return;
        }
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 4);
        params.put("receive_account_id", userId);
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_REJECT_APPLY)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 设置观众申请上麦许可（举手）
     * status 1允许0禁止
     */
    public void setHandsUp(String status, CallBack callBack) {
        if (!VssRoleManager.getInstance().canRaiseHandSwitch()) {
            if (callBack != null) {
                callBack.onError(VssRoleManager.VSS_ROLE_ERROR_CODE, "没有设置举手控制权限");
            }
            VLog.e(TAG, "没有设置举手控制权限");
            return;
        }
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 3);
        params.put(VssApiConstant.KEY_STATUS, status);
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_SET_HANDSUP)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 邀请用户上麦
     */
    public void invite(String receiveJoinId, CallBack callBack) {
        if (!VssRoleManager.getInstance().canInviteSpeak()) {
            if (callBack != null) {
                callBack.onError(VssRoleManager.VSS_ROLE_ERROR_CODE, "没有邀请用户上麦控制权限");
            }
            VLog.e(TAG, "没有邀请用户上麦控制权限");
            return;
        }
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 4);
        params.put("receive_account_id", receiveJoinId);
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_INVITE)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 用户上麦
     */
    public void publish(CallBack callBack) {
        if (instance == null) {
            return;
        }
        HashMap<String, String> params = instance.getDefaultParam(vssToken, roomId, 3);
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_SPEAK)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }


    /**
     * 禁言/取消禁言
     * status 操作，1禁言0恢复
     */
    public void setBanned(String receiveJoinId, String status, CallBack callBack) {
        if (!VssRoleManager.getInstance().canChatBanned()) {
            if (callBack != null) {
                callBack.onError(VssRoleManager.VSS_ROLE_ERROR_CODE, "没有禁言或取消禁言控制权限");
            }
            VLog.e(TAG, "没有禁言或取消禁言控制权限");
            return;
        }
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 4);
        params.put("receive_account_id", receiveJoinId);
        params.put(VssApiConstant.KEY_STATUS, status);
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_SET_BANNED)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

}
