package vhall.com.vss2.module.room;

import static com.vhall.beautify.type.VHBeautifyCode.CODE_INIT_SUCCESS;


import android.text.TextUtils;
import android.util.Log;

import com.vhall.beautify.IVHBeautifyInitListener;
import com.vhall.beautify.VHBeautifyKit;
import com.vhall.business.core.VHEventManager;
import com.vhall.framework.VhallBaseSDK;
import com.vhall.framework.VhallSDK;
import com.vhall.framework.connect.VhallConnectService;
import com.vhall.httpclient.api.VHNetApi;
import com.vhall.httpclient.core.IVHNetCallback;
import com.vhall.httpclient.core.IVHRequest;
import com.vhall.httpclient.core.VHNetResponse;
import com.vhall.ims.VHIM;
import com.vhall.logmanager.L;
import com.vhall.logmanager.VLog;
import com.vhall.message.ConnectServer;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import vhall.com.vss2.CallBack;
import vhall.com.vss2.VssSdk;
import vhall.com.vss2.api.VssApiConstant;
import vhall.com.vss2.data.MessageData;
import vhall.com.vss2.data.ResponseAttributes;
import vhall.com.vss2.data.ResponseChatInfo;
import vhall.com.vss2.data.ResponseImMessageInfo;
import vhall.com.vss2.data.ResponseJe;
import vhall.com.vss2.data.ResponsePushInfo;
import vhall.com.vss2.data.ResponseRoomInfo;
import vhall.com.vss2.data.ResponseScrollingInfo;
import vhall.com.vss2.data.ResponseUserStatus;
import vhall.com.vss2.data.UserInfoData;
import vhall.com.vss2.data.VssMessageAnnouncementData;
import vhall.com.vss2.data.VssMessageChatData;
import vhall.com.vss2.data.VssMessageLotteryData;
import vhall.com.vss2.data.VssMessageQuestionData;
import vhall.com.vss2.data.VssMessageSignData;
import vhall.com.vss2.module.role.VssRoleManager;
import vhall.com.vss2.module.room.callback.IVssCallBackListener;
import vhall.com.vss2.module.room.callback.IVssMessageListener;
import vhall.com.vss2.net.VssNetCallback;
import vhall.com.vss2.utils.VHJSON;
import vhall.com.vss2.utils.exception.ApiException;
import vhall.com.vss2.utils.exception.CustomException;
import vhall.com.vss2.utils.rxutils.BasePresenter;

/**
 * @author hkl
 * Date: 2019-06-26 14:05
 */
class RoomPresenter extends BasePresenter implements IRoomPresenter {
    private VHIM im;
    private final String TAG = "RoomPresenter";
    private IVssCallBackListener vssCallBackLister;
    private List<IVssMessageListener> messageListerList = new ArrayList<>();

    public ResponseRoomInfo getInfo() {
        return roomInfo;
    }

    /**
     * 房间 获取房间信息
     */
    private void getRoomInfo(String vssToken, String roomId, final CallBack<ResponseRoomInfo> callBack) {
       HashMap<String, String> bodyParams = getDefaultParam(vssToken, roomId, 2);

        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(bodyParams)
                .setUrl(createVssUrl(VssApiConstant.VSS_ROOM_GET)).build();
        VHNetApi.getNetApi().doPost(request, new IVHNetCallback() {
            @Override
            public void onFailure(VHNetResponse response, Exception e) {
                if (callBack != null) {
                    ApiException exception = CustomException.handleException(response.getResponseCode(), e);
                    callBack.onError(exception.getCode(), exception.getMessage());
                }
            }

            @Override
            public void response(VHNetResponse response) {
                if (response != null && !TextUtils.isEmpty(response.getResult())) {
                    ResponseJe responseJe = new ResponseJe(response.getResult(), ResponseRoomInfo.class);
                    if (responseJe.getCode() != 200) {
                        if (callBack != null) {
                            callBack.onError(responseJe.getCode(), responseJe.getMsg());
                        }
                        return;
                    }
                    roomInfo = (ResponseRoomInfo) responseJe.getData();
                    if (roomInfo == null) {
                        if (callBack != null) {
                            callBack.onError(-1, "房间信息加载失败");
                        }
                        return;
                    }

                    UserInfoData userInfo = VHJSON.parseObject(VhallSDK.getInstance().getmUserInfo(), UserInfoData.class);
                    if (userInfo == null) {
                        userInfo = new UserInfoData();
                        userInfo.setAvatar(VssSdk.getInstance().getAvatar());
                        userInfo.setNick_name(VssSdk.getInstance().getNickName());
                        userInfo.setNickname(VssSdk.getInstance().getNickName());
                    }
                    userInfo.setThird_party_user_id(roomInfo.getThird_party_user_id());
                    userInfo.setRole_name(roomInfo.getRole_name());
                    userInfo.setDevice_type("3");
                    userInfo.setDevice_status("1");
                    final UserInfoData finalUserInfo = userInfo;
                    final UserInfoData finalUserInfo1 = userInfo;
                    getAttributes(new CallBack<ResponseAttributes>() {
                        @Override
                        public void onSuccess(ResponseAttributes result) {
                            if (roomInfo == null) {
                                if (callBack != null) {
                                    callBack.onError(-1, "房间信息加载失败");
                                }
                                return;
                            }
                            roomInfo.setAttributes(result);
                            getUserStatus(new CallBack<ResponseUserStatus>() {
                                @Override
                                public void onSuccess(ResponseUserStatus result) {
                                    if (roomInfo == null) {
                                        if (callBack != null) {
                                            callBack.onError(-1, "房间信息加载失败");
                                        }
                                        return;
                                    }
                                    if (result == null) {
                                        VssSdk.getInstance().setUserInfo(finalUserInfo);
                                        callBack.onSuccess(roomInfo);
                                        return;
                                    }
                                    roomInfo.setUserStatus(result);
                                    finalUserInfo.setIs_banned(result.getIs_banned());
                                    VssSdk.getInstance().setUserInfo(finalUserInfo);
                                    callBack.onSuccess(roomInfo);
                                }

                                @Override
                                public void onError(int eventCode, String msg) {
                                    if (roomInfo == null) {
                                        if (callBack != null) {
                                            callBack.onError(-1, "房间信息加载失败");
                                        }
                                        return;
                                    }
                                    roomInfo.setUserStatus(new ResponseUserStatus());
                                    finalUserInfo.setIs_banned("0");
                                    VssSdk.getInstance().setUserInfo(finalUserInfo);
                                    callBack.onSuccess(roomInfo);
                                }
                            });
                        }

                        @Override
                        public void onError(int eventCode, String msg) {
                            if (roomInfo == null) {
                                if (callBack != null) {
                                    callBack.onError(-1, "房间信息加载失败");
                                }
                                return;
                            }
                            roomInfo.setAttributes(new ResponseAttributes());
                            getUserStatus(new CallBack<ResponseUserStatus>() {
                                @Override
                                public void onSuccess(ResponseUserStatus result) {
                                    if (roomInfo == null) {
                                        if (callBack != null) {
                                            callBack.onError(-1, "房间信息加载失败");
                                        }
                                        return;
                                    }
                                    if (result == null) {
                                        VssSdk.getInstance().setUserInfo(finalUserInfo1);
                                        callBack.onSuccess(roomInfo);
                                        return;
                                    }
                                    roomInfo.setUserStatus(result);
                                    finalUserInfo1.setIs_banned(result.getIs_banned());
                                    VssSdk.getInstance().setUserInfo(finalUserInfo1);
                                    callBack.onSuccess(roomInfo);
                                }

                                @Override
                                public void onError(int eventCode, String msg) {
                                    if (roomInfo == null) {
                                        if (callBack != null) {
                                            callBack.onError(-1, "房间信息加载失败");
                                        }
                                        return;
                                    }
                                    roomInfo.setUserStatus(new ResponseUserStatus());
                                    finalUserInfo1.setIs_banned("0");
                                    VssSdk.getInstance().setUserInfo(finalUserInfo1);
                                    callBack.onSuccess(roomInfo);
                                }
                            });
                        }
                    });
                } else {
                    if (callBack != null) {
                        callBack.onError(-1, "room data error");
                    }
                }
            }
        });

    }

    /**
     * 房间 获取推流信息
     */
    public void roomGetPushInfo(String status, CallBack<ResponsePushInfo> callBack) {
        if (TextUtils.isEmpty(vssToken) || TextUtils.isEmpty(roomId)) {
            if (callBack != null) {
                callBack.onError(-1, "NO enter room");
            }
            return;
        }
        HashMap<String, String> bodyParams = getDefaultParam(vssToken, roomId, 2);

        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(bodyParams)
                .setUrl(createVssUrl(VssApiConstant.VSS_ROOM_GET_PUSH_INFO)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack, ResponsePushInfo.class));
    }


    /**
     * 房间 开始直播
     */
    @Override
    public void roomStartLive(CallBack<String> callBack) {
        if (TextUtils.isEmpty(vssToken) || TextUtils.isEmpty(roomId)) {
            if (callBack != null) {
                callBack.onError(-1, "NO enter room");
            }
            return;
        }
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 2);
        params.put("start_type","3");
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_ROOM_START_LIVE)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 踢出/取消踢出
     *
     * @param status 操作，1踢出0恢复
     */
    @Override
    public void setKicked(String receiveJoinId, String status, CallBack callBack) {
        if (!VssRoleManager.getInstance().canChatKickOut()) {
            if (callBack != null) {
                callBack.onError(VssRoleManager.VSS_ROLE_ERROR_CODE, "没有踢出或取消踢出权限");
            }
            VLog.e(TAG, "没有踢出或取消踢出权限");
            return;
        }
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 4);
        params.put("receive_account_id", receiveJoinId);
        params.put(VssApiConstant.KEY_STATUS, status);
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_SET_KICKED)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 设置用户演示状态（主画面）
     */
    @Override
    public void setMainScreen(String receiveJoinId, String joinId, CallBack callBack) {

        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 4);
        params.put(VssApiConstant.KEY_RECEIVE_JOIN_ID, receiveJoinId);
        params.put(VssApiConstant.KEY_JOIN_ID, joinId);
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_SET_MAIN_SCREEN)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 设置文档白板权限
     */
    @Override
    public void setDocPermission(String receiveJoinId, String joinId, CallBack callBack) {
        if (!VssRoleManager.getInstance().canDocwhiteBoard()) {
            if (callBack != null) {
                callBack.onError(VssRoleManager.VSS_ROLE_ERROR_CODE, "没有设置文档白板权限权限");
            }
            return;
        }
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 4);

        params.put(VssApiConstant.KEY_RECEIVE_JOIN_ID, receiveJoinId);
        params.put(VssApiConstant.KEY_JOIN_ID, joinId);
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_SET_DOC_PERMISSION)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 发送公告
     *
     * @param content  内容
     * @param callBack callBack
     */
    @Override
    public void sendNotice(String content, CallBack callBack) {
        HashMap<String, String> params = getDefaultParam(null, roomId, 2);
        params.put(VssApiConstant.KEY_CONTENT, content);
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_SEND_NOTICE)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 获取用户状态
     */
    @Override
    public void getUserStatus(CallBack<ResponseUserStatus> callBack) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 3);
        params.put(VssApiConstant.KEY_ACCOUNT_ID, roomInfo.getThird_party_user_id());
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_GET_USER_STATUS)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack, ResponseUserStatus.class));
    }

    /**
     * 房间 结束直播
     */
    @Override
    public void roomEndLive(CallBack<String> callBack) {
        if (TextUtils.isEmpty(vssToken) || TextUtils.isEmpty(roomId)) {
            if (callBack != null) {
                callBack.onError(-1, "NO enter room");
            }
            return;
        }
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 2);
        params.put("end_type","3");
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_ROOM_END_LIVE)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));

    }

    /**
     * 房间 开启/关闭文档
     * status 1开启，0关闭
     */
    @Override
    public void roomSwitchDoc(String status, CallBack callBack) {
        if (!VssRoleManager.getInstance().canDocSwitch()) {
            if (callBack != null) {
                callBack.onError(VssRoleManager.VSS_ROLE_ERROR_CODE, "没有文档开关控制权限");
            }
            VLog.e(TAG, "没有文档开关控制权限");
            return;
        }
        if (TextUtils.isEmpty(vssToken) || TextUtils.isEmpty(roomId)) {
            callBack.onError(-1, "NO enter room");
            return;
        }

        HashMap<String, String> bodyParams = getDefaultParam(vssToken, roomId, 3);
        bodyParams.put(VssApiConstant.KEY_STATUS, status);
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(bodyParams)
                .setUrl(createVssUrl(VssApiConstant.VSS_ROOM_SWITCH_DOC)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    @Override
    public void leaveRoom() {
        if (im != null) {
            im.leave();
            im = null;
        }
        messageListerList.clear();
        roomInfo = null;
        vssToken = null;
        roomId = null;
    }


    @Override
    public void enterRoom(String vssToken1, String roomId1, final CallBack callBack) {
        if (TextUtils.isEmpty(vssToken1) || TextUtils.isEmpty(roomId1)) {
            if (callBack != null) {
                callBack.onError(-1, "data error");
            }
            return;
        }
        vssToken = vssToken1;
        roomId = roomId1;
        getRoomInfo(vssToken, roomId, new CallBack<ResponseRoomInfo>() {
            @Override
            public void onSuccess(ResponseRoomInfo result) {
                roomInfo = result;
                try{
                    VhallBaseSDK.getInstance().initBeautify(result.getPaas_access_token(), new IVHBeautifyInitListener() {
                        @Override
                        public void onSuccess() {
                            VHBeautifyKit.getInstance().setBeautifyEnable(true);
                            VLog.v("initBeautify", "onSuccess");
                            VHEventManager.share().notifyEvent( CODE_INIT_SUCCESS,"initBeautify onSuccess","",null);
                        }

                        @Override
                        public void onError(int i, String s) {
                            VLog.e("initBeautify", "onError  msg:   " + s);
                            VHEventManager.share().notifyEvent(i,s,"",null);
                        }
                    });
                }catch (IllegalStateException e){

                }
                if (im == null) {
                    im = new VHIM(result.getChannel_id(), result.getPaas_access_token());
                    im.setOnMessageListener(new MsgListener());
                    im.setOnConnectChangedListener(new VhallConnectService.OnConnectStateChangedListener() {
                        @Override
                        public void onStateChanged(ConnectServer.State state, int i) {
                            if (vssCallBackLister != null) {
                                vssCallBackLister.onStateChanged(state, i);
                            }
                        }
                    });
                    im.join();
                }
                // 要申请的权限 CAMERA, RECORD_AUDIO
                setDevice("1", "1", null);

                if (!VssRoleManager.getInstance().isOpenRole()) {
                    VssRoleManager.getInstance().getAccessList(roomInfo.getThird_party_user_id(), roomInfo.getRole_name(), new CallBack<List<Integer>>() {
                        @Override
                        public void onSuccess(List<Integer> result) {
                        }

                        @Override
                        public void onError(int eventCode, String msg) {
                            VLog.e(TAG, "getAccessList onError:   " + msg);
                        }
                    });
                }
                if (callBack != null) {
                    callBack.onSuccess(result);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (msg != null && msg.contains("Can not perform")) {
                    return;
                }
                if (callBack != null) {
                    callBack.onError(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void setVssCallBackLister(IVssCallBackListener listener) {
        if (im != null) {
            vssCallBackLister = listener;
        } else {
            VLog.e(TAG, "No enter room");
        }
    }

    @Override
    public void getScrollingInfo(CallBack<ResponseScrollingInfo> callBack) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 2);
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_SCROLLING_INFO)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack, ResponseScrollingInfo.class));
    }

    /**
     * 房间-获取属性状态
     */
    @Override
    public void getAttributes(CallBack<ResponseAttributes> callBack) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 2);
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_ROOM_GET_ATTRIBUTES)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack, ResponseAttributes.class));
    }

    /**
     * 设置设备检测结果
     *
     * @param status   设备检测状态，0未检测1可以上麦2不可以上麦
     * @param type     设备类型，0其它1手机端2PC
     * @param callBack callBack
     */
    public void setDevice(String status, String type, CallBack callBack) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 4);
        params.put(VssApiConstant.KEY_STATUS, status);
        params.put(VssApiConstant.KEY_TYPE, type);
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_SET_DEVICE)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * @param type VHIM.TYPE_IMAGE
     */
    @Override
    public void sendMsg(String msg, String type, final CallBack callBack) {
        if (TextUtils.isEmpty(type)) {
            type = VHIM.TYPE_TEXT;
        }
        if (im != null) {
            if (VHIM.TYPE_CUSTOM.equals(type)) {
                im.sendCustomMsg(msg, new VHIM.Callback() {
                    @Override
                    public void onSuccess() {
                        if (callBack != null) {
                            callBack.onSuccess(null);
                        }
                    }

                    @Override
                    public void onFailure(int i, String s) {
                        if (callBack != null) {
                            callBack.onError(i, s);
                        }
                    }
                });
                return;
            }
            im.sendMsg(msg, type, new VHIM.Callback() {
                @Override
                public void onSuccess() {
                    if (callBack != null) {
                        callBack.onSuccess(null);
                    }
                }

                @Override
                public void onFailure(int i, String s) {
                    if (callBack != null) {
                        callBack.onError(i, s);
                    }
                }
            });
        } else {
            if (callBack != null) {
                callBack.onError(-1, "初始化失败");
            }
        }
    }

    @Override
    public void sendImageMsg(String text, List<String> imageUrls, final CallBack callBack) {
        if (im != null) {
            im.sendImageText(text, imageUrls, new VHIM.Callback() {
                @Override
                public void onSuccess() {
                    if (callBack != null) {
                        callBack.onSuccess(null);
                    }
                }

                @Override
                public void onFailure(int i, String s) {
                    if (callBack == null) {
                        return;
                    }
                    callBack.onError(i, s);
                }
            });
        } else {
            if (callBack == null) {
                return;
            }
            callBack.onError(-1, "初始化失败");
        }
    }

    @Override
    public void setVssMessageListener(IVssMessageListener iVssMessageListener) {
        messageListerList.add(iVssMessageListener);
    }


    public void removeVssMessageListener(IVssMessageListener iVssMessageListener) {
        messageListerList.remove(iVssMessageListener);
    }

    class MsgListener implements VHIM.OnMessageListener {

        @Override
        public void onMessage(String msg) {
            //解析
            if (TextUtils.isEmpty(msg)) {
                return;
            }
            //VLog.e(TAG + "onMessage      ", msg);
            try {
                ResponseImMessageInfo responseImMessageInfo = VHJSON.parseObject(msg, ResponseImMessageInfo.class);
                if (TextUtils.isEmpty(responseImMessageInfo.getData()) || TextUtils.isEmpty(responseImMessageInfo.getService_type())) {
                    return;
                }
                dealMessage(responseImMessageInfo);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onChannelStatus(String s) {

        }

        private void sendMessage(String type, Object data, ResponseImMessageInfo responseImMessageInfo) {
            if (messageListerList != null && messageListerList.size() > 0) {
                for (IVssMessageListener iVssMessageListener : messageListerList) {
                    if (iVssMessageListener != null) {
                        iVssMessageListener.onMessage(new MessageData(type, data, responseImMessageInfo));
                    }
                }
            }
        }

        private void dealMessage(ResponseImMessageInfo responseImMessageInfo) {
            try {
                JSONObject objCon = null;
                if (!TextUtils.isEmpty(responseImMessageInfo.getContext())) {
                    objCon = new JSONObject(responseImMessageInfo.getContext());
                }
                // Log.e(TAG, responseImMessageInfo.getData());
                JSONObject objData;
                String type;
                try {
                    objData = new JSONObject(responseImMessageInfo.getData());
                    type = objData.optString("type");
                } catch (Exception e) {
                    objData = null;
                    type = "-1";
                }

                String id = "";
                switch (responseImMessageInfo.getService_type()) {
                    case MessageTypeData.MESSAGE_SERVICE_IM:
                        switch (type) {
                            case MessageTypeData.MESSAGE_SERVICE_IM_DISABLE:
                                id = objData.optString("target_id");
                                if (roomInfo != null && TextUtils.equals(roomInfo.getThird_party_user_id(), id)) {
                                    roomInfo.getUserStatus().setIs_banned("1");
                                }
                                sendMessage(type, null, responseImMessageInfo);
                                break;
                            case MessageTypeData.MESSAGE_SERVICE_IM_PERMIT:
                                id = objData.optString("target_id");
                                if (roomInfo != null && TextUtils.equals(roomInfo.getThird_party_user_id(), id)) {
                                    roomInfo.getUserStatus().setIs_banned("0");
                                }
                                sendMessage(type, null, responseImMessageInfo);
                                break;
                            case MessageTypeData.MESSAGE_SERVICE_IM_DISABLE_ALL:
                                if (roomInfo != null && TextUtils.equals(roomInfo.getThird_party_user_id(), id)) {
                                    roomInfo.getAttributes().setAll_banned("1");
                                }
                                sendMessage(type, null, responseImMessageInfo);
                                break;
                            case MessageTypeData.MESSAGE_SERVICE_IM_PERMIT_ALL:
                                if (roomInfo != null && TextUtils.equals(roomInfo.getThird_party_user_id(), id)) {
                                    roomInfo.getAttributes().setAll_banned("0");
                                }
                                sendMessage(type, null, responseImMessageInfo);
                                break;
                            case MessageTypeData.MESSAGE_SERVICE_IM_IMAGE:
                            case MessageTypeData.MESSAGE_SERVICE_IM_TEXT:
                                //聊天相关
                                VssMessageChatData chatData = new VssMessageChatData();
                                List<ResponseChatInfo.ContextBean.AtListBean> atList = new ArrayList<>();
                                if (objCon != null) {
                                    chatData.setAvatar(objCon.optString("avatar"));
                                    chatData.setRoom_id(objCon.optString("room_id"));
                                    chatData.setRoleName(objCon.optString("role_name"));
                                    if (!TextUtils.isEmpty(objCon.optString("nickname"))) {
                                        chatData.setNickname(objCon.optString("nickname"));
                                    }
                                    if (TextUtils.isEmpty(chatData.getNickname())) {
                                        chatData.setNickname(objCon.optString("nick_name"));
                                    }
                                    String replyMsg = objCon.optString("replyMsg").trim();
                                    if (TextUtils.isEmpty(replyMsg) || replyMsg.startsWith("[")) {
                                    } else if (replyMsg.startsWith("{")) {
                                        VssMessageChatData.ReplyMsgBean replyMsgBean = VHJSON.parseObject(replyMsg, VssMessageChatData.ReplyMsgBean.class);
                                        chatData.setReplyMsg(replyMsgBean);
                                    }
                                    JSONArray atListArray = objCon.optJSONArray("atList");
                                    if (atListArray != null && atListArray.length() > 0) {
                                        atList = VHJSON.parseObject(atListArray.toString(), new ArrayList<ResponseChatInfo.ContextBean.AtListBean>() {
                                        }.getClass());
                                        chatData.setAtlist(atList);
                                    }
                                }
                                JSONArray image_urls = objData.optJSONArray("image_urls");
                                if (image_urls != null) {
                                    List<String> urls = new ArrayList<>();
                                    for (int i = 0; i < image_urls.length(); i++) {
                                        urls.add(image_urls.get(i).toString());
                                    }
                                    chatData.setImage_urls(urls);
                                }
                                chatData.setTime(responseImMessageInfo.getDate_time());
                                chatData.setType(type);
                                String textContent = objData.optString("text_content");
                                if (atList.size() > 0) {
                                    for (ResponseChatInfo.ContextBean.AtListBean bean : atList) {
                                        textContent = textContent.replace("***" + bean.getNickName(), "@" + bean.getNickName());
                                    }
                                }
                                chatData.setText_content(textContent);
                                chatData.setImage_url(objData.optString("image_url"));
                                chatData.setUserId(responseImMessageInfo.getSender_id());
                                chatData.setMy(responseImMessageInfo.getSender_id().equals(roomInfo.getThird_party_user_id()));
                                sendMessage(type, chatData, responseImMessageInfo);
                                break;
                            default:
                                sendMessage(type, responseImMessageInfo, responseImMessageInfo);
                                break;
                        }
                        break;
                    case MessageTypeData.MESSAGE_SERVICE_CUSTOM:
                        //聊天相关
                        VssMessageChatData chatData = new VssMessageChatData();
                        if (objCon != null) {
                            chatData.setAvatar(objCon.optString("avatar"));
                            chatData.setRoom_id(objCon.optString("room_id"));
                            chatData.setRoleName(objCon.optString("role_name"));
                            if (!TextUtils.isEmpty(objCon.optString("nickname"))) {
                                chatData.setNickname(objCon.optString("nickname"));
                            } else {
                                chatData.setNickname(objCon.optString("nick_name"));
                            }
                            chatData.setRoleName(objCon.optString("role_name"));
                        }
                        chatData.setTime(responseImMessageInfo.getDate_time());
                        chatData.setType("text");
                        chatData.event = VssMessageChatData.eventCustomKey;
                        chatData.setText_content(responseImMessageInfo.getData());
                        chatData.setUserId(responseImMessageInfo.getSender_id());
                        chatData.setMy(responseImMessageInfo.getSender_id().equals(roomInfo.getThird_party_user_id()));
                        sendMessage(MessageTypeData.MESSAGE_SERVICE_CUSTOM, chatData, responseImMessageInfo);
                        break;
                    case MessageTypeData.MESSAGE_SERVICE_ONLINE:
                        String hide = objData.optString("hide");
                        JSONObject online = new JSONObject();
                        online.put("time", responseImMessageInfo.getDate_time());
                        online.put("id", responseImMessageInfo.getSender_id());
                        online.put("hide", objData.optString("hide"));
                        if (objCon != null) {
                            if (!TextUtils.isEmpty(objCon.optString("nickname"))) {
                                online.put("name", objCon.optString("nickname"));
                            } else {
                                online.put("name", objCon.optString("nick_name"));
                            }
                            online.put("avatar", objCon.optString("avatar"));
                        }
                        sendMessage(type, online, responseImMessageInfo);
                        break;
                    case MessageTypeData.MESSAGE_SERVICE_ROOM:
                        switch (type) {
                            case MessageTypeData.MESSAGE_LOTTERY_PUSH:
                            case MessageTypeData.MESSAGE_LOTTERY_RESULT_NOTICE:
                                dealLottery(responseImMessageInfo, type);
                                break;
                            case MessageTypeData.MESSAGE_SIGN_IN_PUSH:

                                dealData(responseImMessageInfo, type, VssMessageSignData.class);
                                break;
                            case MessageTypeData.MESSAGE_ROOM_ANNOUNCEMENT:
                                dealData(responseImMessageInfo, type, VssMessageAnnouncementData.class);
                                break;
                            case MessageTypeData.MESSAGE_QUESTION_ANSWER_OPEN:
                                dealData(responseImMessageInfo, type, VssMessageAnnouncementData.class);
                                break;
                            case MessageTypeData.MESSAGE_QUESTION_ANSWER_CREATE:
                            case MessageTypeData.MESSAGE_QUESTION_ANSWER_COMMIT:
                                dealData(responseImMessageInfo, type, VssMessageQuestionData.class);
                                break;
                            case MessageTypeData.MESSAGE_QUESTIONNAIRE_PUSH:
                            case MessageTypeData.MESSAGE_QUESTIONNAIRE_REPUSH:
                                String questionnaire_id = objData.optString("questionnaire_id");
                                JSONObject question = new JSONObject();
                                question.put("questionnaire_id", questionnaire_id);
                                sendMessage(type, question, responseImMessageInfo);
                                break;

                            case MessageTypeData.MESSAGE_VRTC_CONNECT_APPLY:
                            case MessageTypeData.MESSAGE_VRTC_CONNECT_APPLY_CANCEL:
                            case MessageTypeData.MESSAGE_VRTC_CONNECT_INVITE_REFUSED:
                            case MessageTypeData.MESSAGE_VRTC_CONNECT_SUCCESS:
                                JSONObject apply = new JSONObject();
                                apply.put("nick_name", objData.optString("nick_name"));
                                apply.put("user_id", objData.optString("room_join_id"));
                                sendMessage(type, apply, responseImMessageInfo);
                                break;
                            case MessageTypeData.MESSAGE_VRTC_CONNECT_INVITE:
                            case MessageTypeData.MESSAGE_ROOM_KICKOUT:
                            case MessageTypeData.MESSAGE_VRTC_CONNECT_AGREE:
                            case MessageTypeData.MESSAGE_VRTC_CONNECT_REFUSED:
                                //自己关注消息
                                id = objData.optString("target_id");
                                sendMessage(type, responseImMessageInfo, responseImMessageInfo);
                                break;
                            case MessageTypeData.MESSAGE_VRTC_FRAMES_FORBID:
                            case MessageTypeData.MESSAGE_VRTC_MUTE_CANCEL:
                            case MessageTypeData.MESSAGE_VRTC_MUTE:
                            case MessageTypeData.MESSAGE_VRTC_FRAMES_DISPLAY:
                            case MessageTypeData.MESSAGE_VRTC_DISCONNECT_SUCCESS:
                                sendMessage(type, responseImMessageInfo, responseImMessageInfo);
                                break;
                            default:
                                sendMessage(type, responseImMessageInfo, responseImMessageInfo);
                                break;
                        }
                        break;
                    default:
                        sendMessage(type, responseImMessageInfo, responseImMessageInfo);
                        break;
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        private void dealData(ResponseImMessageInfo responseImMessageInfo, String type, Class c) {
            Object data = VHJSON.parseObject(responseImMessageInfo.getData(), c);
            if (data != null) {
                sendMessage(type, data, responseImMessageInfo);
            }
        }

        //抽奖
        private void dealLottery(ResponseImMessageInfo responseImMessageInfo, String type) {
            VssMessageLotteryData lotteryData = VHJSON.parseObject(responseImMessageInfo.getData(), VssMessageLotteryData.class);
            if (lotteryData != null) {
                List<VssMessageLotteryData.LotteryWinnersBean> lottery_winners = lotteryData.getLottery_winners();
                if (lottery_winners != null && lottery_winners.size() > 0) {
                    for (int i = 0; i < lottery_winners.size(); i++) {
                        VssMessageLotteryData.LotteryWinnersBean lotteryWinnersBean = lottery_winners.get(i);
                        if (lotteryWinnersBean.getLottery_user_id().equals(roomInfo.getThird_party_user_id())) {
                            lotteryWinnersBean.setSelf(true);
                        } else {
                            lotteryWinnersBean.setSelf(false);
                        }
                    }
                }
                sendMessage(type, lotteryData, responseImMessageInfo);
            }
        }
    }


}
