package vhall.com.vss2.module.room;

import java.util.List;

import vhall.com.vss2.CallBack;
import vhall.com.vss2.data.ResponseAttributes;
import vhall.com.vss2.data.ResponseRoomInfo;
import vhall.com.vss2.data.ResponseScrollingInfo;
import vhall.com.vss2.data.ResponseUserStatus;
import vhall.com.vss2.module.room.callback.IVssCallBackListener;
import vhall.com.vss2.module.room.callback.IVssMessageListener;

/**
 * @author hkl
 * Date: 2019-06-27 12:41
 */
interface IRoomPresenter{

    /**
     * 离开房间
     */
    void leaveRoom();

    /**
     * 进入房间
     */
    void enterRoom(String vssToken, String roomId, CallBack<ResponseRoomInfo> callBack);

    /**
     * 设置im消息监听
     */
    void setVssCallBackLister(IVssCallBackListener listener);

    /**
     * 获取跑马灯
     */
    void getScrollingInfo(CallBack<ResponseScrollingInfo> callBack);

    /**
     * 房间 开启/关闭文档
     * status 1开启，0关闭
     */
    void roomSwitchDoc(String status, CallBack callBack);

    /**
     * 发消息
     */
    void sendMsg(String msg, String type, CallBack callBack);

    void sendImageMsg(String text, List<String> imageUrls, CallBack callBack);

    /**
     * 房间 开始直播
     */
    void roomStartLive(CallBack<String> callback);

    /**
     * 房间 结束直播
     */
    void roomEndLive(CallBack<String> callback);

    /**
     * 房间 设置消息监听
     */
    void setVssMessageListener(IVssMessageListener iVssMessageListener);

    /**
     * 房间-获取属性状态
     */
    void getAttributes(CallBack<ResponseAttributes> callBack);

    /**
     * 房间-获取用户状态
     */
    void getUserStatus(CallBack<ResponseUserStatus> callBack);

    /**
     * 踢出/取消踢出
     */
    void setKicked(String receiveJoinId, String status,CallBack callBack);

    /**
     * 房间-设置用户演示状态（主画面）
     */
    void setMainScreen(String receiveJoinId, String joinId,CallBack callBack);

    /**
     * 房间-设置文档白板权限
     */
    void setDocPermission(String receiveJoinId, String joinId,CallBack callBack);

    /**
     * 房间-发送公告
     */
    void sendNotice(String content,CallBack callBack);

    }
