package vhall.com.vss2.module.role;

import com.vhall.httpclient.api.VHNetApi;
import com.vhall.httpclient.core.IVHRequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import vhall.com.vss2.CallBack;
import vhall.com.vss2.VssSdk;
import vhall.com.vss2.api.VssApiConstant;
import vhall.com.vss2.net.VssNetCallback;
import vhall.com.vss2.utils.rxutils.BasePresenter;

/**
 * @author hkl
 * Date: 2019-06-26 14:05
 */
public class  VssRoleManager extends BasePresenter {
    private volatile static VssRoleManager instance;
    private static String TAG = "VssRoleManager";
    //角色名称 1主持人2观众3助理4嘉宾
    public static final String VSS_ROLE_TYPR_COMPERE = "1";//主持人
    public static final String VSS_ROLE_TYPR_AUDIENCE = "2";//观众
    public static final String VSS_ROLE_TYPR_ASSISTANT = "3";//助理
    public static final String VSS_ROLE_TYPR_GUESTS = "4";//嘉宾
    public static final int VSS_ROLE_ERROR_CODE = 1001;
    private List<Integer> roleTypeList = new ArrayList<>();
    private boolean openRole = true;
    //false 表示不参与 true 表示权限全开

    private boolean canChangeCamera = true;
    private boolean canChangeVoice = true;

    public static VssRoleManager getInstance() {
        if (instance == null) {
            synchronized (VssRoleManager.class) {
                if (instance == null) {
                    instance = new VssRoleManager();
                    /**
                     * create by zwp 20200116
                     * SaaS SDK 4.1 及以前版本默认权限全开；
                     * SaaS SDK 开始启用权限配置后可以删除 默认打开代码
                     */
                    if ("15df4d3f".equals(VssSdk.getInstance().getAppId()) ||
                            "f92b0393".equals(VssSdk.getInstance().getAppId())) {
                        instance.openRole = true;
                    }

                }
            }
        }
        return instance;
    }

    public boolean isOpenRole() {
        return openRole;
    }

    public boolean isCanChangeCamera() {
        return canChangeCamera;
    }

    public void setCanChangeCamera(boolean canChangeCamera) {
        this.canChangeCamera = canChangeCamera;
    }

    public boolean isCanChangeVoice() {
        return canChangeVoice;
    }

    public void setCanChangeVoice(boolean canChangeVoice) {
        this.canChangeVoice = canChangeVoice;
    }

    /**
     * 获取角色信息
     */
    public String getRoleType() {
        return roomInfo.getRole_name();
    }

    /**
     * 媒体 第三方推流
     */
    public boolean canTrigonalPushStream() {
        return openRole || roleTypeList.contains(10001);
    }

    /**
     * 媒体 播放器进度条
     */
    public boolean canPlaySeekBar() {
        return openRole || roleTypeList.contains(10004);
    }

    /**
     * 媒体 播放器清晰度
     */
    public boolean canPlayDefinition() {
        return openRole || roleTypeList.contains(10005);
    }

    /**
     * 媒体 播放器倍速
     */
    public boolean canPlaySpeed() {
        return openRole || roleTypeList.contains(10006);
    }

    /**
     * 媒体 播放器弹幕
     */
    public boolean canPlayBarrage() {
        return openRole || roleTypeList.contains(10007);
    }

    /**
     * 媒体 开启旁路推流
     */
    public boolean canPushStream() {
        return openRole || roleTypeList.contains(10008);
    }

    /**
     * 媒体 操作上麦申请 同意拒绝
     */
    public boolean canOperateInviteSpeak() {
        return openRole || roleTypeList.contains(10013);
    }

    /**
     * 媒体 邀请上麦
     */
    public boolean canInviteSpeak() {
        return openRole || roleTypeList.contains(10013);
    }

    /**
     * 媒体 申请上麦
     */
    public boolean canApplySpeak() {
        return openRole || roleTypeList.contains(10014);
    }

    /**
     * 媒体  开关自己的音视频
     */
    public boolean canOpenCameraVoice() {
        return openRole || roleTypeList.contains(10015);
    }

    /**
     * 媒体  开关别人的音视频
     */
    public boolean canChangeOtherVoiceCamera() {
        return openRole || roleTypeList.contains(10016);
    }

    /**
     * 媒体  下麦自己
     */
    public boolean canOnSpeak() {
        return openRole || roleTypeList.contains(10017);
    }

    /**
     * 媒体  下麦他人
     */
    public boolean canOperateOtherOnSpeak() {
        return openRole || roleTypeList.contains(10018);
    }

    /**
     * 媒体  举手开关
     */
    public boolean canRaiseHandSwitch() {
        return openRole || roleTypeList.contains(10020);
    }


    /**
     * 媒体  举手（申请上麦）
     */
    public boolean canRaiseHand() {
        return openRole || roleTypeList.contains(10021);
    }

    /**
     * 文档  上传
     */
    public boolean canDocUploud() {
        return openRole || roleTypeList.contains(11001);
    }

    /**
     * 文档  开关
     */
    public boolean canDocSwitch() {
        return openRole || roleTypeList.contains(11002);
    }

    /**
     * 文档  演示
     */
    public boolean canDocPlay() {
        return openRole || roleTypeList.contains(11003);
    }

    /**
     * 文档  翻页
     */
    public boolean canDocPaging() {
        return openRole || roleTypeList.contains(11004);
    }

    /**
     * 文档  画笔
     */
    public boolean canDocBrush() {
        return openRole || roleTypeList.contains(11005);
    }

    /**
     * 文档  白板
     */
    public boolean canDocwhiteBoard() {
        return openRole || roleTypeList.contains(11006);
    }

    /**
     * 聊天 成员列表
     */
    public boolean canChatMemberList() {
        return openRole || roleTypeList.contains(12001);
    }

    /**
     * 聊天 踢出恢复
     */
    public boolean canChatKickOut() {
        return openRole || roleTypeList.contains(12002);
    }

    /**
     * 聊天 禁言/恢复
     */
    public boolean canChatBanned() {
        return openRole || roleTypeList.contains(12003);
    }

    /**
     * 聊天 禁言踢出列表
     */
    public boolean canChatOperateList() {
        return openRole || roleTypeList.contains(12004);
    }

    /**
     * 聊天 禁言全部
     */
    public boolean canChatBannedAll() {
        return openRole || roleTypeList.contains(12006);
    }

    /**
     * 回放
     */
    public boolean playBack() {
        return openRole || roleTypeList.contains(13001);
    }

    /**
     * 红包
     */
    public boolean redPacket() {
        return openRole || roleTypeList.contains(14001);
    }

    /**
     * 抽奖
     */
    public boolean lottery() {
        return openRole || roleTypeList.contains(15001);
    }

    /**
     * 问卷
     */
    public boolean questionnaire() {
        return openRole || roleTypeList.contains(16001);
    }

    /**
     * 问答
     */
    public boolean questionAndAnswers() {
        return openRole || roleTypeList.contains(17001);
    }

    /**
     * 签到
     */
    public boolean sign() {
        return openRole || roleTypeList.contains(18001);
    }

    /**
     * 点赞
     */
    public boolean like() {
        return openRole || roleTypeList.contains(19001);
    }

    /**
     * 礼物
     */
    public boolean gift() {
        return openRole || roleTypeList.contains(20001);
    }

    /**
     * 分享
     */
    public boolean share() {
        return openRole || roleTypeList.contains(21001);
    }

    /**
     * 打赏
     */
    public boolean giveReward() {
        return openRole || roleTypeList.contains(22001);
    }

    /**
     * 权限 获取用户角色列表
     * accountId 用户id
     */
    public void getAccessList(String accountId, String roleName, CallBack<List<Integer>> callBack) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 2);
        params.put(VssApiConstant.KEY_ACCOUNT_ID, accountId);
        params.put("role_name", roleName);
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_USER_GET_ACCESS_LIST)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack, new ArrayList<Integer>(){}.getClass()));
    }

    public void clearRoleData() {
        roleTypeList.clear();
    }
}
