package vhall.com.vss2.module.question;

import android.text.TextUtils;

import com.vhall.httpclient.api.VHNetApi;
import com.vhall.httpclient.core.IVHRequest;

import java.util.HashMap;

import vhall.com.vss2.CallBack;
import vhall.com.vss2.api.VssApiConstant;
import vhall.com.vss2.data.CreateQuestionParam;
import vhall.com.vss2.data.VssQuestionListData;
import vhall.com.vss2.net.VssNetCallback;
import vhall.com.vss2.utils.rxutils.BasePresenter;

/**
 * @author hkl
 * Date: 2019-06-26 14:05
 */
public class VssQuestionManager extends BasePresenter {
    private volatile static VssQuestionManager instance;
    private static String TAG = "VssQaManager";

    public static VssQuestionManager getInstance() {
        if (instance == null) {
            synchronized (VssQuestionManager.class) {
                if (instance == null) {
                    instance = new VssQuestionManager();
                }
            }
        }
        return instance;
    }


    /**
     * 问卷-创建问卷
     * 必填参数  title question_id vss_token account_id app_id
     */
    public void questionCreate(CreateQuestionParam createQuestionParam, CallBack callBack) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 10);
        if (createQuestionParam != null) {
            params.put(VssApiConstant.KEY_TITLE, createQuestionParam.getTitle());
            params.put(VssApiConstant.KEY_DEFINITION, createQuestionParam.getDescription());
            params.put(VssApiConstant.KEY_QUESTION_ID, createQuestionParam.getQuestion_id());
            params.put(VssApiConstant.KEY_COVER, createQuestionParam.getCover());
            params.put(VssApiConstant.KEY_EXTEND, createQuestionParam.getExtend());
            params.put(VssApiConstant.KEY_IS_PUBLIC, createQuestionParam.getIs_public());
            params.put(VssApiConstant.KEY_ACCOUNT_ID, createQuestionParam.getAccount_id());
            params.put(VssApiConstant.KEY_APP_ID, createQuestionParam.getApp_id());
        }
        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_QUESTION_CREATE)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 问卷 提交答案
     * 必填参数  vss_token question_id room_id answer_id
     */
    public void questionAnswer(String answerId, String questionId, String extend, CallBack callBack) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 5);
        params.put(VssApiConstant.KEY_ANSWER_ID, answerId);
        params.put(VssApiConstant.KEY_QUESTION_ID, questionId);
        if (!TextUtils.isEmpty(extend)) {
            params.put(VssApiConstant.KEY_EXTEND, extend);
        }

        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_QUESTION_ANSWER)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 问卷 获取统计列表
     */
    public void questionStatisticsList(String page, String pageSize, CallBack callBack) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 4);
        params.put(VssApiConstant.KEY_PAGE, page);
        params.put(VssApiConstant.KEY_PAGE_SIZE, pageSize);

        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_QUESTION_STATISTICS_LIST)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void questionList(CallBack callBack) {
        questionList("", "", "", "", "", callBack);
    }

    /**
     * 问卷 获取列表
     * room_id,account_id二选一
     */
    public void questionList(String keyword, String publish, String isPublic, String page, String pageSize, CallBack<VssQuestionListData> callBack) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 7);
        params.put(VssApiConstant.KEY_PAGE, page);
        params.put(VssApiConstant.KEY_PAGE_SIZE, pageSize);
        params.put(VssApiConstant.KEY_KEYWORD, keyword);
        params.put(VssApiConstant.KEY_IS_PUBLIC, isPublic);
        params.put(VssApiConstant.KEY_PUBLISH, publish);
        params.put("from_room_id", roomId);

        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_QUESTION_LIST)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 问卷 取消发布问卷(主播)
     */
    public void questionCancelPublish(String vssToken, String roomId, String questionId, CallBack callBack) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 3);
        params.put(VssApiConstant.KEY_QUESTION_ID, questionId);

        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_QUESTION_CANCEL_PUBLISH)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 问卷 发布问卷(主播)
     */
    public void questionPublish(String vssToken, String roomId, String questionId, CallBack callBack) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 3);
        params.put(VssApiConstant.KEY_QUESTION_ID, questionId);

        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_QUESTION_PUBLISH)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 问卷 更新问卷
     */
    public void questionUpdate(String vssToken, CreateQuestionParam createQuestionParam, CallBack callBack) {
        HashMap<String, String> params = getDefaultParam(vssToken, null, 7);
        params.put(VssApiConstant.KEY_QUESTION_ID, createQuestionParam.getQuestion_id());
        params.put(VssApiConstant.KEY_DEFINITION, createQuestionParam.getDescription());
        params.put(VssApiConstant.KEY_TITLE, createQuestionParam.getTitle());
        params.put(VssApiConstant.KEY_EXTEND, createQuestionParam.getExtend());
        params.put(VssApiConstant.KEY_COVER, createQuestionParam.getCover());
        params.put(VssApiConstant.KEY_ACCOUNT_ID, createQuestionParam.getAccount_id());

        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_QUESTION_UPDATE)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    /**
     * 问卷 问卷列表(观看端)
     */
    public void questionWatchList(String vssToken, String roomId, String keyword, String page, String pageSize, CallBack callBack) {
        HashMap<String, String> params = getDefaultParam(vssToken, roomId, 5);
        params.put(VssApiConstant.KEY_KEYWORD, keyword);
        params.put(VssApiConstant.KEY_PAGE, page);
        params.put(VssApiConstant.KEY_PAGE_SIZE, pageSize);

        IVHRequest request = new IVHRequest.Builder()
                .addFormParas(params)
                .setUrl(createVssUrl(VssApiConstant.VSS_QUESTION_WATCH_LIST)).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }
}
