package vhall.com.vss2.data;


import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hkl
 * Date: 2019-07-03 15:49
 */
public class VssMessageChatData implements Serializable {

    private String text_content;//聊天内容
    private String type;//消息类型,text、image、video...
    private String room_id;//房间id
    private String nickname;//昵称
    private String avatar;//头像
    private String userId;//用户id
    private String time;//发送时间
    private String image_url;//如为图片信息，图片地址
    private boolean isMy;//是否本人发送
    private List<String> image_urls;//多图消息，组图列表
    private String roleName;
    private String target_id;//私聊接收者的id

    public String event = eventMsgKey;
    public static final String eventOnlineKey = "online";// 上线
    public static final String eventOfflineKey = "offline";// 下线
    public static final String eventMsgKey = "msg";// 聊天
    public static final String eventCustomKey = "custom_broadcast";// 自定义消息
    public static final String eventQuestion = "question";//提问和回答
    /**
     * replyMsg : {"type":"text","avatar":"https:\\/\\/t-alistatic01.e.vhall.com\\/upload\\/webinars\\/img_url\\/30\\/1b\\/301ba4009695509cfba9838505b6336f.jpg","account_id":"16420747","user_name":"900530","role":"2","content":{"type":"text","text_content":"yuui"},"showTime":"","sendTime":"2020-03-03 10:20:33","client":"mobile","count":1,"replyMsg":[],"msgId":"msg_07d593ac99c57d972775d512421500d6","channel":"ch_9a09a109","atList":[],"isHistoryMsg":false}
     */

    private ReplyMsgBean replyMsg;//回复消息

    private List<ResponseChatInfo.ContextBean.AtListBean> atList;

    public List<ResponseChatInfo.ContextBean.AtListBean> getAtlist() {
        return atList;
    }

    public void setAtlist(List<ResponseChatInfo.ContextBean.AtListBean> atlist) {
        this.atList = atlist;
    }

    /**
     * nickName : 900533
     * accountId : 16420702
     * index : 0
     *//*
    public static class AtListBean {
        private String nickName;
        private String accountId;
        private int index;

        public String getNickName() {
            return nickName;
        }

        public void setNickName(String nickName) {
            this.nickName = nickName;
        }

        public String getAccountId() {
            return accountId;
        }

        public void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public int getIndex() {
            return index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }*/
    public String getText_content() {
        return text_content;
    }

    public void setText_content(String text_content) {
        this.text_content = text_content;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRoom_id() {
        return room_id;
    }

    public void setRoom_id(String room_id) {
        this.room_id = room_id;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getUserId() {
        return userId;
    }

    public String getTarget_id() {
        return target_id;
    }

    public void setTarget_id(String target_id) {
        this.target_id = target_id;
    }


    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getTime() {
        return time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public boolean isMy() {
        return isMy;
    }

    public void setMy(boolean my) {
        isMy = my;
    }

    public String getImage_url() {
        return image_url;
    }

    public void setImage_url(String image_url) {
        this.image_url = image_url;
    }

    public List<String> getImage_urls() {
        return image_urls;
    }

    public void setImage_urls(List<String> image_urls) {
        this.image_urls = image_urls;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public VssMessageChatData getMsgData(ResponseChatInfo chatInfo) {
        VssMessageChatData chatData = new VssMessageChatData();
        chatData.setUserId(chatInfo.getThird_party_user_id());
        chatData.setAvatar(chatInfo.getAvatar());
        chatData.setNickname(chatInfo.getNickname());
        chatData.setTime(chatInfo.getDate_time());
        String contentString = chatInfo.getData().getText_content();
        List<ResponseChatInfo.ContextBean.AtListBean> atList = chatInfo.getContext().getAtList();
        if (atList != null && atList.size() > 0) {
            for (ResponseChatInfo.ContextBean.AtListBean bean : atList) {
                contentString = contentString.replace("***" + bean.getNickName(), "@" + bean.getNickName());
            }
        }
        chatData.setText_content(contentString);
        chatData.setType(chatInfo.getData().getType());
        chatData.setImage_urls(chatInfo.getData().getImage_urls());
        return chatData;
    }

    public ReplyMsgBean getReplyMsg() {
        return replyMsg;
    }

    public void setReplyMsg(ReplyMsgBean replyMsg) {
        this.replyMsg = replyMsg;
    }

    public static class ReplyMsgBean {
        /**
         * type : text
         * avatar : https:\/\/t-alistatic01.e.vhall.com\/upload\/webinars\/img_url\/30\/1b\/301ba4009695509cfba9838505b6336f.jpg
         * account_id : 16420747
         * user_name : 900530
         * role : 2
         * content : {"type":"text","text_content":"yuui"}
         * showTime :
         * sendTime : 2020-03-03 10:20:33
         * client : mobile
         * count : 1
         * replyMsg : []
         * msgId : msg_07d593ac99c57d972775d512421500d6
         * channel : ch_9a09a109
         * atList : []
         * isHistoryMsg : false
         */

        private String type;
        private String avatar;
        private String sendId;
        private String nickName;
        private String roleName;
        private VssMessageChatData content;
        private String showTime;
        private String sendTime;
        private String client;
        private int count;
        private String msgId;
        private String channel;
        private boolean isHistoryMsg;
        private List<?> replyMsg;
        private List<?> atList;

        public ReplyMsgBean(JSONObject object) {
            this.type = object.optString("type");
            this.avatar = object.optString("avatar");
            this.sendId = object.optString("sendId");
            this.nickName = object.optString("nickName");
            this.roleName = object.optString("roleName");
            this.showTime = object.optString("showTime");
            this.sendTime = object.optString("sendTime");
            this.client = object.optString("client");
            this.count = object.optInt("count");
            this.msgId = object.optString("msgId");
            this.channel = object.optString("channel");
            this.isHistoryMsg = object.optBoolean("isHistoryMsg");
            JSONObject contentObject = object.optJSONObject("content");
            if (contentObject != null) {
                this.content = new VssMessageChatData();
                this.content.text_content = contentObject.optString("text_content");
                this.content.type = contentObject.optString("type");
                this.content.image_url = contentObject.optString("image_url");
                this.content.nickname = contentObject.optString("nickname");
                this.content.avatar = contentObject.optString("avatar");
                this.content.userId = contentObject.optString("userId");
                this.content.time = contentObject.optString("time");
                JSONArray image_urlsArray = contentObject.optJSONArray("image_urls");
                if (image_urlsArray != null) {
                    this.content.image_urls = new ArrayList<>();
                    for (int i = 0; i < image_urlsArray.length(); i++) {
                        this.content.image_urls.add(image_urlsArray.optString(i));
                    }
                }
                JSONObject replyObject = contentObject.optJSONObject("replyMsg");
                if (replyObject!=null){
                    this.content.replyMsg= new ReplyMsgBean(replyObject);
                }
            }
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getAvatar() {
            return avatar;
        }

        public void setAvatar(String avatar) {
            this.avatar = avatar;
        }

        public String getSendId() {
            return sendId;
        }

        public void setSendId(String sendId) {
            this.sendId = sendId;
        }

        public String getNickName() {
            return nickName;
        }

        public void setNickName(String nickName) {
            this.nickName = nickName;
        }

        public String getRoleName() {
            return roleName;
        }

        public void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public VssMessageChatData getContent() {
            return content;
        }

        public void setContent(VssMessageChatData content) {
            this.content = content;
        }

        public String getShowTime() {
            return showTime;
        }

        public void setShowTime(String showTime) {
            this.showTime = showTime;
        }

        public String getSendTime() {
            return sendTime;
        }

        public void setSendTime(String sendTime) {
            this.sendTime = sendTime;
        }

        public String getClient() {
            return client;
        }

        public void setClient(String client) {
            this.client = client;
        }

        public int getCount() {
            return count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public String getMsgId() {
            return msgId;
        }

        public void setMsgId(String msgId) {
            this.msgId = msgId;
        }

        public String getChannel() {
            return channel;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        public boolean isIsHistoryMsg() {
            return isHistoryMsg;
        }

        public void setIsHistoryMsg(boolean isHistoryMsg) {
            this.isHistoryMsg = isHistoryMsg;
        }

        public List<?> getReplyMsg() {
            return replyMsg;
        }

        public void setReplyMsg(List<?> replyMsg) {
            this.replyMsg = replyMsg;
        }

        public List<?> getAtList() {
            return atList;
        }

        public void setAtList(List<?> atList) {
            this.atList = atList;
        }
    }
}
