package vhall.com.vss2.data;

import android.text.TextUtils;

import com.vhall.business.VhallSDK;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author hkl
 * Date: 2019-07-10 16:44
 */

public class UserInfoData {

    /**
     * {
     * "third_party_user_id":"userid",//用户id
     * "nick_name": "张三", //昵称
     * "avatar": "xxxxxx.jpg", //头像
     * "pv": 100, //pv
     * "role_name": "1", //角色 1主持人2观众3助理4嘉宾
     * "device_type": "1", // 设备类型 1手机端 2PC 3SDK
     * "device_status": "1", // 设备状态  1可以上麦2不可以上麦
     * "is_banned": "1" //是否禁言 1是0否
     * }
     */
    public String third_party_user_id;
    public String nick_name;
    public String avatar;
    public String role_name;
    public String device_type;
    public String device_status = "1";
    public String is_banned = "0";
    public String nickname;
    public String pv;
    public String kick_id;
    public String kick_mark;
    public String privacies;
    public String platform = "5";//"app 1 、sdk 5 "
    public boolean audience = true;
    public String third_account_id = "";//用户登录信息的id
    public String ver = VhallSDK.getVersion();//用户登录信息的id

    public UserInfoData(JSONObject object) {
        this.third_party_user_id = object.optString("third_party_user_id");
        this.nick_name = object.optString("nick_name");
        this.avatar = object.optString("avatar");
        this.role_name = object.optString("role_name");
        this.device_type = object.optString("device_type");
        this.device_status = object.optString("device_status");
        this.nickname = object.optString("nickname");
        this.pv = object.optString("pv");
        this.platform = object.optString("platform");
        this.third_account_id = object.optString("third_account_id");
    }

    public String getKick_id() {
        return kick_id;
    }

    public void setKick_id(String kick_id) {
        this.kick_id = kick_id;
    }

    public String getKick_mark() {
        return kick_mark;
    }

    public void setKick_mark(String kick_mark) {
        this.kick_mark = kick_mark;
    }

    public boolean isAudience() {
        return audience;
    }

    public void setAudience(boolean audience) {
        this.audience = audience;
    }

    public String getThird_party_user_id() {
        return third_party_user_id;
    }

    public void setThird_party_user_id(String third_party_user_id) {
        this.third_party_user_id = third_party_user_id;
    }

    public String getPrivacies() {
        return privacies;
    }

    public void setPrivacies(String privacies) {
        this.privacies = privacies;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getNick_name() {
        return nick_name;
    }

    public void setNick_name(String nick_name) {
        this.nick_name = nick_name;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getRole_name() {
        return role_name;
    }

    public void setRole_name(String role_name) {
        this.role_name = role_name;
    }

    public String getDevice_type() {
        return device_type;
    }

    public void setDevice_type(String device_type) {
        this.device_type = device_type;
    }

    public String getDevice_status() {
        return device_status;
    }

    public void setDevice_status(String device_status) {
        this.device_status = device_status;
    }

    public String getIs_banned() {
        return is_banned;
    }

    public void setIs_banned(String is_banned) {
        this.is_banned = is_banned;
    }

    public String getPv() {
        return pv;
    }

    public void setPv(String pv) {
        this.pv = pv;
    }

    public UserInfoData() {
    }

    public UserInfoData(String third_party_user_id, String nick_name, String avatar, String role_name, String device_type, String device_status, String is_banned,String pv,String third_account_id) {
        this.third_party_user_id = third_party_user_id;
        this.nick_name = nick_name;
        this.nickname = nick_name;
        this.avatar = avatar;
        this.role_name = role_name;
        this.device_type = device_type;
        this.device_status = device_status;
        this.is_banned = is_banned;
        this.pv = pv;
        this.third_account_id = third_account_id;
    }

    public UserInfoData(String third_party_user_id, String nick_name, String avatar, String role_name, String device_type, String device_status, String is_banned, String kick_id, String kick_mark,String pv,String third_account_id) {
        this.third_party_user_id = third_party_user_id;
        this.nick_name = nick_name;
        this.nickname = nick_name;
        this.avatar = avatar;
        this.role_name = role_name;
        this.device_type = device_type;
        this.device_status = device_status;
        this.is_banned = is_banned;
        this.kick_id = kick_id;
        this.kick_mark = kick_mark;
        this.pv = pv;
        this.third_account_id = third_account_id;
    }

    public String onlineToString() {
        JSONObject obj = new JSONObject();
        try {
            obj.put("third_party_user_id", third_party_user_id)
                    .put("account_id", third_party_user_id)
                    .put("nick_name", nick_name)
                    .put("avatar", avatar)
                    .put("role_name", role_name)
                    .put("device_type", device_type)
                    .put("device_status", device_status)
                    .put("is_banned", is_banned)
                    .put("nickname", nickname)
                    .put("kick_id", kick_id)
                    .put("kick_mark", kick_mark)
                    .put("platform", platform)
                    .put("third_account_id", third_account_id)
                    .put("ver", ver)
                    .put("pv", pv);
            if (audience) {
                obj.put("audience", audience);
            }
            if (!TextUtils.isEmpty(privacies)) {
                obj.put("privacies", privacies);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return obj.toString();
    }

    @Override
    public String toString() {
        JSONObject obj = new JSONObject();
        try {
            obj.put("third_party_user_id", third_party_user_id)
                    .put("account_id", third_party_user_id)
                    .put("nick_name", nick_name)
                    .put("avatar", avatar)
                    .put("role_name", role_name)
                    .put("device_type", device_type)
                    .put("device_status", device_status)
                    .put("is_banned", is_banned)
                    .put("nickname", nickname)
                    .put("platform", platform)
                    .put("third_account_id", third_account_id)
                    .put("ver", ver)
                    .put("pv", pv);
            if (audience) {
                obj.put("audience", audience);
            }
            if (!TextUtils.isEmpty(privacies)) {
                obj.put("privacies", privacies);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return obj.toString();
    }

}
