package vhall.com.vss2.data;


import org.json.JSONObject;

import java.io.Serializable;

/**
 * @author hkl
 */
public class ResponseAttributes implements Serializable {
    private String is_board;//开关白板，1开0关
    private String is_doc;//开关文档，1开0关
    private String is_handsup;//开关举手，1开0关
    private String main_screen;//主画面
    private String doc_permission;//文档权限（主讲人）
    private String speaker_list;//上麦列表
    private String start_type;//1 web 2 app 3 sdk 4 推拉流 5 定时 6 admin后台 7第三方8 助手
    private String rebroadcast;//转播源房间id
    private String all_banned;//全体禁言1禁言0取消禁言
    private String is_desktop;//开关桌面演示，1开0关
    private String is_qa;//是否开启问答，1开0关
    private String is_invitecard;//是否开启邀请卡，1开0关
    private String rebroadcast_channel_id;//转播源房间频道ID

    private StreamBean stream;//流

    public ResponseAttributes() {
    }

    public ResponseAttributes(JSONObject object) {
        this.is_board = object.optString("is_board");
        this.is_doc = object.optString("is_doc");
        this.is_handsup = object.optString("is_handsup");
        this.main_screen = object.optString("main_screen");
        this.doc_permission = object.optString("doc_permission");
        this.speaker_list = object.optString("speaker_list");
        this.start_type = object.optString("start_type");
        this.rebroadcast = object.optString("rebroadcast");
        this.all_banned = object.optString("all_banned");
        this.is_desktop = object.optString("is_desktop");
        this.is_qa = object.optString("is_qa");
        this.is_invitecard = object.optString("is_invitecard");
        this.rebroadcast_channel_id = object.optString("rebroadcast_channel_id");
        JSONObject streamObject = object.optJSONObject("stream");
        if (streamObject != null) {
            this.stream = new StreamBean(streamObject);
        }
    }

    public String getIs_board() {
        return this.is_board;
    }

    public String getIs_doc() {
        return this.is_doc;
    }

    public String getIs_handsup() {
        return this.is_handsup;
    }

    public String getMain_screen() {
        return this.main_screen;
    }

    public String getDoc_permission() {
        return this.doc_permission;
    }

    public String getSpeaker_list() {
        return this.speaker_list;
    }

    public String getStart_type() {
        return this.start_type;
    }

    public String getRebroadcast() {
        return this.rebroadcast;
    }

    public String getAll_banned() {
        return this.all_banned;
    }

    public String getIs_desktop() {
        return this.is_desktop;
    }

    public String getIs_qa() {
        return this.is_qa;
    }

    public String getIs_invitecard() {
        return this.is_invitecard;
    }

    public String getRebroadcast_channel_id() {
        return this.rebroadcast_channel_id;
    }

    public StreamBean getStream() {
        return this.stream;
    }

    public void setIs_board(String is_board) {
        this.is_board = is_board;
    }

    public void setIs_doc(String is_doc) {
        this.is_doc = is_doc;
    }

    public void setIs_handsup(String is_handsup) {
        this.is_handsup = is_handsup;
    }

    public void setMain_screen(String main_screen) {
        this.main_screen = main_screen;
    }

    public void setDoc_permission(String doc_permission) {
        this.doc_permission = doc_permission;
    }

    public void setSpeaker_list(String speaker_list) {
        this.speaker_list = speaker_list;
    }

    public void setStart_type(String start_type) {
        this.start_type = start_type;
    }

    public void setRebroadcast(String rebroadcast) {
        this.rebroadcast = rebroadcast;
    }

    public void setAll_banned(String all_banned) {
        this.all_banned = all_banned;
    }

    public void setIs_desktop(String is_desktop) {
        this.is_desktop = is_desktop;
    }

    public void setIs_qa(String is_qa) {
        this.is_qa = is_qa;
    }

    public void setIs_invitecard(String is_invitecard) {
        this.is_invitecard = is_invitecard;
    }

    public void setRebroadcast_channel_id(String rebroadcast_channel_id) {
        this.rebroadcast_channel_id = rebroadcast_channel_id;
    }

    public void setStream(StreamBean stream) {
        this.stream = stream;
    }

    public static class StreamBean {
        private String layout;
        private String definition;

        public StreamBean(JSONObject object) {

            this.layout = object.optString("layout");
            this.definition = object.optString("definition");
        }

        public String getLayout() {
            return this.layout;
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setLayout(String layout) {
            this.layout = layout;
        }

        public void setDefinition(String definition) {
            this.definition = definition;
        }
    }
}