package vhall.com.vss2;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;


import com.vhall.framework.VhallSDK;
import com.vhall.logmanager.L;
import com.vhall.logmanager.VLog;

import vhall.com.vss2.api.VssApiConstant;
import vhall.com.vss2.data.UserInfoData;


/**
 * @author hkl
 * Date: 2019-06-26 18:22
 */
public class VssSdk {
    private static final String TAG = "VssSdk";
    private volatile static VssSdk instance;
    public Context mContext;
    private String userId = Build.BRAND + "id";
    private String nickName = Build.BRAND + "手机用户";
    private String client_version =  "client_version_android";
    private String avatar = "";
    private String appId = "15df4d3f";

    public static VssSdk getInstance() {
        if (instance == null) {
            synchronized (VssSdk.class) {
                if (instance == null) {
                    instance = new VssSdk();
                }
            }
        }
        return instance;
    }

    public void clearData(){
        userId = Build.BRAND + "id";
        nickName = Build.BRAND + "手机用户";
    }

    public String getUserId() {
        return userId;
    }

    public String getNickName() {
        return nickName;
    }

    public String getAvatar() {
        return avatar;
    }

    public String getAppId() {
        return appId;
    }

    public String getClient_version() {
        return client_version;
    }

    public void setClient_version(String client_version) {
        this.client_version = client_version;
    }

    public void init(Context context, String userId) {
        init(context, null, userId);
    }

    public void init(Context context, String appId, String userId) {
        init(context, appId, userId, null, null);
    }

    public void init(Context context, String appId, String userId, String hostUrl, String yunUrl) {
        if (!TextUtils.isEmpty(appId)) {
            this.appId = appId;
        }
        if (!TextUtils.isEmpty(hostUrl)) {
            VssApiConstant.API_HOST = "https://" + hostUrl;
            VssApiConstant.API_AREA = "/cmpt/";
        }
        if (!VhallSDK.getInstance().isEnable()) {
            mContext = context;
            VhallSDK.getInstance().setPackageCheck("com.vhallsaas.sdk", "241A634279A943313DCF69893E5B079A");
            VhallSDK.getInstance().init(context, this.appId, userId, yunUrl);
        } else {
            VLog.e(TAG, "vss init error");
        }
    }

    /**
     * init之前设置有效
     */
    public static void setPackageCheck(String packName, String sign) {
        VhallSDK.getInstance().setPackageCheck(packName, sign);

    }

    public void setUserId(String userId) {
        this.userId = userId;
        VhallSDK.getInstance().setUserId(userId);
    }

    /**
     * {
     * "third_party_user_id":"userid",//用户id
     * "nick_name": "张三", //昵称
     * "avatar": "xxxxxx.jpg", //头像
     * "pv": 100, //pv
     * "role_name": "1", //角色 1主持人2观众3助理4嘉宾
     * "device_type": "1", // 设备类型 1手机端 2PC 3SDK
     * "device_status": "1", // 设备状态  1可以上麦2不可以上麦
     * "is_banned": "1" //是否禁言 1是0否
     * }
     */
    public void setUserInfo(UserInfoData userInfo) {
        this.userId = userInfo.getThird_party_user_id();
        this.nickName = userInfo.getNick_name();
        this.avatar = userInfo.getAvatar();
        VhallSDK.getInstance().setUserInfo(userInfo.toString());
    }
    public void updateUserInfo(UserInfoData userInfo) {
        this.userId = userInfo.getThird_party_user_id();
        this.nickName = userInfo.getNick_name();
        this.avatar = userInfo.getAvatar();
        VhallSDK.getInstance().updateUserInfo(userInfo.toString());
    }
}
