package com.vhall.vhss.network;


import android.text.TextUtils;

import com.vhall.httpclient.api.VHNetApi;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.TokenManger;
import com.vhall.vhss.api.CoreApiConstant;
import com.vhall.vhss.data.VersionRollData;
import com.vhall.vhss.data.VersionUpgradeData;
import com.vhall.vhss.netutils.CoreNetCallback;

import java.util.HashMap;

/**
 * @author hkl
 * 版本回滚 相关
 */
public class VersionNetworkRequest extends BaseNetwork {

    /**
     * 回滚接口 和获取bu
     */
    public static void versionInitConfig(String app_key, final CallBack<VersionRollData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        if (!TextUtils.isEmpty(app_key)) {
            params.put("app_key", "app_key");
        }
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_VERSION_INIT_CONFIG), new CoreNetCallback(new CallBack<VersionRollData>() {
            @Override
            public void onSuccess(VersionRollData result) {
                TokenManger.setSignType(result.sign_type);
                if (callBack != null) {
                    callBack.onSuccess(result);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callBack != null) {
                    callBack.onError(eventCode, msg);
                }
            }
        }, VersionRollData.class));
    }

    /**
     * 强制升级
     */
    public static void versionUpgrade(String version, CallBack<VersionUpgradeData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("source","app");
        params.put("ver",version);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_VERSION_UPGRADE), new CoreNetCallback(callBack, VersionUpgradeData.class));
    }

}
