package com.vhall.vhss.network;


import android.os.Bundle;
import android.text.TextUtils;

import com.vhall.httpclient.api.VHNetApi;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.TokenManger;
import com.vhall.vhss.api.CoreApiConstant;
import com.vhall.vhss.api.CoreNetApi;
import com.vhall.vhss.data.VhssUserInfoData;
import com.vhall.vhss.netutils.CoreNetCallback;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * @author hkl
 * Date: 2019-06-25 13:49
 */
public class UserNetworkRequest extends BaseNetwork {

    public static void sendCode(String type, String data, CallBack callBack) {
        sendCode(type, data, "7", callBack);
    }

    /**
     * 发送验证码
     *
     * @param type     类型 手机号或者邮箱 1手机  2邮箱
     * @param data     根据type值不同，分别传手机号、邮箱
     * @param scene_id 场景ID：1账户信息-修改密码  2账户信息-修改密保手机 3账户信息-修改关联邮箱 4忘记密码-邮箱方式找回
     *                 // 5忘记密码-短信方式找回 6提现绑定时手机号验证 7快捷方式登录 8注册-验证码  11账号注销 12消息通知手机号填写
     *                 <p>
     *                 biz_id  新增，区分业务线：2=SaaS直播，4=知客，8=其他
     */
    public static void sendCode(String type, String data, String scene_id, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("type", TextUtils.isEmpty(type) ? "" : type.trim());
        params.put("data", TextUtils.isEmpty(data) ? "" : data.trim());
        params.put("scene_id", scene_id);
        params.put("biz_id", "2");
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_CODE_SEND), new CoreNetCallback(callBack));
    }


    /**
     * 获取用户信息
     */
    public static void getUserInfo(CallBack<VhssUserInfoData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("scene_id", "1");
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_USER_GET_INFO), new CoreNetCallback(callBack, VhssUserInfoData.class));
    }

    /**
     * 登录
     *
     * @param account      saas账号 或者手机号 或者邮箱
     * @param password     密码
     * @param dynamic_code 动态密码【快捷登录必传】
     *                     remember 自动登录：0否 1是【账号密码方式登录必传】
     */
    public static void login(String account, String password, String dynamic_code, final CallBack<VhssUserInfoData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("account", TextUtils.isEmpty(account) ? "" : account.trim());
        if (!TextUtils.isEmpty(password)) {
            params.put("password", password.trim());
            params.put("remember", "1");
        }
        if (!TextUtils.isEmpty(dynamic_code)) {
            params.put("dynamic_code", dynamic_code.trim());
        }
        Bundle bundle = new Bundle();
        bundle.putString(CoreNetCallback.DYNAMIC_CODE, dynamic_code.trim());
        bundle.putString(CoreNetCallback.USER_NAME, account.trim());
        bundle.putString(CoreNetCallback.PASS_WORD, password.trim());
        bundle.putString(CoreNetCallback.REQUEST_URL, CoreApiConstant.API_USER_LOGIN);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_USER_LOGIN), new CoreNetCallback(new CallBack<VhssUserInfoData>() {
            @Override
            public void onSuccess(VhssUserInfoData result) {
                TokenManger.setToken(result.token);
                TokenManger.setGrayId(result.user_id);
                if (callBack != null) {
                    callBack.onSuccess(result);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callBack != null) {
                    callBack.onError(eventCode, msg);
                }
            }
        }, VhssUserInfoData.class, bundle));
    }

    /**
     * 登录
     * 第三方账号id（max：255字符）
     */
    public static void loginByThirdId(Map<String, String> requestParams, final CallBack<VhssUserInfoData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        for (String key : requestParams.keySet()) {
            if (!TextUtils.isEmpty(requestParams.get(key))) {
                params.put(key, TextUtils.isEmpty(requestParams.get(key)) ? "" : requestParams.get(key).trim());
            }
        }
        Bundle bundle = new Bundle();
        bundle.putString(CoreNetCallback.THIRD_ID, TextUtils.isEmpty(params.get(ApiKeyConstants.KEY_THIRD_USER_ID)) ? "" : params.get(ApiKeyConstants.KEY_THIRD_USER_ID));
        bundle.putString(CoreNetCallback.USER_NAME, TextUtils.isEmpty(params.get(ApiKeyConstants.KEY_NICK_NAME)) ? "" : params.get(ApiKeyConstants.KEY_NICK_NAME));
        bundle.putString(CoreNetCallback.HEAD_NET_URL, TextUtils.isEmpty(params.get(ApiKeyConstants.KEY_HEAD_NET_URL)) ? "" : params.get(ApiKeyConstants.KEY_HEAD_NET_URL));
        bundle.putString(CoreNetCallback.REQUEST_URL, TextUtils.isEmpty(params.get(CoreApiConstant.API_USER_LOGIN_THIRDID)) ? "" : CoreApiConstant.API_USER_LOGIN_THIRDID);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_USER_LOGIN_THIRDID), new CoreNetCallback(new CallBack<VhssUserInfoData>() {
            @Override
            public void onSuccess(VhssUserInfoData result) {
                TokenManger.setToken(result.token);
                TokenManger.setGrayId(result.user_id);
                if (callBack != null) {
                    callBack.onSuccess(result);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callBack != null) {
                    callBack.onError(eventCode, msg);
                }
            }
        }, VhssUserInfoData.class, bundle));
    }

    /**
     * 退出登录
     */
    public static void logout(final CallBack callBack) {
        Bundle bundle = new Bundle();
        bundle.putString(CoreNetCallback.REQUEST_URL, CoreApiConstant.API_USER_LOGOUT);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(new HashMap<String, String>()), CoreApiConstant.API_USER_LOGOUT), new CoreNetCallback(new CallBack() {
            @Override
            public void onSuccess(Object result) {
                if (callBack != null) {
                    callBack.onSuccess("");
                    TokenManger.liveOutByUser();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callBack != null) {
                    callBack.onError(eventCode, msg);
                }
            }
        }, null, bundle));
    }

    /**
     * 用户反馈
     * type
     * <p>
     * 1:卡顿 2:黑屏  3:声音不同步 4:APP反馈
     */
    public static void feedBack(String content, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("content", content);
        params.put("type", "4");
        params.put("source", "2");

        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_CREATE_FEED_BACK), new CoreNetCallback(callBack));
    }
}
