package com.vhall.vhss.network;


import android.text.TextUtils;

import com.vhall.httpclient.api.VHNetApi;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.api.CoreApiConstant;
import com.vhall.vhss.data.DocListInfoData;
import com.vhall.vhss.netutils.CoreNetCallback;

import java.util.HashMap;

/**
 * @author hkl
 * 文档 相关
 */
public class DocNetworkRequest extends BaseNetwork {
    /**
     * 直播设置_获取活动下的文档列表
     *
     * @param webinar_id 活动id
     * @param page        yage数字
     * @param limit      获取条目数量，最大100
     *                   keyword 用户昵称  可以添加
     */
    public static void getDocList(String webinar_id, String room_id, int page, int limit, String keyword, CallBack<DocListInfoData> callBack) {
        if (page == 0) {
            if (callBack != null) {
                callBack.onError(-1, "页码从1开始");
            }
            return;
        }
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", webinar_id);
        params.put("room_id", room_id);
        limit = limit == 0 ? 10 : limit;
        params.put("limit", String.valueOf(limit));
        params.put("pos", String.valueOf((page-1) * limit));
        params.put("type", "2");
        if (!TextUtils.isEmpty(keyword)) {
            params.put("keyword", keyword);
        }
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_DOCUMENT_LIST), new CoreNetCallback(callBack, DocListInfoData.class));
    }

    /**
     * 直播设置_设置主讲人
     *
     * @param room_id            房间id
     * @param receive_account_id 用户id
     */
    public static void setDocPermission(String room_id, String receive_account_id, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        params.put("receive_account_id", receive_account_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_SET_DOC_PERMISSION), new CoreNetCallback(callBack));
    }

}
