package com.vhall.vhss.network;


import android.text.TextUtils;

import com.vhall.business.VhallSDK;
import com.vhall.business.data.WatchAuthInfo;
import com.vhall.httpclient.api.VHNetApi;
import com.vhall.httpclient.core.IVHNetCallback;
import com.vhall.httpclient.core.VHNetResponse;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.CallBackV2;
import com.vhall.vhss.TokenManger;
import com.vhall.vhss.api.CoreApiConstant;
import com.vhall.vhss.data.AgreementData;
import com.vhall.vhss.data.CardsInfoData;
import com.vhall.vhss.data.CommonConfigData;
import com.vhall.vhss.data.CouponInfoData;
import com.vhall.vhss.data.CreateRecordData;
import com.vhall.vhss.data.DirectorSeatListData;
import com.vhall.vhss.data.FilesData;
import com.vhall.vhss.data.GoodsInfoData;
import com.vhall.vhss.data.GoodsOrderSetting;
import com.vhall.vhss.data.GuestJoinInfoData;
import com.vhall.vhss.data.LabelListInfoData;
import com.vhall.vhss.data.LanguageListData;
import com.vhall.vhss.data.NoticeListInfoData;
import com.vhall.vhss.data.OrderInfoData;
import com.vhall.vhss.data.PlayerConfigData;
import com.vhall.vhss.data.PrivilegeInfoData;
import com.vhall.vhss.data.RecordChaptersData;
import com.vhall.vhss.data.RecordsData;
import com.vhall.vhss.data.RoleNameData;
import com.vhall.vhss.data.RoomToolsStatusData;
import com.vhall.vhss.data.RoundUserListData;
import com.vhall.vhss.data.ScrollInfoData;
import com.vhall.vhss.data.SurveyInfoData;
import com.vhall.vhss.data.VhssUserInfoData;
import com.vhall.vhss.data.WarmInfoData;
import com.vhall.vhss.data.WatermarkInfoData;
import com.vhall.vhss.data.WebinarBaseInfoData;
import com.vhall.vhss.data.WebinarInfoData;
import com.vhall.vhss.data.WebinarinfoListData;
import com.vhall.vhss.exception.ApiException;
import com.vhall.vhss.exception.CustomException;
import com.vhall.vhss.netutils.CoreNetCallback;
import com.vhall.vhss.params.CreateWebinarParams;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @author hkl
 * 活动 相关
 */
public class ActivityNetworkRequest extends BaseNetwork {

    private static String _visitorId = null;

    /**
     * 通过活动id获取活动拥有者用户id
     * <p>
     * 灰度测试使用获取grayId
     * <p>
     * 登陆的时候 设置 嘉宾登陆和两个init 请求
     *
     * @param webinarId 活动id
     */
    public static void initBefore(String webinarId, final CallBack<String> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinarId) ? "" : webinarId.trim());
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_INIT_BEFORE), new CoreNetCallback(new CallBack<String>() {
            @Override
            public void onSuccess(String result) {
                try {
                    JSONObject objectResult = new JSONObject(result);
                    if (!TextUtils.isEmpty(objectResult.optString("data"))) {
                        JSONObject objectData = new JSONObject(objectResult.optString("data"));
                        String id = objectData.optString("user_id");
                        if (!TextUtils.isEmpty(id)) {
                            if (callBack != null) {
                                callBack.onSuccess(id);
                            }
                        } else {
                            if (callBack != null) {
                                callBack.onError(-1, "no id");
                            }
                        }
                    } else {
                        if (callBack != null) {
                            callBack.onError(-1, "no data");
                        }
                    }
                } catch (Exception e) {
                    if (callBack != null) {
                        callBack.onError(-1, e.getMessage());
                    }
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callBack != null) {
                    callBack.onError(eventCode, msg);
                }
            }
        }));
    }

    /**
     * 获取用户直播列表
     *
     * @param page 获取条目节点，默认为0
     *             order_type 排序规则 1 按照创建时间排序 2 按照最后直播时间排序
     *             webinar_state 直播类型
     */
    public static void getWebinarList(int page, String user_id, String webinar_state, CallBack<WebinarinfoListData> callBack) {
        if (page == 0) {
            if (callBack != null) {
                callBack.onError(-1, "页码从1开始");
            }
            return;
        }
        HashMap<String, String> params = new HashMap<>();
        params.put("limit", String.valueOf(10));
        params.put("pos", String.valueOf((page - 1) * 10));
        params.put("user_id", user_id);
        params.put("order_type", "1");
        params.put("need_flash", "0");
        if (!TextUtils.isEmpty(webinar_state)) {
            params.put("webinar_state", webinar_state);
        }
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_WEBINAR_LIST), new CoreNetCallback(callBack, WebinarinfoListData.class));
    }

    /**
     * 口令用户登录验证
     *
     * @param webinarId 活动id
     * @param password  密码
     * @param nickname  昵称
     *                  avatar  头像可以是空的
     * @param type      类型 角色（1-主持人，2-嘉宾，3-助理）
     *                  refer      来源 自定义渠道 目前没有用
     * @param visitorId 访客唯一标识
     */
    public static void guestJoinWebinar(String webinarId, String password, String nickname, String type, String visitorId, CallBack<GuestJoinInfoData> callBack) {
        guestJoinWebinar(webinarId, password, nickname, "", type, visitorId, callBack);
    }

    public static void guestJoinWebinar(String webinarId, String password, String nickname, String avatar, String type, String visitorId, final CallBack<GuestJoinInfoData> callBack) {
        final HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinarId) ? "" : webinarId.trim());
        params.put("nickname", TextUtils.isEmpty(nickname) ? "" : nickname.trim());
        params.put("password", TextUtils.isEmpty(password) ? "" : password.trim());
        params.put("type", TextUtils.isEmpty(type) ? "" : type.trim());

        if (!TextUtils.isEmpty(visitorId)) {
            params.put("visitor_id", visitorId.trim());
        }
        if (!TextUtils.isEmpty(avatar)) {
            params.put("avatar", avatar.trim());
        }
        initBefore(webinarId, new CallBack<String>() {
            @Override
            public void onSuccess(String result) {
                TokenManger.setGrayId(result);
                VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_ROLE_LOGIN), new CoreNetCallback(callBack, GuestJoinInfoData.class));
            }

            @Override
            public void onError(int eventCode, String msg) {
                VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_ROLE_LOGIN), new CoreNetCallback(callBack, GuestJoinInfoData.class));
            }
        });
    }

    /**
     * 获取直播间互动工具状态
     *
     * @param roomId 房间id lss_asfa3asdf3
     */
    public static void getRoomToolsState(String roomId, CallBack<RoomToolsStatusData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", roomId);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_ROOM_STATUS), new CoreNetCallback(callBack, RoomToolsStatusData.class));
    }

    /**
     * 获取活动角色配置接口
     *
     * @param webinar_id 活动id
     */
    public static void getPrivilegeInfo(String webinar_id, CallBack<PrivilegeInfoData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinar_id) ? "" : webinar_id.trim());
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_PRIVILEGE_INFO), new CoreNetCallback(callBack, PrivilegeInfoData.class));
    }

    /**
     * 开启关闭角色开关
     *
     * @param webinar_id   活动id
     * @param is_privilege 是否开启 1 开启 0 关闭
     */
    public static void setPrivilegeOpen(String webinar_id, int is_privilege, CallBack<PrivilegeInfoData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinar_id) ? "" : webinar_id.trim());
        params.put("is_privilege", String.valueOf(is_privilege));
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_PRIVILEGE_OPEN), new CoreNetCallback(callBack, PrivilegeInfoData.class));
    }

    /**
     * 获取直播状态
     *
     * @param webinarId 活动id
     */
    public static void getWebinarState(String webinarId, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_ids", TextUtils.isEmpty(webinarId) ? "" : webinarId.trim());
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_WEBINAR_STATE), new CoreNetCallback(callBack, VhssUserInfoData.class));
    }

    /**
     * 活动创建接口
     *
     * @param createWebinarParams 活动参数
     *                            返回值 活动id
     */
    public static void createWebinar(CreateWebinarParams createWebinarParams, final CallBack myCallBack) {

        VHNetApi.getNetApi().doPost(getBaseRequest(createWebinarParams.getParams(), CoreApiConstant.API_CREATE_WEBINAR), new CoreNetCallback(new CallBack<String>() {
            @Override
            public void onSuccess(String result) {
                String webinar_id = "";
                try {
                    JSONObject objectResult = new JSONObject(result);
                    JSONObject data = objectResult.optJSONObject("data");
                    int code = objectResult.optInt("code");
                    if (code == 200) {
                        if (data != null) {
                            webinar_id = data.optString("webinar_id");
                        } else {
                            if (myCallBack != null) {
                                myCallBack.onError(code, "create webinar error");
                            }
                        }
                    } else {
                        if (myCallBack != null) {
                            myCallBack.onError(code, objectResult.optString("msg"));
                        }
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                if (myCallBack != null) {
                    myCallBack.onSuccess(webinar_id);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (myCallBack != null) {
                    myCallBack.onError(eventCode, msg);
                }
            }
        }));
    }

    /**
     * 活动修改接口
     *
     * @param createWebinarParams 活动参数
     */
    public static void updateWebinar(CreateWebinarParams createWebinarParams, final CallBack myCallBack) {

        VHNetApi.getNetApi().doPost(getBaseRequest(createWebinarParams.getParams(), CoreApiConstant.API_EDIT_WEBINAR), new CoreNetCallback(new CallBack<String>() {
            @Override
            public void onSuccess(String result) {
                String webinar_id = "";
                try {
                    JSONObject objectResult = new JSONObject(result);
                    JSONObject data = objectResult.optJSONObject("data");
                    int code = objectResult.optInt("code");
                    if (code == 200) {
                        if (data != null) {
                            webinar_id = data.optString("webinar_id");
                        } else {
                            if (myCallBack != null) {
                                myCallBack.onError(code, "update webinar error");
                            }
                        }
                    } else {
                        if (myCallBack != null) {
                            myCallBack.onError(code, objectResult.optString("msg"));
                        }
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                if (myCallBack != null) {
                    myCallBack.onSuccess(webinar_id);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (myCallBack != null) {
                    myCallBack.onError(eventCode, msg);
                }
            }
        }));
    }

    /**
     * 获取当前云导播活动下的机位列表
     *
     * @param webinarId 当前云导播活动
     */
    public static void getDirectorSeatList(String webinarId, final CallBack<DirectorSeatListData> myCallBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinarId) ? "" : webinarId.trim());
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_WEBINAR_DIRECTOR_SEAT_LIST), new CoreNetCallback(myCallBack, DirectorSeatListData.class
        ));
    }

    /**
     * 占用当前云导播活动下的机位
     *
     * @param webinarId 当前云导播活动
     * @param seatId    机位id
     * @param uuid      设备 ID， 每个设备保持唯一即可， 最大 64 位
     */
    public static void directorSelectSeat(String webinarId, String seatId, String uuid, final CallBack myCallBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinarId) ? "" : webinarId.trim());
        params.put("seat_id", TextUtils.isEmpty(seatId) ? "" : seatId.trim());
        params.put("uuid", TextUtils.isEmpty(uuid) ? "" : uuid.trim());
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_WEBINAR_DIRECTOR_SELECT_SEAT), new CoreNetCallback(myCallBack));
    }

    /**
     * 获取云导播开关
     *
     * @param webinarId 活动id
     *                  云导播台状态， 0： 未开启， 1：已开启
     */
    public static void getDirectorStatus(final String webinarId, final CallBack<String> myCallBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinarId) ? "" : webinarId.trim());
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_WEBINAR_DIRECTOR_STATUS), new CoreNetCallback(new CallBack<String>() {
            @Override
            public void onSuccess(String result) {
                try {
                    JSONObject objectResult = new JSONObject(result);
                    JSONObject data = objectResult.optJSONObject("data");
                    int code = objectResult.optInt("code");
                    if (code == 200) {
                        if (myCallBack != null) {
                            myCallBack.onSuccess(data.optString("director_status"));
                        }
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                    if (myCallBack != null) {
                        myCallBack.onError(-1, e.getMessage());
                    }
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (myCallBack != null) {
                    myCallBack.onError(eventCode, msg);
                }
            }
        }));
    }

    /**
     * 获取直播间流状态
     *
     * @param webinarId 活动id
     *                  流状态， 0：没流，1：有流
     */
    public static void getDirectorStreamStatus(final String webinarId, final CallBack<String> myCallBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinarId) ? "" : webinarId.trim());
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_WEBINAR_DIRECTOR_STREAM_STATUS), new CoreNetCallback(new CallBack<String>() {
            @Override
            public void onSuccess(String result) {
                try {
                    JSONObject objectResult = new JSONObject(result);
                    JSONObject data = objectResult.optJSONObject("data");
                    int code = objectResult.optInt("code");
                    if (code == 200) {
                        if (myCallBack != null) {
                            myCallBack.onSuccess(data.optString("director_stream"));
                        }
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                    if (myCallBack != null) {
                        myCallBack.onError(-1, e.getMessage());
                    }
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (myCallBack != null) {
                    myCallBack.onError(eventCode, msg);
                }
            }
        }));
    }


    /**
     * 发起端 获取当前云导播权限
     * director-seat-init
     *
     * @param webinarId 活动id
     * @param seat_id   机位 id， 机位列表返回
     *                  check_online 是否检查主持人，0 不检查， 1 检查，默认检查
     */
    public static void getDirectorSeatInfo(final String webinarId, final String seat_id, final CallBack<WebinarInfoData> myCallBack) {
        getDirectorSeatInfo(webinarId, seat_id, "0", myCallBack);
    }

    public static void getDirectorSeatInfo(final String webinarId, final String seat_id, final String check_online, final CallBack<WebinarInfoData> myCallBack) {

        initBefore(webinarId, new CallBack<String>() {
            @Override
            public void onSuccess(String result) {
                TokenManger.setGrayId(result);
                getDirectorSeatInit(webinarId, seat_id, check_online, myCallBack);
            }

            @Override
            public void onError(int eventCode, String msg) {
                getDirectorSeatInit(webinarId, seat_id, check_online, myCallBack);
            }
        });
    }

    private static void getDirectorSeatInit(String webinarId, String seatId, final String check_online, final CallBack<WebinarInfoData> myCallBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinarId) ? "" : webinarId.trim());
        if (!TextUtils.isEmpty(seatId)) {
            params.put("seat_id", seatId.trim());
        }
        params.put("check_online", check_online);

        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_WEBINAR_DIRECTOR_SEAT), new CoreNetCallback(new CallBack<WebinarInfoData>() {
            @Override
            public void onSuccess(final WebinarInfoData webinarInfoData) {
                if (TextUtils.isEmpty(TokenManger.getGrayId())) {
                    TokenManger.setGrayId(webinarInfoData.webinar.userinfo.user_id);
                }
                if (myCallBack != null) {
                    myCallBack.onSuccess(webinarInfoData);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (myCallBack != null) {
                    myCallBack.onError(eventCode, msg);
                }
            }
        }, WebinarInfoData.class));
    }


    /**
     * 获取发起端 详情
     * live/init
     *
     * @param webinarId 活动id
     * @param liveToken 参会token 嘉宾助理的（live_token不能为空）
     * @param email     参会token 嘉宾助理的
     * @param nickName  昵称 增加昵称（2021/02/19）
     */
    public static void getLiveInfo(final String webinarId, final String liveToken, final String nickName, final String email, final CallBack<WebinarInfoData> myCallBack) {

        initBefore(webinarId, new CallBack<String>() {
            @Override
            public void onSuccess(String result) {
                TokenManger.setGrayId(result);
                getLiveInit(webinarId, liveToken, nickName, email, myCallBack);
            }

            @Override
            public void onError(int eventCode, String msg) {
                getLiveInit(webinarId, liveToken, nickName, email, myCallBack);
            }
        });
    }

    private static void getLiveInit(final String webinarId, final String liveToken, String nickName, String email, final CallBack<WebinarInfoData> myCallBack) {

        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinarId) ? "" : webinarId.trim());

        if (!TextUtils.isEmpty(liveToken)) {
            params.put("live_token", liveToken.trim());
        }

        if (!TextUtils.isEmpty(email)) {
            params.put("email", email.trim());
        }
        if (!TextUtils.isEmpty(nickName)) {
            params.put("nickname", nickName.trim());
        }
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_WEBINAR_LIVE_INFO), new CoreNetCallback(new CallBack<WebinarInfoData>() {
            @Override
            public void onSuccess(final WebinarInfoData webinarInfoData) {
                TokenManger.setInteractToken(webinarInfoData.interact.interact_token);
                if (TextUtils.isEmpty(TokenManger.getGrayId())) {
                    TokenManger.setGrayId(webinarInfoData.webinar.userinfo.user_id);
                }
                InteractNetworkRequest.setDevice(webinarInfoData.interact.room_id, "1", null);
                commonConfig(webinarId, new CallBack<CommonConfigData>() {
                    @Override
                    public void onSuccess(CommonConfigData result) {
                        if (result != null) {
                            webinarInfoData.roomToolsStatusData = result.roomTool;
                            webinarInfoData.filters = result.keyWord;
                            webinarInfoData.like = result.like;
                            webinarInfoData.noticeListInfoData = result.noticeListInfoData;
                            webinarInfoData.skinData = result.skinData;
                            webinarInfoData.menuListInfoData = result.menuListInfoData;
                        }
                        playerConfig(webinarId, new CallBack<PlayerConfigData>() {
                            @Override
                            public void onSuccess(PlayerConfigData result) {
                                if (result != null) {
                                    webinarInfoData.scrollInfoData = result.scrollInfoData;
                                    webinarInfoData.watermarkInfoData = result.watermarkInfoData;
                                }
                                if (myCallBack != null) {
                                    myCallBack.onSuccess(webinarInfoData);
                                }
                            }

                            @Override
                            public void onError(int eventCode, String msg) {
                                if (myCallBack != null) {
                                    myCallBack.onSuccess(webinarInfoData);
                                }
                            }
                        });
                    }

                    @Override
                    public void onError(int eventCode, String msg) {
                        playerConfig(webinarId, new CallBack<PlayerConfigData>() {
                            @Override
                            public void onSuccess(PlayerConfigData result) {
                                if (result != null) {
                                    webinarInfoData.scrollInfoData = result.scrollInfoData;
                                    webinarInfoData.watermarkInfoData = result.watermarkInfoData;
                                }
                                if (myCallBack != null) {
                                    myCallBack.onSuccess(webinarInfoData);
                                }
                            }

                            @Override
                            public void onError(int eventCode, String msg) {
                                if (myCallBack != null) {
                                    myCallBack.onSuccess(webinarInfoData);
                                }
                            }
                        });
                    }
                });
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (myCallBack != null) {
                    myCallBack.onError(eventCode, msg);
                }
            }
        }, WebinarInfoData.class));
    }

    /**
     * 开始直播
     *
     * @param webinarId  活动id
     * @param liveToken  参会token 嘉宾助理的
     * @param start_type 1-web（默认）， 2-app，3-sdk，4-推拉流，5-定时，6-admin后台， 7-第三方，8-windows客户端
     *                   live_type 开播类型：0-正式直播（默认）；2-彩排
     */

    public static void liveStart(String webinarId, String liveToken, String start_type, CallBack callBack) {
        liveStart(webinarId, liveToken, start_type, "0", callBack);
    }

    public static void liveStart(String webinarId, String liveToken, String start_type, String live_type, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinarId) ? "" : webinarId.trim());

        if (!TextUtils.isEmpty(liveToken)) {
            params.put("live_token", liveToken);
        }
        if (!TextUtils.isEmpty(start_type)) {
            params.put("start_type", start_type);
        }
        if (!TextUtils.isEmpty(live_type)) {
            params.put("live_type", live_type);
        }
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_WEBINAR_LIVE_START), new CoreNetCallback(callBack));
    }

    /**
     * 结束直播
     *
     * @param webinarId 活动id
     * @param liveToken 参会token 嘉宾助理的
     * @param end_type  1-web（默认）， 2-app，3-sdk，4-推拉流，5-定时，6-admin后台， 7-第三方，8-windows客户端
     *                  live_type 开播类型：0-正式直播（默认）；2-彩排
     */

    public static void liveEnd(String webinarId, String liveToken, String end_type, CallBack callBack) {
        liveEnd(webinarId, liveToken, end_type, "0", callBack);
    }

    public static void liveEnd(String webinarId, String liveToken, String end_type, String live_type, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinarId) ? "" : webinarId.trim());

        if (!TextUtils.isEmpty(liveToken)) {
            params.put("live_token", liveToken);
        }
        if (!TextUtils.isEmpty(end_type)) {
            params.put("end_type", end_type);
        }
        if (!TextUtils.isEmpty(live_type)) {
            params.put("live_type", live_type);
        }
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_WEBINAR_LIVE_END), new CoreNetCallback(callBack));
    }

    /**
     * 获取观看 详情
     *
     * @param webinarId   活动id
     * @param is_no_check 1:不检查是否属于当前用户（嘉宾加入检查）
     */
    public static void getWebinarBaseInfo(String webinarId, String is_no_check, CallBack<WebinarBaseInfoData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinarId) ? "" : webinarId.trim());
        if (!TextUtils.isEmpty(is_no_check)) {
            params.put("is_no_check", is_no_check.trim());
        }
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_WEBINAR_BASE_INFO), new CoreNetCallback(callBack, WebinarBaseInfoData.class));
    }

    /**
     * 执行观看授权
     *
     * @param webinarId   活动id
     * @param type        0:免费（默认），1:密码，2：白名单，3：付费，4：邀请码
     * @param verifyValue type对应的值
     * @param callBack
     */
    public static void getWatchAuth(String webinarId, String type, String verifyValue, CallBackV2<WatchAuthInfo> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinarId) ? "" : webinarId.trim());
        if (!TextUtils.isEmpty(verifyValue)) {
            params.put("type", String.valueOf(type));
            params.put("verify_value", verifyValue);
        }
        if (!TextUtils.isEmpty(_visitorId)) {
            params.put("visitor_id", _visitorId);
        }

        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_WEBINAR_WATCH_AUTH), new CoreNetCallback(new CallBackV2<WatchAuthInfo>() {
            @Override
            public void onSuccess(WatchAuthInfo result) {
                _visitorId = result.visitor_id;
                if (null != callBack) {
                    callBack.onSuccess(result);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
            }

            @Override
            public void onError(int eventCode, String msg, WatchAuthInfo result) {
                if (null != callBack) {
                    callBack.onError(eventCode, msg, result);
                }
            }
        }, WatchAuthInfo.class));
    }

    public static void getWatchInfo(final String webinarId, final String recordId, final String nickname, final String email, final String pass, final CallBack<WebinarInfoData> myCallBack) {
        getWatchInit(webinarId, recordId, nickname, email, pass, "", null, myCallBack);
    }

    /**
     * 获取观看 详情
     * watch/sdk-init
     *
     * @param webinarId 活动id
     * @param recordId  回放id
     * @param email     邮箱，访客必填
     * @param nickname  昵称，访客必填
     * @param pass      第三方k值或密码
     * @param k_id      k_id-用户提供 非必传 6.5.2
     */

    public static void getWatchInfo(final String webinarId, final String recordId, final String nickname, final String email, final String pass, final String k_id, final HashMap<String, String> authConfig, final CallBack<WebinarInfoData> myCallBack) {
        initBefore(webinarId, new CallBack<String>() {
            @Override
            public void onSuccess(String result) {
                TokenManger.setGrayId(result);
                getWatchInit(webinarId, recordId, nickname, email, pass, k_id, authConfig, myCallBack);
            }

            @Override
            public void onError(int eventCode, String msg) {
                getWatchInit(webinarId, recordId, nickname, email, pass, k_id, authConfig, myCallBack);
            }
        });
    }

    private static void getWatchInit(final String webinarId, String recordId, String nickname, String email, String pass, final String k_id, final HashMap<String, String> authConfig, final CallBack<WebinarInfoData> myCallBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinarId) ? "" : webinarId.trim());
        if (!TextUtils.isEmpty(recordId)) {
            params.put("record_id", recordId.trim());
        }
        if (!TextUtils.isEmpty(email)) {
            params.put("email", email.trim());
        }
        if (!TextUtils.isEmpty(nickname)) {
            params.put("nickname", nickname.trim());
        }
        if (!TextUtils.isEmpty(pass)) {
            params.put("pass", pass.trim());
        }
        if (!TextUtils.isEmpty(k_id)) {
            params.put("k_id", k_id.trim());
        }

        if (null != authConfig && authConfig.containsKey("auth_model")) {
            params.put("auth_model", authConfig.get("auth_model"));
        }
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_WEBINAR_WATCH_INFO), new CoreNetCallback(new CallBack<WebinarInfoData>() {
            @Override
            public void onSuccess(final WebinarInfoData webinarInfoData) {
                TokenManger.setInteractToken(webinarInfoData.interact.interact_token);
                if (TextUtils.isEmpty(TokenManger.getGrayId())) {
                    TokenManger.setGrayId(webinarInfoData.webinar.userinfo.user_id);
                }
                InteractNetworkRequest.setDevice(webinarInfoData.interact.room_id, "1", null);

                commonConfig(webinarId, new CallBack<CommonConfigData>() {
                    @Override
                    public void onSuccess(CommonConfigData commonConfigData) {
                        if (commonConfigData != null) {
                            webinarInfoData.roomToolsStatusData = commonConfigData.roomTool;
                            webinarInfoData.filters = commonConfigData.keyWord;
                            webinarInfoData.like = commonConfigData.like;
                            webinarInfoData.noticeListInfoData = commonConfigData.noticeListInfoData;
                            webinarInfoData.skinData = commonConfigData.skinData;
                            webinarInfoData.menuListInfoData = commonConfigData.menuListInfoData;
                        }
                        playerConfig(webinarId, new CallBack<PlayerConfigData>() {
                            @Override
                            public void onSuccess(PlayerConfigData result) {
                                if (result != null) {
                                    webinarInfoData.scrollInfoData = result.scrollInfoData;
                                    webinarInfoData.watermarkInfoData = result.watermarkInfoData;
                                }
                                if (myCallBack != null) {
                                    myCallBack.onSuccess(webinarInfoData);
                                }
                            }

                            @Override
                            public void onError(int eventCode, String msg) {
                                if (myCallBack != null) {
                                    myCallBack.onSuccess(webinarInfoData);
                                }
                            }
                        });
                    }

                    @Override
                    public void onError(int eventCode, String msg) {
                        playerConfig(webinarId, new CallBack<PlayerConfigData>() {
                            @Override
                            public void onSuccess(PlayerConfigData result) {
                                if (result != null) {
                                    webinarInfoData.scrollInfoData = result.scrollInfoData;
                                    webinarInfoData.watermarkInfoData = result.watermarkInfoData;
                                }
                                if (myCallBack != null) {
                                    myCallBack.onSuccess(webinarInfoData);
                                }
                            }

                            @Override
                            public void onError(int eventCode, String msg) {
                                if (myCallBack != null) {
                                    myCallBack.onSuccess(webinarInfoData);
                                }
                            }
                        });
                    }
                });
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (myCallBack != null) {
                    myCallBack.onError(eventCode, msg);
                }
            }
        }, WebinarInfoData.class));
    }

    /**
     * 获取公告列表
     */
    public static void getNoticeList(String room_id, int pos, int limit, CallBack<NoticeListInfoData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        limit = limit == 0 ? 10 : limit;
        params.put("room_id", room_id);
        params.put("limit", String.valueOf(limit));
        params.put("pos", String.valueOf(pos * limit));
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_ROOM_NOTICE), new CoreNetCallback(callBack, NoticeListInfoData.class));
    }

    /**
     * 观看端_获取水印设置
     */
    public static void getWatermark(String webinar_id, CallBack<WatermarkInfoData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinar_id) ? "" : webinar_id.trim());
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_WATERMARK), new CoreNetCallback(callBack, WatermarkInfoData.class));
    }

    /**
     * 观看端_获取跑马灯
     */
    public static void getScrolling(String webinar_id, CallBack<ScrollInfoData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinar_id) ? "" : webinar_id.trim());
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_SCROLLING), new CoreNetCallback(callBack, ScrollInfoData.class));
    }

    /**
     * 观看端_观看协议
     */
    public static void getAgreement(String webinar_id, CallBack<AgreementData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinar_id) ? "" : webinar_id.trim());
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_AGREEMENT), new CoreNetCallback(callBack, AgreementData.class));
    }

    /**
     * 观看端_用户同意观看协议
     */
    public static void setUserAgreeAgreement(String webinar_id, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinar_id) ? "" : webinar_id.trim());
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_SET_USER_AGREE_AGREEMENT), new CoreNetCallback(callBack));
    }

    /**
     * 发起端-直播结束生成回放
     * live_type 开播类型：0-正式直播（默认）；2-彩排
     */
    public static void createRecord(String webinar_id, CallBack<CreateRecordData> callBack) {
        createRecord(webinar_id, "0", callBack);
    }

    public static void createRecord(String webinar_id, String live_type, CallBack<CreateRecordData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinar_id) ? "" : webinar_id.trim());
        if (!TextUtils.isEmpty(live_type)) {
            params.put("live_type", live_type);
        }
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_LIVE_CREATE_RECORD), new CoreNetCallback(callBack, CreateRecordData.class));
    }

    /**
     * 发起端-设置默认回放
     * 彩排不支持
     */
    public static void setDefaultRecord(String record_id, CallBack<ScrollInfoData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("record_id", TextUtils.isEmpty(record_id) ? "" : record_id.trim());
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_SET_DEFAULT_RECORD), new CoreNetCallback(callBack, ScrollInfoData.class));
    }

    /**
     * 文件上传
     *
     * @param resfile 图片的base64
     */
    public static void uploadFile(String resfile, final CallBack<String> myCallBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("path", "webinars/img_url");
        params.put("resfile", resfile);
        params.put("type", "image");
        params.put("method", "base64");
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_UPLOAD_FILE), new CoreNetCallback(new CallBack<String>() {
            @Override
            public void onSuccess(String result) {
                String imageUrl = "";
                try {
                    JSONObject objectResult = new JSONObject(result);
                    JSONObject data = objectResult.optJSONObject("data");
                    int code = objectResult.optInt("code");
                    if (code == 200) {
                        if (data != null) {
                            imageUrl = data.optString("domain_url");
                        } else {
                            if (myCallBack != null) {
                                myCallBack.onError(code, "upload image error");
                            }
                        }
                    } else {
                        if (myCallBack != null) {
                            myCallBack.onError(code, objectResult.optString("msg"));
                        }
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                if (myCallBack != null) {
                    myCallBack.onSuccess(imageUrl);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (myCallBack != null) {
                    myCallBack.onError(eventCode, msg);
                }
            }
        }));
    }

    /**
     * 获取当前活动 支持的语言
     */
    public static void getActivityLanguage(String webinar_id, final CallBack<LanguageListData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinar_id) ? "" : webinar_id.trim());
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_LANGUAGE), new CoreNetCallback(callBack, LanguageListData.class));
    }


    /**
     * 刷新token
     */
    public static void refreshToken(final CallBack<String> callBack) {
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(null), CoreApiConstant.API_REFRESH_TOKEN), new CoreNetCallback(new CallBack<String>() {
            @Override
            public void onSuccess(String result) {
                try {
                    JSONObject objectResult = new JSONObject(result);
                    JSONObject data = objectResult.optJSONObject("data");
                    int code = objectResult.optInt("code");
                    if (code == 200) {
                        if (callBack != null) {
                            callBack.onSuccess(data.optString("token"));
                        }
                        TokenManger.setToken(data.optString("token"));
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
            }
        }));
    }

    /**
     * 获取分享信息
     */
    public static void getShareInfo(String webinar_id, final CallBack<String> myCallBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinar_id) ? "" : webinar_id.trim());
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_SHARE_INFO), new CoreNetCallback(new CallBack<String>() {
            @Override
            public void onSuccess(String result) {
                if (myCallBack != null) {
                    myCallBack.onSuccess(result);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (myCallBack != null) {
                    myCallBack.onError(eventCode, msg);
                }
            }
        }));
    }

    /**
     * 获取角色信息
     */
    public static void getRoleName(String webinar_id, final CallBack<RoleNameData> myCallBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinar_id) ? "" : webinar_id.trim());
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_ROLE_NAME), new CoreNetCallback(myCallBack, RoleNameData.class));
    }

    /**
     * 编辑角色信息
     */
    public static void editRoleName(String webinar_id, String type, String name, final CallBack<RoleNameData> myCallBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinar_id) ? "" : webinar_id.trim());
        params.put("type", TextUtils.isEmpty(type) ? "" : type.trim());
        params.put("name", TextUtils.isEmpty(name) ? "" : name.trim());
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_EDIT_ROLE_NAME), new CoreNetCallback(myCallBack, RoleNameData.class));
    }

    /**
     * 获取配置信息
     * scene_id 使用场景：1权限检测（默认1）  2获取配置项选中值
     * 活动id，1、传活动id时，返回活动id+活动创建者相关的配置项信息 2、不传活动id时，获取登录用户的配置项信息
     * 有webinar_id时，必传
     */
    public static void getConfigList(String webinar_id, String webinar_user_id, final CallBack<String> myCallBack) {
        getConfigList("2", webinar_id, webinar_user_id, myCallBack);
    }

    public static void getConfigList(String scene_id, String webinar_id, String webinar_user_id, final CallBack<String> myCallBack) {
        HashMap<String, String> params = new HashMap<>();
        if (!TextUtils.isEmpty(scene_id))
            params.put("scene_id", scene_id);
        params.put("webinar_user_id", webinar_user_id);
        if (!TextUtils.isEmpty(webinar_id) && !TextUtils.isEmpty(webinar_user_id)) {
            params.put("webinar_id", webinar_id);
            params.put("webinar_user_id", webinar_user_id);
        }
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_CONFIG_LIST), new CoreNetCallback(new CallBack<String>() {
            @Override
            public void onSuccess(String result) {
                if (myCallBack != null) {
                    myCallBack.onSuccess(result);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (myCallBack != null) {
                    myCallBack.onError(eventCode, msg);
                }
            }
        }));
    }

    /**
     * 标签列表接口
     */
    public static void getLabelList(String webinar_id, String name, String pos, String limit, final CallBack<LabelListInfoData> myCallBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", TextUtils.isEmpty(webinar_id) ? "" : webinar_id.trim());
        if (!TextUtils.isEmpty(name)) {
            params.put("name", name);
        }
        if (!TextUtils.isEmpty(pos)) {
            params.put("pos", pos);
        }
        if (!TextUtils.isEmpty(limit)) {
            params.put("limit", limit);
        }
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_LABEL_LIST), new CoreNetCallback(myCallBack, LabelListInfoData.class));
    }

    /**
     * 标签列表接口
     */
    public static void createLabelList(String name, final CallBack<String> myCallBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("name", TextUtils.isEmpty(name) ? "" : name.trim());

        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_LABEL_CREATE), new CoreNetCallback(myCallBack));
    }

    /**
     * 获取当前轮询用户
     * is_next 是否是下一组， 0：当前组， 1：下一组
     */
    public static void getRoundUsers(String room_id, String is_next, final CallBack<RoundUserListData> myCallBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", TextUtils.isEmpty(room_id) ? "" : room_id.trim());
        params.put("is_next", TextUtils.isEmpty(is_next) ? "" : is_next.trim());
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_ROUND_USERS), new CoreNetCallback(myCallBack, RoundUserListData.class));
    }


    /**
     * 互动配置聚合接口
     */
    public static void commonConfig(String webinar_id, CallBack<CommonConfigData> callBack) {
        try {
            HashMap<String, String> params = new HashMap<>();
            params.put("webinar_id", webinar_id);
            params.put("tags", "skin,screen-poster,room-tool,webinar-tag,menu,goods-default,adv-default,invite-card,keywords,like,announcement,sign,timer");
            VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_COMMON_CONFIG), new CoreNetCallback(callBack, CommonConfigData.class));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    /**
     * 互动播放器聚合配置
     */
    public static void playerConfig(String webinar_id, CallBack<PlayerConfigData> callBack) {
        try {
            HashMap<String, String> params = new HashMap<>();
            params.put("webinar_id", webinar_id);
            params.put("tags", "definition,screen-config,water-mark");
            VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_PLAYER_CONFIG), new CoreNetCallback(callBack, PlayerConfigData.class));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    /**
     * 互动播放器聚合配置
     */
    public static void getStreamPushAddress(String webinar_id, CallBack<PlayerConfigData> callBack) {
        try {
            HashMap<String, String> params = new HashMap<>();
            params.put("webinar_id", webinar_id);
            VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_STREAM_PUSH_ADDRESS), new CoreNetCallback(callBack, PlayerConfigData.class));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    /**
     * 获取暖场视频详情接口
     */
    public static void getWarmInfo(String webinar_id, CallBack<WarmInfoData> callBack) {
        try {
            HashMap<String, String> params = new HashMap<>();
            params.put("webinar_id", webinar_id);
            VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_WARM_INFO), new CoreNetCallback(callBack, WarmInfoData.class));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    /**
     * 查询章节信息-章节打点
     *
     * @param record_id saas 回放id
     */
    public static void getRecordChaptersList(String record_id, CallBack<RecordChaptersData> callBack) {
        try {
            HashMap<String, String> params = new HashMap<>();
            params.put("record_id", record_id);
            VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_RECORD_CHAPTERS_LIST), new CoreNetCallback(callBack, RecordChaptersData.class));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    /**
     * 查询回放列表
     *
     * @param webinar_id saas 回放id
     */
    public static void getRecordList(String webinar_id, int pos, int limit, CallBack<RecordsData> callBack) {
        try {
            String vhallId = VhallSDK.getUserId();
            vhallId = (vhallId == null ? "" : vhallId);

            HashMap<String, String> params = new HashMap<>();
            params.put("webinar_id", webinar_id);
            params.put("pos", pos+"");
            params.put("limit", limit+"");
            VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_RECORD_LIST), new CoreNetCallback(callBack, RecordsData.class));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    /**
     * 查询文件列表
     *
     * @param webinar_id saas 回放id
     */
    public static void getFilesList(String webinar_id,String menu_id, CallBack<FilesData> callBack) {
        try {
            HashMap<String, String> params = new HashMap<>();
            params.put("webinar_id", webinar_id);
            params.put("menu_id", menu_id);
            VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_FILES_LIST), new CoreNetCallback(callBack, FilesData.class));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    /**
     * 检测下载
     *
     * @param webinar_id saas 回放id
     *  http://yapi.vhall.domain/project/101/interface/api/54519
     */
    public static void getFileDownLoadUrl(String webinar_id,String menu_id,String file_id,CallBack<String> callBack) {
        try {
            String vhallId = VhallSDK.getUserId();
            vhallId = (vhallId == null ? "" : vhallId);

            HashMap<String, String> params = new HashMap<>();
            params.put("webinar_id", webinar_id);
            params.put("menu_id", menu_id);
            params.put("file_id", file_id);
            params.put("visit_id", vhallId);
            params.put("download_type", "3");

            VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_CHECK_DOWNLOAD), new IVHNetCallback() {
                @Override
                public void onFailure(VHNetResponse response, Exception e) {
                    if (callBack != null) {
                        ApiException exception = CustomException.handleException(response.getResponseCode(), e);
                        if (callBack instanceof CallBackV2) {
                            response(response);
                        } else {
                            callBack.onError(exception.getCode(), exception.getMessage());
                        }
                    }
                }

                @Override
                public void response(VHNetResponse response) {
                    if (callBack != null && response != null) {
                        try {
                            JSONObject jsonObject = new JSONObject(response.getResult());
                            int    code = jsonObject.optInt("code");
                            String msg = jsonObject.optString("msg");
                            if (code == 200) {
                                callBack.onSuccess(jsonObject.optJSONObject("data").optString("download_url") );
                            } else {
                                callBack.onError(code,msg);
                            }
                        } catch (JSONException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                }
            });
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }
}
