package com.vhall.vhss.netutils;

import android.os.Bundle;
import android.text.TextUtils;

import com.vhall.httpclient.core.IVHNetCallback;
import com.vhall.httpclient.core.VHNetResponse;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.CallBackV2;
import com.vhall.vhss.TokenManger;
import com.vhall.vhss.api.CoreApiConstant;
import com.vhall.vhss.data.ResponseJe;
import com.vhall.vhss.data.VhssUserInfoData;
import com.vhall.vhss.exception.ApiException;
import com.vhall.vhss.exception.CustomException;
import com.vhall.vhss.network.ApiKeyConstants;
import com.vhall.vhss.network.UserNetworkRequest;

import java.util.HashMap;
import java.util.Map;


/**
 * @author cyl
 */
public class CoreNetCallback<T> implements IVHNetCallback {
    /**
     * 网络请求地址
     */
    public static final String REQUEST_URL = "REQUEST_URL";
    /**
     * 用户名
     */
    public static final String USER_NAME = "user_name";
    /**
     * 密码
     */
    public static final String PASS_WORD = "pass_word";
    /**
     * 动态码
     */
    public static final String DYNAMIC_CODE = "dynamic_code";

    /**
     * 三方id
     */
    public static final String THIRD_ID = "thirdId";
    /**
     * 用户头像
     */
    public static final String HEAD_NET_URL = "headNetUrl";

    private static Map<String, String> sLoginParams = new HashMap<>();


    private CallBack callback;

    private Class<T> clz;

    public CoreNetCallback(CallBack callback) {
        this.callback = callback;
    }

    public CoreNetCallback(CallBack callback, Class<T> clz) {
        this.callback = callback;
        this.clz = clz;
    }

    private Bundle bundle;

    public CoreNetCallback(CallBack callBack, Class<T> clz, Bundle bundle) {
        this.callback = callBack;
        this.clz = clz;
        this.bundle = bundle;
        if (bundle != null) {
            sLoginParams.clear();
            sLoginParams.put(USER_NAME, bundle.getString(USER_NAME));
            sLoginParams.put(PASS_WORD, bundle.getString(PASS_WORD));
            sLoginParams.put(DYNAMIC_CODE, bundle.getString(DYNAMIC_CODE));
            sLoginParams.put(THIRD_ID, bundle.getString(THIRD_ID));
            sLoginParams.put(HEAD_NET_URL, bundle.getString(HEAD_NET_URL));
        }
    }

    @Override
    public void onFailure(VHNetResponse response, Exception e) {
        if (callback != null) {
            ApiException exception = CustomException.handleException(response.getResponseCode(), e);
            if (callback instanceof CallBackV2) {
                response(response);
            } else {
                callback.onError(exception.getCode(), exception.getMessage());
            }
        }
    }

    @Override
    public void response(VHNetResponse response) {
        if (callback != null && response != null) {
            ResponseJe data = new ResponseJe(response.getResult(), clz);
            int code = data.getCode();
            if (code != 200) {
                if (!retryLogin(code)) {
                    if (isTokenExpired(code)) {
                        TokenManger.liveOutByError();
                    }
                }
                String msg = data.getMsg();
                if (TextUtils.isEmpty(msg))
                    msg = response.getResult();
                if (callback instanceof CallBackV2) {
                    ((CallBackV2) callback).onError(data.getCode(), msg, data.getData());
                } else {
                    callback.onError(data.getCode(), msg);
                }
                return;
            }
            if (null != clz) {
                try {
                    callback.onSuccess(data.getData());
                } catch (Exception e) {
                    if (callback instanceof CallBackV2) {
                        ((CallBackV2) callback).onError(-1, e.getMessage(), data.getData());
                    } else {
                        callback.onError(-1, e.getMessage());
                    }
                }
            } else {
                callback.onSuccess(response.getResult());
            }
        }
    }

    private boolean isTokenExpired(int code) {
        return (code == 511006 || code == 511005 || code == 511007 || code == 11005);
    }

    private boolean retryLogin(int code) {
        boolean retry = false;
        //当前请求的url 不包含 用户名/三方id 登陆的url
        if (!isLoginUrl()) {
            if (isTokenExpired(code)) {
                if (TextUtils.isEmpty(sLoginParams.get(THIRD_ID))) {
                    retryByUser();
                } else {
                    retryByThirdId();
                }
                retry = true;
            }
        }
        return retry;
    }

    /**
     * 1、用户登陆
     * 2、三番id登陆
     * 3、退出登陆
     * 以上均不处理重新登陆
     *
     * @return
     */
    private boolean isLoginUrl() {
        if (bundle == null) {
            return false;
        }
        String requestUrl = bundle.getString(REQUEST_URL);
        if (!TextUtils.isEmpty(requestUrl)) {
            return requestUrl.contains(CoreApiConstant.API_USER_LOGIN) || requestUrl.contains(CoreApiConstant.API_USER_LOGIN_THIRDID) || requestUrl.contains(CoreApiConstant.API_USER_LOGOUT);
        }
        return false;

    }

    /**
     * 通过三方id重试
     */
    private void retryByThirdId() {
        String userName = sLoginParams.get(USER_NAME);
        String thirdId = sLoginParams.get(THIRD_ID);
        String headIcon = sLoginParams.get(HEAD_NET_URL);
        if (TextUtils.isEmpty(thirdId) || TextUtils.isEmpty(userName)) {
            return;
        }

        Map<String, String> map = new HashMap();
        map.put(ApiKeyConstants.KEY_THIRD_USER_ID, thirdId);
        map.put(ApiKeyConstants.KEY_NICK_NAME, userName);
        map.put(ApiKeyConstants.KEY_HEAD_NET_URL, headIcon);
        UserNetworkRequest.loginByThirdId(map, new CallBack<VhssUserInfoData>() {
            @Override
            public void onSuccess(VhssUserInfoData result) {

            }

            @Override
            public void onError(int eventCode, String msg) {

            }
        });
    }

    /**
     * 通过用户名/密码重试
     */
    private void retryByUser() {

        String userName = sLoginParams.get(USER_NAME);
        String pwd = sLoginParams.get(PASS_WORD);
        String dynamicCode = sLoginParams.get(DYNAMIC_CODE);
        if (TextUtils.isEmpty(userName) || TextUtils.isEmpty(pwd)) {
            return;
        }
        UserNetworkRequest.login(userName, pwd, dynamicCode, new CallBack<VhssUserInfoData>() {
            @Override
            public void onSuccess(VhssUserInfoData result) {

            }

            @Override
            public void onError(int eventCode, String msg) {

            }
        });


    }
}
