package com.vhall.vhss.data;


import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hkl
 * Date: 2020/11/13 9:50 AM
 */

public class WebinarInfoData implements Serializable {
    /**
     * join_info : {"nickname":"张三","avata":"dolore cillum sint","join_id":123456,"role_name":"host","third_party_user_id":"123","is_gag":0}
     * permission : []
     * webinar : {"id":434924568,"subject":"广交会直播","mode":2,"live_time":3600,"document_id":12,"start_time":"2020-10-16 00:37","img_url":" http://t-alistatic01.e.vhall.com/static/img/v35-webinar.png","userinfo":{"nickname":"张三","avata":"nostrud eu exercitation e"}}
     * cut_record_status : 1
     * is_recording : 1
     * record_tip : 1
     * interact : {"room_id":"lss_fba2a2eb","interact_token":"eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.InZpc2l0X3Rlc3RfdmlzaXRvcl8xMjMi.K2r8yHIF2yKIgHn5Y0kipybQMgepW3GlsKnvL482DZE","inav_id":"inav_97c3d4a4","channel_id":"ch_08973c36","paas_access_token":"access:fd8d3653:a13982a5a4e851fc"}
     * live_domain_customization : http://www.baidu.com
     * share_id : u-123
     */

    public JoinInfoBean join_info;
    public WebinarBean webinar;
    public int record_tip;//是否提示生成回放，1提示0不提示
    public InteractBean interact;
    public String share_id;//分享id
    public int webinar_show_type = 0;//0 竖屏 1横屏
    public List<String> permission;
    public NumDataBean pv;//热度
    public NumDataBean online;//在线人数
    public SsoBean ssoBean;//设置单点登录
    public SeatBean seatBean;//机位信息
    public int cast_screen;//投屏权限：0-无权限投屏，1-有权限投屏
    public int cheat_num;//欺骗系数（平安用）
    public int is_recording;//是否正在录制1是0否
    public String paas_record_id;//回放id
    public String director_stream;//当前云导播房间有没有流
    public String live_type;//直播类型 live_type:0-正式（默认）；2-彩排
    /**
     * report_data : {" vid":-9.533103272069155E7,"join_id":-3.5397814185050435E7,"biz_id":9972755,"guid":"ad","vfid":-49725575,"switch_id":5.555076176181099E7,"report_extra":"{\"report_extra\":{\"join_id\":\"10000\",\"switch_id\":27689}}"}
     */

    public ReportDataBean report_data;

    public RoomToolsStatusData roomToolsStatusData;
    public WatermarkInfoData watermarkInfoData;
    public ScrollInfoData scrollInfoData;
    public NoticeListInfoData noticeListInfoData;
    public MenuListInfoData menuListInfoData;
    public SkinData skinData;
    public List<String> filters;
    public int like;
    /**
     * 场次信息
     */
    public SwitchBean switchBean;

    public String raw;
    public PermissionKeyBean permissionKey;
    public RecordBean record;


    public WebinarInfoData() {
    }


    public WebinarInfoData(JSONObject object) {
        raw = object.toString();
        this.record_tip = object.optInt("record_tip");
        this.cast_screen = object.optInt("cast_screen");
        this.cheat_num = object.optInt("cheat_num");
        this.webinar_show_type = object.optInt("webinar_show_type", 0);
        this.share_id = object.optString("share_id");
        this.paas_record_id = object.optString("paas_record_id");
        this.director_stream = object.optString("director_stream");
        this.live_type = object.optString("live_type");
        this.is_recording = object.optInt("is_recording");
        JSONObject join_infoObject = object.optJSONObject("join_info");
        if (join_infoObject != null) {
            this.join_info = new JoinInfoBean(join_infoObject);
        }
        JSONObject recordObject = object.optJSONObject("record");
        if (recordObject != null) {
            this.record = new RecordBean(recordObject);
        }
        JSONObject webinarObject = object.optJSONObject("webinar");
        if (webinarObject != null) {
            this.webinar = new WebinarBean(webinarObject);
        }
        JSONObject switchObject = object.optJSONObject("switch");
        if (switchObject != null) {
            this.switchBean = new SwitchBean(switchObject);
        }
        JSONObject interactObject = object.optJSONObject("interact");
        if (interactObject != null) {
            this.interact = new InteractBean(interactObject);
        }
        JSONObject pvObject = object.optJSONObject("pv");
        if (pvObject != null) {
            this.pv = new NumDataBean(pvObject);
        }
        JSONObject reportDataObject = object.optJSONObject("report_data");
        if (reportDataObject != null) {
            this.report_data = new ReportDataBean(reportDataObject);
        }
        JSONObject onlineObject = object.optJSONObject("online");
        if (onlineObject != null) {
            this.online = new NumDataBean(onlineObject);
        }
        JSONObject ssoObject = object.optJSONObject("sso");
        if (ssoObject != null) {
            this.ssoBean = new SsoBean(ssoObject);
        }
        JSONObject seatObject = object.optJSONObject("seat");
        if (seatObject != null) {
            this.seatBean = new SeatBean(seatObject);
        }
        JSONObject permissionKeyObject = object.optJSONObject("permissionKey");
        if (permissionKeyObject != null) {
            this.permissionKey = new PermissionKeyBean(permissionKeyObject);
        }
        JSONArray permissionArray = object.optJSONArray("permission");
        if (permissionArray != null) {
            this.permission = new ArrayList<>();
            for (int i = 0; i < permissionArray.length(); i++) {
                this.permission.add(permissionArray.optString(i));
            }
        }
    }

    public int getWebinar_show_type() {
        return webinar_show_type;
    }

    public void setWebinar_show_type(int webinar_show_type) {
        this.webinar_show_type = webinar_show_type;
    }

    public List<String> getPermission() {
        return permission;
    }

    public void setPermission(List<String> permission) {
        this.permission = permission;
    }

    public JoinInfoBean getJoin_info() {
        return join_info;
    }

    public void setJoin_info(JoinInfoBean join_info) {
        this.join_info = join_info;
    }

    public WebinarBean getWebinar() {
        return webinar;
    }

    public void setWebinar(WebinarBean webinar) {
        this.webinar = webinar;
    }


    public int getRecord_tip() {
        return record_tip;
    }

    public void setRecord_tip(int record_tip) {
        this.record_tip = record_tip;
    }

    public InteractBean getInteract() {
        return interact;
    }

    public void setInteract(InteractBean interact) {
        this.interact = interact;
    }

    public String getShare_id() {
        return share_id;
    }

    public void setShare_id(String share_id) {
        this.share_id = share_id;
    }


    public static class JoinInfoBean implements Serializable {
        /**
         * nickname : 张三
         * avata : dolore cillum sint
         * join_id : 123456
         * role_name : host
         * third_party_user_id : 123
         * is_gag : 0
         */

        public String nickname;
        public String avatar;
        public String join_id;
        public String role_name;
        public String third_party_user_id;
        public String privacies;
        public int is_gag;
        public int is_kick;

        public JoinInfoBean(JSONObject object) {

            this.nickname = object.optString("nickname");
            this.avatar = object.optString("avatar");
            this.join_id = object.optString("join_id");
            this.role_name = object.optString("role_name");
            this.privacies = object.optString("privacies");
            this.third_party_user_id = object.optString("third_party_user_id");
            this.is_gag = object.optInt("is_gag");
            this.is_kick = object.optInt("is_kick");
        }

        public JoinInfoBean() {

        }

        public String getNickname() {
            return nickname;
        }

        public void setNickname(String nickname) {
            this.nickname = nickname;
        }

        public String getAvata() {
            return avatar;
        }

        public void setAvata(String avata) {
            this.avatar = avata;
        }

        public String getJoin_id() {
            return join_id;
        }

        public void setJoin_id(String join_id) {
            this.join_id = join_id;
        }

        public String getRole_name() {
            return role_name;
        }

        public void setRole_name(String role_name) {
            this.role_name = role_name;
        }

        public String getThird_party_user_id() {
            return third_party_user_id;
        }

        public void setThird_party_user_id(String third_party_user_id) {
            this.third_party_user_id = third_party_user_id;
        }

        public int getIs_gag() {
            return is_gag;
        }

        public void setIs_gag(int is_gag) {
            this.is_gag = is_gag;
        }
    }

    public static class WebinarBean implements Serializable {
        /**
         * id : 434924568
         * subject : 广交会直播
         * mode : 2
         * live_time : 3600
         * document_id : 12
         * start_time : 2020-10-16 00:37
         * img_url :  http://t-alistatic01.e.vhall.com/static/img/v35-webinar.png
         * userinfo : {"nickname":"张三","avata":"nostrud eu exercitation e"}
         */

        public String id;
        public String subject;
        public String introduction;
        public String mode;//webinar_type 直播类型 1-音频、2-视频、3-互动
        public String live_time;
        public int type;//1-直播中，2-预约，3-结束，4-点播，5-回放
        public String document_id;
        public String start_time;
        public String img_url;
        public UserinfoBean userinfo;
        public int inav_num;//连麦人数 1v5 = 6 1v15=16
        public int no_delay_webinar;//是否无延迟直播 1:是 0:否
        public int is_director;//是否支持云导播 1:开启 0:关闭
        public int webinar_show_type = -1;//横竖屏 0 竖屏 1横屏
        public int live_subtitle_type = 0;//0：关闭，1：中文转中文字幕，2：中文转中英字幕，3：中文转英文字幕，4：英文转英文字母，5：英文转中英字幕

        public WebinarBean(JSONObject object) {

            this.id = object.optString("id");
            this.subject = object.optString("subject");
            this.introduction = object.optString("introduction");
            this.mode = object.optString("mode");
            this.live_time = object.optString("live_time");
            this.document_id = object.optString("document_id");
            this.start_time = object.optString("start_time");
            this.type = object.optInt("type");
            this.img_url = object.optString("img_url");
            this.inav_num = object.optInt("inav_num");
            this.no_delay_webinar = object.optInt("no_delay_webinar");
            this.is_director = object.optInt("is_director");
            this.webinar_show_type = object.optInt("webinar_show_type", -1);
            this.live_subtitle_type = object.optInt("live_subtitle_type", 0);
            JSONObject userinfoObject = object.optJSONObject("userinfo");
            if (userinfoObject != null) {
                this.userinfo = new UserinfoBean(userinfoObject);
            }
        }

        public WebinarBean() {

        }

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getSubject() {
            return subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getMode() {
            return mode;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public String getLive_time() {
            return live_time;
        }

        public void setLive_time(String live_time) {
            this.live_time = live_time;
        }

        public String getDocument_id() {
            return document_id;
        }

        public void setDocument_id(String document_id) {
            this.document_id = document_id;
        }

        public String getStart_time() {
            return start_time;
        }

        public void setStart_time(String start_time) {
            this.start_time = start_time;
        }

        public String getImg_url() {
            return img_url;
        }

        public void setImg_url(String img_url) {
            this.img_url = img_url;
        }

        public UserinfoBean getUserinfo() {
            return userinfo;
        }

        public void setUserinfo(UserinfoBean userinfo) {
            this.userinfo = userinfo;
        }

        public static class UserinfoBean implements Serializable {
            /**
             * nickname : 张三
             * avata : nostrud eu exercitation e
             */

            public String nickname;
            public String avatar;
            public String user_id;
            public String attentioned_count;

            public UserinfoBean() {
            }

            public UserinfoBean(JSONObject object) {

                this.nickname = object.optString("nickname");
                this.avatar = object.optString("avatar");
                this.user_id = object.optString("user_id");
                this.attentioned_count = object.optString("attentioned_count");
            }

            public String getNickname() {
                return nickname;
            }

            public void setNickname(String nickname) {
                this.nickname = nickname;
            }

            public String getAvatar() {
                return avatar;
            }

            public void setAvatar(String avatar) {
                this.avatar = avatar;
            }
        }
    }

    public static class InteractBean implements Serializable {
        /**
         * room_id : lss_fba2a2eb
         * interact_token : eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.InZpc2l0X3Rlc3RfdmlzaXRvcl8xMjMi.K2r8yHIF2yKIgHn5Y0kipybQMgepW3GlsKnvL482DZE
         * inav_id : inav_97c3d4a4
         * channel_id : ch_08973c36
         * paas_access_token : access:fd8d3653:a13982a5a4e851fc
         */

        public String room_id;
        public String interact_token;
        public String inav_id;
        public String channel_id;
        public String paas_access_token;
        public String paas_app_id;

        public InteractBean(JSONObject object) {

            this.room_id = object.optString("room_id");
            this.interact_token = object.optString("interact_token");
            this.inav_id = object.optString("inav_id");
            this.channel_id = object.optString("channel_id");
            this.paas_access_token = object.optString("paas_access_token");
            this.paas_app_id = object.optString("paas_app_id");
        }

        public InteractBean() {

        }

        public String getRoom_id() {
            return room_id;
        }

        public void setRoom_id(String room_id) {
            this.room_id = room_id;
        }

        public String getInteract_token() {
            return interact_token;
        }

        public void setInteract_token(String interact_token) {
            this.interact_token = interact_token;
        }

        public String getInav_id() {
            return inav_id;
        }

        public void setInav_id(String inav_id) {
            this.inav_id = inav_id;
        }

        public String getChannel_id() {
            return channel_id;
        }

        public void setChannel_id(String channel_id) {
            this.channel_id = channel_id;
        }

        public String getPaas_access_token() {
            return paas_access_token;
        }

        public void setPaas_access_token(String paas_access_token) {
            this.paas_access_token = paas_access_token;
        }
    }

    // 服务端 1直播 2预约 3结束 4点播 5回放
    // saas对外展示 1直播 2预约 3结束 4回放 5点播
    public static int getStatusStr(int status) {
        int statusStr = 2;
        switch (status) {
            case 1:
            case 2:
            case 3:
                statusStr = status;
                break;
            case 4:
                statusStr = 5;
                break;
            case 5:
                statusStr = 4;
                break;
        }
        return statusStr;
    }

    public static class ReportDataBean implements Serializable {
        /**
         * vid : -9.533103272069155E7
         * biz_id : 9972755
         * guid : ad
         * vfid : -49725575
         * report_extra : {"report_extra":{"join_id":"10000","switch_id":27689}}
         */

        public String vid;
        public String biz_id;
        public String guid;
        public String vfid;
        public String report_extra;

        public ReportDataBean(JSONObject object) {
            this.vid = object.optString("vid");
            this.biz_id = object.optString("biz_id");
            this.guid = object.optString("guid");
            this.vfid = object.optString("vfid");
            this.report_extra = object.optString("report_extra");
        }

        public ReportDataBean() {

        }
    }

    public static class NumDataBean implements Serializable {
        public int virtual;
        public int real;
        public int show;

        public NumDataBean() {
        }

        public NumDataBean(JSONObject object) {
            this.virtual = object.optInt("virtual");
            this.real = object.optInt("real");
            this.show = object.optInt("show");
        }
    }

    public static class SsoBean implements Serializable {
        public int enabled;//是否开启 1是0否
        public String kick_id;// 单点登录唯一标示

        public SsoBean() {
        }

        public SsoBean(JSONObject object) {
            this.enabled = object.optInt("enabled");
            this.kick_id = object.optString("kick_id");
        }
    }

    public static class SeatBean implements Serializable {
        public String id;
        public String room_id;
        public String inav_id;
        public String camera_num;
        public String name;

        public SeatBean() {
        }

        public SeatBean(JSONObject object) {
            this.id = object.optString("id");
            this.room_id = object.optString("room_id");
            this.inav_id = object.optString("inav_id");
            this.camera_num = object.optString("camera_num");
            this.name = object.optString("name");
        }
    }

    public static class SwitchBean implements Serializable {
        public String switch_id;//场次id
        public String start_time;//本场开始时间
        public String end_time;//本场结束时间
        public int start_type;//开始类型 1:WEB 2:APP 3:SDK 4:推拉流 5:定时 6:Admin后台
        public int end_type;//结束类型 1:WEB 2:APP 3:SDK 4:推拉流 5:定时 6:Admin后台
        public int type;//类型 0 直播 1录制


        public SwitchBean() {
        }

        public SwitchBean(JSONObject object) {
            this.switch_id = object.optString("switch_id");
            this.start_time = object.optString("start_time");
            this.end_time = object.optString("end_time");
            this.start_type = object.optInt("start_type");
            this.end_type = object.optInt("end_type");
            this.type = object.optInt("type");
        }
    }


    public static class PermissionKeyBean implements Serializable {
        public String ui_hide_logo_but_show_login;
        public String ui_hide_live_helper;
        public String ui_hide_favicon;
        public String ui_hide_hostOnly;
        public String ui_hide_share;
        public String ui_hide_guest_normal_userlist;
        public String ui_hide_assistant_userlist;
        public String ui_hide_host_userlist_nums;
        public String ui_hide_guest_userlist_nums;
        public String ui_hide_handsUp;
        public String ui_hide_lottery;
        public String members_manager;
        public String ui_hide_survey;
        public String close_assistant_flip_doc;
        public String comment_check;
        public String ui_is_hide_qa_button;
        public String disable_msg;
        public String ui_show_redpacket;
        public String webinar_notice;
        public String cut_record;
        public String ui_hide_live_end;
        public String ui_hide_sign_in;
        public String btn_thirdway;
        public String is_interact_and_host;
        public String is_interact;
        public String is_membermanage;
        public String rebroadcast;
        public String virtual_user;
        public String hide_document;
        public String waiting_video_file;
        public String webinar_timer;
        public String webinar_group;
        public String video_polling;
        public String speak_manage;
        public String webinar_director;
        public String ui_is_show_estoppel;
        public String initiate_embed_function_close;
        public String live_rehearsal;

        public PermissionKeyBean() {
        }

        public PermissionKeyBean(JSONObject object) {
            this.ui_hide_logo_but_show_login = object.optString("ui.hide_logo_but_show_login");
            this.ui_hide_live_helper = object.optString("ui.hide_live_helper");
            this.ui_hide_favicon = object.optString("ui.hide_favicon");
            this.ui_hide_hostOnly = object.optString("ui.hide_hostOnly");
            this.ui_hide_share = object.optString("ui.hide_share");
            this.ui_hide_guest_normal_userlist = object.optString("ui.hide_guest_normal_userlist");
            this.ui_hide_assistant_userlist = object.optString("ui.hide_assistant_userlist");
            this.ui_hide_host_userlist_nums = object.optString("ui.hide_host_userlist_nums");
            this.ui_hide_guest_userlist_nums = object.optString("ui.hide_guest_userlist_nums");
            this.ui_hide_handsUp = object.optString("ui.hide_handsUp");
            this.ui_hide_lottery = object.optString("ui.hide_lottery");
            this.members_manager = object.optString("members_manager");
            this.ui_hide_survey = object.optString("ui.hide_survey");
            this.close_assistant_flip_doc = object.optString("close_assistant_flip_doc");
            this.comment_check = object.optString("comment_check");
            this.ui_is_hide_qa_button = object.optString("ui.is_hide_qa_button");
            this.disable_msg = object.optString("disable_msg");
            this.ui_show_redpacket = object.optString("ui.show_redpacket");
            this.webinar_notice = object.optString("webinar_notice");
            this.cut_record = object.optString("cut_record");
            this.ui_hide_live_end = object.optString("ui.hide_live_end");
            this.ui_hide_sign_in = object.optString("ui.hide_sign_in");
            this.btn_thirdway = object.optString("btn_thirdway");
            this.is_interact_and_host = object.optString("is_interact_and_host");
            this.is_interact = object.optString("is_interact");
            this.is_membermanage = object.optString("is_membermanage");
            this.rebroadcast = object.optString("rebroadcast");
            this.virtual_user = object.optString("virtual_user");
            this.hide_document = object.optString("hide-document");
            this.waiting_video_file = object.optString("waiting.video.file");
            this.webinar_timer = object.optString("webinar.timer");
            this.webinar_group = object.optString("webinar.group");
            this.video_polling = object.optString("video_polling");
            this.speak_manage = object.optString("speak_manage");
            this.webinar_director = object.optString("webinar.director");
            this.ui_is_show_estoppel = object.optString("ui.is_show_estoppel");
            this.initiate_embed_function_close = object.optString("initiate_embed_function_close");
            this.live_rehearsal = object.optString("live_rehearsal");

        }
    }


    public static class RecordBean implements Serializable {
        public String paas_record_id;
        public String record_id;
        public String record_remark_layout;
        public String preview_paas_record_id;
        public String encrypt_status;

        public RecordBean() {
        }

        public RecordBean(JSONObject object) {
            this.paas_record_id = object.optString("paas_record_id");
            this.record_id = object.optString("record_id");
            this.record_remark_layout = object.optString("record_remark_layout");
            this.preview_paas_record_id = object.optString("preview_paas_record_id");
            this.encrypt_status = object.optString("encrypt_status");
        }
    }
}
