package com.vhall.vhss.data;

import android.text.TextUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;

/**
 * @author hkl
 * Date: 2020/11/30 6:33 PM
 */
public class WatermarkInfoData implements Serializable {

    public String webinar_id;
    public int watermark_open;//是否开启水印  1 开启 0 关闭
    public String img_url;
    public int img_alpha;
    public int img_position;
    /**
     * 文档：水印类型+内容
     */
    public WatermarkTypeInfo doc_watermark_type;
    /**
     * 文档：水印字号
     */
    public String doc_font_size;
    /**
     * 文档：水印文字颜色
     */
    public String doc_font_color;
    /**
     * 文档：水印文字不透明度
     */
    public String doc_transparency;
    /**
     * 文档：水印是否开启
     */
    public String doc_watermark_open;

    public String raw;

    public WatermarkInfoData(JSONObject object) {
        raw = object.toString();
        this.webinar_id = object.optString("webinar_id");
        this.img_url = object.optString("img_url");
        this.img_alpha = object.optInt("img_alpha");
        this.img_position = object.optInt("img_position");
        this.watermark_open = object.optInt("watermark_open");

        String docWatermarkTypeOrigin = object.optString("doc_watermark_type");
        if (!TextUtils.isEmpty(docWatermarkTypeOrigin)) {
            try {
                JSONObject watermarkType = new JSONObject(docWatermarkTypeOrigin);
                WatermarkTypeInfo typeInfo = new WatermarkTypeInfo();
                typeInfo.text = watermarkType.optString("text");
                typeInfo.user_id = watermarkType.optString("user_id");
                typeInfo.nick_name = watermarkType.optString("nick_name");
                typeInfo.text_value = watermarkType.optString("text_value");
                this.doc_watermark_type = typeInfo;
            } catch (JSONException e) {
                e.printStackTrace();
            }

            if (null != doc_watermark_type) {
                doc_font_size = object.optString("doc_font_size");
                doc_font_color = object.optString("doc_font_color");
                doc_transparency = object.optString("doc_transparency");
                doc_watermark_open = object.optString("doc_watermark_open");
            }
        }
    }

    public WatermarkInfoData() {

    }

    public boolean isDocWatermarkEnable() {
        return TextUtils.equals("1", doc_watermark_open) && null != doc_watermark_type && doc_watermark_type.isConfigEnable();
    }

    /**
     * 文档水印
     */
    public static class WatermarkTypeInfo implements Serializable {
        /**
         * 类型：文本
         */
        public String text;
        /**
         * 类型：当前用户id
         */
        public String user_id;
        /**
         * 类型：当前用户昵称
         */
        public String nick_name;
        /**
         * 类型包含text时，对应的水印内容
         */
        public String text_value;

        public boolean isConfigEnable() {
            return !TextUtils.isEmpty(text_value) &&
                    (TextUtils.equals("1", text) ||
                            TextUtils.equals("1", user_id) ||
                            TextUtils.equals("1", nick_name)
                    );
        }

        /**
         * 根据配置组合后的文档水印文本
         *
         * @return
         */
        public String getWatermarkText(String userId, String nickName) {
            String combinedText = "";
            if (TextUtils.equals("1", text) && !TextUtils.isEmpty(text_value)) {
                combinedText = combinedText + text_value;
            }
            if (TextUtils.equals("1", user_id)) {
                if (!TextUtils.isEmpty(userId)) {
                    String split = "";
                    if (!TextUtils.isEmpty(combinedText)) {
                        split = "-";
                    }
                    combinedText = combinedText + split + userId;
                }
            }
            if (TextUtils.equals("1", nick_name)) {
                if (!TextUtils.isEmpty(nickName)) {
                    String split = "";
                    if (!TextUtils.isEmpty(combinedText)) {
                        split = "-";
                    }
                    combinedText = combinedText + split + nickName;
                }
            }
            return combinedText;
        }
    }
}
