package com.vhall.vhss.data;

import android.text.TextUtils;

import org.json.JSONObject;

import java.io.Serializable;

/**
 * @author hkl
 * Date: 2020/11/13 9:50 AM
 */
public class VersionRollData implements Serializable {

    /**
     * 是否回滚,0不会滚 1回滚
     */
    public String is_roll_back = "0";
    /**
     * sass bu值
     */
    public String bu;
    /**
     * 数据上报域名
     */
    public String data_domain;
    /**
     * 0:md5 1:rsa   (如果传入app_key，会返回该字段)
     */
    public String sign_type = "0";

    public String raw;

    public VersionRollData() {
    }

    public VersionRollData(JSONObject object) {
        raw = object.toString();
        this.is_roll_back = object.optString("is_roll_back");
        this.bu = object.optString("bu");
        this.data_domain = object.optString("data_domain");
        this.sign_type = TextUtils.isEmpty(object.optString("sign_type")) ? "0" : object.optString("sign_type");
    }
}
