package com.vhall.vhss.data;


import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hkl
 * 获取禁言列表/获取踢出用户列表/获取在线用户列表/获取特殊用户列表
 * <p>
 * "role_name": "1", //角色 1主持人2观众3助理4嘉宾
 * "device_type": "1", // 设备类型 1手机端 2PC 3SDK
 * "device_status": "1", // 设备状态  1可以上麦2不可以上麦
 * "is_banned": "1" //是否禁言 1是0否
 */
public class UserStateListData implements Serializable {
    /**
     * total : 0
     * page : 15
     * pagesize : 1
     * list : []
     */

    public String total;
    public String page;
    public String pagesize;
    public List<DataBeen> list;

    public String raw;

    public UserStateListData() {
    }

    public UserStateListData(JSONObject object) {
        raw = object.toString();
        this.total = object.optString("total");
        this.page = object.optString("page");
        this.pagesize = object.optString("pagesize");
        JSONArray listArray = object.optJSONArray("list");
        if (listArray != null) {
            this.list = new ArrayList<>();
            for (int i = 0; i < listArray.length(); i++) {
                this.list.add(new DataBeen(listArray.optJSONObject(i)));
            }
        }
    }

    public String getTotal() {
        return total;
    }

    public void setTotal(String total) {
        this.total = total;
    }

    public String getPage() {
        return page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getPagesize() {
        return pagesize;
    }

    public void setPagesize(String pagesize) {
        this.pagesize = pagesize;
    }

    public List<DataBeen> getList() {
        return list;
    }

    public void setList(List<DataBeen> list) {
        this.list = list;
    }

    public static class DataBeen implements Serializable {

        /**
         * join_id : 55916
         * room_id : lss_1b63a433
         * account_id : 16422080
         * nickname : v16422080
         * avatar :
         * role_name : 1
         * is_banned : 0
         * is_kicked : 0
         * device_type : 2
         * device_status : 1
         * is_signed : 0
         * is_answered_questionnaire : 0
         * is_lottery_winner : 0
         * status : 0
         * updated_at : 2020-06-22 18:13:05
         * created_at : 2020-06-19 14:32:11
         * deleted_at : null
         * is_speak : 0
         */

        public String join_id;
        public String room_id;
        public String account_id;
        public String nickname;
        public String avatar;
        public String role_name;
        public int is_banned;
        public int is_kicked;
        public int device_type;
        public int device_status;
        public int is_signed;
        public int is_answered_questionnaire;
        public int is_lottery_winner;
        public int is_answered_exam;
        public int is_answered_vote;
        public int status;
        public String updated_at;
        public String created_at;
        public String deleted_at;
        public int is_speak;

        public DataBeen() {
        }

        public DataBeen(JSONObject object) {

            this.join_id = object.optString("join_id");
            this.room_id = object.optString("room_id");
            this.account_id = object.optString("account_id");
            this.nickname = object.optString("nickname");
            this.avatar = object.optString("avatar");
            this.role_name = object.optString("role_name");
            this.is_banned = object.optInt("is_banned");
            this.is_kicked = object.optInt("is_kicked");
            this.device_type = object.optInt("device_type");
            this.device_status = object.optInt("device_status");
            this.is_signed = object.optInt("is_signed");
            this.is_answered_questionnaire = object.optInt("is_answered_questionnaire");
            this.is_lottery_winner = object.optInt("is_lottery_winner");
            this.is_answered_exam = object.optInt("is_answered_exam");
            this.is_answered_vote = object.optInt("is_answered_vote");
            this.status = object.optInt("status");
            this.updated_at = object.optString("updated_at");
            this.created_at = object.optString("created_at");
            this.deleted_at = object.optString("deleted_at");
            this.is_speak = object.optInt("is_speak");
        }

        public String getJoin_id() {
            return join_id;
        }

        public void setJoin_id(String join_id) {
            this.join_id = join_id;
        }

        public String getRoom_id() {
            return room_id;
        }

        public void setRoom_id(String room_id) {
            this.room_id = room_id;
        }

        public String getAccount_id() {
            return account_id;
        }

        public void setAccount_id(String account_id) {
            this.account_id = account_id;
        }

        public String getNickname() {
            return nickname;
        }

        public void setNickname(String nickname) {
            this.nickname = nickname;
        }

        public String getAvatar() {
            return avatar;
        }

        public void setAvatar(String avatar) {
            this.avatar = avatar;
        }

        public String getRole_name() {
            return role_name;
        }

        public void setRole_name(String role_name) {
            this.role_name = role_name;
        }

        public int getIs_banned() {
            return is_banned;
        }

        public void setIs_banned(int is_banned) {
            this.is_banned = is_banned;
        }

        public int getIs_kicked() {
            return is_kicked;
        }

        public void setIs_kicked(int is_kicked) {
            this.is_kicked = is_kicked;
        }

        public int getDevice_type() {
            return device_type;
        }

        public void setDevice_type(int device_type) {
            this.device_type = device_type;
        }

        public int getDevice_status() {
            return device_status;
        }

        public void setDevice_status(int device_status) {
            this.device_status = device_status;
        }

        public int getIs_signed() {
            return is_signed;
        }

        public void setIs_signed(int is_signed) {
            this.is_signed = is_signed;
        }

        public int getIs_answered_questionnaire() {
            return is_answered_questionnaire;
        }

        public void setIs_answered_questionnaire(int is_answered_questionnaire) {
            this.is_answered_questionnaire = is_answered_questionnaire;
        }

        public int getIs_lottery_winner() {
            return is_lottery_winner;
        }

        public void setIs_lottery_winner(int is_lottery_winner) {
            this.is_lottery_winner = is_lottery_winner;
        }

        public int getStatus() {
            return status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public String getUpdated_at() {
            return updated_at;
        }

        public void setUpdated_at(String updated_at) {
            this.updated_at = updated_at;
        }

        public String getCreated_at() {
            return created_at;
        }

        public void setCreated_at(String created_at) {
            this.created_at = created_at;
        }

        public String getDeleted_at() {
            return deleted_at;
        }

        public void setDeleted_at(String deleted_at) {
            this.deleted_at = deleted_at;
        }

        public int getIs_speak() {
            return is_speak;
        }

        public void setIs_speak(int is_speak) {
            this.is_speak = is_speak;
        }
    }
}
