package com.vhall.vhss.data;


import android.text.TextUtils;

import org.json.JSONObject;

import java.io.Serializable;

/**
 * @author hkl
 * 获取角色信息
 */
public class SkinData implements Serializable {




    public String raw;

    public int skin_id;
    public String skin_name;
    public String skin_json_pc;
    public String skin_style_code_pc;
    public String skin_preview_code_pc;
    public String skin_json_wap;
    public String skin_style_code_wap;
    public String skin_preview_code_wap;
    public String user_id;
    public String status;
    public String created_at;
    public String updated_at;

    public String videoBackGroundColor;
    public String finalVideoBackground;

    public SkinData() {
    }

    public SkinData(JSONObject object) {
        raw = object.toString();
        this.skin_id = object.optInt("skin_id");
        this.skin_name = object.optString("skin_name");
        this.skin_json_pc = object.optString("skin_json_pc");
        this.skin_style_code_pc = object.optString("skin_style_code_pc");

        this.skin_preview_code_pc = object.optString("skin_preview_code_pc");
        this.skin_json_wap = object.optString("skin_json_wap");
        this.skin_style_code_wap = object.optString("skin_style_code_wap");

        this.skin_preview_code_wap = object.optString("skin_preview_code_wap");
        this.user_id = object.optString("user_id");
        this.status = object.optString("status");
        this.created_at = object.optString("created_at");
        this.updated_at = object.optString("updated_at");

        if (!TextUtils.isEmpty(skin_json_pc)){
            try{
                JSONObject jsonObject = new JSONObject(skin_json_pc);
                this.videoBackGroundColor = jsonObject.optString("videoBackGroundColor");
                this.finalVideoBackground = jsonObject.optString("finalVideoBackground");
            }catch (Exception e){

            }
        }

    }
}
