package com.vhall.vhss.data;


import com.vhall.business.VhallSDK;

import org.json.JSONObject;

import java.io.Serializable;

/**
 * @author hkl
 * Date: 2020/11/13 9:50 AM
 */
public class ScrollInfoData implements Serializable {
    public static final int POSITION_RANDOM=1;
    public static final int POSITION_HIGHT=2;
    public static final int POSITION_MIDDLE=3;
    public static final int POSITION_LOW=4;
    public static final int SPEED_LOW=10000;
    public static final int SPEED_MIDDLE=6000;
    public static final int SPEED_HIGHT=3000;
    public String webinar_id;
    public int scrolling_open;//是否开启跑马灯 1 开启 0 关闭
    public String color;//十六进制色值 #ffffff
    public String text;//内容 #ffffff
    public int alpha;//不透明度
    public int text_type;//文本显示格式
    public int size;//字体
    public int position;//显示位置
    public int scroll_type;//显示方式 1 滚动 2 闪烁
    public int speed;//滚屏速度
    public int interval;//间隔时间

    public String raw;

    public ScrollInfoData(JSONObject object) {
        raw = object.toString();
        this.webinar_id = object.optString("webinar_id");
        this.color = object.optString("color");
        this.text = object.optString("text");
        this.alpha = object.optInt("alpha");
        this.text_type = object.optInt("text_type");
        this.size = object.optInt("size");
        this.position = object.optInt("position");
        this.speed = object.optInt("speed");
        this.interval = object.optInt("interval");
        this.scroll_type = object.optInt("scroll_type");
        this.scrolling_open = object.optInt("scrolling_open");
        if(text_type == 2){
            this.text = VhallSDK.getUserId()+VhallSDK.getUserNickname();
        }
    }

    public String getWebinar_id() {
        return webinar_id;
    }

    public void setWebinar_id(String webinar_id) {
        this.webinar_id = webinar_id;
    }

    public int getScrolling_open() {
        return scrolling_open;
    }

    public void setScrolling_open(int scrolling_open) {
        this.scrolling_open = scrolling_open;
    }

    public String getColor() {
        return color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getAlpha() {
        return alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getText_type() {
        return text_type;
    }

    public void setText_type(int text_type) {
        this.text_type = text_type;
    }

    public int getSize() {
        return size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getPosition() {
        return position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getScroll_type() {
        return scroll_type;
    }

    public void setScroll_type(int scroll_type) {
        this.scroll_type = scroll_type;
    }

    public int getSpeed() {
        return speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public int getInterval() {
        return interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public ScrollInfoData() {

    }
}
