package com.vhall.vhss.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hkl
 * Date: 2020/11/13 9:50 AM
 */
public class RoomToolsStatusData implements Serializable {


    /**
     * is_board : 0
     * is_doc : 0
     * is_handsup : 0
     * layout :
     * definition :
     * screen_definition :
     * main_screen : 988
     * doc_permission : 988
     * speaker_list : 1
     * start_type : 1
     * all_banned : 0
     * is_desktop : 0
     * question_status : 0
     * cast_screen : 988
     */

    public int is_board;
    public int is_doc;//获取文档开关状态 0 否 1是
    public int is_handsup;//获取观看端布局, 未设置返回空
    public String layout;//获取观看端布局, 未设置返回空
    public String definition;//获取视频清晰度， 未设置返回空
    public String screen_definition;//获取桌面清晰度， 未设置返回空
    public String main_screen;//主画面绑定的参会ID，默认为主持人
    public String doc_permission;//主讲人id 文档操作权限绑定的参会ID. 默认为主持人
    public String start_type;//获取活动发起类型 1 web 2 app 3 sdk 4 推拉流 5 定时 6 admin后台 7第三方8 助手
    public int all_banned;//获取全体禁言 0 否 1 是
    public int is_desktop;//获取是否开启桌面演示状态  0 否 1 是
    public int question_status;//问答是否处于开启状态 1 开启 0 关闭，对应原始qa_open
    public String question_name;//问答昵称
    public int cast_screen;//废弃
    public String chat_status;//公聊维度：1禁言 0取消禁言
    public String qa_status;//问答维度：1禁言 0取消禁言
    public String private_chat_status;//私聊维度：1禁言 0取消禁言
    public int is_adi_watch_doc;//观众是否可预览文档1:是 0 否
    public int is_open_switch;//是否开启分组讨论1=是|0=否
    public int speakerAndShowLayout;//是否开启文档融屏 1=是|0=否
    /**
     * speaker_list : [{"nick_name":"v16422080","role_name":1,"account_id":"16422080","audio":0,"video":1},{"nick_name":"帮不帮","role_name":4,"account_id":"74e633fb048e4a178cd1e9e284522121","audio":0,"video":1}]
     * start_type : 2
     * push_definition : 360
     * hd_definition : 360
     * is_banned : 0
     * is_kicked : 0
     */

    public List<SpeakerListBean> speaker_list;


    public String raw;
    public VideoBackGroundMapBean videoBackGroundMap;

    public RoomToolsStatusData(JSONObject object) {
        raw = object.toString();
        this.is_board = object.optInt("is_board");
        this.is_adi_watch_doc = object.optInt("is_adi_watch_doc");
        this.is_open_switch = object.optInt("is_open_switch");
        this.is_doc = object.optInt("is_doc");
        this.is_handsup = object.optInt("is_handsup");
        this.layout = object.optString("layout");
        this.definition = object.optString("definition");
        this.screen_definition = object.optString("screen_definition");
        this.main_screen = object.optString("main_screen");
        this.question_name = object.optString("question_name");
        this.qa_status = object.optString("qa_status");
        this.chat_status = object.optString("chat_status");
        this.private_chat_status = object.optString("private_chat_status");
        this.doc_permission = object.optString("doc_permission");
        this.start_type = object.optString("start_type");
        this.all_banned = object.optInt("all_banned");
        this.is_desktop = object.optInt("is_desktop");
        this.question_status = object.optInt("question_status");
        this.cast_screen = object.optInt("cast_screen");
        this.speakerAndShowLayout = object.optInt("speakerAndShowLayout");

        JSONObject videoBackGroundMapObject = object.optJSONObject("videoBackGroundMap");
        if (videoBackGroundMapObject != null) {
            this.videoBackGroundMap = new VideoBackGroundMapBean(videoBackGroundMapObject);
        }

        JSONArray speaker_listArray = object.optJSONArray("speaker_list");
        if (speaker_listArray != null) {
            this.speaker_list = new ArrayList<>();
            for (int i = 0; i < speaker_listArray.length(); i++) {
                this.speaker_list.add(new SpeakerListBean(speaker_listArray.optJSONObject(i)));
            }
        }
    }

    public RoomToolsStatusData() {

    }


    public static class SpeakerListBean implements Serializable {
        /**
         * nick_name : v16422080
         * role_name : 1
         * account_id : 16422080
         * audio : 0
         * video : 1
         */

        public String nick_name;
        public int role_name;
        public String account_id;
        public int audio;
        public int video;

        public SpeakerListBean() {
        }

        public SpeakerListBean(JSONObject object) {

            this.nick_name = object.optString("nick_name");
            this.role_name = object.optInt("role_name");
            this.account_id = object.optString("account_id");
            this.audio = object.optInt("audio");
            this.video = object.optInt("video");
        }
    }

    public static class VideoBackGroundMapBean implements Serializable{
        public VideoBackGroundSizeBean videoBackGroundSize;
        public String videoBackGroundColor;
        public String videoBackGround;

        public VideoBackGroundMapBean(JSONObject object) {

            this.videoBackGroundColor = object.optString("videoBackGroundColor");//#333338
            this.videoBackGround = object.optString("videoBackGround");
            JSONObject videoBackGroundSizeObject = object.optJSONObject("videoBackGroundSize");
            if (videoBackGroundSizeObject != null) {
                this.videoBackGroundSize = new VideoBackGroundSizeBean(videoBackGroundSizeObject);
            }
        }


        public static class VideoBackGroundSizeBean implements Serializable{
            public int x;
            public int y;
            public int width;
            public int height;

            public VideoBackGroundSizeBean(JSONObject object) {

                this.x = object.optInt("x");
                this.y = object.optInt("y");
                this.width = object.optInt("width");
                this.height = object.optInt("height");
            }

            public VideoBackGroundSizeBean() {
            }
        }

        public VideoBackGroundMapBean() {
        }
    }
}
