package com.vhall.vhss.data;


import com.vhall.vhss.netutils.VHJSON;

import org.json.JSONObject;

import java.io.Serializable;


/**
 * @author hkl
 */
public class ResponseJe<T> implements Serializable {
    private int code;
    private T data;
    private String msg;

    public ResponseJe() {

    }
    public ResponseJe(String json, Class<T> clz) {
        try {
            json = json.replace(":null",":\"\"");
            JSONObject jsonObject = new JSONObject(json);
            this.code = jsonObject.optInt("code");
            this.msg = jsonObject.optString("msg");
            if (clz != null) {
                this.data = (T) VHJSON.parseObject(jsonObject.opt("data").toString(), clz);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
